/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.dirchooser;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.netbeans.swing.dirchooser.DelegatingChooserUI;
import org.openide.modules.ModuleInstall;
import org.openide.windows.WindowManager;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;

public class Module
extends ModuleInstall {
    private static final String KEY = "FileChooserUI";
    private static Class<?> originalImpl;
    private static PropertyChangeListener pcl;
    private static final String QUICK_CHOOSER_NAME = "org.netbeans.modules.quickfilechooser.ChooserComponentUI";
    private static final String FORCE_STANDARD_CHOOSER = "standard-file-chooser";

    public void restored() {
        WindowManager.getDefault().addWindowSystemListener(new WindowSystemListener(){

            public void beforeLoad(WindowSystemEvent event) {
            }

            public void afterLoad(WindowSystemEvent event) {
                WindowManager.getDefault().removeWindowSystemListener((WindowSystemListener)this);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Module.install();
                    }
                });
            }

            public void beforeSave(WindowSystemEvent event) {
            }

            public void afterSave(WindowSystemEvent event) {
            }
        });
    }

    public void uninstalled() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Module.uninstall();
            }
        });
    }

    private static void install() {
        if (Module.isStandardChooserForced()) {
            return;
        }
        final UIDefaults uid = UIManager.getDefaults();
        originalImpl = uid.getUIClass(KEY);
        Class<DelegatingChooserUI> impl = DelegatingChooserUI.class;
        final String val = impl.getName();
        if (!Module.isQuickFileChooser(uid.get(KEY))) {
            uid.put(KEY, val);
            uid.put(val, impl);
        }
        pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                Object className = uid.get(Module.KEY);
                if ((name.equals(Module.KEY) || name.equals("UIDefaults")) && !val.equals(className) && !Module.isQuickFileChooser(className)) {
                    originalImpl = uid.getUIClass(Module.KEY);
                    uid.put(Module.KEY, val);
                }
            }
        };
        uid.addPropertyChangeListener(pcl);
    }

    private static void uninstall() {
        if (Module.isInstalled()) {
            assert (pcl != null);
            UIDefaults uid = UIManager.getDefaults();
            uid.removePropertyChangeListener(pcl);
            pcl = null;
            String val = originalImpl.getName();
            uid.put(KEY, val);
            uid.put(val, originalImpl);
            originalImpl = null;
        }
    }

    private static boolean isInstalled() {
        return originalImpl != null;
    }

    static Class<?> getOrigChooser() {
        return originalImpl;
    }

    private static boolean isQuickFileChooser(Object className) {
        return QUICK_CHOOSER_NAME.equals(className);
    }

    private static boolean isStandardChooserForced() {
        return Boolean.getBoolean(FORCE_STANDARD_CHOOSER);
    }
}

