/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor.parser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public class TplParserResult
extends ParserResult {
    private boolean valid = true;
    private List<Error> errorList = new ArrayList<Error>();
    private List<Block> blockList = new ArrayList<Block>();

    protected TplParserResult(Snapshot snapshot) {
        super(snapshot);
    }

    public List<Error> getErrors() {
        return this.errorList;
    }

    public void addError(String description, int offset, int length) {
        this.errorList.add(new Error(description, offset, length, this.getSnapshot()));
    }

    public List<Block> getBlocks() {
        return this.blockList;
    }

    public void addBlock(Block block) {
        this.blockList.add(block);
    }

    protected void invalidate() {
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public List<? extends org.netbeans.modules.csl.api.Error> getDiagnostics() {
        return this.errorList;
    }

    public static class Block {
        private final List<Section> sections = new LinkedList<Section>();

        public Block() {
        }

        public Block(Section section) {
            this.sections.add(section);
        }

        public void addSection(Section section) {
            this.sections.add(section);
        }

        public List<Section> getSections() {
            return this.sections;
        }
    }

    public static class Section {
        private final String function;
        private final OffsetRange offset;
        private final String text;

        public Section(String function, OffsetRange offset, String text) {
            this.function = function;
            this.offset = offset;
            this.text = text;
        }

        public String getName() {
            return this.function;
        }

        public OffsetRange getOffset() {
            return this.offset;
        }

        public String getText() {
            return this.text;
        }

        public int getFunctionNameLength() {
            return this.function.length();
        }
    }

    public static class Error
    implements org.netbeans.modules.csl.api.Error {
        private String description;
        private int offset;
        private int length;
        private Snapshot snapshot;

        public Error(String description, int offset, int length, Snapshot snapshot) {
            this.description = description;
            this.offset = offset;
            this.length = length;
            this.snapshot = snapshot;
        }

        public String getDescription() {
            return this.description;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String getDisplayName() {
            return this.description;
        }

        public String getKey() {
            return this.description;
        }

        public FileObject getFile() {
            return this.snapshot.getSource().getFileObject();
        }

        public int getStartPosition() {
            return this.offset;
        }

        public int getEndPosition() {
            return this.offset + this.length;
        }

        public boolean isLineError() {
            return false;
        }

        public Severity getSeverity() {
            return Severity.ERROR;
        }

        public Object[] getParameters() {
            return null;
        }
    }
}

