/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.server;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import net.jradius.handler.chain.JRCommand;
import net.jradius.server.EventDispatcher;
import net.jradius.server.JRadiusThread;
import net.jradius.server.ListenerRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Processor
extends JRadiusThread
implements ApplicationContextAware {
    protected Log log = LogFactory.getLog(this.getClass());
    private ApplicationContext applicationContext;
    private EventDispatcher eventDispatcher;
    private List<JRCommand> requestHandlers;
    private BlockingQueue<ListenerRequest> queue;
    private boolean active = true;

    public void setRequestQueue(BlockingQueue<ListenerRequest> q) {
        this.queue = q;
    }

    public BlockingQueue<ListenerRequest> getRequestQueue() {
        return this.queue;
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public void setRequestHandlers(List<JRCommand> handlers) {
        this.requestHandlers = handlers;
    }

    public List<JRCommand> getRequestHandlers() {
        return this.requestHandlers;
    }

    protected abstract void processRequest(ListenerRequest var1) throws Exception;

    @Override
    public void run() {
        while (this.getActive()) {
            try {
                Thread.yield();
                this.process();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.log.error((Object)"Error in radius task Processor", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws Exception {
        ListenerRequest queueElement = this.queue.take();
        if (!(queueElement instanceof ListenerRequest)) {
            throw new IllegalArgumentException("Expected ListenerRequest but found " + queueElement.getClass().getName());
        }
        ListenerRequest request = queueElement;
        try {
            this.processRequest(request);
        }
        finally {
            ObjectPool pool = request.getBorrowedFromPool();
            if (pool != null) {
                pool.returnObject(request);
            }
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (!active) {
            try {
                this.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

