/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.compliance;

import java.util.regex.PatternSyntaxException;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDriver;
import onl.netfishers.netshot.device.DeviceGroup;
import onl.netfishers.netshot.device.Module;

@Entity
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class SoftwareRule
implements Comparable<SoftwareRule> {
    protected long id;
    protected double priority;
    protected DeviceGroup targetGroup;
    private String driver = null;
    private String family = "";
    private boolean familyRegExp = false;
    private String version = "";
    private boolean versionRegExp = false;
    private String partNumber;
    private boolean partNumberRegExp = false;
    protected ConformanceLevel level = ConformanceLevel.GOLD;

    protected SoftwareRule() {
    }

    public SoftwareRule(double priority, DeviceGroup targetGroup, String driver, String family, boolean familyRegExp, String version, boolean versionRegExp, String partNumber, boolean partNumberRegExp, ConformanceLevel level) {
        this.priority = priority;
        this.targetGroup = targetGroup;
        this.driver = driver;
        this.family = family;
        this.familyRegExp = familyRegExp;
        this.version = version;
        this.versionRegExp = versionRegExp;
        this.partNumber = partNumber;
        this.partNumberRegExp = partNumberRegExp;
        this.level = level;
    }

    @Override
    public int compareTo(SoftwareRule o) {
        return Double.compare(this.priority, o.priority);
    }

    @Id
    @GeneratedValue
    @XmlElement
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @XmlElement
    public double getPriority() {
        return this.priority;
    }

    public void setPriority(double priority) {
        this.priority = priority;
    }

    @ManyToOne
    @XmlElement
    public DeviceGroup getTargetGroup() {
        return this.targetGroup;
    }

    public void setTargetGroup(DeviceGroup targetGroup) {
        this.targetGroup = targetGroup;
    }

    @XmlElement
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    @XmlElement
    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    @XmlElement
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @XmlElement
    public String getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(String partNumber) {
        this.partNumber = partNumber;
    }

    @XmlElement
    public boolean isPartNumberRegExp() {
        return this.partNumberRegExp;
    }

    public void setPartNumberRegExp(boolean partNumberRegExp) {
        this.partNumberRegExp = partNumberRegExp;
    }

    @XmlElement
    public ConformanceLevel getLevel() {
        return this.level;
    }

    public void setLevel(ConformanceLevel level) {
        this.level = level;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SoftwareRule other = (SoftwareRule)obj;
        return this.id == other.id;
    }

    @Transient
    @XmlElement
    public String getDeviceType() {
        DeviceDriver deviceDriver = DeviceDriver.getDriverByName(this.driver);
        if (deviceDriver == null) {
            return "";
        }
        return deviceDriver.getDescription();
    }

    public void check(Device device) {
        block20: {
            block19: {
                device.setSoftwareLevel(ConformanceLevel.UNKNOWN);
                if (this.targetGroup != null && !this.targetGroup.getCachedDevices().contains(device)) {
                    return;
                }
                if (this.driver != null && !this.driver.equals(device.getDriver())) {
                    return;
                }
                if (this.familyRegExp) {
                    try {
                        if (!device.getFamily().matches(this.family)) {
                            return;
                        }
                        break block19;
                    }
                    catch (PatternSyntaxException e) {
                        return;
                    }
                }
                if (!this.family.equals("") && !device.getFamily().equals(this.family)) {
                    return;
                }
            }
            if (this.versionRegExp) {
                try {
                    if (!device.getSoftwareVersion().matches(this.version)) {
                        return;
                    }
                    break block20;
                }
                catch (PatternSyntaxException e) {
                    return;
                }
            }
            if (!this.version.equals("") && !device.getSoftwareVersion().equals(this.version)) {
                return;
            }
        }
        if (this.partNumber != null && this.partNumber != "") {
            boolean moduleMatches = false;
            for (Module module : device.getModules()) {
                block21: {
                    if (this.partNumberRegExp) {
                        try {
                            if (!module.getPartNumber().matches(this.partNumber)) {
                                continue;
                            }
                            break block21;
                        }
                        catch (PatternSyntaxException e) {
                            return;
                        }
                    }
                    if (!this.partNumber.equals("") && !module.getPartNumber().equals(this.partNumber)) continue;
                }
                moduleMatches = true;
                break;
            }
            if (!moduleMatches) {
                return;
            }
        }
        device.setSoftwareLevel(this.level);
    }

    @XmlElement
    public boolean isFamilyRegExp() {
        return this.familyRegExp;
    }

    public void setFamilyRegExp(boolean familyRegExp) {
        this.familyRegExp = familyRegExp;
    }

    @XmlElement
    public boolean isVersionRegExp() {
        return this.versionRegExp;
    }

    public void setVersionRegExp(boolean versionRegExp) {
        this.versionRegExp = versionRegExp;
    }

    public static enum ConformanceLevel {
        GOLD,
        SILVER,
        BRONZE,
        UNKNOWN;

    }
}

