/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Embeddable;

@Embeddable
public class PhysicalAddress {
    @Column(name="physicalAddress")
    private long address;

    protected PhysicalAddress() {
    }

    public PhysicalAddress(long address) {
        this.address = address;
    }

    public PhysicalAddress(String address) throws ParseException {
        long[] result = new long[6];
        String[] patterns = new String[]{"^(?<b0>[0-9A-F]{2})(?<b1>[0-9A-F]{2})[\\-\\.](?<b2>[0-9A-F]{2})(?<b3>[0-9A-F]{2})[\\.\\-](?<b4>[0-9A-F]{2})(?<b5>[0-9A-F]{2})$", "^(?<b0>[0-9A-F]{1,2})[\\-\\.:](?<b1>[0-9A-F]{1,2})[\\-\\.:](?<b2>[0-9A-F]{1,2})[\\-\\.:](?<b3>[0-9A-F]{1,2})[\\-\\.:](?<b4>[0-9A-F]{1,2})[\\-\\.:](?<b5>[0-9A-F]{1,2})$"};
        for (int i = 0; i < patterns.length; ++i) {
            Pattern p = Pattern.compile(patterns[i], 2);
            Matcher m = p.matcher(address);
            if (!m.find()) continue;
            try {
                result[0] = Integer.parseInt(m.group("b0"), 16);
                result[1] = Integer.parseInt(m.group("b1"), 16);
                result[2] = Integer.parseInt(m.group("b2"), 16);
                result[3] = Integer.parseInt(m.group("b3"), 16);
                result[4] = Integer.parseInt(m.group("b4"), 16);
                result[5] = Integer.parseInt(m.group("b5"), 16);
                this.address = result[0] << 40 | result[1] << 32 | result[2] << 24 | result[3] << 16 | result[4] << 8 | result[5];
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ParseException("Couldn't parse the MAC address", 0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.address ^ this.address >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PhysicalAddress other = (PhysicalAddress)obj;
        return this.address == other.address;
    }

    public static PhysicalAddress parseMacAddress(String address) throws ParseException {
        return new PhysicalAddress(address);
    }

    private byte[] toBytes() {
        byte[] chunks = new byte[]{(byte)(this.address >> 40 & 0xFFL), (byte)(this.address >> 32 & 0xFFL), (byte)(this.address >> 24 & 0xFFL), (byte)(this.address >> 16 & 0xFFL), (byte)(this.address >> 8 & 0xFFL), (byte)(this.address & 0xFFL)};
        return chunks;
    }

    public String toString() {
        byte[] macAddress = this.toBytes();
        return String.format("%02x%02x.%02x%02x.%02x%02x", macAddress[0], macAddress[1], macAddress[2], macAddress[3], macAddress[4], macAddress[5]);
    }

    public long getLongAddress() {
        return this.address;
    }
}

