/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.work;

import java.io.Serializable;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.TaskManager;
import onl.netfishers.netshot.work.Task;
import org.hibernate.Session;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskJob
implements Job {
    public static final String NETSHOT_TASK = "Netshot Task";
    private static Logger logger = LoggerFactory.getLogger(TaskJob.class);

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        logger.debug("Starting job.");
        Long id = (Long)context.getJobDetail().getJobDataMap().get(NETSHOT_TASK);
        logger.trace("The task id is {}.", (Object)id);
        Task task = null;
        try (Session session = Database.getSession();){
            Thread.sleep(1000L);
            session.beginTransaction();
            task = (Task)session.get(Task.class, (Serializable)id);
            if (task == null) {
                logger.error("The retrieved task {} is null.", (Object)id);
            }
            task.setRunning();
            session.update(task);
            session.getTransaction().commit();
            logger.trace("Got the task.");
            task.prepare();
            logger.trace("The task has prepared its fields.");
        }
        logger.trace("Running the task {} of type {}", (Object)id, (Object)task.getClass().getName());
        task.run();
        if (task.getStatus() == Task.Status.RUNNING) {
            logger.error("The task {} exited with a status of RUNNING.", (Object)id);
            task.setStatus(Task.Status.FAILURE);
        }
        logger.trace("Updating the task with the result.");
        session = Database.getSession();
        try {
            session.beginTransaction();
            session.update(task);
            session.getTransaction().commit();
        }
        catch (Exception e) {
            logger.error("Error while updating the task {} after execution.", (Object)id, (Object)e);
            try {
                session.getTransaction().rollback();
            }
            catch (Exception e1) {
                logger.error("Error during the rollback.", e1);
            }
            try {
                session.clear();
                session.beginTransaction();
                Task eTask = (Task)session.get(Task.class, (Serializable)id);
                eTask.setFailed();
                session.update(eTask);
                session.getTransaction().commit();
            }
            catch (Exception e1) {
                logger.error("Error while setting the task {} to FAILED.", (Object)id, (Object)e1);
            }
            throw new JobExecutionException("Unable to save the task.");
        }
        finally {
            session.close();
        }
        try {
            TaskManager.repeatTask(task);
        }
        catch (Exception e) {
            logger.error("Unable to repeat the task {} again.", (Object)id);
        }
        logger.trace("End of task {}.", (Object)id);
    }
}

