/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.win32;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.win32.FileInfo;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Win32FsCache {
    private final IdeaWin32 myKernel = IdeaWin32.getInstance();
    private Reference<TIntObjectHashMap<THashMap<String, FileAttributes>>> myCache;

    Win32FsCache() {
    }

    void clearCache() {
        this.myCache = null;
    }

    @NotNull
    private TIntObjectHashMap<THashMap<String, FileAttributes>> getMap() {
        TIntObjectHashMap map = (TIntObjectHashMap)SoftReference.dereference(this.myCache);
        if (map == null) {
            map = new TIntObjectHashMap();
            this.myCache = new java.lang.ref.SoftReference<TIntObjectHashMap>(map);
        }
        TIntObjectHashMap tIntObjectHashMap = map;
        if (tIntObjectHashMap == null) {
            Win32FsCache.$$$reportNull$$$0(0);
        }
        return tIntObjectHashMap;
    }

    @NotNull
    String[] list(@NotNull VirtualFile file2) {
        int parentId;
        String path;
        FileInfo[] fileInfo;
        if (file2 == null) {
            Win32FsCache.$$$reportNull$$$0(1);
        }
        if ((fileInfo = this.myKernel.listChildren(path = file2.getPath())) == null || fileInfo.length == 0) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                Win32FsCache.$$$reportNull$$$0(2);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] names = new String[fileInfo.length];
        TIntObjectHashMap<THashMap<String, FileAttributes>> map = this.getMap();
        THashMap nestedMap = (THashMap)map.get(parentId = ((VirtualFileWithId)file2).getId());
        if (nestedMap == null) {
            nestedMap = new THashMap(fileInfo.length, FileUtil.PATH_HASHING_STRATEGY);
            map.put(parentId, (Object)nestedMap);
        }
        for (FileInfo info : fileInfo) {
            String name = info.getName();
            nestedMap.put((Object)name, (Object)info.toFileAttributes());
            names[i] = name;
        }
        if (names == null) {
            Win32FsCache.$$$reportNull$$$0(3);
        }
        return names;
    }

    @Nullable
    FileAttributes getAttributes(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        VirtualFile parent;
        if (file2 == null) {
            Win32FsCache.$$$reportNull$$$0(4);
        }
        int parentId = (parent = file2.getParent()) instanceof VirtualFileWithId ? ((VirtualFileWithId)parent).getId() : -((VirtualFileWithId)file2).getId();
        TIntObjectHashMap<THashMap<String, FileAttributes>> map = this.getMap();
        IncompleteChildrenMap nestedMap = (IncompleteChildrenMap)((Object)map.get(parentId));
        String name = file2.getName();
        FileAttributes fileAttributes = attributes = nestedMap != null ? (FileAttributes)nestedMap.get(name) : null;
        if (attributes == null) {
            if (nestedMap != null && !(nestedMap instanceof IncompleteChildrenMap)) {
                return null;
            }
            FileInfo info = this.myKernel.getInfo(file2.getPath());
            if (info == null) {
                return null;
            }
            attributes = info.toFileAttributes();
            if (nestedMap == null) {
                nestedMap = new IncompleteChildrenMap(FileUtil.PATH_HASHING_STRATEGY);
                map.put(parentId, nestedMap);
            }
            nestedMap.put(name, attributes);
        }
        return attributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/win32/Win32FsCache";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMap";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/win32/Win32FsCache";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IncompleteChildrenMap<K, V>
    extends THashMap<K, V> {
        IncompleteChildrenMap(TObjectHashingStrategy<K> strategy) {
            super(strategy);
        }
    }
}

