/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsBrowser.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsFilePath;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextAdapter;
import com.intellij.cvsSupport2.actions.cvsContext.CvsLightweightFile;
import com.intellij.cvsSupport2.changeBrowser.CvsRepositoryLocation;
import com.intellij.cvsSupport2.checkout.CheckoutAction;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.cvsBrowser.CheckoutHelper;
import com.intellij.cvsSupport2.cvsBrowser.CvsElement;
import com.intellij.cvsSupport2.cvsBrowser.CvsTree;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TreeUIHelper;
import com.intellij.util.Consumer;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserPanel
extends JPanel
implements DataProvider,
CvsTabbedWindow.DeactivateListener {
    private final CvsTree myTree;
    private final CheckoutHelper myCheckoutHelper;
    private final CvsRootConfiguration myCvsRootConfiguration;
    private final Project myProject;

    public BrowserPanel(CvsRootConfiguration configuration, Project project, Consumer<VcsException> errorCallback) {
        super(new BorderLayout(2, 0));
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.myProject = project;
        this.myCvsRootConfiguration = configuration;
        this.myTree = new CvsTree(project, false, 1, true, true, errorCallback);
        this.add((Component)this.myTree, "Center");
        this.myTree.init();
        this.myTree.setCvsRootConfiguration(configuration);
        this.myCheckoutHelper = new CheckoutHelper(configuration, this);
        TreeUIHelper uiHelper = TreeUIHelper.getInstance();
        uiHelper.installEditSourceOnDoubleClick((JTree)this.myTree.getTree());
        TreeUtil.installActions((JTree)this.myTree.getTree());
        ActionGroup group = this.getActionGroup();
        PopupHandler.installPopupHandler((JComponent)this.myTree.getTree(), (ActionGroup)group, (String)"CheckoutPopup", (ActionManager)ActionManager.getInstance());
    }

    public ActionGroup getActionGroup() {
        DefaultActionGroup result = new DefaultActionGroup();
        result.add((AnAction)new EditSourceAction());
        result.add((AnAction)new MyCheckoutAction());
        result.add((AnAction)new MyHistoryAction());
        result.add((AnAction)new MyAnnotateAction());
        result.add((AnAction)new BrowseChangesAction());
        return result;
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            BrowserPanel.$$$reportNull$$$0(0);
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            VirtualFile cvsVirtualFile = this.getCvsVirtualFile();
            if (cvsVirtualFile == null || !cvsVirtualFile.isValid()) {
                return null;
            }
            return new OpenFileDescriptor(this.myProject, cvsVirtualFile);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        return null;
    }

    @Nullable
    private VirtualFile getCvsVirtualFile() {
        CvsElement[] currentSelection = this.myTree.getCurrentSelection();
        if (currentSelection.length != 1) {
            return null;
        }
        VirtualFile file = currentSelection[0].getVirtualFile();
        if (file == null) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        return file;
    }

    @Nullable
    private CvsLightweightFile getCvsLightFile() {
        CvsElement[] currentSelection = this.myTree.getCurrentSelection();
        if (currentSelection.length != 1) {
            return null;
        }
        return new CvsLightweightFile(currentSelection[0].getCvsLightFile(), null);
    }

    @Override
    public void deactivated() {
        this.myTree.deactivated();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/cvsSupport2/cvsBrowser/ui/BrowserPanel", "getData"));
    }

    private class BrowseChangesAction
    extends AnAction
    implements DumbAware {
        BrowseChangesAction() {
            super(VcsBundle.message((String)"browse.changes.action", (Object[])new Object[0]), "", AllIcons.Actions.Preview);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                BrowseChangesAction.$$$reportNull$$$0(0);
            }
            CvsElement[] currentSelection = BrowserPanel.this.myTree.getCurrentSelection();
            assert (currentSelection.length == 1);
            String moduleName = currentSelection[0].getElementPath();
            CvsRepositoryLocation location = new CvsRepositoryLocation(null, BrowserPanel.this.myCvsRootConfiguration, moduleName);
            AbstractVcsHelper.getInstance((Project)BrowserPanel.this.myProject).showChangesBrowser(CvsVcs2.getInstance(BrowserPanel.this.myProject).getCommittedChangesProvider(), (RepositoryLocation)location, VcsBundle.message((String)"browse.changes.scope", (Object[])new Object[]{moduleName}), (Component)BrowserPanel.this);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                BrowseChangesAction.$$$reportNull$$$0(1);
            }
            CvsElement[] currentSelection = BrowserPanel.this.myTree.getCurrentSelection();
            e.getPresentation().setEnabled(currentSelection.length == 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/cvsSupport2/cvsBrowser/ui/BrowserPanel$BrowseChangesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyAnnotateAction
    extends AnAction
    implements DumbAware {
        MyAnnotateAction() {
            super(CvsBundle.message((String)"operation.name.annotate", (Object[])new Object[0]), null, AllIcons.Actions.Annotate);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAnnotateAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = e.getPresentation();
            presentation.setVisible(true);
            CvsLightweightFile cvsLightFile = BrowserPanel.this.getCvsLightFile();
            if (cvsLightFile != null) {
                File file = cvsLightFile.getCvsFile();
                presentation.setEnabled(file != null);
            } else {
                presentation.setEnabled(false);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAnnotateAction.$$$reportNull$$$0(1);
            }
            VcsVirtualFile vcsVirtualFile = (VcsVirtualFile)BrowserPanel.this.getCvsVirtualFile();
            try {
                CvsVcs2 vcs = CvsVcs2.getInstance(BrowserPanel.this.myProject);
                FileAnnotation annotation = vcs.createAnnotation((VirtualFile)vcsVirtualFile, vcsVirtualFile.getRevision(), BrowserPanel.this.myCvsRootConfiguration);
                AbstractVcsHelper.getInstance((Project)BrowserPanel.this.myProject).showAnnotation(annotation, (VirtualFile)vcsVirtualFile, (AbstractVcs)vcs);
            }
            catch (VcsException e1) {
                AbstractVcsHelper.getInstance((Project)BrowserPanel.this.myProject).showError(e1, CvsBundle.message((String)"operation.name.annotate", (Object[])new Object[0]));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/cvsSupport2/cvsBrowser/ui/BrowserPanel$MyAnnotateAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyHistoryAction
    extends AnAction
    implements DumbAware {
        MyHistoryAction() {
            super(CvsBundle.message((String)"operation.name.show.file.history", (Object[])new Object[0]), CvsBundle.message((String)"operation.name.show.file.history.description", (Object[])new Object[0]), AllIcons.Vcs.History);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyHistoryAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = e.getPresentation();
            presentation.setVisible(true);
            CvsLightweightFile cvsLightFile = BrowserPanel.this.getCvsLightFile();
            presentation.setEnabled(cvsLightFile != null && cvsLightFile.getCvsFile() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            CvsElement[] currentSelection;
            if (e == null) {
                MyHistoryAction.$$$reportNull$$$0(1);
            }
            if ((currentSelection = BrowserPanel.this.myTree.getCurrentSelection()).length != 1) {
                return;
            }
            CvsElement cvsElement = currentSelection[0];
            VirtualFile virtualFile = cvsElement.getVirtualFile();
            if (virtualFile == null || virtualFile.isDirectory()) {
                return;
            }
            CvsVcs2 vcs = CvsVcs2.getInstance(BrowserPanel.this.myProject);
            VcsHistoryProvider historyProvider = vcs.getVcsHistoryProvider();
            String moduleName = cvsElement.getElementPath();
            CvsRepositoryLocation location = new CvsRepositoryLocation(null, BrowserPanel.this.myCvsRootConfiguration, moduleName);
            CvsFilePath filePath = new CvsFilePath(virtualFile.getPath(), virtualFile.isDirectory(), location);
            AbstractVcsHelper.getInstance((Project)BrowserPanel.this.myProject).showFileHistory(historyProvider, (FilePath)filePath, (AbstractVcs)vcs);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/cvsSupport2/cvsBrowser/ui/BrowserPanel$MyHistoryAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyCheckoutAction
    extends AnAction
    implements DumbAware {
        MyCheckoutAction() {
            super(CvsBundle.message((String)"operation.name.check.out", (Object[])new Object[0]), null, AllIcons.Actions.CheckOut);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCheckoutAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(this.canPerformCheckout());
        }

        private boolean canPerformCheckout() {
            CvsElement[] currentSelection = BrowserPanel.this.myTree.getCurrentSelection();
            return currentSelection.length == 1 && currentSelection[0].canBeCheckedOut();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCheckoutAction.$$$reportNull$$$0(1);
            }
            CvsElement[] cvsElements = BrowserPanel.this.myTree.getCurrentSelection();
            CvsElement selectedElement = cvsElements[0];
            if (!BrowserPanel.this.myCheckoutHelper.prepareCheckoutData(selectedElement, false)) {
                return;
            }
            CvsHandler checkoutHandler = CommandCvsHandler.createCheckoutHandler(BrowserPanel.this.myCvsRootConfiguration, new String[]{selectedElement.getCheckoutPath()}, BrowserPanel.this.myCheckoutHelper.getCheckoutLocation(), false, CvsConfiguration.getInstance((Project)((BrowserPanel)BrowserPanel.this).myProject).MAKE_NEW_FILES_READONLY, VcsConfiguration.getInstance((Project)BrowserPanel.this.myProject).getCheckoutOption());
            CvsContextAdapter context = new CvsContextAdapter(){

                @Override
                public Project getProject() {
                    return BrowserPanel.this.myProject;
                }
            };
            new CheckoutAction(new CvsElement[]{selectedElement}, BrowserPanel.this.myCheckoutHelper.getCheckoutLocation(), false).actionPerformed(context, checkoutHandler);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/cvsSupport2/cvsBrowser/ui/BrowserPanel$MyCheckoutAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EditSourceAction
    extends AnAction
    implements DumbAware {
        EditSourceAction() {
            super(ActionsBundle.actionText((String)"EditSource"), ActionsBundle.actionDescription((String)"EditSource"), AllIcons.Actions.EditSource);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditSourceAction.$$$reportNull$$$0(0);
            }
            Navigatable[] navigatableArray = (Navigatable[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY);
            OpenSourceUtil.navigate((Navigatable[])navigatableArray);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EditSourceAction.$$$reportNull$$$0(1);
            }
            Navigatable[] navigatableArray = (Navigatable[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY);
            e.getPresentation().setEnabled(navigatableArray != null && navigatableArray.length > 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/cvsSupport2/cvsBrowser/ui/BrowserPanel$EditSourceAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

