/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AquaEditorTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;

public class AquaEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private Color lineMiddleColor = null;
    private Color lineHlColor = null;
    private static Map<Integer, String[]> buttonIconPaths;

    public AquaEditorTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    public void install() {
        super.install();
        this.scroll().setMinimumXposition(9);
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new AquaEditorTabCellRenderer();
    }

    public Insets getTabAreaInsets() {
        Insets insets = super.getTabAreaInsets();
        insets.bottom = 2;
        return insets;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaEditorTabDisplayerUI((TabDisplayer)jComponent);
    }

    protected boolean isAntialiased() {
        return true;
    }

    protected Font createFont() {
        return UIManager.getFont("Label.font");
    }

    protected int createRepaintPolicy() {
        return 351;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n = 28;
        Graphics2D graphics2D = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (graphics2D != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.displayer.getFont());
            Insets insets = this.getTabAreaInsets();
            n = fontMetrics.getHeight() + insets.top + insets.bottom + 7;
        }
        if (n % 2 == 0) {
            ++n;
        }
        return new Dimension(this.displayer.getWidth(), n);
    }

    protected void paintAfterTabs(Graphics graphics) {
        int n = (this.displayer.getHeight() - 2) / 2 + 0 - 1 + this.getTabAreaInsets().top + 1;
        if (this.lineMiddleColor == null) {
            this.lineMiddleColor = ColorUtil.getMiddle(UIManager.getColor("controlShadow"), UIManager.getColor("control"));
        }
        graphics.setColor(this.lineMiddleColor);
        int n2 = this.getTabsAreaWidth() - 13;
        int n3 = this.displayer.getWidth() - 9;
        if (this.displayer.getModel().size() > 0 && !this.scroll().isLastTabClipped()) {
            int n4 = this.scroll().getLastVisibleTab(this.displayer.getWidth());
            n2 = this.scroll().getX(n4) + this.scroll().getW(n4);
        } else if (this.displayer.getModel().size() == 0) {
            n2 = 6;
        }
        if (this.scroll().getOffset() >= 0) {
            graphics.drawLine(6, n, 11, n);
        }
        graphics.drawLine(n2, n, n3, n);
        if (this.lineHlColor == null) {
            this.lineHlColor = ColorUtil.getMiddle(this.lineMiddleColor, UIManager.getColor("control"));
        }
        graphics.setColor(this.lineHlColor);
        graphics.drawLine(n2, n + 1, n3, n + 1);
        if (this.scroll().getOffset() > 0) {
            graphics.drawLine(6, n + 1, 11, n + 1);
        }
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            String[] stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/mac_scrollleft_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/mac_scrollleft_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/mac_scrollleft_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/mac_scrollleft_pressed.png";
            buttonIconPaths.put(9, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/mac_scrollright_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/mac_scrollright_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/mac_scrollright_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/mac_scrollright_pressed.png";
            buttonIconPaths.put(10, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/mac_popup_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/mac_popup_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/mac_popup_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/mac_popup_pressed.png";
            buttonIconPaths.put(8, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/mac_maximize_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/mac_maximize_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/mac_maximize_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/mac_maximize_pressed.png";
            buttonIconPaths.put(3, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/mac_restore_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/mac_restore_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/mac_restore_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/mac_restore_pressed.png";
            buttonIconPaths.put(4, stringArray);
        }
    }

    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        AquaEditorTabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        return icon;
    }

    protected Rectangle getControlButtonsRectangle(Container container) {
        int n = (this.displayer.getHeight() - 2) / 2 + 0 + this.getTabAreaInsets().top;
        int n2 = container.getWidth();
        int n3 = container.getHeight();
        int n4 = this.getControlButtons().getWidth();
        int n5 = this.getControlButtons().getHeight();
        return new Rectangle(n2 - n4 - 3, n - n5 / 2, n4, n5);
    }
}

