/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.apache.tomcat.util.compat.Jre6Compat;

class Jre7Compat
extends Jre6Compat {
    private static final Method forLanguageTagMethod;

    Jre7Compat() {
    }

    static boolean isSupported() {
        return forLanguageTagMethod != null;
    }

    public Locale forLanguageTag(String languageTag) {
        try {
            return (Locale)forLanguageTagMethod.invoke(null, languageTag);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    static {
        Method m = null;
        try {
            m = Locale.class.getMethod("forLanguageTag", String.class);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        forLanguageTagMethod = m;
    }
}

