/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.geolocation.GeolocationProvider;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class GeolocationHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeolocationHandler.class);
    private final GeolocationProvider geolocationProvider;
    private final boolean processInvalidPositions;

    public GeolocationHandler(GeolocationProvider geolocationProvider, boolean processInvalidPositions) {
        this.geolocationProvider = geolocationProvider;
        this.processInvalidPositions = processInvalidPositions;
    }

    public void channelRead(final ChannelHandlerContext ctx, Object message) throws Exception {
        if (message instanceof Position) {
            final Position position = (Position)message;
            if ((position.getOutdated() || this.processInvalidPositions && !position.getValid()) && position.getNetwork() != null) {
                Context.getStatisticsManager().registerGeolocationRequest();
                this.geolocationProvider.getLocation(position.getNetwork(), new GeolocationProvider.LocationProviderCallback(){

                    @Override
                    public void onSuccess(double latitude, double longitude, double accuracy) {
                        position.set("approximate", true);
                        position.setValid(true);
                        position.setFixTime(position.getDeviceTime());
                        position.setLatitude(latitude);
                        position.setLongitude(longitude);
                        position.setAccuracy(accuracy);
                        position.setAltitude(0.0);
                        position.setSpeed(0.0);
                        position.setCourse(0.0);
                        position.set("rssi", 0);
                        ctx.fireChannelRead((Object)position);
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        LOGGER.warn("Geolocation network error", e);
                        ctx.fireChannelRead((Object)position);
                    }
                });
            } else {
                ctx.fireChannelRead((Object)position);
            }
        } else {
            ctx.fireChannelRead(message);
        }
    }
}

