/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.model.User;
import org.traccar.notification.PropertiesProvider;

public final class MailManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailManager.class);

    private static Properties getProperties(PropertiesProvider provider) {
        Properties properties = new Properties();
        String host = provider.getString("mail.smtp.host");
        if (host != null) {
            String from;
            String password;
            String username;
            String sslProtocols;
            String sslTrust;
            Boolean sslEnable;
            Boolean starttlsRequired;
            properties.put("mail.transport.protocol", provider.getString("mail.transport.protocol", "smtp"));
            properties.put("mail.smtp.host", host);
            properties.put("mail.smtp.port", String.valueOf(provider.getInteger("mail.smtp.port", 25)));
            Boolean starttlsEnable = provider.getBoolean("mail.smtp.starttls.enable");
            if (starttlsEnable != null) {
                properties.put("mail.smtp.starttls.enable", String.valueOf(starttlsEnable));
            }
            if ((starttlsRequired = provider.getBoolean("mail.smtp.starttls.required")) != null) {
                properties.put("mail.smtp.starttls.required", String.valueOf(starttlsRequired));
            }
            if ((sslEnable = provider.getBoolean("mail.smtp.ssl.enable")) != null) {
                properties.put("mail.smtp.ssl.enable", String.valueOf(sslEnable));
            }
            if ((sslTrust = provider.getString("mail.smtp.ssl.trust")) != null) {
                properties.put("mail.smtp.ssl.trust", sslTrust);
            }
            if ((sslProtocols = provider.getString("mail.smtp.ssl.protocols")) != null) {
                properties.put("mail.smtp.ssl.protocols", sslProtocols);
            }
            if ((username = provider.getString("mail.smtp.username")) != null) {
                properties.put("mail.smtp.username", username);
            }
            if ((password = provider.getString("mail.smtp.password")) != null) {
                properties.put("mail.smtp.password", password);
            }
            if ((from = provider.getString("mail.smtp.from")) != null) {
                properties.put("mail.smtp.from", from);
            }
        }
        return properties;
    }

    public void sendMessage(long userId, String subject, String body) throws MessagingException {
        this.sendMessage(userId, subject, body, null);
    }

    public void sendMessage(long userId, String subject, String body, MimeBodyPart attachment) throws MessagingException {
        User user = Context.getPermissionsManager().getUser(userId);
        Properties properties = null;
        if (!Context.getConfig().getBoolean("mail.smtp.ignoreUserConfig")) {
            properties = MailManager.getProperties(new PropertiesProvider(user));
        }
        if (properties == null || !properties.containsKey("mail.smtp.host")) {
            properties = MailManager.getProperties(new PropertiesProvider(Context.getConfig()));
        }
        if (!properties.containsKey("mail.smtp.host")) {
            LOGGER.warn("No SMTP configuration found");
            return;
        }
        Session session = Session.getInstance((Properties)properties);
        MimeMessage message = new MimeMessage(session);
        String from = properties.getProperty("mail.smtp.from");
        if (from != null) {
            message.setFrom((Address)new InternetAddress(from));
        }
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(user.getEmail()));
        message.setSubject(subject);
        message.setSentDate(new Date());
        if (attachment != null) {
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)body, "text/html; charset=utf-8");
            multipart.addBodyPart((BodyPart)messageBodyPart);
            multipart.addBodyPart((BodyPart)attachment);
            message.setContent((Multipart)multipart);
        } else {
            message.setContent((Object)body, "text/html; charset=utf-8");
        }
        try (Transport transport = session.getTransport();){
            Context.getStatisticsManager().registerMail();
            transport.connect(properties.getProperty("mail.smtp.host"), properties.getProperty("mail.smtp.username"), properties.getProperty("mail.smtp.password"));
            transport.sendMessage((Message)message, message.getAllRecipients());
        }
    }
}

