/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssFrequency;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssTime;
import org.w3c.css.values.CssValue;

public class CssCalc
extends CssCheckableValue {
    public static final int type = 19;
    ApplContext ac;
    int computed_type = -1;
    CssValue val1 = null;
    CssValue val2 = null;
    char operator;
    boolean hasParen = false;
    String _toString = null;

    @Override
    public final int getRawType() {
        return 19;
    }

    @Override
    public final int getType() {
        if (this.computed_type == 19) {
            return 19;
        }
        return this.computed_type;
    }

    public CssCalc() {
    }

    public CssCalc(ApplContext ac) {
        this(ac, null);
    }

    public CssCalc(CssValue value) {
        this(null, value);
    }

    public CssCalc(ApplContext ac, CssValue value) {
        if (ac != null) {
            this.ac = ac;
        }
        if (value != null) {
            this.computed_type = value.getType();
            this.val1 = value;
        }
    }

    @Override
    public void set(String s, ApplContext ac) throws InvalidParamException {
        throw new InvalidParamException("unrecognize", s, ac);
    }

    @Override
    public void setValue(BigDecimal d) {
    }

    public CssCalc setLeftSide(CssValue value) throws InvalidParamException {
        if (this.val1 != null) {
            throw new InvalidParamException("unrecognized", this.val1, this.ac);
        }
        this.val1 = value;
        this._toString = null;
        return this;
    }

    public CssCalc addRightSide(String oper, CssValue value) throws InvalidParamException {
        this._toString = null;
        switch (oper) {
            case "+": {
                this.operator = (char)43;
                break;
            }
            case "-": {
                this.operator = (char)45;
                break;
            }
            case "*": {
                this.operator = (char)42;
                break;
            }
            case "/": {
                this.operator = (char)47;
                break;
            }
            default: {
                throw new InvalidParamException("operator", oper, this.ac);
            }
        }
        this.val2 = value;
        this._computeResultingType(false);
        return this;
    }

    public CssCalc setParenthesis() {
        this.hasParen = true;
        return this;
    }

    public void validate() throws InvalidParamException {
        this._computeResultingType(true);
    }

    private void _checkAcceptableType(int type) throws InvalidParamException {
        if (type != 4 && type != 6 && type != 5 && type != 7 && type != 9 && type != 8) {
            throw new InvalidParamException("invalidtype", this.toStringUnprefixed(), this.ac);
        }
    }

    private void _computeResultingType(boolean end) throws InvalidParamException {
        if (this.val2 == null) {
            int valtype = this.val1.getType();
            this._checkAcceptableType(valtype);
            this.computed_type = valtype;
        } else {
            switch (this.operator) {
                case '*': {
                    if (this.val1.getType() == 5) {
                        int valtype = this.val2.getType();
                        this._checkAcceptableType(valtype);
                        this.computed_type = valtype;
                        break;
                    }
                    if (this.val2.getType() == 5) {
                        int valtype = this.val1.getType();
                        this._checkAcceptableType(valtype);
                        this.computed_type = valtype;
                        break;
                    }
                    throw new InvalidParamException("operandnumber", this.toStringUnprefixed(), this.ac);
                }
                case '/': {
                    if (this.val2.getType() != 5) {
                        throw new InvalidParamException("divisortype", this.toStringUnprefixed(), this.ac);
                    }
                    if (this.val2.getNumber().isZero()) {
                        throw new InvalidParamException("divzero", this.toStringUnprefixed(), this.ac);
                    }
                    int valtype = this.val1.getType();
                    this._checkAcceptableType(valtype);
                    this.computed_type = valtype;
                    break;
                }
                case '+': 
                case '-': {
                    int valtype = this.val1.getType();
                    if (valtype == this.val2.getType()) {
                        this._checkAcceptableType(valtype);
                        this.computed_type = valtype;
                        break;
                    }
                    if (valtype == 4) {
                        valtype = this.val2.getType();
                        this._checkAcceptableType(valtype);
                        this.computed_type = valtype;
                        break;
                    }
                    if (this.val2.getType() == 4) {
                        this._checkAcceptableType(valtype);
                        this.computed_type = valtype;
                        break;
                    }
                    if (valtype == 5 && this.val1.getNumber().isZero()) {
                        valtype = this.val2.getType();
                        this._checkAcceptableType(valtype);
                        this.computed_type = valtype;
                        break;
                    }
                    if (this.val2.getType() == 5 && this.val2.getNumber().isZero()) {
                        this._checkAcceptableType(valtype);
                        this.computed_type = valtype;
                        break;
                    }
                    throw new InvalidParamException("incompatibletypes", this.toStringUnprefixed(), this.ac);
                }
                default: {
                    int valtype = this.val1.getType();
                    this._checkAcceptableType(valtype);
                    this.computed_type = valtype;
                }
            }
        }
    }

    @Override
    public Object get() {
        return this.toString();
    }

    protected String toStringUnprefixed() {
        StringBuilder sb = new StringBuilder();
        if (this.hasParen) {
            sb.append('(');
        }
        if (this.val1.getRawType() == 19) {
            sb.append(((CssCalc)this.val1).toStringUnprefixed());
        } else {
            sb.append(this.val1);
        }
        if (this.val2 != null) {
            sb.append(' ').append(this.operator).append(' ');
            if (this.val2.getRawType() == 19) {
                sb.append(((CssCalc)this.val2).toStringUnprefixed());
            } else {
                sb.append(this.val2);
            }
        }
        if (this.hasParen) {
            sb.append(')');
        }
        return sb.toString();
    }

    public String toString() {
        if (this._toString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("calc(").append(this.toStringUnprefixed()).append(')');
            this._toString = sb.toString();
        }
        return this._toString;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isPositive() {
        return false;
    }

    @Override
    public boolean isStrictlyPositive() {
        return false;
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean equals(Object value) {
        return value instanceof CssCalc && this.val1.equals(((CssCalc)value).val1) && this.val2.equals(((CssCalc)value).val2);
    }

    @Override
    public void checkPositiveness(ApplContext ac, String callername) throws InvalidParamException {
    }

    @Override
    public void checkStrictPositiveness(ApplContext ac, String callername) throws InvalidParamException {
    }

    @Override
    public void checkInteger(ApplContext ac, String callername) throws InvalidParamException {
    }

    @Override
    public void warnPositiveness(ApplContext ac, String callername) {
    }

    @Override
    public CssLength getLength() throws InvalidParamException {
        if (this.computed_type == 6) {
            if (this.val1.getType() == 6) {
                return this.val1.getLength();
            }
            if (this.val2.getType() == 6) {
                return this.val2.getLength();
            }
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssPercentage getPercentage() throws InvalidParamException {
        if (this.computed_type == 4) {
            if (this.val1.getType() == 4) {
                return this.val1.getPercentage();
            }
            if (this.val2.getType() == 4) {
                return this.val2.getPercentage();
            }
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssNumber getNumber() throws InvalidParamException {
        if (this.computed_type == 5) {
            if (this.val1.getType() == 5) {
                return this.val1.getNumber();
            }
            if (this.val2.getType() == 5) {
                return this.val2.getNumber();
            }
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssTime getTime() throws InvalidParamException {
        if (this.computed_type == 8) {
            if (this.val1.getType() == 8) {
                return this.val1.getTime();
            }
            if (this.val2.getType() == 8) {
                return this.val2.getTime();
            }
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssAngle getAngle() throws InvalidParamException {
        if (this.computed_type == 7) {
            if (this.val1.getType() == 7) {
                return this.val1.getAngle();
            }
            if (this.val2.getType() == 7) {
                return this.val2.getAngle();
            }
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssFrequency getFrequency() throws InvalidParamException {
        if (this.computed_type == 9) {
            if (this.val1.getType() == 9) {
                return this.val1.getFrequency();
            }
            if (this.val2.getType() == 9) {
                return this.val2.getFrequency();
            }
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public void checkEqualsZero(ApplContext ac, String callername) throws InvalidParamException {
        this.warnEqualsZero(ac, callername);
    }

    @Override
    public void warnEqualsZero(ApplContext ac, String callername) {
        if (!this.isZero()) {
            ac.getFrame().addWarning("dynamic", this.toString());
        }
    }
}

