/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zaproxy.zap.ZapHttpConnection;
import org.zaproxy.zap.network.ZapHttpParser;

public class ZapGetMethod
extends GetMethod {
    private static final Log LOG = LogFactory.getLog(ZapGetMethod.class);
    private Socket upgradedSocket;
    private InputStream inputStream;

    public ZapGetMethod() {
    }

    public ZapGetMethod(String uri) {
        super(uri);
    }

    protected void readResponse(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.readResponse(HttpState, HttpConnection)");
        boolean isUpgrade = false;
        while (this.getStatusLine() == null) {
            this.readStatusLine(state, conn);
            this.processStatusLine(state, conn);
            this.readResponseHeaders(state, conn);
            this.processResponseHeaders(state, conn);
            int status = this.statusLine.getStatusCode();
            if (status == 101) {
                LOG.debug((Object)"Retrieved HTTP status code '101 Switching Protocols'. Keep connection open!");
                if (!(conn instanceof ZapHttpConnection)) continue;
                isUpgrade = true;
                conn.setHttpConnectionManager(null);
                continue;
            }
            if (status < 100 || status >= 200) continue;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Discarding unexpected response: " + this.statusLine.toString()));
            }
            this.statusLine = null;
        }
        if (conn instanceof ZapHttpConnection) {
            ZapHttpConnection zapConn = (ZapHttpConnection)conn;
            this.upgradedSocket = zapConn.getSocket();
            this.inputStream = zapConn.getResponseInputStream();
        }
        if (!isUpgrade) {
            this.readResponseBody(state, conn);
            this.processResponseBody(state, conn);
        }
    }

    public Socket getUpgradedConnection() {
        return this.upgradedSocket;
    }

    public InputStream getUpgradedInputStream() {
        return this.inputStream;
    }

    public void releaseConnection() {
        String contentTypeHeader;
        Header header = this.getResponseHeader("content-type");
        if (header != null && (contentTypeHeader = header.getValue()) != null && contentTypeHeader.equals("text/event-stream")) {
            return;
        }
        super.releaseConnection();
    }

    protected void readResponseHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        this.getResponseHeaderGroup().clear();
        Header[] headers = ZapHttpParser.parseHeaders(conn.getResponseInputStream(), this.getParams().getHttpElementCharset());
        this.getResponseHeaderGroup().setHeaders(headers);
    }
}

