from envi.archs.z80.regs import *
from envi.archs.z80.const import *
# (patrn,mask), mnem, o1type, o1info, o2type, o2info, oplen, immoff, iflags
z80table = [
(('00', 'ff'), 'nop', None, None, None, None, 1, 0, 0),
(('010000', 'ff0000'), 'ld', OPTYPE_Reg, REG_BC, OPTYPE_imm16, None, 3, 1, 0),
(('02', 'ff'), 'ld', OPTYPE_RegMem, REG_BC, OPTYPE_Reg, REG_A, 1, 0, 0),
(('03', 'ff'), 'inc', OPTYPE_Reg, REG_BC, None, None, 1, 0, 0),
(('04', 'ff'), 'inc', OPTYPE_Reg, REG_B, None, None, 1, 0, 0),
(('05', 'ff'), 'dec', OPTYPE_Reg, REG_B, None, None, 1, 0, 0),
(('0600', 'ff00'), 'ld', OPTYPE_Reg, REG_B, OPTYPE_imm8, None, 2, 1, 0),
(('07', 'ff'), 'rlca', None, None, None, None, 1, 0, 0),
(('08', 'ff'), 'ex', OPTYPE_Reg, REG_AF, OPTYPE_RegAlt, REG_AF, 1, 0, 0),
(('09', 'ff'), 'add', OPTYPE_Reg, REG_HL, OPTYPE_Reg, REG_BC, 1, 0, 0),
(('0a', 'ff'), 'ld', OPTYPE_Reg, REG_A, OPTYPE_RegMem, REG_BC, 1, 0, 0),
(('0b', 'ff'), 'dec', OPTYPE_Reg, REG_BC, None, None, 1, 0, 0),
(('0c', 'ff'), 'inc', OPTYPE_Reg, REG_C, None, None, 1, 0, 0),
(('0d', 'ff'), 'dec', OPTYPE_Reg, REG_C, None, None, 1, 0, 0),
(('0e00', 'ff00'), 'ld', OPTYPE_Reg, REG_C, OPTYPE_imm8, None, 2, 1, 0),
(('0f', 'ff'), 'rrca', None, None, None, None, 1, 0, 0),
(('1000', 'ff00'), 'djnz', OPTYPE_Ind, None, None, None, 2, 1, 0),
(('110000', 'ff0000'), 'ld', OPTYPE_Reg, REG_DE, OPTYPE_imm16, None, 3, 1, 0),
(('12', 'ff'), 'ld', OPTYPE_RegMem, REG_DE, OPTYPE_Reg, REG_A, 1, 0, 0),
(('13', 'ff'), 'inc', OPTYPE_Reg, REG_DE, None, None, 1, 0, 0),
(('14', 'ff'), 'inc', OPTYPE_Reg, REG_D, None, None, 1, 0, 0),
(('15', 'ff'), 'dec', OPTYPE_Reg, REG_D, None, None, 1, 0, 0),
(('1600', 'ff00'), 'ld', OPTYPE_Reg, REG_D, OPTYPE_imm8, None, 2, 1, 0),
(('17', 'ff'), 'rla', None, None, None, None, 1, 0, 0),
(('1800', 'ff00'), 'jr', OPTYPE_Ind, None, None, None, 2, 1, 0),
(('19', 'ff'), 'add', OPTYPE_Reg, REG_HL, OPTYPE_Reg, REG_DE, 1, 0, 0),
(('1a', 'ff'), 'ld', OPTYPE_Reg, REG_A, OPTYPE_RegMem, REG_DE, 1, 0, 0),
(('1b', 'ff'), 'dec', OPTYPE_Reg, REG_DE, None, None, 1, 0, 0),
(('1c', 'ff'), 'inc', OPTYPE_Reg, REG_E, None, None, 1, 0, 0),
(('1d', 'ff'), 'dec', OPTYPE_Reg, REG_E, None, None, 1, 0, 0),
(('1e00', 'ff00'), 'ld', OPTYPE_Reg, REG_E, OPTYPE_imm8, None, 2, 1, 0),
(('1f', 'ff'), 'rra', None, None, None, None, 1, 0, 0),
(('2000', 'ff00'), 'jr', OPTYPE_Cond, COND_NZ, OPTYPE_Ind, None, 2, 1, 0),
(('210000', 'ff0000'), 'ld', OPTYPE_Reg, REG_HL, OPTYPE_imm16, None, 3, 1, 0),
(('220000', 'ff0000'), 'ld', OPTYPE_immmem16, None, OPTYPE_Reg, REG_HL, 3, 1, 0),
(('23', 'ff'), 'inc', OPTYPE_Reg, REG_HL, None, None, 1, 0, 0),
(('24', 'ff'), 'inc', OPTYPE_Reg, REG_H, None, None, 1, 0, 0),
(('25', 'ff'), 'dec', OPTYPE_Reg, REG_H, None, None, 1, 0, 0),
(('2600', 'ff00'), 'ld', OPTYPE_Reg, REG_H, OPTYPE_imm8, None, 2, 1, 0),
(('27', 'ff'), 'daa', None, None, None, None, 1, 0, 0),
(('2800', 'ff00'), 'jr', OPTYPE_Cond, COND_Z, OPTYPE_Ind, None, 2, 1, 0),
(('29', 'ff'), 'add', OPTYPE_Reg, REG_HL, OPTYPE_Reg, REG_HL, 1, 0, 0),
(('2a0000', 'ff0000'), 'ld', OPTYPE_Reg, REG_HL, OPTYPE_immmem16, None, 3, 1, 0),
(('2b', 'ff'), 'dec', OPTYPE_Reg, REG_HL, None, None, 1, 0, 0),
(('2c', 'ff'), 'inc', OPTYPE_Reg, REG_L, None, None, 1, 0, 0),
(('2d', 'ff'), 'dec', OPTYPE_Reg, REG_L, None, None, 1, 0, 0),
(('2e00', 'ff00'), 'ld', OPTYPE_Reg, REG_L, OPTYPE_imm8, None, 2, 1, 0),
(('2f', 'ff'), 'cpl', None, None, None, None, 1, 0, 0),
(('3000', 'ff00'), 'jr', OPTYPE_Cond, COND_NC, OPTYPE_Ind, None, 2, 1, 0),
(('310000', 'ff0000'), 'ld', OPTYPE_Reg, REG_SP, OPTYPE_imm16, None, 3, 1, 0),
(('320000', 'ff0000'), 'ld', OPTYPE_immmem16, None, OPTYPE_Reg, REG_A, 3, 1, 0),
(('33', 'ff'), 'inc', OPTYPE_Reg, REG_SP, None, None, 1, 0, 0),
(('34', 'ff'), 'inc', OPTYPE_RegMem, REG_HL, None, None, 1, 0, 0),
(('35', 'ff'), 'dec', OPTYPE_RegMem, REG_HL, None, None, 1, 0, 0),
(('3600', 'ff00'), 'ld', OPTYPE_RegMem, REG_HL, OPTYPE_imm8, None, 2, 1, 0),
(('37', 'ff'), 'scf', None, None, None, None, 1, 0, 0),
(('3800', 'ff00'), 'jr', OPTYPE_Cond, COND_C, OPTYPE_Ind, None, 2, 1, 0),
(('39', 'ff'), 'add', OPTYPE_Reg, REG_HL, OPTYPE_Reg, REG_SP, 1, 0, 0),
(('3a0000', 'ff0000'), 'ld', OPTYPE_Reg, REG_A, OPTYPE_immmem16, None, 3, 1, 0),
(('3b', 'ff'), 'dec', OPTYPE_Reg, REG_SP, None, None, 1, 0, 0),
(('3c', 'ff'), 'inc', OPTYPE_Reg, REG_A, None, None, 1, 0, 0),
(('3d', 'ff'), 'dec', OPTYPE_Reg, REG_A, None, None, 1, 0, 0),
(('3e00', 'ff00'), 'ld', OPTYPE_Reg, REG_A, OPTYPE_imm8, None, 2, 1, 0),
(('3f', 'ff'), 'ccf', None, None, None, None, 1, 0, 0),
(('40', 'ff'), 'ld', OPTYPE_Reg, REG_B, OPTYPE_Reg, REG_B, 1, 0, 0),
(('41', 'ff'), 'ld', OPTYPE_Reg, REG_B, OPTYPE_Reg, REG_C, 1, 0, 0),
(('42', 'ff'), 'ld', OPTYPE_Reg, REG_B, OPTYPE_Reg, REG_D, 1, 0, 0),
(('43', 'ff'), 'ld', OPTYPE_Reg, REG_B, OPTYPE_Reg, REG_E, 1, 0, 0),
(('44', 'ff'), 'ld', OPTYPE_Reg, REG_B, OPTYPE_Reg, REG_H, 1, 0, 0),
(('45', 'ff'), 'ld', OPTYPE_Reg, REG_B, OPTYPE_Reg, REG_L, 1, 0, 0),
(('46', 'ff'), 'ld', OPTYPE_Reg, REG_B, OPTYPE_RegMem, REG_HL, 1, 0, 0),
(('47', 'ff'), 'ld', OPTYPE_Reg, REG_B, OPTYPE_Reg, REG_A, 1, 0, 0),
(('48', 'ff'), 'ld', OPTYPE_Reg, REG_C, OPTYPE_Reg, REG_B, 1, 0, 0),
(('49', 'ff'), 'ld', OPTYPE_Reg, REG_C, OPTYPE_Reg, REG_C, 1, 0, 0),
(('4a', 'ff'), 'ld', OPTYPE_Reg, REG_C, OPTYPE_Reg, REG_D, 1, 0, 0),
(('4b', 'ff'), 'ld', OPTYPE_Reg, REG_C, OPTYPE_Reg, REG_E, 1, 0, 0),
(('4c', 'ff'), 'ld', OPTYPE_Reg, REG_C, OPTYPE_Reg, REG_H, 1, 0, 0),
(('4d', 'ff'), 'ld', OPTYPE_Reg, REG_C, OPTYPE_Reg, REG_L, 1, 0, 0),
(('4e', 'ff'), 'ld', OPTYPE_Reg, REG_C, OPTYPE_RegMem, REG_HL, 1, 0, 0),
(('4f', 'ff'), 'ld', OPTYPE_Reg, REG_C, OPTYPE_Reg, REG_A, 1, 0, 0),
(('50', 'ff'), 'ld', OPTYPE_Reg, REG_D, OPTYPE_Reg, REG_B, 1, 0, 0),
(('51', 'ff'), 'ld', OPTYPE_Reg, REG_D, OPTYPE_Reg, REG_C, 1, 0, 0),
(('52', 'ff'), 'ld', OPTYPE_Reg, REG_D, OPTYPE_Reg, REG_D, 1, 0, 0),
(('53', 'ff'), 'ld', OPTYPE_Reg, REG_D, OPTYPE_Reg, REG_E, 1, 0, 0),
(('54', 'ff'), 'ld', OPTYPE_Reg, REG_D, OPTYPE_Reg, REG_H, 1, 0, 0),
(('55', 'ff'), 'ld', OPTYPE_Reg, REG_D, OPTYPE_Reg, REG_L, 1, 0, 0),
(('56', 'ff'), 'ld', OPTYPE_Reg, REG_D, OPTYPE_RegMem, REG_HL, 1, 0, 0),
(('57', 'ff'), 'ld', OPTYPE_Reg, REG_D, OPTYPE_Reg, REG_A, 1, 0, 0),
(('58', 'ff'), 'ld', OPTYPE_Reg, REG_E, OPTYPE_Reg, REG_B, 1, 0, 0),
(('59', 'ff'), 'ld', OPTYPE_Reg, REG_E, OPTYPE_Reg, REG_C, 1, 0, 0),
(('5a', 'ff'), 'ld', OPTYPE_Reg, REG_E, OPTYPE_Reg, REG_D, 1, 0, 0),
(('5b', 'ff'), 'ld', OPTYPE_Reg, REG_E, OPTYPE_Reg, REG_E, 1, 0, 0),
(('5c', 'ff'), 'ld', OPTYPE_Reg, REG_E, OPTYPE_Reg, REG_H, 1, 0, 0),
(('5d', 'ff'), 'ld', OPTYPE_Reg, REG_E, OPTYPE_Reg, REG_L, 1, 0, 0),
(('5e', 'ff'), 'ld', OPTYPE_Reg, REG_E, OPTYPE_RegMem, REG_HL, 1, 0, 0),
(('5f', 'ff'), 'ld', OPTYPE_Reg, REG_E, OPTYPE_Reg, REG_A, 1, 0, 0),
(('60', 'ff'), 'ld', OPTYPE_Reg, REG_H, OPTYPE_Reg, REG_B, 1, 0, 0),
(('61', 'ff'), 'ld', OPTYPE_Reg, REG_H, OPTYPE_Reg, REG_C, 1, 0, 0),
(('62', 'ff'), 'ld', OPTYPE_Reg, REG_H, OPTYPE_Reg, REG_D, 1, 0, 0),
(('63', 'ff'), 'ld', OPTYPE_Reg, REG_H, OPTYPE_Reg, REG_E, 1, 0, 0),
(('64', 'ff'), 'ld', OPTYPE_Reg, REG_H, OPTYPE_Reg, REG_H, 1, 0, 0),
(('65', 'ff'), 'ld', OPTYPE_Reg, REG_H, OPTYPE_Reg, REG_L, 1, 0, 0),
(('66', 'ff'), 'ld', OPTYPE_Reg, REG_H, OPTYPE_RegMem, REG_HL, 1, 0, 0),
(('67', 'ff'), 'ld', OPTYPE_Reg, REG_H, OPTYPE_Reg, REG_A, 1, 0, 0),
(('68', 'ff'), 'ld', OPTYPE_Reg, REG_L, OPTYPE_Reg, REG_B, 1, 0, 0),
(('69', 'ff'), 'ld', OPTYPE_Reg, REG_L, OPTYPE_Reg, REG_C, 1, 0, 0),
(('6a', 'ff'), 'ld', OPTYPE_Reg, REG_L, OPTYPE_Reg, REG_D, 1, 0, 0),
(('6b', 'ff'), 'ld', OPTYPE_Reg, REG_L, OPTYPE_Reg, REG_E, 1, 0, 0),
(('6c', 'ff'), 'ld', OPTYPE_Reg, REG_L, OPTYPE_Reg, REG_H, 1, 0, 0),
(('6d', 'ff'), 'ld', OPTYPE_Reg, REG_L, OPTYPE_Reg, REG_L, 1, 0, 0),
(('6e', 'ff'), 'ld', OPTYPE_Reg, REG_L, OPTYPE_RegMem, REG_HL, 1, 0, 0),
(('6f', 'ff'), 'ld', OPTYPE_Reg, REG_L, OPTYPE_Reg, REG_A, 1, 0, 0),
(('70', 'ff'), 'ld', OPTYPE_RegMem, REG_HL, OPTYPE_Reg, REG_B, 1, 0, 0),
(('71', 'ff'), 'ld', OPTYPE_RegMem, REG_HL, OPTYPE_Reg, REG_C, 1, 0, 0),
(('72', 'ff'), 'ld', OPTYPE_RegMem, REG_HL, OPTYPE_Reg, REG_D, 1, 0, 0),
(('73', 'ff'), 'ld', OPTYPE_RegMem, REG_HL, OPTYPE_Reg, REG_E, 1, 0, 0),
(('74', 'ff'), 'ld', OPTYPE_RegMem, REG_HL, OPTYPE_Reg, REG_H, 1, 0, 0),
(('75', 'ff'), 'ld', OPTYPE_RegMem, REG_HL, OPTYPE_Reg, REG_L, 1, 0, 0),
(('76', 'ff'), 'halt', None, None, None, None, 1, 0, 0),
(('77', 'ff'), 'ld', OPTYPE_RegMem, REG_HL, OPTYPE_Reg, REG_A, 1, 0, 0),
(('78', 'ff'), 'ld', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_B, 1, 0, 0),
(('79', 'ff'), 'ld', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_C, 1, 0, 0),
(('7a', 'ff'), 'ld', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_D, 1, 0, 0),
(('7b', 'ff'), 'ld', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_E, 1, 0, 0),
(('7c', 'ff'), 'ld', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_H, 1, 0, 0),
(('7d', 'ff'), 'ld', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_L, 1, 0, 0),
(('7e', 'ff'), 'ld', OPTYPE_Reg, REG_A, OPTYPE_RegMem, REG_HL, 1, 0, 0),
(('7f', 'ff'), 'ld', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_A, 1, 0, 0),
(('80', 'ff'), 'add', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_B, 1, 0, 0),
(('81', 'ff'), 'add', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_C, 1, 0, 0),
(('82', 'ff'), 'add', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_D, 1, 0, 0),
(('83', 'ff'), 'add', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_E, 1, 0, 0),
(('84', 'ff'), 'add', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_H, 1, 0, 0),
(('85', 'ff'), 'add', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_L, 1, 0, 0),
(('86', 'ff'), 'add', OPTYPE_Reg, REG_A, OPTYPE_RegMem, REG_HL, 1, 0, 0),
(('87', 'ff'), 'add', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_A, 1, 0, 0),
(('88', 'ff'), 'adc', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_B, 1, 0, 0),
(('89', 'ff'), 'adc', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_C, 1, 0, 0),
(('8a', 'ff'), 'adc', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_D, 1, 0, 0),
(('8b', 'ff'), 'adc', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_E, 1, 0, 0),
(('8c', 'ff'), 'adc', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_H, 1, 0, 0),
(('8d', 'ff'), 'adc', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_L, 1, 0, 0),
(('8e', 'ff'), 'adc', OPTYPE_Reg, REG_A, OPTYPE_RegMem, REG_HL, 1, 0, 0),
(('8f', 'ff'), 'adc', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_A, 1, 0, 0),
(('90', 'ff'), 'sub', OPTYPE_Reg, REG_B, None, None, 1, 0, 0),
(('91', 'ff'), 'sub', OPTYPE_Reg, REG_C, None, None, 1, 0, 0),
(('92', 'ff'), 'sub', OPTYPE_Reg, REG_D, None, None, 1, 0, 0),
(('93', 'ff'), 'sub', OPTYPE_Reg, REG_E, None, None, 1, 0, 0),
(('94', 'ff'), 'sub', OPTYPE_Reg, REG_H, None, None, 1, 0, 0),
(('95', 'ff'), 'sub', OPTYPE_Reg, REG_L, None, None, 1, 0, 0),
(('96', 'ff'), 'sub', OPTYPE_RegMem, REG_HL, None, None, 1, 0, 0),
(('97', 'ff'), 'sub', OPTYPE_Reg, REG_A, None, None, 1, 0, 0),
(('98', 'ff'), 'sbc', OPTYPE_Reg, REG_B, None, None, 1, 0, 0),
(('99', 'ff'), 'sbc', OPTYPE_Reg, REG_C, None, None, 1, 0, 0),
(('9a', 'ff'), 'sbc', OPTYPE_Reg, REG_D, None, None, 1, 0, 0),
(('9b', 'ff'), 'sbc', OPTYPE_Reg, REG_E, None, None, 1, 0, 0),
(('9c', 'ff'), 'sbc', OPTYPE_Reg, REG_H, None, None, 1, 0, 0),
(('9d', 'ff'), 'sbc', OPTYPE_Reg, REG_L, None, None, 1, 0, 0),
(('9e', 'ff'), 'sbc', OPTYPE_RegMem, REG_HL, None, None, 1, 0, 0),
(('9f', 'ff'), 'sbc', OPTYPE_Reg, REG_A, None, None, 1, 0, 0),
(('a0', 'ff'), 'and', OPTYPE_Reg, REG_B, None, None, 1, 0, 0),
(('a1', 'ff'), 'and', OPTYPE_Reg, REG_C, None, None, 1, 0, 0),
(('a2', 'ff'), 'and', OPTYPE_Reg, REG_D, None, None, 1, 0, 0),
(('a3', 'ff'), 'and', OPTYPE_Reg, REG_E, None, None, 1, 0, 0),
(('a4', 'ff'), 'and', OPTYPE_Reg, REG_H, None, None, 1, 0, 0),
(('a5', 'ff'), 'and', OPTYPE_Reg, REG_L, None, None, 1, 0, 0),
(('a6', 'ff'), 'and', OPTYPE_RegMem, REG_HL, None, None, 1, 0, 0),
(('a7', 'ff'), 'and', OPTYPE_Reg, REG_A, None, None, 1, 0, 0),
(('a8', 'ff'), 'xor', OPTYPE_Reg, REG_B, None, None, 1, 0, 0),
(('a9', 'ff'), 'xor', OPTYPE_Reg, REG_C, None, None, 1, 0, 0),
(('aa', 'ff'), 'xor', OPTYPE_Reg, REG_D, None, None, 1, 0, 0),
(('ab', 'ff'), 'xor', OPTYPE_Reg, REG_E, None, None, 1, 0, 0),
(('ac', 'ff'), 'xor', OPTYPE_Reg, REG_H, None, None, 1, 0, 0),
(('ad', 'ff'), 'xor', OPTYPE_Reg, REG_L, None, None, 1, 0, 0),
(('ae', 'ff'), 'xor', OPTYPE_RegMem, REG_HL, None, None, 1, 0, 0),
(('af', 'ff'), 'xor', OPTYPE_Reg, REG_A, None, None, 1, 0, 0),
(('b0', 'ff'), 'or', OPTYPE_Reg, REG_B, None, None, 1, 0, 0),
(('b1', 'ff'), 'or', OPTYPE_Reg, REG_C, None, None, 1, 0, 0),
(('b2', 'ff'), 'or', OPTYPE_Reg, REG_D, None, None, 1, 0, 0),
(('b3', 'ff'), 'or', OPTYPE_Reg, REG_E, None, None, 1, 0, 0),
(('b4', 'ff'), 'or', OPTYPE_Reg, REG_H, None, None, 1, 0, 0),
(('b5', 'ff'), 'or', OPTYPE_Reg, REG_L, None, None, 1, 0, 0),
(('b6', 'ff'), 'or', OPTYPE_RegMem, REG_HL, None, None, 1, 0, 0),
(('b7', 'ff'), 'or', OPTYPE_Reg, REG_A, None, None, 1, 0, 0),
(('b8', 'ff'), 'cp', OPTYPE_Reg, REG_B, None, None, 1, 0, 0),
(('b9', 'ff'), 'cp', OPTYPE_Reg, REG_C, None, None, 1, 0, 0),
(('ba', 'ff'), 'cp', OPTYPE_Reg, REG_D, None, None, 1, 0, 0),
(('bb', 'ff'), 'cp', OPTYPE_Reg, REG_E, None, None, 1, 0, 0),
(('bc', 'ff'), 'cp', OPTYPE_Reg, REG_H, None, None, 1, 0, 0),
(('bd', 'ff'), 'cp', OPTYPE_Reg, REG_L, None, None, 1, 0, 0),
(('be', 'ff'), 'cp', OPTYPE_RegMem, REG_HL, None, None, 1, 0, 0),
(('bf', 'ff'), 'cp', OPTYPE_Reg, REG_A, None, None, 1, 0, 0),
(('c0', 'ff'), 'ret', OPTYPE_Cond, COND_NZ, None, None, 1, 0, 0),
(('c1', 'ff'), 'pop', OPTYPE_Reg, REG_BC, None, None, 1, 0, 0),
(('c2', 'ff'), 'jp', OPTYPE_Cond, COND_NZ, OPTYPE_Ind, None, 1, 0, 0),
(('c3', 'ff'), 'jp', OPTYPE_imm16, None, None, None, 3, 1, 0),
(('c40000', 'ff0000'), 'call', OPTYPE_Cond, COND_NZ, OPTYPE_imm16, None, 3, 1, 0),
(('c5', 'ff'), 'push', OPTYPE_Reg, REG_BC, None, None, 1, 0, 0),
(('c600', 'ff00'), 'add', OPTYPE_Reg, REG_A, OPTYPE_imm8, None, 2, 1, 0),
(('c7', 'ff'), 'rst', OPTYPE_const, 0, None, None, 1, 0, 0),
(('c8', 'ff'), 'ret', OPTYPE_Cond, COND_Z, None, None, 1, 0, 0),
(('c9', 'ff'), 'ret', None, None, None, None, 1, 0, 0),
(('ca', 'ff'), 'jp', OPTYPE_Cond, COND_Z, OPTYPE_Ind, None, 1, 0, 0),
(('cb00', 'ffff'), 'rlc', OPTYPE_Reg, REG_B, None, None, 2, 0, 0),
(('cb01', 'ffff'), 'rlc', OPTYPE_Reg, REG_C, None, None, 2, 0, 0),
(('cb02', 'ffff'), 'rlc', OPTYPE_Reg, REG_D, None, None, 2, 0, 0),
(('cb03', 'ffff'), 'rlc', OPTYPE_Reg, REG_E, None, None, 2, 0, 0),
(('cb04', 'ffff'), 'rlc', OPTYPE_Reg, REG_H, None, None, 2, 0, 0),
(('cb05', 'ffff'), 'rlc', OPTYPE_Reg, REG_L, None, None, 2, 0, 0),
(('cb06', 'ffff'), 'rlc', OPTYPE_RegMem, REG_HL, None, None, 2, 0, 0),
(('cb07', 'ffff'), 'rlc', OPTYPE_Reg, REG_A, None, None, 2, 0, 0),
(('cb08', 'ffff'), 'rrc', OPTYPE_Reg, REG_B, None, None, 2, 0, 0),
(('cb09', 'ffff'), 'rrc', OPTYPE_Reg, REG_C, None, None, 2, 0, 0),
(('cb0a', 'ffff'), 'rrc', OPTYPE_Reg, REG_D, None, None, 2, 0, 0),
(('cb0b', 'ffff'), 'rrc', OPTYPE_Reg, REG_E, None, None, 2, 0, 0),
(('cb0c', 'ffff'), 'rrc', OPTYPE_Reg, REG_H, None, None, 2, 0, 0),
(('cb0d', 'ffff'), 'rrc', OPTYPE_Reg, REG_L, None, None, 2, 0, 0),
(('cb0e', 'ffff'), 'rrc', OPTYPE_RegMem, REG_HL, None, None, 2, 0, 0),
(('cb0f', 'ffff'), 'rrc', OPTYPE_Reg, REG_A, None, None, 2, 0, 0),
(('cb10', 'ffff'), 'rl', OPTYPE_Reg, REG_B, None, None, 2, 0, 0),
(('cb11', 'ffff'), 'rl', OPTYPE_Reg, REG_C, None, None, 2, 0, 0),
(('cb12', 'ffff'), 'rl', OPTYPE_Reg, REG_D, None, None, 2, 0, 0),
(('cb13', 'ffff'), 'rl', OPTYPE_Reg, REG_E, None, None, 2, 0, 0),
(('cb14', 'ffff'), 'rl', OPTYPE_Reg, REG_H, None, None, 2, 0, 0),
(('cb15', 'ffff'), 'rl', OPTYPE_Reg, REG_L, None, None, 2, 0, 0),
(('cb16', 'ffff'), 'rl', OPTYPE_RegMem, REG_HL, None, None, 2, 0, 0),
(('cb17', 'ffff'), 'rl', OPTYPE_Reg, REG_A, None, None, 2, 0, 0),
(('cb18', 'ffff'), 'rr', OPTYPE_Reg, REG_B, None, None, 2, 0, 0),
(('cb19', 'ffff'), 'rr', OPTYPE_Reg, REG_C, None, None, 2, 0, 0),
(('cb1a', 'ffff'), 'rr', OPTYPE_Reg, REG_D, None, None, 2, 0, 0),
(('cb1b', 'ffff'), 'rr', OPTYPE_Reg, REG_E, None, None, 2, 0, 0),
(('cb1c', 'ffff'), 'rr', OPTYPE_Reg, REG_H, None, None, 2, 0, 0),
(('cb1d', 'ffff'), 'rr', OPTYPE_Reg, REG_L, None, None, 2, 0, 0),
(('cb1e', 'ffff'), 'rr', OPTYPE_RegMem, REG_HL, None, None, 2, 0, 0),
(('cb1f', 'ffff'), 'rr', OPTYPE_Reg, REG_A, None, None, 2, 0, 0),
(('cb20', 'ffff'), 'sla', OPTYPE_Reg, REG_B, None, None, 2, 0, 0),
(('cb21', 'ffff'), 'sla', OPTYPE_Reg, REG_C, None, None, 2, 0, 0),
(('cb22', 'ffff'), 'sla', OPTYPE_Reg, REG_D, None, None, 2, 0, 0),
(('cb23', 'ffff'), 'sla', OPTYPE_Reg, REG_E, None, None, 2, 0, 0),
(('cb24', 'ffff'), 'sla', OPTYPE_Reg, REG_H, None, None, 2, 0, 0),
(('cb25', 'ffff'), 'sla', OPTYPE_Reg, REG_L, None, None, 2, 0, 0),
(('cb26', 'ffff'), 'sla', OPTYPE_RegMem, REG_HL, None, None, 2, 0, 0),
(('cb27', 'ffff'), 'sla', OPTYPE_Reg, REG_A, None, None, 2, 0, 0),
(('cb28', 'ffff'), 'sra', OPTYPE_Reg, REG_B, None, None, 2, 0, 0),
(('cb29', 'ffff'), 'sra', OPTYPE_Reg, REG_C, None, None, 2, 0, 0),
(('cb2a', 'ffff'), 'sra', OPTYPE_Reg, REG_D, None, None, 2, 0, 0),
(('cb2b', 'ffff'), 'sra', OPTYPE_Reg, REG_E, None, None, 2, 0, 0),
(('cb2c', 'ffff'), 'sra', OPTYPE_Reg, REG_H, None, None, 2, 0, 0),
(('cb2d', 'ffff'), 'sra', OPTYPE_Reg, REG_L, None, None, 2, 0, 0),
(('cb2e', 'ffff'), 'sra', OPTYPE_RegMem, REG_HL, None, None, 2, 0, 0),
(('cb2f', 'ffff'), 'sra', OPTYPE_Reg, REG_A, None, None, 2, 0, 0),
(('cb38', 'ffff'), 'srl', OPTYPE_Reg, REG_B, None, None, 2, 0, 0),
(('cb39', 'ffff'), 'srl', OPTYPE_Reg, REG_C, None, None, 2, 0, 0),
(('cb3a', 'ffff'), 'srl', OPTYPE_Reg, REG_D, None, None, 2, 0, 0),
(('cb3b', 'ffff'), 'srl', OPTYPE_Reg, REG_E, None, None, 2, 0, 0),
(('cb3c', 'ffff'), 'srl', OPTYPE_Reg, REG_H, None, None, 2, 0, 0),
(('cb3d', 'ffff'), 'srl', OPTYPE_Reg, REG_L, None, None, 2, 0, 0),
(('cb3e', 'ffff'), 'srl', OPTYPE_RegMem, REG_HL, None, None, 2, 0, 0),
(('cb3f', 'ffff'), 'srl', OPTYPE_Reg, REG_A, None, None, 2, 0, 0),
(('cb40', 'ffff'), 'bit', OPTYPE_const, 0, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cb41', 'ffff'), 'bit', OPTYPE_const, 0, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cb42', 'ffff'), 'bit', OPTYPE_const, 0, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cb43', 'ffff'), 'bit', OPTYPE_const, 0, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cb44', 'ffff'), 'bit', OPTYPE_const, 0, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cb45', 'ffff'), 'bit', OPTYPE_const, 0, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cb46', 'ffff'), 'bit', OPTYPE_const, 0, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cb47', 'ffff'), 'bit', OPTYPE_const, 0, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cb48', 'ffff'), 'bit', OPTYPE_const, 1, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cb49', 'ffff'), 'bit', OPTYPE_const, 1, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cb4a', 'ffff'), 'bit', OPTYPE_const, 1, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cb4b', 'ffff'), 'bit', OPTYPE_const, 1, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cb4c', 'ffff'), 'bit', OPTYPE_const, 1, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cb4d', 'ffff'), 'bit', OPTYPE_const, 1, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cb4e', 'ffff'), 'bit', OPTYPE_const, 1, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cb4f', 'ffff'), 'bit', OPTYPE_const, 1, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cb50', 'ffff'), 'bit', OPTYPE_const, 2, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cb51', 'ffff'), 'bit', OPTYPE_const, 2, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cb52', 'ffff'), 'bit', OPTYPE_const, 2, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cb53', 'ffff'), 'bit', OPTYPE_const, 2, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cb54', 'ffff'), 'bit', OPTYPE_const, 2, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cb55', 'ffff'), 'bit', OPTYPE_const, 2, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cb56', 'ffff'), 'bit', OPTYPE_const, 2, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cb57', 'ffff'), 'bit', OPTYPE_const, 2, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cb58', 'ffff'), 'bit', OPTYPE_const, 3, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cb59', 'ffff'), 'bit', OPTYPE_const, 3, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cb5a', 'ffff'), 'bit', OPTYPE_const, 3, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cb5b', 'ffff'), 'bit', OPTYPE_const, 3, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cb5c', 'ffff'), 'bit', OPTYPE_const, 3, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cb5d', 'ffff'), 'bit', OPTYPE_const, 3, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cb5e', 'ffff'), 'bit', OPTYPE_const, 3, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cb5f', 'ffff'), 'bit', OPTYPE_const, 3, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cb60', 'ffff'), 'bit', OPTYPE_const, 4, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cb61', 'ffff'), 'bit', OPTYPE_const, 4, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cb62', 'ffff'), 'bit', OPTYPE_const, 4, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cb63', 'ffff'), 'bit', OPTYPE_const, 4, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cb64', 'ffff'), 'bit', OPTYPE_const, 4, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cb65', 'ffff'), 'bit', OPTYPE_const, 4, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cb66', 'ffff'), 'bit', OPTYPE_const, 4, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cb67', 'ffff'), 'bit', OPTYPE_const, 4, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cb68', 'ffff'), 'bit', OPTYPE_const, 5, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cb69', 'ffff'), 'bit', OPTYPE_const, 5, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cb6a', 'ffff'), 'bit', OPTYPE_const, 5, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cb6b', 'ffff'), 'bit', OPTYPE_const, 5, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cb6c', 'ffff'), 'bit', OPTYPE_const, 5, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cb6d', 'ffff'), 'bit', OPTYPE_const, 5, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cb6e', 'ffff'), 'bit', OPTYPE_const, 5, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cb6f', 'ffff'), 'bit', OPTYPE_const, 5, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cb70', 'ffff'), 'bit', OPTYPE_const, 6, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cb71', 'ffff'), 'bit', OPTYPE_const, 6, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cb72', 'ffff'), 'bit', OPTYPE_const, 6, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cb73', 'ffff'), 'bit', OPTYPE_const, 6, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cb74', 'ffff'), 'bit', OPTYPE_const, 6, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cb75', 'ffff'), 'bit', OPTYPE_const, 6, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cb76', 'ffff'), 'bit', OPTYPE_const, 6, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cb77', 'ffff'), 'bit', OPTYPE_const, 6, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cb78', 'ffff'), 'bit', OPTYPE_const, 7, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cb79', 'ffff'), 'bit', OPTYPE_const, 7, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cb7a', 'ffff'), 'bit', OPTYPE_const, 7, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cb7b', 'ffff'), 'bit', OPTYPE_const, 7, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cb7c', 'ffff'), 'bit', OPTYPE_const, 7, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cb7d', 'ffff'), 'bit', OPTYPE_const, 7, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cb7e', 'ffff'), 'bit', OPTYPE_const, 7, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cb7f', 'ffff'), 'bit', OPTYPE_const, 7, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cb80', 'ffff'), 'res', OPTYPE_const, 0, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cb81', 'ffff'), 'res', OPTYPE_const, 0, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cb82', 'ffff'), 'res', OPTYPE_const, 0, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cb83', 'ffff'), 'res', OPTYPE_const, 0, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cb84', 'ffff'), 'res', OPTYPE_const, 0, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cb85', 'ffff'), 'res', OPTYPE_const, 0, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cb86', 'ffff'), 'res', OPTYPE_const, 0, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cb87', 'ffff'), 'res', OPTYPE_const, 0, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cb88', 'ffff'), 'res', OPTYPE_const, 1, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cb89', 'ffff'), 'res', OPTYPE_const, 1, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cb8a', 'ffff'), 'res', OPTYPE_const, 1, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cb8b', 'ffff'), 'res', OPTYPE_const, 1, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cb8c', 'ffff'), 'res', OPTYPE_const, 1, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cb8d', 'ffff'), 'res', OPTYPE_const, 1, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cb8e', 'ffff'), 'res', OPTYPE_const, 1, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cb8f', 'ffff'), 'res', OPTYPE_const, 1, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cb90', 'ffff'), 'res', OPTYPE_const, 2, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cb91', 'ffff'), 'res', OPTYPE_const, 2, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cb92', 'ffff'), 'res', OPTYPE_const, 2, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cb93', 'ffff'), 'res', OPTYPE_const, 2, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cb94', 'ffff'), 'res', OPTYPE_const, 2, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cb95', 'ffff'), 'res', OPTYPE_const, 2, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cb96', 'ffff'), 'res', OPTYPE_const, 2, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cb97', 'ffff'), 'res', OPTYPE_const, 2, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cb98', 'ffff'), 'res', OPTYPE_const, 3, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cb99', 'ffff'), 'res', OPTYPE_const, 3, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cb9a', 'ffff'), 'res', OPTYPE_const, 3, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cb9b', 'ffff'), 'res', OPTYPE_const, 3, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cb9c', 'ffff'), 'res', OPTYPE_const, 3, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cb9d', 'ffff'), 'res', OPTYPE_const, 3, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cb9e', 'ffff'), 'res', OPTYPE_const, 3, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cb9f', 'ffff'), 'res', OPTYPE_const, 3, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cba0', 'ffff'), 'res', OPTYPE_const, 4, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cba1', 'ffff'), 'res', OPTYPE_const, 4, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cba2', 'ffff'), 'res', OPTYPE_const, 4, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cba3', 'ffff'), 'res', OPTYPE_const, 4, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cba4', 'ffff'), 'res', OPTYPE_const, 4, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cba5', 'ffff'), 'res', OPTYPE_const, 4, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cba6', 'ffff'), 'res', OPTYPE_const, 4, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cba7', 'ffff'), 'res', OPTYPE_const, 4, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cba8', 'ffff'), 'res', OPTYPE_const, 5, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cba9', 'ffff'), 'res', OPTYPE_const, 5, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cbaa', 'ffff'), 'res', OPTYPE_const, 5, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cbab', 'ffff'), 'res', OPTYPE_const, 5, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cbac', 'ffff'), 'res', OPTYPE_const, 5, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cbad', 'ffff'), 'res', OPTYPE_const, 5, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cbae', 'ffff'), 'res', OPTYPE_const, 5, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cbaf', 'ffff'), 'res', OPTYPE_const, 5, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cbb0', 'ffff'), 'res', OPTYPE_const, 6, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cbb1', 'ffff'), 'res', OPTYPE_const, 6, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cbb2', 'ffff'), 'res', OPTYPE_const, 6, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cbb3', 'ffff'), 'res', OPTYPE_const, 6, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cbb4', 'ffff'), 'res', OPTYPE_const, 6, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cbb5', 'ffff'), 'res', OPTYPE_const, 6, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cbb6', 'ffff'), 'res', OPTYPE_const, 6, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cbb7', 'ffff'), 'res', OPTYPE_const, 6, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cbb8', 'ffff'), 'res', OPTYPE_const, 7, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cbb9', 'ffff'), 'res', OPTYPE_const, 7, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cbba', 'ffff'), 'res', OPTYPE_const, 7, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cbbb', 'ffff'), 'res', OPTYPE_const, 7, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cbbc', 'ffff'), 'res', OPTYPE_const, 7, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cbbd', 'ffff'), 'res', OPTYPE_const, 7, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cbbe', 'ffff'), 'res', OPTYPE_const, 7, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cbbf', 'ffff'), 'res', OPTYPE_const, 7, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cbc0', 'ffff'), 'set', OPTYPE_const, 0, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cbc1', 'ffff'), 'set', OPTYPE_const, 0, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cbc2', 'ffff'), 'set', OPTYPE_const, 0, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cbc3', 'ffff'), 'set', OPTYPE_const, 0, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cbc4', 'ffff'), 'set', OPTYPE_const, 0, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cbc5', 'ffff'), 'set', OPTYPE_const, 0, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cbc6', 'ffff'), 'set', OPTYPE_const, 0, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cbc7', 'ffff'), 'set', OPTYPE_const, 0, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cbc8', 'ffff'), 'set', OPTYPE_const, 1, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cbc9', 'ffff'), 'set', OPTYPE_const, 1, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cbca', 'ffff'), 'set', OPTYPE_const, 1, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cbcb', 'ffff'), 'set', OPTYPE_const, 1, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cbcc', 'ffff'), 'set', OPTYPE_const, 1, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cbcd', 'ffff'), 'set', OPTYPE_const, 1, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cbce', 'ffff'), 'set', OPTYPE_const, 1, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cbcf', 'ffff'), 'set', OPTYPE_const, 1, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cbd0', 'ffff'), 'set', OPTYPE_const, 2, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cbd1', 'ffff'), 'set', OPTYPE_const, 2, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cbd2', 'ffff'), 'set', OPTYPE_const, 2, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cbd3', 'ffff'), 'set', OPTYPE_const, 2, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cbd4', 'ffff'), 'set', OPTYPE_const, 2, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cbd5', 'ffff'), 'set', OPTYPE_const, 2, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cbd6', 'ffff'), 'set', OPTYPE_const, 2, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cbd7', 'ffff'), 'set', OPTYPE_const, 2, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cbd8', 'ffff'), 'set', OPTYPE_const, 3, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cbd9', 'ffff'), 'set', OPTYPE_const, 3, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cbda', 'ffff'), 'set', OPTYPE_const, 3, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cbdb', 'ffff'), 'set', OPTYPE_const, 3, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cbdc', 'ffff'), 'set', OPTYPE_const, 3, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cbdd', 'ffff'), 'set', OPTYPE_const, 3, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cbde', 'ffff'), 'set', OPTYPE_const, 3, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cbdf', 'ffff'), 'set', OPTYPE_const, 3, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cbe0', 'ffff'), 'set', OPTYPE_const, 4, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cbe1', 'ffff'), 'set', OPTYPE_const, 4, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cbe2', 'ffff'), 'set', OPTYPE_const, 4, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cbe3', 'ffff'), 'set', OPTYPE_const, 4, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cbe4', 'ffff'), 'set', OPTYPE_const, 4, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cbe5', 'ffff'), 'set', OPTYPE_const, 4, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cbe6', 'ffff'), 'set', OPTYPE_const, 4, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cbe7', 'ffff'), 'set', OPTYPE_const, 4, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cbe8', 'ffff'), 'set', OPTYPE_const, 5, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cbe9', 'ffff'), 'set', OPTYPE_const, 5, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cbea', 'ffff'), 'set', OPTYPE_const, 5, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cbeb', 'ffff'), 'set', OPTYPE_const, 5, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cbec', 'ffff'), 'set', OPTYPE_const, 5, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cbed', 'ffff'), 'set', OPTYPE_const, 5, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cbee', 'ffff'), 'set', OPTYPE_const, 5, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cbef', 'ffff'), 'set', OPTYPE_const, 5, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cbf0', 'ffff'), 'set', OPTYPE_const, 6, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cbf1', 'ffff'), 'set', OPTYPE_const, 6, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cbf2', 'ffff'), 'set', OPTYPE_const, 6, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cbf3', 'ffff'), 'set', OPTYPE_const, 6, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cbf4', 'ffff'), 'set', OPTYPE_const, 6, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cbf5', 'ffff'), 'set', OPTYPE_const, 6, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cbf6', 'ffff'), 'set', OPTYPE_const, 6, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cbf7', 'ffff'), 'set', OPTYPE_const, 6, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cbf8', 'ffff'), 'set', OPTYPE_const, 7, OPTYPE_Reg, REG_B, 2, 0, 0),
(('cbf9', 'ffff'), 'set', OPTYPE_const, 7, OPTYPE_Reg, REG_C, 2, 0, 0),
(('cbfa', 'ffff'), 'set', OPTYPE_const, 7, OPTYPE_Reg, REG_D, 2, 0, 0),
(('cbfb', 'ffff'), 'set', OPTYPE_const, 7, OPTYPE_Reg, REG_E, 2, 0, 0),
(('cbfc', 'ffff'), 'set', OPTYPE_const, 7, OPTYPE_Reg, REG_H, 2, 0, 0),
(('cbfd', 'ffff'), 'set', OPTYPE_const, 7, OPTYPE_Reg, REG_L, 2, 0, 0),
(('cbfe', 'ffff'), 'set', OPTYPE_const, 7, OPTYPE_RegMem, REG_HL, 2, 0, 0),
(('cbff', 'ffff'), 'set', OPTYPE_const, 7, OPTYPE_Reg, REG_A, 2, 0, 0),
(('cc0000', 'ff0000'), 'call', OPTYPE_Cond, COND_Z, OPTYPE_imm16, None, 3, 1, 0),
(('cd0000', 'ff0000'), 'call', OPTYPE_imm16, None, None, None, 3, 1, 0),
(('ce00', 'ff00'), 'adc', OPTYPE_Reg, REG_A, OPTYPE_imm8, None, 2, 1, 0),
(('cf', 'ff'), 'rst', OPTYPE_const, 8, None, None, 1, 0, 0),
(('d0', 'ff'), 'ret', OPTYPE_Cond, COND_NC, None, None, 1, 0, 0),
(('d1', 'ff'), 'pop', OPTYPE_Reg, REG_DE, None, None, 1, 0, 0),
(('d2', 'ff'), 'jp', OPTYPE_Cond, COND_NC, OPTYPE_Ind, None, 1, 0, 0),
(('d300', 'ff00'), 'out', OPTYPE_immmem8, None, OPTYPE_Reg, REG_A, 2, 1, 0),
(('d40000', 'ff0000'), 'call', OPTYPE_Cond, COND_NC, OPTYPE_imm16, None, 3, 1, 0),
(('d40000', 'ff0000'), 'call', OPTYPE_Cond, COND_NC, OPTYPE_imm16, None, 3, 1, 0),
(('d5', 'ff'), 'push', OPTYPE_Reg, REG_DE, None, None, 1, 0, 0),
(('d600', 'ff00'), 'sub', OPTYPE_imm8, None, None, None, 2, 1, 0),
(('d7', 'ff'), 'rst', OPTYPE_const, 16, None, None, 1, 0, 0),
(('d8', 'ff'), 'ret', OPTYPE_Reg, REG_C, None, None, 1, 0, 0),
(('d9', 'ff'), 'exx', None, None, None, None, 1, 0, 0),
(('da', 'ff'), 'jp', OPTYPE_Reg, REG_C, OPTYPE_Ind, None, 1, 0, 0),
(('db00', 'ff00'), 'in', OPTYPE_Reg, REG_A, OPTYPE_immmem8, None, 2, 1, 0),
(('dc0000', 'ff0000'), 'call', OPTYPE_Reg, REG_C, OPTYPE_imm16, None, 3, 1, 0),
(('dd09', 'ffff'), 'add', OPTYPE_Reg, REG_IX, OPTYPE_Reg, REG_BC, 2, 0, 0),
(('dd19', 'ffff'), 'add', OPTYPE_Reg, REG_IX, OPTYPE_Reg, REG_DE, 2, 0, 0),
(('dd210000', 'ffff0000'), 'ld', OPTYPE_Reg, REG_IX, OPTYPE_imm16, None, 4, 2, 0),
(('dd220000', 'ffff0000'), 'ld', OPTYPE_immmem16, None, OPTYPE_Reg, REG_IX, 4, 2, 0),
(('dd23', 'ffff'), 'inc', OPTYPE_Reg, REG_IX, None, None, 2, 0, 0),
(('dd29', 'ffff'), 'add', OPTYPE_Reg, REG_IX, OPTYPE_Reg, REG_IX, 2, 0, 0),
(('dd2a0000', 'ffff0000'), 'ld', OPTYPE_Reg, REG_IX, OPTYPE_immmem16, None, 4, 2, 0),
(('dd2b', 'ffff'), 'dec', OPTYPE_Reg, REG_IX, None, None, 2, 0, 0),
(('dd3400', 'ffff00'), 'inc', OPTYPE_RegMemDisp, REG_IX, None, None, 3, 2, 0),
(('dd3500', 'ffff00'), 'dec', OPTYPE_RegMemDisp, REG_IX, None, None, 3, 2, 0),
(('dd360000', 'ffff0000'), 'ld', OPTYPE_RegMemDisp, REG_IX, OPTYPE_imm8, None, 4, 2, 0),
(('dd39', 'ffff'), 'add', OPTYPE_Reg, REG_IX, OPTYPE_Reg, REG_SP, 2, 0, 0),
(('dd4600', 'ffff00'), 'ld', OPTYPE_Reg, REG_B, OPTYPE_RegMemDisp, REG_IX, 3, 2, 0),
(('dd4e00', 'ffff00'), 'ld', OPTYPE_Reg, REG_C, OPTYPE_RegMemDisp, REG_IX, 3, 2, 0),
(('dd5600', 'ffff00'), 'ld', OPTYPE_Reg, REG_D, OPTYPE_RegMemDisp, REG_IX, 3, 2, 0),
(('dd5e00', 'ffff00'), 'ld', OPTYPE_Reg, REG_E, OPTYPE_RegMemDisp, REG_IX, 3, 2, 0),
(('dd6600', 'ffff00'), 'ld', OPTYPE_Reg, REG_H, OPTYPE_RegMemDisp, REG_IX, 3, 2, 0),
(('dd6e00', 'ffff00'), 'ld', OPTYPE_Reg, REG_L, OPTYPE_RegMemDisp, REG_IX, 3, 2, 0),
(('dd7000', 'ffff00'), 'ld', OPTYPE_RegMemDisp, REG_IX, OPTYPE_Reg, REG_B, 3, 2, 0),
(('dd7100', 'ffff00'), 'ld', OPTYPE_RegMemDisp, REG_IX, OPTYPE_Reg, REG_C, 3, 2, 0),
(('dd7200', 'ffff00'), 'ld', OPTYPE_RegMemDisp, REG_IX, OPTYPE_Reg, REG_D, 3, 2, 0),
(('dd7300', 'ffff00'), 'ld', OPTYPE_RegMemDisp, REG_IX, OPTYPE_Reg, REG_E, 3, 2, 0),
(('dd7400', 'ffff00'), 'ld', OPTYPE_RegMemDisp, REG_IX, OPTYPE_Reg, REG_H, 3, 2, 0),
(('dd7500', 'ffff00'), 'ld', OPTYPE_RegMemDisp, REG_IX, OPTYPE_Reg, REG_L, 3, 2, 0),
(('dd7700', 'ffff00'), 'ld', OPTYPE_RegMemDisp, REG_IX, OPTYPE_Reg, REG_A, 3, 2, 0),
(('dd7e00', 'ffff00'), 'ld', OPTYPE_Reg, REG_A, OPTYPE_RegMemDisp, REG_IX, 3, 2, 0),
(('dd8600', 'ffff00'), 'add', OPTYPE_Reg, REG_A, OPTYPE_RegMemDisp, REG_IX, 3, 2, 0),
(('dd8e00', 'ffff00'), 'adc', OPTYPE_Reg, REG_A, OPTYPE_RegMemDisp, REG_IX, 3, 2, 0),
(('dd9600', 'ffff00'), 'sub', OPTYPE_RegMemDisp, REG_IX, None, None, 3, 2, 0),
(('dd9e00', 'ffff00'), 'sbc', OPTYPE_Reg, REG_A, OPTYPE_RegMemDisp, REG_IX, 3, 2, 0),
(('dda600', 'ffff00'), 'and', OPTYPE_RegMemDisp, REG_IX, None, None, 3, 2, 0),
(('ddae00', 'ffff00'), 'xor', OPTYPE_RegMemDisp, REG_IX, None, None, 3, 2, 0),
(('ddb600', 'ffff00'), 'or', OPTYPE_RegMemDisp, REG_IX, None, None, 3, 2, 0),
(('ddbe00', 'ffff00'), 'cp', OPTYPE_RegMemDisp, REG_IX, None, None, 3, 2, 0),
(('ddcb0006', 'ffff00ff'), 'rlc', OPTYPE_RegMemDisp, REG_IX, None, None, 4, 2, 0),
(('ddcb000e', 'ffff00ff'), 'rrc', OPTYPE_RegMemDisp, REG_IX, None, None, 4, 2, 0),
(('ddcb0016', 'ffff00ff'), 'rl', OPTYPE_RegMemDisp, REG_IX, None, None, 4, 2, 0),
(('ddcb001e', 'ffff00ff'), 'rr', OPTYPE_RegMemDisp, REG_IX, None, None, 4, 2, 0),
(('ddcb0026', 'ffff00ff'), 'sla', OPTYPE_RegMemDisp, REG_IX, None, None, 4, 2, 0),
(('ddcb002e', 'ffff00ff'), 'sra', OPTYPE_RegMemDisp, REG_IX, None, None, 4, 2, 0),
(('ddcb0046', 'ffff00ff'), 'bit', OPTYPE_const, 0, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb004e', 'ffff00ff'), 'bit', OPTYPE_const, 1, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb0056', 'ffff00ff'), 'bit', OPTYPE_const, 2, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb005e', 'ffff00ff'), 'bit', OPTYPE_const, 3, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb0066', 'ffff00ff'), 'bit', OPTYPE_const, 4, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb006e', 'ffff00ff'), 'bit', OPTYPE_const, 5, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb0076', 'ffff00ff'), 'bit', OPTYPE_const, 6, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb007e', 'ffff00ff'), 'bit', OPTYPE_const, 7, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb0086', 'ffff00ff'), 'res', OPTYPE_const, 0, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb008e', 'ffff00ff'), 'res', OPTYPE_const, 1, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb0096', 'ffff00ff'), 'res', OPTYPE_const, 2, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb009e', 'ffff00ff'), 'res', OPTYPE_const, 3, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb00a6', 'ffff00ff'), 'res', OPTYPE_const, 4, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb00ae', 'ffff00ff'), 'res', OPTYPE_const, 5, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb00b6', 'ffff00ff'), 'res', OPTYPE_const, 6, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb00be', 'ffff00ff'), 'res', OPTYPE_const, 7, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb00c6', 'ffff00ff'), 'set', OPTYPE_const, 0, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb00ce', 'ffff00ff'), 'set', OPTYPE_const, 1, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb00d6', 'ffff00ff'), 'set', OPTYPE_const, 2, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb00de', 'ffff00ff'), 'set', OPTYPE_const, 3, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb00e6', 'ffff00ff'), 'set', OPTYPE_const, 4, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb00ee', 'ffff00ff'), 'set', OPTYPE_const, 5, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb00f6', 'ffff00ff'), 'set', OPTYPE_const, 6, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('ddcb00fe', 'ffff00ff'), 'set', OPTYPE_const, 7, OPTYPE_RegMemDisp, REG_IX, 4, 2, 0),
(('dde1', 'ffff'), 'pop', OPTYPE_Reg, REG_IX, None, None, 2, 0, 0),
(('dde3', 'ffff'), 'ex', OPTYPE_RegMem, REG_SP, OPTYPE_Reg, REG_IX, 2, 0, 0),
(('dde5', 'ffff'), 'push', OPTYPE_Reg, REG_IX, None, None, 2, 0, 0),
(('dde9', 'ffff'), 'jp', OPTYPE_RegMem, REG_IX, None, None, 2, 0, 0),
(('ddf9', 'ffff'), 'ld', OPTYPE_Reg, REG_SP, OPTYPE_Reg, REG_IX, 2, 0, 0),
(('de00', 'ff00'), 'sbc', OPTYPE_Reg, REG_A, OPTYPE_imm8, None, 2, 1, 0),
(('df', 'ff'), 'rst', OPTYPE_const, 24, None, None, 1, 0, 0),
(('e0', 'ff'), 'ret', OPTYPE_Cond, COND_PO, None, None, 1, 0, 0),
(('e1', 'ff'), 'pop', OPTYPE_Reg, REG_HL, None, None, 1, 0, 0),
(('e2', 'ff'), 'jp', OPTYPE_Cond, COND_PO, OPTYPE_Ind, None, 1, 0, 0),
(('e3', 'ff'), 'ex', OPTYPE_RegMem, REG_SP, OPTYPE_Reg, REG_HL, 1, 0, 0),
(('e40000', 'ff0000'), 'call', OPTYPE_Cond, COND_PO, OPTYPE_imm16, None, 3, 1, 0),
(('e5', 'ff'), 'push', OPTYPE_Reg, REG_HL, None, None, 1, 0, 0),
(('e600', 'ff00'), 'and', OPTYPE_imm8, None, None, None, 2, 1, 0),
(('e7', 'ff'), 'rst', OPTYPE_const, 32, None, None, 1, 0, 0),
(('e8', 'ff'), 'ret', OPTYPE_Cond, COND_PE, None, None, 1, 0, 0),
(('e9', 'ff'), 'jp', OPTYPE_RegMem, REG_HL, None, None, 1, 0, 0),
(('ea', 'ff'), 'jp', OPTYPE_Cond, COND_PE, OPTYPE_Ind, None, 1, 0, 0),
(('eb', 'ff'), 'ex', OPTYPE_Reg, REG_DE, OPTYPE_Reg, REG_HL, 1, 0, 0),
(('ec0000', 'ff0000'), 'call', OPTYPE_Cond, COND_PE, OPTYPE_imm16, None, 3, 1, 0),
(('ed40', 'ffff'), 'in', OPTYPE_Reg, REG_B, OPTYPE_RegMem, REG_C, 2, 0, 0),
(('ed41', 'ffff'), 'out', OPTYPE_RegMem, REG_C, OPTYPE_Reg, REG_B, 2, 0, 0),
(('ed42', 'ffff'), 'sbc', OPTYPE_Reg, REG_HL, OPTYPE_Reg, REG_BC, 2, 0, 0),
(('ed430000', 'ffff0000'), 'ld', OPTYPE_immmem16, None, OPTYPE_Reg, REG_BC, 4, 2, 0),
(('ed44', 'ffff'), 'neg', None, None, None, None, 2, 0, 0),
(('ed45', 'ffff'), 'retn', None, None, None, None, 2, 0, 0),
(('ed46', 'ffff'), 'im', OPTYPE_const, 0, None, None, 2, 0, 0),
(('ed47', 'ffff'), 'ld', OPTYPE_Reg, REG_I, OPTYPE_Reg, REG_A, 2, 0, 0),
(('ed48', 'ffff'), 'in', OPTYPE_Reg, REG_C, OPTYPE_RegMem, REG_C, 2, 0, 0),
(('ed49', 'ffff'), 'out', OPTYPE_RegMem, REG_C, OPTYPE_Reg, REG_C, 2, 0, 0),
(('ed4a', 'ffff'), 'adc', OPTYPE_Reg, REG_HL, OPTYPE_Reg, REG_BC, 2, 0, 0),
(('ed4b0000', 'ffff0000'), 'ld', OPTYPE_Reg, REG_BC, OPTYPE_immmem16, None, 4, 2, 0),
(('ed4d', 'ffff'), 'reti', None, None, None, None, 2, 0, 0),
(('ed50', 'ffff'), 'in', OPTYPE_Reg, REG_D, OPTYPE_RegMem, REG_C, 2, 0, 0),
(('ed51', 'ffff'), 'out', OPTYPE_RegMem, REG_C, OPTYPE_Reg, REG_D, 2, 0, 0),
(('ed52', 'ffff'), 'sbc', OPTYPE_Reg, REG_HL, OPTYPE_Reg, REG_DE, 2, 0, 0),
(('ed530000', 'ffff0000'), 'ld', OPTYPE_immmem16, None, OPTYPE_Reg, REG_DE, 4, 2, 0),
(('ed56', 'ffff'), 'im', OPTYPE_const, 1, None, None, 2, 0, 0),
(('ed57', 'ffff'), 'ld', OPTYPE_Reg, REG_A, OPTYPE_Reg, REG_I, 2, 0, 0),
(('ed58', 'ffff'), 'in', OPTYPE_Reg, REG_E, OPTYPE_RegMem, REG_C, 2, 0, 0),
(('ed59', 'ffff'), 'out', OPTYPE_RegMem, REG_C, OPTYPE_Reg, REG_E, 2, 0, 0),
(('ed5a', 'ffff'), 'adc', OPTYPE_Reg, REG_HL, OPTYPE_Reg, REG_DE, 2, 0, 0),
(('ed5b0000', 'ffff0000'), 'ld', OPTYPE_Reg, REG_DE, OPTYPE_immmem16, None, 4, 2, 0),
(('ed5e', 'ffff'), 'im', OPTYPE_const, 2, None, None, 2, 0, 0),
(('ed60', 'ffff'), 'in', OPTYPE_Reg, REG_H, OPTYPE_RegMem, REG_C, 2, 0, 0),
(('ed61', 'ffff'), 'out', OPTYPE_RegMem, REG_C, OPTYPE_Reg, REG_H, 2, 0, 0),
(('ed62', 'ffff'), 'sbc', OPTYPE_Reg, REG_HL, OPTYPE_Reg, REG_HL, 2, 0, 0),
(('ed67', 'ffff'), 'rrd', None, None, None, None, 2, 0, 0),
(('ed68', 'ffff'), 'in', OPTYPE_Reg, REG_L, OPTYPE_RegMem, REG_C, 2, 0, 0),
(('ed69', 'ffff'), 'out', OPTYPE_RegMem, REG_C, OPTYPE_Reg, REG_L, 2, 0, 0),
(('ed6a', 'ffff'), 'adc', OPTYPE_Reg, REG_HL, OPTYPE_Reg, REG_HL, 2, 0, 0),
(('ed6f', 'ffff'), 'rld', None, None, None, None, 2, 0, 0),
(('ed72', 'ffff'), 'sbc', OPTYPE_Reg, REG_HL, OPTYPE_Reg, REG_SP, 2, 0, 0),
(('ed730000', 'ffff0000'), 'ld', OPTYPE_immmem16, None, OPTYPE_Reg, REG_SP, 4, 2, 0),
(('ed78', 'ffff'), 'in', OPTYPE_Reg, REG_A, OPTYPE_RegMem, REG_C, 2, 0, 0),
(('ed79', 'ffff'), 'out', OPTYPE_RegMem, REG_C, OPTYPE_Reg, REG_A, 2, 0, 0),
(('ed7a', 'ffff'), 'adc', OPTYPE_Reg, REG_HL, OPTYPE_Reg, REG_SP, 2, 0, 0),
(('ed7b0000', 'ffff0000'), 'ld', OPTYPE_Reg, REG_SP, OPTYPE_immmem16, None, 4, 2, 0),
(('eda0', 'ffff'), 'ldi', None, None, None, None, 2, 0, 0),
(('eda1', 'ffff'), 'cpi', None, None, None, None, 2, 0, 0),
(('eda2', 'ffff'), 'ini', None, None, None, None, 2, 0, 0),
(('eda3', 'ffff'), 'outi', None, None, None, None, 2, 0, 0),
(('eda8', 'ffff'), 'ldd', None, None, None, None, 2, 0, 0),
(('eda9', 'ffff'), 'cpd', None, None, None, None, 2, 0, 0),
(('edaa', 'ffff'), 'ind', None, None, None, None, 2, 0, 0),
(('edab', 'ffff'), 'outd', None, None, None, None, 2, 0, 0),
(('edb0', 'ffff'), 'ldir', None, None, None, None, 2, 0, 0),
(('edb1', 'ffff'), 'cpir', None, None, None, None, 2, 0, 0),
(('edb2', 'ffff'), 'inir', None, None, None, None, 2, 0, 0),
(('edb3', 'ffff'), 'otir', None, None, None, None, 2, 0, 0),
(('edb8', 'ffff'), 'lddr', None, None, None, None, 2, 0, 0),
(('edb9', 'ffff'), 'cpdr', None, None, None, None, 2, 0, 0),
(('edba', 'ffff'), 'indr', None, None, None, None, 2, 0, 0),
(('edbb', 'ffff'), 'otdr', None, None, None, None, 2, 0, 0),
(('ee00', 'ff00'), 'xor', OPTYPE_imm8, None, None, None, 2, 1, 0),
(('ef', 'ff'), 'rst', OPTYPE_const, 40, None, None, 1, 0, 0),
(('f0', 'ff'), 'ret', OPTYPE_Cond, COND_P, None, None, 1, 0, 0),
(('f1', 'ff'), 'pop', OPTYPE_Reg, REG_AF, None, None, 1, 0, 0),
(('f2', 'ff'), 'jp', OPTYPE_Cond, COND_P, OPTYPE_Ind, None, 1, 0, 0),
(('f3', 'ff'), 'di', None, None, None, None, 1, 0, 0),
(('f40000', 'ff0000'), 'call', OPTYPE_Cond, COND_P, OPTYPE_imm16, None, 3, 1, 0),
(('f5', 'ff'), 'push', OPTYPE_Reg, REG_AF, None, None, 1, 0, 0),
(('f600', 'ff00'), 'or', OPTYPE_imm8, None, None, None, 2, 1, 0),
(('f7', 'ff'), 'rst', OPTYPE_const, 48, None, None, 1, 0, 0),
(('f8', 'ff'), 'ret', OPTYPE_Cond, COND_M, None, None, 1, 0, 0),
(('f9', 'ff'), 'ld', OPTYPE_Reg, REG_SP, OPTYPE_Reg, REG_HL, 1, 0, 0),
(('fa', 'ff'), 'jp', OPTYPE_Cond, COND_M, OPTYPE_Ind, None, 1, 0, 0),
(('fb', 'ff'), 'ei', None, None, None, None, 1, 0, 0),
(('fc0000', 'ff0000'), 'call', OPTYPE_Cond, COND_M, OPTYPE_imm16, None, 3, 1, 0),
(('fd09', 'ffff'), 'add', OPTYPE_Reg, REG_IY, OPTYPE_Reg, REG_BC, 2, 0, 0),
(('fd19', 'ffff'), 'add', OPTYPE_Reg, REG_IY, OPTYPE_Reg, REG_DE, 2, 0, 0),
(('fd210000', 'ffff0000'), 'ld', OPTYPE_Reg, REG_IY, OPTYPE_imm16, None, 4, 2, 0),
(('fd220000', 'ffff0000'), 'ld', OPTYPE_immmem16, None, OPTYPE_Reg, REG_IY, 4, 2, 0),
(('fd23', 'ffff'), 'inc', OPTYPE_Reg, REG_IY, None, None, 2, 0, 0),
(('fd29', 'ffff'), 'add', OPTYPE_Reg, REG_IY, OPTYPE_Reg, REG_IY, 2, 0, 0),
(('fd2a0000', 'ffff0000'), 'ld', OPTYPE_Reg, REG_IY, OPTYPE_immmem16, None, 4, 2, 0),
(('fd2b', 'ffff'), 'dec', OPTYPE_Reg, REG_IY, None, None, 2, 0, 0),
(('fd3400', 'ffff00'), 'inc', OPTYPE_RegMemDisp, REG_IY, None, None, 3, 2, 0),
(('fd3500', 'ffff00'), 'dec', OPTYPE_RegMemDisp, REG_IY, None, None, 3, 2, 0),
(('fd360000', 'ffff0000'), 'ld', OPTYPE_RegMemDisp, REG_IY, OPTYPE_imm8, None, 4, 2, 0),
(('fd39', 'ffff'), 'add', OPTYPE_Reg, REG_IY, OPTYPE_Reg, REG_SP, 2, 0, 0),
(('fd4600', 'ffff00'), 'ld', OPTYPE_Reg, REG_B, OPTYPE_RegMemDisp, REG_IY, 3, 2, 0),
(('fd4e00', 'ffff00'), 'ld', OPTYPE_Reg, REG_C, OPTYPE_RegMemDisp, REG_IY, 3, 2, 0),
(('fd5600', 'ffff00'), 'ld', OPTYPE_Reg, REG_D, OPTYPE_RegMemDisp, REG_IY, 3, 2, 0),
(('fd5e00', 'ffff00'), 'ld', OPTYPE_Reg, REG_E, OPTYPE_RegMemDisp, REG_IY, 3, 2, 0),
(('fd6600', 'ffff00'), 'ld', OPTYPE_Reg, REG_H, OPTYPE_RegMemDisp, REG_IY, 3, 2, 0),
(('fd6e00', 'ffff00'), 'ld', OPTYPE_Reg, REG_L, OPTYPE_RegMemDisp, REG_IY, 3, 2, 0),
(('fd7000', 'ffff00'), 'ld', OPTYPE_RegMemDisp, REG_IY, OPTYPE_Reg, REG_B, 3, 2, 0),
(('fd7100', 'ffff00'), 'ld', OPTYPE_RegMemDisp, REG_IY, OPTYPE_Reg, REG_C, 3, 2, 0),
(('fd7200', 'ffff00'), 'ld', OPTYPE_RegMemDisp, REG_IY, OPTYPE_Reg, REG_D, 3, 2, 0),
(('fd7300', 'ffff00'), 'ld', OPTYPE_RegMemDisp, REG_IY, OPTYPE_Reg, REG_E, 3, 2, 0),
(('fd7400', 'ffff00'), 'ld', OPTYPE_RegMemDisp, REG_IY, OPTYPE_Reg, REG_H, 3, 2, 0),
(('fd7500', 'ffff00'), 'ld', OPTYPE_RegMemDisp, REG_IY, OPTYPE_Reg, REG_L, 3, 2, 0),
(('fd7700', 'ffff00'), 'ld', OPTYPE_RegMemDisp, REG_IY, OPTYPE_Reg, REG_A, 3, 2, 0),
(('fd7e00', 'ffff00'), 'ld', OPTYPE_Reg, REG_A, OPTYPE_RegMemDisp, REG_IY, 3, 2, 0),
(('fd8600', 'ffff00'), 'add', OPTYPE_Reg, REG_A, OPTYPE_RegMemDisp, REG_IY, 3, 2, 0),
(('fd8e00', 'ffff00'), 'adc', OPTYPE_Reg, REG_A, OPTYPE_RegMemDisp, REG_IY, 3, 2, 0),
(('fd9600', 'ffff00'), 'sub', OPTYPE_RegMemDisp, REG_IY, None, None, 3, 2, 0),
(('fd9e00', 'ffff00'), 'sbc', OPTYPE_Reg, REG_A, OPTYPE_RegMemDisp, REG_IY, 3, 2, 0),
(('fda600', 'ffff00'), 'and', OPTYPE_RegMemDisp, REG_IY, None, None, 3, 2, 0),
(('fdae00', 'ffff00'), 'xor', OPTYPE_RegMemDisp, REG_IY, None, None, 3, 2, 0),
(('fdb600', 'ffff00'), 'or', OPTYPE_RegMemDisp, REG_IY, None, None, 3, 2, 0),
(('fdbe00', 'ffff00'), 'cp', OPTYPE_RegMemDisp, REG_IY, None, None, 3, 2, 0),
(('fdcb0006', 'ffff00ff'), 'rlc', OPTYPE_RegMemDisp, REG_IY, None, None, 4, 2, 0),
(('fdcb000e', 'ffff00ff'), 'rrc', OPTYPE_RegMemDisp, REG_IY, None, None, 4, 2, 0),
(('fdcb0016', 'ffff00ff'), 'rl', OPTYPE_RegMemDisp, REG_IY, None, None, 4, 2, 0),
(('fdcb001e', 'ffff00ff'), 'rr', OPTYPE_RegMemDisp, REG_IY, None, None, 4, 2, 0),
(('fdcb0026', 'ffff00ff'), 'sla', OPTYPE_RegMemDisp, REG_IY, None, None, 4, 2, 0),
(('fdcb002e', 'ffff00ff'), 'sra', OPTYPE_RegMemDisp, REG_IY, None, None, 4, 2, 0),
(('fdcb0046', 'ffff00ff'), 'bit', OPTYPE_const, 0, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb004e', 'ffff00ff'), 'bit', OPTYPE_const, 1, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb0056', 'ffff00ff'), 'bit', OPTYPE_const, 2, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb005e', 'ffff00ff'), 'bit', OPTYPE_const, 3, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb0066', 'ffff00ff'), 'bit', OPTYPE_const, 4, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb006e', 'ffff00ff'), 'bit', OPTYPE_const, 5, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb0076', 'ffff00ff'), 'bit', OPTYPE_const, 6, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb007e', 'ffff00ff'), 'bit', OPTYPE_const, 7, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb0086', 'ffff00ff'), 'res', OPTYPE_const, 0, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb008e', 'ffff00ff'), 'res', OPTYPE_const, 1, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb0096', 'ffff00ff'), 'res', OPTYPE_const, 2, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb009e', 'ffff00ff'), 'res', OPTYPE_const, 3, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb00a6', 'ffff00ff'), 'res', OPTYPE_const, 4, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb00ae', 'ffff00ff'), 'res', OPTYPE_const, 5, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb00b6', 'ffff00ff'), 'res', OPTYPE_const, 6, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb00be', 'ffff00ff'), 'res', OPTYPE_const, 7, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb00c6', 'ffff00ff'), 'set', OPTYPE_const, 0, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb00ce', 'ffff00ff'), 'set', OPTYPE_const, 1, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb00d6', 'ffff00ff'), 'set', OPTYPE_const, 2, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb00de', 'ffff00ff'), 'set', OPTYPE_const, 3, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb00e6', 'ffff00ff'), 'set', OPTYPE_const, 4, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb00ee', 'ffff00ff'), 'set', OPTYPE_const, 5, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb00f6', 'ffff00ff'), 'set', OPTYPE_const, 6, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fdcb00fe', 'ffff00ff'), 'set', OPTYPE_const, 7, OPTYPE_RegMemDisp, REG_IY, 4, 2, 0),
(('fde1', 'ffff'), 'pop', OPTYPE_Reg, REG_IY, None, None, 2, 0, 0),
(('fde3', 'ffff'), 'ex', OPTYPE_RegMem, REG_SP, OPTYPE_Reg, REG_IY, 2, 0, 0),
(('fde5', 'ffff'), 'push', OPTYPE_Reg, REG_IY, None, None, 2, 0, 0),
(('fde9', 'ffff'), 'jp', OPTYPE_RegMem, REG_IY, None, None, 2, 0, 0),
(('fdf9', 'ffff'), 'ld', OPTYPE_Reg, REG_SP, OPTYPE_Reg, REG_IY, 2, 0, 0),
(('fe00', 'ff00'), 'cp', OPTYPE_imm8, None, None, None, 2, 1, 0),
(('ff', 'ff'), 'rst', OPTYPE_const, 56, None, None, 1, 0, 0),
]

from envi.bits import binbytes as bb

nbits = '00000000'
nnbits = '0000000000000000'

newtab = (

  # 8bit ld variants...
  (bb('01000000'), bb('11000000'), 'ld', OPTYPE_Reg, (2, 3), OPTYPE_Reg, (5, 3)),
  (bb('00000110'), bb('11000111'), 'ld', OPTYPE_Reg, (2, 3), OPTYPE_Imm, (8, 8)),
  (bb('01000110'), bb('11000111'), 'ld', OPTYPE_Reg, (2, 3), OPTYPE_OpReg, REG_HL),
  (bb('110111010100011000000000'), bb('111111111100011100000000'), 'ld', OPTYPE_Reg, (10, 3), OPTYPE_RegMemDisp, (REG_IX, 16, 8)),
  (bb('111111010100011000000000'), bb('111111111100011100000000'), 'ld', OPTYPE_Reg, (10, 3), OPTYPE_RegMemDisp, (REG_IY, 16, 8)),
  (bb('01110000'), bb('11111000'), 'ld', OPTYPE_RegMem, (REG_HL, None, None), OPTYPE_Reg, (5, 3)),
  (bb('110111010111000000000000'), bb('111111111111100000000000'), 'ld', OPTYPE_RegMemDisp, (REG_IX, 16, 8), OPTYPE_Reg, (13, 3)),
  (bb('111111010111000000000000'), bb('111111111111100000000000'), 'ld', OPTYPE_RegMemDisp, (REG_IY, 16, 8), OPTYPE_Reg, (13, 3)),
  (bb('0011011000000000'), bb('1111111100000000'), 'ld', OPTYPE_RegMem, (REG_HL, None, None), OPTYPE_Imm, (8, 8)),
  (bb('11011101001101100000000000000000'), bb('11111111111111110000000000000000'), 'ld', OPTYPE_RegMemDisp, (REG_IX, 16, 8), OPTYPE_Imm, (24, 8)),
  (bb('11111101001101100000000000000000'), bb('11111111111111110000000000000000'), 'ld', OPTYPE_RegMemDisp, (REG_IY, 16, 8), OPTYPE_Imm, (24, 8)),
  (bb('00001010'), bb('11111111'), 'ld', OPTYPE_OpReg, REG_A, OPTYPE_RegMem, (REG_BC, None, None)),
  (bb('00011010'), bb('11111111'), 'ld', OPTYPE_OpReg, REG_A, OPTYPE_RegMem, (REG_DE, None, None)),
  (bb('001110100000000000000000'), bb('111111110000000000000000'), 'ld', OPTYPE_OpReg, REG_A, OPTYPE_ImmMem, (8, 16)),
  (bb('00000010'), bb('11111111'), 'ld', OPTYPE_RegMem, (REG_BC, None, None), OPTYPE_OpReg, REG_A),
  (bb('00010010'), bb('11111111'), 'ld', OPTYPE_RegMem, (REG_DE, None, None), OPTYPE_OpReg, REG_A),
  (bb('001100100000000000000000'), bb('111111110000000000000000'), 'ld', OPTYPE_ImmMem, (8, 16), OPTYPE_OpReg, REG_A),
  (bb('1110110101010111'), bb('1111111111111111'), 'ld', OPTYPE_OpReg, REG_A, OPTYPE_OpReg, REG_I),
  (bb('1110110101011111'), bb('1111111111111111'), 'ld', OPTYPE_OpReg, REG_A, OPTYPE_OpReg, REG_R),
  (bb('1110110101000111'), bb('1111111111111111'), 'ld', OPTYPE_OpReg, REG_I, OPTYPE_OpReg, REG_A),
  (bb('111011010100f111'), bb('1111111111111111'), 'ld', OPTYPE_OpReg, REG_R, OPTYPE_OpReg, REG_A),

  # 16 bit ld variants
  (bb('000000010000000000000000'), bb('110011110000000000000000'), 'ld', OPTYPE_RegPair, (2, 2), OPTYPE_Imm, (8, 16)),
  (bb('11011101001000010000000000000000'), bb('11111111111111110000000000000000'), 'ld', OPTYPE_OpReg, REG_IX, OPTYPE_Imm, (16, 16)),
  (bb('11111101001000010000000000000000'), bb('11111111111111110000000000000000'), 'ld', OPTYPE_OpReg, REG_IY, OPTYPE_Imm, (16, 16)),
  (bb('001010100000000000000000'), bb('111111110000000000000000'), 'ld', OPTYPE_OpReg, REG_HL, OPTYPE_ImmMem, (8,16)),
  (bb('11101101010010110000000000000000'), bb('11111111110011110000000000000000'), 'ld', OPTYPE_RegPair, (10, 2), OPTYPE_ImmMem, (16, 16)),
  (bb('11011101001010100000000000000000'), bb('11111111111111110000000000000000'), 'ld', OPTYPE_OpReg, REG_IX, OPTYPE_ImmMem, (16, 16)),
  (bb('11111101001010100000000000000000'), bb('11111111111111110000000000000000'), 'ld', OPTYPE_OpReg, REG_IY, OPTYPE_ImmMem, (16, 16)),
  (bb('001000100000000000000000'), bb('111111110000000000000000'), 'ld', OPTYPE_ImmMem, (8, 16), OPTYPE_OpReg, REG_HL),
)

