/* tracker-miner-2.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Tracker", gir_namespace = "TrackerMiner", gir_version = "2.0", lower_case_cprefix = "tracker_")]
namespace Tracker {
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", type_id = "tracker_decorator_get_type ()")]
	public abstract class Decorator : Tracker.Miner, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected Decorator ();
		[Version (since = "0.18.")]
		public void delete_id (int id);
		[Version (since = "0.18.")]
		public static GLib.Quark error_quark ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "0.18.")]
		public unowned string[] get_class_names ();
		[Version (since = "0.18.")]
		public unowned string get_data_source ();
		[Version (since = "0.18.")]
		public uint get_n_items ();
		[Version (since = "0.18.")]
		public async Tracker.DecoratorInfo next (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "0.18.")]
		public void prepend_id (int id, int class_name_id);
		[Version (since = "0.18.")]
		public void set_priority_rdf_types (string rdf_types);
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] class_names { owned get; set; }
		[NoAccessorMethod]
		public int commit_batch_size { get; set; }
		public string data_source { get; construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] priority_rdf_types { set; }
		[Version (since = "0.18.")]
		public virtual signal void finished ();
		[Version (since = "0.18.")]
		public virtual signal void items_available ();
	}
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", type_id = "tracker_decorator_fs_get_type ()")]
	public abstract class DecoratorFS : Tracker.Decorator, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected DecoratorFS ();
		[Version (since = "1.2")]
		public int prepend_file (GLib.File file);
	}
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", ref_function = "tracker_decorator_info_ref", type_id = "tracker_decorator_info_get_type ()", unref_function = "tracker_decorator_info_unref")]
	[Compact]
	public class DecoratorInfo {
		[Version (since = "2.0")]
		public void complete (string sparql);
		[Version (since = "2.0")]
		public void complete_error (GLib.Error error);
		[Version (since = "0.18.")]
		public unowned string get_mimetype ();
		[Version (since = "0.18.")]
		public unowned GLib.Task get_task ();
		[Version (since = "0.18.")]
		public unowned string get_url ();
		[Version (since = "0.18.")]
		public unowned string get_urn ();
		[Version (since = "0.18.")]
		public Tracker.DecoratorInfo @ref ();
		[Version (since = "0.18.")]
		public void unref ();
	}
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", type_id = "tracker_indexing_tree_get_type ()")]
	public class IndexingTree : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.14.0")]
		public IndexingTree ();
		public void add (GLib.File directory, Tracker.DirectoryFlags flags);
		public void add_filter (Tracker.FilterType filter, string glob_string);
		public void clear_filters (Tracker.FilterType type);
		public bool file_is_indexable (GLib.File file, GLib.FileType file_type);
		[Version (since = "1.2.")]
		public bool file_is_root (GLib.File file);
		public bool file_matches_filter (Tracker.FilterType type, GLib.File file);
		[Version (since = "0.18.")]
		public Tracker.FilterPolicy get_default_policy (Tracker.FilterType filter);
		[Version (since = "0.18.")]
		public bool get_filter_hidden ();
		[Version (since = "1.2.")]
		public unowned GLib.File get_master_root ();
		public unowned GLib.File get_root (GLib.File file, out Tracker.DirectoryFlags directory_flags);
		public GLib.List<weak GLib.File> list_roots ();
		[Version (since = "1.10")]
		public bool notify_update (GLib.File file, bool recursive);
		public bool parent_is_indexable (GLib.File parent, GLib.List<GLib.File> children);
		public void remove (GLib.File directory);
		[Version (since = "0.18.")]
		public void set_default_policy (Tracker.FilterType filter, Tracker.FilterPolicy policy);
		[Version (since = "0.18.")]
		public void set_filter_hidden (bool filter_hidden);
		[CCode (has_construct_function = false)]
		[Version (since = "1.2.2")]
		public IndexingTree.with_root (GLib.File root);
		public bool filter_hidden { get; set; }
		[NoAccessorMethod]
		public GLib.File root { owned get; construct; }
		[Version (since = "1.10")]
		public virtual signal void child_updated (GLib.File root, GLib.File child);
		[Version (since = "0.14.0")]
		public virtual signal void directory_added (GLib.File directory);
		[Version (since = "0.14.0")]
		public virtual signal void directory_removed (GLib.File directory);
		[Version (since = "0.14.0")]
		public virtual signal void directory_updated (GLib.File directory);
	}
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", type_id = "tracker_miner_get_type ()")]
	public abstract class Miner : GLib.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected Miner ();
		[Version (since = "0.8")]
		public static GLib.Quark error_quark ();
		[Version (since = "0.10")]
		public bool is_paused ();
		[Version (since = "0.8")]
		public bool is_started ();
		public void pause ();
		public bool resume ();
		[Version (since = "0.8")]
		public void start ();
		[Version (since = "0.8")]
		public void stop ();
		[NoAccessorMethod]
		public virtual double progress { get; set construct; }
		[NoAccessorMethod]
		public int remaining_time { get; set construct; }
		[NoAccessorMethod]
		public string status { owned get; set construct; }
		[Version (since = "0.8")]
		public virtual signal void paused ();
		[Version (since = "0.8")]
		public virtual signal void resumed ();
		[Version (since = "0.8")]
		public virtual signal void started ();
		[Version (since = "0.8")]
		public virtual signal void stopped ();
	}
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", type_id = "tracker_miner_fs_get_type ()")]
	public abstract class MinerFS : Tracker.Miner, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected MinerFS ();
		[Version (since = "0.10")]
		public void check_file (GLib.File file, int priority, bool check_parents);
		[Version (since = "1.2.")]
		public static GLib.Quark error_quark ();
		[NoWrapper]
		public virtual bool filter_event (Tracker.MinerFSEventType type, GLib.File file, GLib.File source_file);
		[Version (since = "1.2")]
		public unowned Tracker.DataProvider get_data_provider ();
		public unowned Tracker.IndexingTree get_indexing_tree ();
		[Version (since = "0.8")]
		public double get_throttle ();
		[Version (since = "0.8")]
		public unowned string? get_urn (GLib.File file);
		[Version (since = "0.10")]
		public bool has_items_to_process ();
		public void notify_finish (GLib.Task task, string? sparql, GLib.Error error);
		[Version (since = "0.10")]
		public string query_urn (GLib.File file);
		[Version (since = "0.8")]
		public void set_throttle (double throttle);
		public Tracker.DataProvider data_provider { get; construct; }
		[NoAccessorMethod]
		public uint processing_pool_ready_limit { get; set construct; }
		[NoAccessorMethod]
		public uint processing_pool_wait_limit { get; set construct; }
		[NoAccessorMethod]
		public GLib.File root { owned get; construct; }
		public double throttle { get; set; }
		[Version (since = "0.8")]
		public virtual signal void finished (double elapsed, uint directories_found, uint directories_ignored, uint files_found, uint files_ignored);
		[Version (since = "1.2")]
		public virtual signal void finished_root (GLib.File root);
		public virtual signal string move_file (GLib.File dest, GLib.File source, bool recursive);
		[Version (since = "0.8")]
		public virtual signal bool process_file (GLib.File file, GLib.Task task);
		[Version (since = "0.10")]
		public virtual signal bool process_file_attributes (GLib.File file, GLib.Task task);
		public virtual signal string remove_children (GLib.File file);
		[Version (since = "1.8")]
		public virtual signal string remove_file (GLib.File file);
	}
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", type_id = "tracker_miner_online_get_type ()")]
	public abstract class MinerOnline : Tracker.Miner, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected MinerOnline ();
		[NoWrapper]
		public virtual bool connected (Tracker.NetworkType network);
		[Version (since = "0.18.")]
		public Tracker.NetworkType get_network_type ();
		[Version (since = "0.18.0")]
		public virtual signal void disconnected ();
	}
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", type_id = "tracker_miner_proxy_get_type ()")]
	public class MinerProxy : GLib.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
		public MinerProxy (Tracker.Miner miner, GLib.DBusConnection connection, string dbus_path, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoAccessorMethod]
		public GLib.DBusConnection dbus_connection { owned get; construct; }
		[NoAccessorMethod]
		public string dbus_path { owned get; construct; }
		[NoAccessorMethod]
		public Tracker.Miner miner { owned get; construct; }
	}
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", type_id = "tracker_data_provider_get_type ()")]
	public interface DataProvider : GLib.Object {
		[Version (since = "1.2")]
		public abstract GLib.FileEnumerator begin (GLib.File url, string attributes, Tracker.DirectoryFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.2")]
		public abstract async GLib.FileEnumerator begin_async (GLib.File url, string attributes, Tracker.DirectoryFlags flags, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", cprefix = "TRACKER_DECORATOR_ERROR_", has_type_id = false)]
	public enum DecoratorError {
		EMPTY,
		PAUSED
	}
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", cprefix = "TRACKER_DIRECTORY_FLAG_", has_type_id = false)]
	[Flags]
	public enum DirectoryFlags {
		NONE,
		RECURSE,
		CHECK_MTIME,
		MONITOR,
		IGNORE,
		PRESERVE,
		PRIORITY,
		NO_STAT,
		CHECK_DELETED
	}
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", cprefix = "TRACKER_FILTER_POLICY_", has_type_id = false)]
	public enum FilterPolicy {
		DENY,
		ACCEPT
	}
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", cprefix = "TRACKER_FILTER_", has_type_id = false)]
	public enum FilterType {
		FILE,
		DIRECTORY,
		PARENT_DIRECTORY
	}
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", cprefix = "TRACKER_MINER_ERROR_", has_type_id = false)]
	public enum MinerError {
		NAME_MISSING,
		NAME_UNAVAILABLE,
		PAUSED,
		PAUSED_ALREADY,
		INVALID_COOKIE
	}
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", cprefix = "TRACKER_MINER_FS_ERROR_", has_type_id = false)]
	[Version (since = "1.2.")]
	public enum MinerFSError {
		[CCode (cname = "TRACKER_MINER_FS_ERROR_INIT")]
		MINER_FS_ERROR_INIT
	}
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", cprefix = "TRACKER_MINER_FS_EVENT_", has_type_id = false)]
	public enum MinerFSEventType {
		CREATED,
		UPDATED,
		DELETED,
		MOVED
	}
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", cprefix = "TRACKER_NETWORK_TYPE_", has_type_id = false)]
	[Version (since = "0.18")]
	public enum NetworkType {
		NONE,
		UNKNOWN,
		GPRS,
		EDGE,
		@3G,
		LAN
	}
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", cname = "TRACKER_MINER_DBUS_INTERFACE")]
	[Version (since = "0.8.")]
	public const string MINER_DBUS_INTERFACE;
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", cname = "TRACKER_MINER_DBUS_NAME_PREFIX")]
	[Version (since = "0.8.")]
	public const string MINER_DBUS_NAME_PREFIX;
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", cname = "TRACKER_MINER_DBUS_PATH_PREFIX")]
	[Version (since = "0.8.")]
	public const string MINER_DBUS_PATH_PREFIX;
	[CCode (cheader_filename = "libtracker-miner/tracker-miner.h", cname = "TRACKER_MINER_ERROR_DOMAIN")]
	[Version (since = "0.8.")]
	public const string MINER_ERROR_DOMAIN;
}
