/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.stream;

import gnu.xml.stream.XMLInputFactoryImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import javax.xml.stream.EventFilter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;

public abstract class XMLInputFactory {
    public static final String IS_NAMESPACE_AWARE = "javax.xml.stream.isNamespaceAware";
    public static final String IS_VALIDATING = "javax.xml.stream.isValidating";
    public static final String IS_COALESCING = "javax.xml.stream.isCoalescing";
    public static final String IS_REPLACING_ENTITY_REFERENCES = "javax.xml.stream.isReplacingEntityReferences";
    public static final String IS_SUPPORTING_EXTERNAL_ENTITIES = "javax.xml.stream.isSupportingExternalEntities";
    public static final String SUPPORT_DTD = "javax.xml.stream.supportDTD";
    public static final String REPORTER = "javax.xml.stream.reporter";
    public static final String RESOLVER = "javax.xml.stream.resolver";
    public static final String ALLOCATOR = "javax.xml.stream.allocator";

    protected XMLInputFactory() {
    }

    public static XMLInputFactory newInstance() throws FactoryConfigurationError {
        return XMLInputFactory.newInstance(null, null);
    }

    public static XMLInputFactory newInstance(String factoryId, ClassLoader classLoader) throws FactoryConfigurationError {
        ClassLoader loader = classLoader;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null) {
            loader = XMLInputFactory.class.getClassLoader();
        }
        String className = null;
        int count = 0;
        do {
            if ((className = XMLInputFactory.getFactoryClassName(loader, count++)) == null) continue;
            try {
                Class<?> t = loader != null ? loader.loadClass(className) : Class.forName(className);
                return (XMLInputFactory)t.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                className = null;
            }
            catch (Exception e) {
                throw new FactoryConfigurationError(e, "error instantiating class " + className);
            }
        } while (className == null && count < 3);
        return new XMLInputFactoryImpl();
    }

    private static String getFactoryClassName(ClassLoader loader, int attempt) {
        switch (attempt) {
            case 0: {
                return System.getProperty("javax.xml.stream.XMLInputFactory");
            }
            case 1: {
                try {
                    File file = new File(System.getProperty("java.home"));
                    file = new File(file, "lib");
                    file = new File(file, "stax.properties");
                    FileInputStream in = new FileInputStream(file);
                    Properties props = new Properties();
                    props.load(in);
                    ((InputStream)in).close();
                    return props.getProperty("javax.xml.stream.XMLInputFactory");
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            case 2: {
                try {
                    InputStream in;
                    String serviceKey = "/META-INF/services/javax.xml.stream.XMLInputFactory";
                    InputStream inputStream = in = loader != null ? loader.getResourceAsStream(serviceKey) : XMLInputFactory.class.getResourceAsStream(serviceKey);
                    if (in != null) {
                        BufferedReader r = new BufferedReader(new InputStreamReader(in));
                        String ret = r.readLine();
                        r.close();
                        return ret;
                    }
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        return null;
    }

    public abstract XMLStreamReader createXMLStreamReader(Reader var1) throws XMLStreamException;

    public abstract XMLStreamReader createXMLStreamReader(Source var1) throws XMLStreamException;

    public abstract XMLStreamReader createXMLStreamReader(InputStream var1) throws XMLStreamException;

    public abstract XMLStreamReader createXMLStreamReader(InputStream var1, String var2) throws XMLStreamException;

    public abstract XMLStreamReader createXMLStreamReader(String var1, InputStream var2) throws XMLStreamException;

    public abstract XMLStreamReader createXMLStreamReader(String var1, Reader var2) throws XMLStreamException;

    public abstract XMLEventReader createXMLEventReader(Reader var1) throws XMLStreamException;

    public abstract XMLEventReader createXMLEventReader(String var1, Reader var2) throws XMLStreamException;

    public abstract XMLEventReader createXMLEventReader(XMLStreamReader var1) throws XMLStreamException;

    public abstract XMLEventReader createXMLEventReader(Source var1) throws XMLStreamException;

    public abstract XMLEventReader createXMLEventReader(InputStream var1) throws XMLStreamException;

    public abstract XMLEventReader createXMLEventReader(InputStream var1, String var2) throws XMLStreamException;

    public abstract XMLEventReader createXMLEventReader(String var1, InputStream var2) throws XMLStreamException;

    public abstract XMLStreamReader createFilteredReader(XMLStreamReader var1, StreamFilter var2) throws XMLStreamException;

    public abstract XMLEventReader createFilteredReader(XMLEventReader var1, EventFilter var2) throws XMLStreamException;

    public abstract XMLResolver getXMLResolver();

    public abstract void setXMLResolver(XMLResolver var1);

    public abstract XMLReporter getXMLReporter();

    public abstract void setXMLReporter(XMLReporter var1);

    public abstract void setProperty(String var1, Object var2) throws IllegalArgumentException;

    public abstract Object getProperty(String var1) throws IllegalArgumentException;

    public abstract boolean isPropertySupported(String var1);

    public abstract void setEventAllocator(XMLEventAllocator var1);

    public abstract XMLEventAllocator getEventAllocator();
}

