const _loadedScripts={};(function(){const baseUrl=self.location?self.location.origin+self.location.pathname:'';self._importScriptPathPrefix=baseUrl.substring(0,baseUrl.lastIndexOf('/')+1);})();const REMOTE_MODULE_FALLBACK_REVISION='@010ddcfda246975d194964ccf20038ebbdec6084';class Runtime{constructor(descriptors){this._modules=[];this._modulesMap={};this._extensions=[];this._cachedTypeClasses={};this._descriptorsMap={};for(let i=0;i<descriptors.length;++i){this._registerModule(descriptors[i]);}}
static loadResourcePromise(url){return new Promise(load);function load(fulfill,reject){const xhr=new XMLHttpRequest();xhr.open('GET',url,true);xhr.onreadystatechange=onreadystatechange;function onreadystatechange(e){if(xhr.readyState!==XMLHttpRequest.DONE){return;}
const status=/^HTTP\/1.1 404/.test(e.target.response)?404:xhr.status;if([0,200,304].indexOf(status)===-1)
{reject(new Error('While loading from url '+url+' server responded with a status of '+status));}else{fulfill(e.target.response);}}
xhr.send(null);}}
static loadResourcePromiseWithFallback(url){return Runtime.loadResourcePromise(url).catch(err=>{const urlWithFallbackVersion=url.replace(/@[0-9a-f]{40}/,REMOTE_MODULE_FALLBACK_REVISION);if(urlWithFallbackVersion===url||!url.includes('audits_worker_module')){throw err;}
return Runtime.loadResourcePromise(urlWithFallbackVersion);});}
static normalizePath(path){if(path.indexOf('..')===-1&&path.indexOf('.')===-1){return path;}
const normalizedSegments=[];const segments=path.split('/');for(let i=0;i<segments.length;i++){const segment=segments[i];if(segment==='.'){continue;}else if(segment==='..'){normalizedSegments.pop();}else if(segment){normalizedSegments.push(segment);}}
let normalizedPath=normalizedSegments.join('/');if(normalizedPath[normalizedPath.length-1]==='/'){return normalizedPath;}
if(path[0]==='/'&&normalizedPath){normalizedPath='/'+normalizedPath;}
if((path[path.length-1]==='/')||(segments[segments.length-1]==='.')||(segments[segments.length-1]==='..')){normalizedPath=normalizedPath+'/';}
return normalizedPath;}
static getResourceURL(scriptName,base){const sourceURL=(base||self._importScriptPathPrefix)+scriptName;const schemaIndex=sourceURL.indexOf('://')+3;let pathIndex=sourceURL.indexOf('/',schemaIndex);if(pathIndex===-1){pathIndex=sourceURL.length;}
return sourceURL.substring(0,pathIndex)+Runtime.normalizePath(sourceURL.substring(pathIndex));}
static _loadScriptsPromise(scriptNames,base){const promises=[];const urls=[];const sources=new Array(scriptNames.length);let scriptToEval=0;for(let i=0;i<scriptNames.length;++i){const scriptName=scriptNames[i];const sourceURL=Runtime.getResourceURL(scriptName,base);if(_loadedScripts[sourceURL]){continue;}
urls.push(sourceURL);const loadResourcePromise=base?Runtime.loadResourcePromiseWithFallback(sourceURL):Runtime.loadResourcePromise(sourceURL);promises.push(loadResourcePromise.then(scriptSourceLoaded.bind(null,i),scriptSourceLoaded.bind(null,i,undefined)));}
return Promise.all(promises).then(undefined);function scriptSourceLoaded(scriptNumber,scriptSource){sources[scriptNumber]=scriptSource||'';while(typeof sources[scriptToEval]!=='undefined'){evaluateScript(urls[scriptToEval],sources[scriptToEval]);++scriptToEval;}}
function evaluateScript(sourceURL,scriptSource){_loadedScripts[sourceURL]=true;if(!scriptSource){console.error('Empty response arrived for script \''+sourceURL+'\'');return;}
self.eval(scriptSource+'\n//# sourceURL='+sourceURL);}}
static _loadResourceIntoCache(url,appendSourceURL){return Runtime.loadResourcePromise(url).then(cacheResource.bind(this,url),cacheResource.bind(this,url,undefined));function cacheResource(path,content){if(!content){console.error('Failed to load resource: '+path);return;}
const sourceURL=appendSourceURL?Runtime.resolveSourceURL(path):'';Runtime.cachedResources[path]=content+sourceURL;}}
static async appStarted(){return Runtime._appStartedPromise;}
static async startApplication(appName){console.timeStamp('Root.Runtime.startApplication');const allDescriptorsByName={};for(let i=0;i<Root.allDescriptors.length;++i){const d=Root.allDescriptors[i];allDescriptorsByName[d['name']]=d;}
if(!Root.applicationDescriptor){let data=await Runtime.loadResourcePromise(appName+'.json');Root.applicationDescriptor=JSON.parse(data);let descriptor=Root.applicationDescriptor;while(descriptor.extends){data=await Runtime.loadResourcePromise(descriptor.extends+'.json');descriptor=JSON.parse(data);Root.applicationDescriptor.modules=descriptor.modules.concat(Root.applicationDescriptor.modules);}}
const configuration=Root.applicationDescriptor.modules;const moduleJSONPromises=[];const coreModuleNames=[];for(let i=0;i<configuration.length;++i){const descriptor=configuration[i];const name=descriptor['name'];const moduleJSON=allDescriptorsByName[name];if(moduleJSON){moduleJSONPromises.push(Promise.resolve(moduleJSON));}else{moduleJSONPromises.push(Runtime.loadResourcePromise(name+'/module.json').then(JSON.parse.bind(JSON)));}
if(descriptor['type']==='autostart'){coreModuleNames.push(name);}}
const moduleDescriptors=await Promise.all(moduleJSONPromises);for(let i=0;i<moduleDescriptors.length;++i){moduleDescriptors[i].name=configuration[i]['name'];moduleDescriptors[i].condition=configuration[i]['condition'];moduleDescriptors[i].remote=configuration[i]['type']==='remote';}
self.runtime=new Runtime(moduleDescriptors);if(coreModuleNames){await self.runtime._loadAutoStartModules(coreModuleNames);}
Runtime._appStartedPromiseCallback();}
static startWorker(appName){return Root.Runtime.startApplication(appName).then(sendWorkerReady);function sendWorkerReady(){self.postMessage('workerReady');}}
static queryParam(name){return Runtime._queryParamsObject.get(name);}
static queryParamsString(){return location.search;}
static _experimentsSetting(){try{return(JSON.parse(self.localStorage&&self.localStorage['experiments']?self.localStorage['experiments']:'{}'));}catch(e){console.error('Failed to parse localStorage[\'experiments\']');return{};}}
static _assert(value,message){if(value){return;}
Runtime._originalAssert.call(Runtime._console,value,message+' '+new Error().stack);}
static setPlatform(platform){Runtime._platform=platform;}
static _isDescriptorEnabled(descriptor){const activatorExperiment=descriptor['experiment'];if(activatorExperiment==='*'){return Runtime.experiments.supportEnabled();}
if(activatorExperiment&&activatorExperiment.startsWith('!')&&Runtime.experiments.isEnabled(activatorExperiment.substring(1))){return false;}
if(activatorExperiment&&!activatorExperiment.startsWith('!')&&!Runtime.experiments.isEnabled(activatorExperiment)){return false;}
const condition=descriptor['condition'];if(condition&&!condition.startsWith('!')&&!Runtime.queryParam(condition)){return false;}
if(condition&&condition.startsWith('!')&&Runtime.queryParam(condition.substring(1))){return false;}
return true;}
static resolveSourceURL(path){let sourceURL=self.location.href;if(self.location.search){sourceURL=sourceURL.replace(self.location.search,'');}
sourceURL=sourceURL.substring(0,sourceURL.lastIndexOf('/')+1)+path;return'\n/*# sourceURL='+sourceURL+' */';}
static setL10nCallback(localizationFunction){Runtime._l10nCallback=localizationFunction;}
useTestBase(){Runtime._remoteBase='http://localhost:8000/inspector-sources/';if(Runtime.queryParam('debugFrontend')){Runtime._remoteBase+='debug/';}}
module(moduleName){return this._modulesMap[moduleName];}
_registerModule(descriptor){const module=new Runtime.Module(this,descriptor);this._modules.push(module);this._modulesMap[descriptor['name']]=module;}
loadModulePromise(moduleName){return this._modulesMap[moduleName]._loadPromise();}
_loadAutoStartModules(moduleNames){const promises=[];for(let i=0;i<moduleNames.length;++i){promises.push(this.loadModulePromise(moduleNames[i]));}
return Promise.all(promises);}
_checkExtensionApplicability(extension,predicate){if(!predicate){return false;}
const contextTypes=extension.descriptor().contextTypes;if(!contextTypes){return true;}
for(let i=0;i<contextTypes.length;++i){const contextType=this._resolve(contextTypes[i]);const isMatching=!!contextType&&predicate(contextType);if(isMatching){return true;}}
return false;}
isExtensionApplicableToContext(extension,context){if(!context){return true;}
return this._checkExtensionApplicability(extension,isInstanceOf);function isInstanceOf(targetType){return context instanceof targetType;}}
isExtensionApplicableToContextTypes(extension,currentContextTypes){if(!extension.descriptor().contextTypes){return true;}
return this._checkExtensionApplicability(extension,currentContextTypes?isContextTypeKnown:null);function isContextTypeKnown(targetType){return currentContextTypes.has(targetType);}}
extensions(type,context,sortByTitle){return this._extensions.filter(filter).sort(sortByTitle?titleComparator:orderComparator);function filter(extension){if(extension._type!==type&&extension._typeClass()!==type){return false;}
if(!extension.enabled()){return false;}
return!context||extension.isApplicable(context);}
function orderComparator(extension1,extension2){const order1=extension1.descriptor()['order']||0;const order2=extension2.descriptor()['order']||0;return order1-order2;}
function titleComparator(extension1,extension2){const title1=extension1.title()||'';const title2=extension2.title()||'';return title1.localeCompare(title2);}}
extension(type,context){return this.extensions(type,context)[0]||null;}
allInstances(type,context){return Promise.all(this.extensions(type,context).map(extension=>extension.instance()));}
_resolve(typeName){if(!this._cachedTypeClasses[typeName]){const path=typeName.split('.');let object=self;for(let i=0;object&&(i<path.length);++i){object=object[path[i]];}
if(object){this._cachedTypeClasses[typeName]=(object);}}
return this._cachedTypeClasses[typeName]||null;}
sharedInstance(constructorFunction){if(Runtime._instanceSymbol in constructorFunction&&Object.getOwnPropertySymbols(constructorFunction).includes(Runtime._instanceSymbol)){return constructorFunction[Runtime._instanceSymbol];}
const instance=new constructorFunction();constructorFunction[Runtime._instanceSymbol]=instance;return instance;}}
Runtime._queryParamsObject=new URLSearchParams(Runtime.queryParamsString());Runtime._instanceSymbol=Symbol('instance');Runtime.cachedResources={__proto__:null};Runtime._console=console;Runtime._originalAssert=console.assert;Runtime._platform='';class ModuleDescriptor{constructor(){this.name;this.extensions;this.dependencies;this.scripts;this.condition;this.remote;}}
class RuntimeExtensionDescriptor{constructor(){this.type;this.className;this.factoryName;this.contextTypes;}}
class Module{constructor(manager,descriptor){this._manager=manager;this._descriptor=descriptor;this._name=descriptor.name;this._extensions=[];this._extensionsByClassName=new Map();const extensions=(descriptor.extensions);for(let i=0;extensions&&i<extensions.length;++i){const extension=new Extension(this,extensions[i]);this._manager._extensions.push(extension);this._extensions.push(extension);}
this._loadedForTest=false;}
name(){return this._name;}
enabled(){return Runtime._isDescriptorEnabled(this._descriptor);}
resource(name){const fullName=this._name+'/'+name;const content=Runtime.cachedResources[fullName];if(!content){throw new Error(fullName+' not preloaded. Check module.json');}
return content;}
_loadPromise(){if(!this.enabled()){return Promise.reject(new Error('Module '+this._name+' is not enabled'));}
if(this._pendingLoadPromise){return this._pendingLoadPromise;}
const dependencies=this._descriptor.dependencies;const dependencyPromises=[];for(let i=0;dependencies&&i<dependencies.length;++i){dependencyPromises.push(this._manager._modulesMap[dependencies[i]]._loadPromise());}
this._pendingLoadPromise=Promise.all(dependencyPromises).then(this._loadResources.bind(this)).then(this._loadScripts.bind(this)).then(()=>this._loadedForTest=true);return this._pendingLoadPromise;}
_loadResources(){const resources=this._descriptor['resources'];if(!resources||!resources.length){return Promise.resolve();}
const promises=[];for(let i=0;i<resources.length;++i){const url=this._modularizeURL(resources[i]);const isHtml=url.endsWith('.html');promises.push(Runtime._loadResourceIntoCache(url,!isHtml));}
return Promise.all(promises).then(undefined);}
_loadScripts(){if(!this._descriptor.scripts||!this._descriptor.scripts.length){return Promise.resolve();}
const specialCases={'sdk':'SDK','js_sdk':'JSSDK','browser_sdk':'BrowserSDK','ui':'UI','object_ui':'ObjectUI','javascript_metadata':'JavaScriptMetadata','perf_ui':'PerfUI','har_importer':'HARImporter','sdk_test_runner':'SDKTestRunner','cpu_profiler_test_runner':'CPUProfilerTestRunner'};const namespace=specialCases[this._name]||this._name.split('_').map(a=>a.substring(0,1).toUpperCase()+a.substring(1)).join('');self[namespace]=self[namespace]||{};return Runtime._loadScriptsPromise(this._descriptor.scripts.map(this._modularizeURL,this),this._remoteBase());}
_modularizeURL(resourceName){return Runtime.normalizePath(this._name+'/'+resourceName);}
_remoteBase(){return!Runtime.queryParam('debugFrontend')&&this._descriptor.remote&&Runtime._remoteBase||undefined;}
fetchResource(resourceName){const base=this._remoteBase();const sourceURL=Runtime.getResourceURL(this._modularizeURL(resourceName),base);return base?Runtime.loadResourcePromiseWithFallback(sourceURL):Runtime.loadResourcePromise(sourceURL);}
substituteURL(value){const base=this._remoteBase()||'';return value.replace(/@url\(([^\)]*?)\)/g,convertURL.bind(this));function convertURL(match,url){return base+this._modularizeURL(url);}}}
class Extension{constructor(module,descriptor){this._module=module;this._descriptor=descriptor;this._type=descriptor.type;this._hasTypeClass=this._type.charAt(0)==='@';this._className=descriptor.className||null;this._factoryName=descriptor.factoryName||null;}
descriptor(){return this._descriptor;}
module(){return this._module;}
enabled(){return this._module.enabled()&&Runtime._isDescriptorEnabled(this.descriptor());}
_typeClass(){if(!this._hasTypeClass){return null;}
return this._module._manager._resolve(this._type.substring(1));}
isApplicable(context){return this._module._manager.isExtensionApplicableToContext(this,context);}
instance(){return this._module._loadPromise().then(this._createInstance.bind(this));}
canInstantiate(){return!!(this._className||this._factoryName);}
_createInstance(){const className=this._className||this._factoryName;if(!className){throw new Error('Could not instantiate extension with no class');}
const constructorFunction=self.eval((className));if(!(constructorFunction instanceof Function)){throw new Error('Could not instantiate: '+className);}
if(this._className){return this._module._manager.sharedInstance(constructorFunction);}
return new constructorFunction(this);}
title(){const title=this._descriptor['title-'+Runtime._platform]||this._descriptor['title'];if(title&&Runtime._l10nCallback){return Runtime._l10nCallback(title);}
return title;}
hasContextType(contextType){const contextTypes=this.descriptor().contextTypes;if(!contextTypes){return false;}
for(let i=0;i<contextTypes.length;++i){if(contextType===this._module._manager._resolve(contextTypes[i])){return true;}}
return false;}}
class ExperimentsSupport{constructor(){this._supportEnabled=Runtime.queryParam('experiments')!==null;this._experiments=[];this._experimentNames={};this._enabledTransiently={};this._serverEnabled=new Set();}
allConfigurableExperiments(){const result=[];for(let i=0;i<this._experiments.length;i++){const experiment=this._experiments[i];if(!this._enabledTransiently[experiment.name]){result.push(experiment);}}
return result;}
supportEnabled(){return this._supportEnabled;}
_setExperimentsSetting(value){if(!self.localStorage){return;}
self.localStorage['experiments']=JSON.stringify(value);}
register(experimentName,experimentTitle,hidden){Runtime._assert(!this._experimentNames[experimentName],'Duplicate registration of experiment '+experimentName);this._experimentNames[experimentName]=true;this._experiments.push(new Runtime.Experiment(this,experimentName,experimentTitle,!!hidden));}
isEnabled(experimentName){this._checkExperiment(experimentName);if(Runtime._experimentsSetting()[experimentName]===false){return false;}
if(this._enabledTransiently[experimentName]){return true;}
if(this._serverEnabled.has(experimentName)){return true;}
if(!this.supportEnabled()){return false;}
return!!Runtime._experimentsSetting()[experimentName];}
setEnabled(experimentName,enabled){this._checkExperiment(experimentName);const experimentsSetting=Runtime._experimentsSetting();experimentsSetting[experimentName]=enabled;this._setExperimentsSetting(experimentsSetting);}
setDefaultExperiments(experimentNames){for(let i=0;i<experimentNames.length;++i){this._checkExperiment(experimentNames[i]);this._enabledTransiently[experimentNames[i]]=true;}}
setServerEnabledExperiments(experimentNames){for(const experiment of experimentNames){this._checkExperiment(experiment);this._serverEnabled.add(experiment);}}
enableForTest(experimentName){this._checkExperiment(experimentName);this._enabledTransiently[experimentName]=true;}
clearForTest(){this._experiments=[];this._experimentNames={};this._enabledTransiently={};this._serverEnabled.clear();}
cleanUpStaleExperiments(){const experimentsSetting=Runtime._experimentsSetting();const cleanedUpExperimentSetting={};for(let i=0;i<this._experiments.length;++i){const experimentName=this._experiments[i].name;if(experimentsSetting[experimentName]){cleanedUpExperimentSetting[experimentName]=true;}}
this._setExperimentsSetting(cleanedUpExperimentSetting);}
_checkExperiment(experimentName){Runtime._assert(this._experimentNames[experimentName],'Unknown experiment '+experimentName);}}
class Experiment{constructor(experiments,name,title,hidden){this.name=name;this.title=title;this.hidden=hidden;this._experiments=experiments;}
isEnabled(){return this._experiments.isEnabled(this.name);}
setEnabled(enabled){this._experiments.setEnabled(this.name,enabled);}}
Runtime.experiments=new ExperimentsSupport();Runtime._appStartedPromiseCallback;Runtime._appStartedPromise=new Promise(fulfil=>Runtime._appStartedPromiseCallback=fulfil);Runtime._l10nCallback;Runtime._remoteBase;(function validateRemoteBase(){if(location.href.startsWith('devtools://devtools/bundled/')&&Runtime.queryParam('remoteBase')){const versionMatch=/\/serve_file\/(@[0-9a-zA-Z]+)\/?$/.exec(Runtime.queryParam('remoteBase'));if(versionMatch){Runtime._remoteBase=`${location.origin}/remote/serve_file/${versionMatch[1]}/`;}}})();self.Root=self.Root||{};Root=Root||{};Root.allDescriptors=[];Root.applicationDescriptor=undefined;Root.Runtime=Runtime;Root.runtime;Root.Runtime.ModuleDescriptor=ModuleDescriptor;Root.Runtime.ExtensionDescriptor=RuntimeExtensionDescriptor;Root.Runtime.Extension=Extension;Root.Runtime.Module=Module;Root.Runtime.ExperimentsSupport=ExperimentsSupport;Root.Runtime.Experiment=Experiment;Root.allDescriptors.push(...[{"dependencies":["ui","platform","common","cm"],"extensions":[{"className":"TextEditor.CodeMirrorUtils.TokenizerFactory","type":"@TextUtils.TokenizerFactory"},{"className":"TextEditor.CodeMirrorTextEditorFactory","type":"@UI.TextEditorFactory"}],"name":"text_editor","scripts":["text_editor_module.js"],"skip_compilation":["acorn/acorn.js","../cm_web_modes/css.js","../cm_web_modes/javascript.js","../cm_web_modes/xml.js","../cm_web_modes/htmlmixed.js","../cm_web_modes/htmlembedded.js"]},{"skip_compilation":["../InspectorBackendCommands.js"],"dependencies":["common","host"],"modules":["protocol.js","NodeURL.js","InspectorBackend.js","../InspectorBackendCommands.js"],"name":"protocol","scripts":[]},{"skip_compilation":["codemirror.js","multiplex.js","matchbrackets.js","closebrackets.js","mark-selection.js","comment.js","overlay.js","active-line.js","foldcode.js","foldgutter.js","brace-fold.js"],"name":"cm","scripts":["cm_module.js"]},{"dependencies":["text_editor"],"extensions":[{"className":"CmModes.DefaultCodeMirrorMimeMode","mimeTypes":["text/x-csrc","text/x-c","text/x-chdr","text/x-c++src","text/x-c++hdr","text/x-java","text/x-csharp","text/x-scala","x-shader/x-vertex","x-shader/x-fragment"],"type":"@TextEditor.CodeMirrorMimeMode","fileName":"clike.js"},{"className":"CmModes.DefaultCodeMirrorMimeMode","mimeTypes":["text/x-coffeescript"],"type":"@TextEditor.CodeMirrorMimeMode","fileName":"coffeescript.js"},{"className":"CmModes.DefaultCodeMirrorMimeMode","mimeTypes":["text/markdown","text/x-markdown"],"type":"@TextEditor.CodeMirrorMimeMode","fileName":"markdown.js"},{"className":"CmModes.DefaultCodeMirrorMimeMode","mimeTypes":["application/x-httpd-php","application/x-httpd-php-open","text/x-php"],"dependencies":["clike.js"],"type":"@TextEditor.CodeMirrorMimeMode","fileName":"php.js"},{"className":"CmModes.DefaultCodeMirrorMimeMode","mimeTypes":["text/x-python","text/x-cython"],"type":"@TextEditor.CodeMirrorMimeMode","fileName":"python.js"},{"className":"CmModes.DefaultCodeMirrorMimeMode","mimeTypes":["text/x-sh"],"type":"@TextEditor.CodeMirrorMimeMode","fileName":"shell.js"},{"className":"CmModes.DefaultCodeMirrorMimeMode","mimeTypes":["text/x-livescript"],"type":"@TextEditor.CodeMirrorMimeMode","fileName":"livescript.js"},{"className":"CmModes.DefaultCodeMirrorMimeMode","mimeTypes":["text/x-clojure"],"type":"@TextEditor.CodeMirrorMimeMode","fileName":"clojure.js"},{"className":"CmModes.DefaultCodeMirrorMimeMode","mimeTypes":["text/jsx","text/typescript-jsx"],"type":"@TextEditor.CodeMirrorMimeMode","fileName":"jsx.js"},{"className":"CmModes.DefaultCodeMirrorMimeMode","mimeTypes":["text/x-styl"],"type":"@TextEditor.CodeMirrorMimeMode","fileName":"stylus.js"}],"name":"cm_modes","scripts":["cm_modes_module.js"]},{"dependencies":["components","search","source_frame","snippets","extensions","persistence","quick_open","inline_editor","color_picker","event_listeners","object_ui","formatter"],"extensions":[{"title":"Sources","id":"sources","className":"Sources.SourcesPanel","location":"panel","type":"view","order":30},{"className":"Sources.SourcesPanel","contextTypes":["Workspace.UISourceCode","Workspace.UILocation","SDK.RemoteObject","SDK.NetworkRequest","Sources.UISourceCodeFrame"],"type":"@UI.ContextMenu.Provider"},{"category":"Debugger","iconClass":"largeicon-pause","toggledIconClass":"largeicon-resume","className":"Sources.SourcesPanel.RevealingActionDelegate","contextTypes":["Sources.SourcesView","UI.ShortcutRegistry.ForwardedShortcut"],"actionId":"debugger.toggle-pause","toggleable":true,"bindings":[{"platform":"windows,linux","shortcut":"F8 Ctrl+\\"},{"platform":"mac","shortcut":"F8 Meta+\\"}],"type":"action","options":[{"value":true,"title":"Pause script execution"},{"value":false,"title":"Resume script execution"}]},{"category":"Debugger","iconClass":"largeicon-step-over","title":"Step over next function call","className":"Sources.SourcesPanel.DebuggingActionDelegate","contextTypes":["SDK.DebuggerPausedDetails"],"actionId":"debugger.step-over","bindings":[{"platform":"windows,linux","shortcut":"F10 Ctrl+'"},{"platform":"mac","shortcut":"F10 Meta+'"}],"type":"action"},{"category":"Debugger","iconClass":"largeicon-step-into","title":"Step into next function call","className":"Sources.SourcesPanel.DebuggingActionDelegate","contextTypes":["SDK.DebuggerPausedDetails"],"actionId":"debugger.step-into","bindings":[{"platform":"windows,linux","shortcut":"F11 Ctrl+;"},{"platform":"mac","shortcut":"F11 Meta+;"}],"type":"action"},{"category":"Debugger","iconClass":"largeicon-step","title":"Step","className":"Sources.SourcesPanel.DebuggingActionDelegate","contextTypes":["SDK.DebuggerPausedDetails"],"actionId":"debugger.step","bindings":[{"shortcut":"F9"}],"type":"action"},{"category":"Debugger","iconClass":"largeicon-step-out","title":"Step out of current function","className":"Sources.SourcesPanel.DebuggingActionDelegate","contextTypes":["SDK.DebuggerPausedDetails"],"actionId":"debugger.step-out","bindings":[{"platform":"windows,linux","shortcut":"Shift+F11 Shift+Ctrl+;"},{"platform":"mac","shortcut":"Shift+F11 Shift+Meta+;"}],"type":"action"},{"iconClass":"largeicon-play","title":"Run snippet","className":"Sources.SourcesPanel.DebuggingActionDelegate","contextTypes":["Sources.SourcesView"],"actionId":"debugger.run-snippet","bindings":[{"platform":"windows,linux","shortcut":"Ctrl+Enter"},{"platform":"mac","shortcut":"Meta+Enter"}],"type":"action"},{"category":"Debugger","iconClass":"largeicon-deactivate-breakpoints","toggledIconClass":"largeicon-activate-breakpoints","className":"Sources.SourcesPanel.DebuggingActionDelegate","contextTypes":["Sources.SourcesView"],"actionId":"debugger.toggle-breakpoints-active","toggleable":true,"bindings":[{"platform":"windows,linux","shortcut":"Ctrl+F8"},{"platform":"mac","shortcut":"Meta+F8"}],"type":"action","options":[{"value":true,"title":"Deactivate breakpoints"},{"value":false,"title":"Activate breakpoints"}]},{"title":"Add selected text to watches","className":"Sources.WatchExpressionsSidebarPane","contextTypes":["Sources.UISourceCodeFrame"],"actionId":"sources.add-to-watch","bindings":[{"shortcut":"Ctrl+Shift+A"}],"type":"action"},{"className":"Sources.WatchExpressionsSidebarPane","contextTypes":["ObjectUI.ObjectPropertyTreeElement"],"type":"@UI.ContextMenu.Provider","actionId":"sources.add-to-watch","title":"Add to watch"},{"className":"Sources.WatchExpressionsSidebarPane","contextTypes":["TextEditor.CodeMirrorTextEditor"],"type":"@UI.ContextMenu.Provider"},{"className":"Sources.GutterDiffPlugin.ContextMenuProvider","contextTypes":["Workspace.UISourceCode"],"type":"@UI.ContextMenu.Provider"},{"title":"Evaluate selected text in console","className":"Sources.SourcesPanel.DebuggingActionDelegate","contextTypes":["Sources.UISourceCodeFrame"],"actionId":"debugger.evaluate-selection","bindings":[{"shortcut":"Ctrl+Shift+E"}],"type":"action"},{"className":"Sources.OpenFileQuickOpen","prefix":"","type":"@QuickOpen.FilteredListWidget.Provider","title":"Open file"},{"className":"Sources.GoToLineQuickOpen","prefix":":","type":"@QuickOpen.FilteredListWidget.Provider","title":"Go to line"},{"className":"Sources.OutlineQuickOpen","prefix":"@","type":"@QuickOpen.FilteredListWidget.Provider","title":"Go to symbol"},{"type":"context-menu-item","location":"navigatorMenu/default","actionId":"quickOpen.show"},{"className":"Sources.SourcesPanel.UILocationRevealer","contextTypes":["Workspace.UILocation"],"destination":"Sources panel","type":"@Common.Revealer"},{"className":"Sources.SourcesPanel.DebuggerLocationRevealer","contextTypes":["SDK.DebuggerModel.Location"],"destination":"Sources panel","type":"@Common.Revealer"},{"className":"Sources.SourcesPanel.UISourceCodeRevealer","contextTypes":["Workspace.UISourceCode"],"destination":"Sources panel","type":"@Common.Revealer"},{"className":"Sources.SourcesPanel.DebuggerPausedDetailsRevealer","contextTypes":["SDK.DebuggerPausedDetails"],"destination":"Sources panel","type":"@Common.Revealer"},{"className":"Sources.InplaceFormatterEditorAction","type":"@Sources.SourcesView.EditorAction"},{"className":"Sources.ScriptFormatterEditorAction","type":"@Sources.SourcesView.EditorAction"},{"title":"Filesystem","id":"navigator-files","className":"Sources.FilesNavigatorView","location":"navigator-view","type":"view","order":3,"persistence":"permanent"},{"title":"Snippets","id":"navigator-snippets","className":"Sources.SnippetsNavigatorView","location":"navigator-view","type":"view","order":6,"persistence":"permanent"},{"title":"Search","id":"sources.search-sources-tab","className":"Sources.SearchSourcesView","location":"drawer-view","type":"view","order":7,"persistence":"closeable"},{"className":"Sources.NetworkNavigatorView","viewId":"navigator-network","type":"@Sources.NavigatorView"},{"className":"Sources.FilesNavigatorView","viewId":"navigator-files","type":"@Sources.NavigatorView"},{"className":"Sources.SnippetsNavigatorView","viewId":"navigator-snippets","type":"@Sources.NavigatorView"},{"className":"Sources.SourcesView.SwitchFileActionDelegate","contextTypes":["Sources.SourcesView"],"bindings":[{"shortcut":"Alt+O"}],"type":"action","actionId":"sources.switch-file"},{"bindings":[{"platform":"windows,linux","shortcut":"F2"},{"platform":"mac","shortcut":"Enter"}],"type":"action","actionId":"sources.rename"},{"defaultValue":"true","type":"setting","settingName":"navigatorGroupByFolder","settingType":"boolean"},{"category":"Sources","title":"Search in anonymous and content scripts","defaultValue":false,"settingName":"searchInAnonymousAndContentScripts","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Search in anonymous and content scripts"},{"value":false,"title":"Do not search in anonymous and content scripts"}]},{"category":"Sources","title":"Automatically reveal files in sidebar","defaultValue":false,"settingName":"autoRevealInNavigator","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Automatically reveal files in sidebar"},{"value":false,"title":"Do not automatically reveal files in sidebar"}]},{"category":"Sources","title":"Enable JavaScript source maps","defaultValue":true,"settingName":"jsSourceMapsEnabled","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Enable JavaScript source maps"},{"value":false,"title":"Disable JavaScript source maps"}]},{"category":"Sources","title":"Enable tab moves focus","defaultValue":false,"settingName":"textEditorTabMovesFocus","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Enable tab moves focus"},{"value":false,"title":"Disable tab moves focus"}]},{"category":"Sources","title":"Detect indentation","defaultValue":true,"settingName":"textEditorAutoDetectIndent","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Detect indentation"},{"value":false,"title":"Do not detect indentation"}]},{"category":"Sources","title":"Autocompletion","defaultValue":true,"settingName":"textEditorAutocompletion","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Enable autocompletion"},{"value":false,"title":"Disable autocompletion"}]},{"category":"Sources","title":"Bracket matching","defaultValue":true,"settingName":"textEditorBracketMatching","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Enable bracket matching"},{"value":false,"title":"Disable bracket matching"}]},{"category":"Sources","title":"Code folding","defaultValue":false,"settingName":"textEditorCodeFolding","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Enable code folding"},{"value":false,"title":"Disable code folding"}]},{"category":"Sources","title":"Show whitespace characters:","defaultValue":"original","settingName":"showWhitespacesInEditor","settingType":"enum","type":"setting","options":[{"text":"None","value":"none","title":"Do not show whitespace characters"},{"text":"All","value":"all","title":"Show all whitespace characters"},{"text":"Trailing","value":"trailing","title":"Show trailing whitespace characters"}]},{"category":"Sources","title":"Display variable values inline while debugging","defaultValue":true,"settingName":"inlineVariableValues","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Display variable values inline while debugging"},{"value":false,"title":"Do not display variable values inline while debugging"}]},{"category":"Sources","title":"Enable CSS source maps","defaultValue":true,"settingName":"cssSourceMapsEnabled","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Enable CSS source maps"},{"value":false,"title":"Disable CSS source maps"}]},{"title":"Quick source","id":"sources.quick","className":"Sources.SourcesPanel.WrapperView","location":"drawer-view","type":"view","order":1000,"persistence":"closeable"},{"category":"Sources","className":"Sources.SourcesView.ActionDelegate","type":"action","actionId":"sources.close-all","title":"Close All"},{"className":"Sources.SourcesView.ActionDelegate","contextTypes":["Sources.SourcesView"],"bindings":[{"shortcut":"Alt+Minus"}],"type":"action","actionId":"sources.jump-to-previous-location"},{"className":"Sources.SourcesView.ActionDelegate","contextTypes":["Sources.SourcesView"],"bindings":[{"shortcut":"Alt+Plus"}],"type":"action","actionId":"sources.jump-to-next-location"},{"className":"Sources.SourcesView.ActionDelegate","contextTypes":["Sources.SourcesView"],"bindings":[{"shortcut":"Alt+w"}],"type":"action","actionId":"sources.close-editor-tab"},{"className":"Sources.SourcesView.ActionDelegate","contextTypes":["Sources.SourcesView"],"bindings":[{"shortcut":"Ctrl+g"}],"type":"action","actionId":"sources.go-to-line"},{"className":"Sources.SourcesView.ActionDelegate","contextTypes":["Sources.SourcesView"],"bindings":[{"platform":"windows,linux","shortcut":"Ctrl+Shift+o"},{"platform":"mac","shortcut":"Meta+Shift+o"}],"type":"action","actionId":"sources.go-to-member"},{"bindings":[{"platform":"windows,linux","shortcut":"Ctrl+b"},{"platform":"mac","shortcut":"Meta+b"}],"type":"action","actionId":"debugger.toggle-breakpoint"},{"bindings":[{"platform":"windows,linux","shortcut":"Ctrl+Shift+b"},{"platform":"mac","shortcut":"Meta+Shift+b"}],"type":"action","actionId":"debugger.toggle-breakpoint-enabled"},{"bindings":[{"platform":"windows,linux","shortcut":"Ctrl+Alt+b"},{"platform":"mac","shortcut":"Meta+Alt+b"}],"type":"action","actionId":"debugger.breakpoint-input-window"},{"className":"Sources.SourcesView.ActionDelegate","contextTypes":["Sources.SourcesView"],"bindings":[{"platform":"windows,linux","shortcut":"Ctrl+s"},{"platform":"mac","shortcut":"Meta+s"}],"type":"action","actionId":"sources.save"},{"className":"Sources.SourcesView.ActionDelegate","contextTypes":["Sources.SourcesView"],"bindings":[{"platform":"windows,linux","shortcut":"Ctrl+Shift+s"},{"platform":"mac","shortcut":"Meta+Alt+s"}],"type":"action","actionId":"sources.save-all"},{"category":"Sources","className":"Sources.ActionDelegate","type":"action","actionId":"sources.create-snippet","title":"Create new snippet"},{"category":"Sources","iconClass":"largeicon-add","title":"Add folder to workspace","className":"Sources.ActionDelegate","actionId":"sources.add-folder-to-workspace","type":"action","condition":"!sources.hide_add_folder"},{"showLabel":true,"type":"@UI.ToolbarItem.Provider","actionId":"sources.add-folder-to-workspace","condition":"!sources.hide_add_folder","location":"files-navigator-toolbar"},{"category":"Sources","className":"Sources.SourcesPanel","type":"@UI.ViewLocationResolver","name":"navigator-view"},{"category":"Sources","className":"Sources.SourcesPanel","type":"@UI.ViewLocationResolver","name":"sources.sidebar-top"},{"category":"Sources","className":"Sources.SourcesPanel","type":"@UI.ViewLocationResolver","name":"sources.sidebar-bottom"},{"category":"Sources","className":"Sources.SourcesPanel","type":"@UI.ViewLocationResolver","name":"sources.sidebar-tabs"},{"title":"Threads","className":"Sources.ThreadsSidebarPane","persistence":"permanent","type":"view","id":"sources.threads","condition":"!sources.hide_thread_sidebar"},{"className":"Sources.ScopeChainSidebarPane","type":"view","id":"sources.scopeChain","persistence":"permanent","title":"Scope"},{"title":"Watch","className":"Sources.WatchExpressionsSidebarPane","hasToolbar":true,"type":"view","id":"sources.watch","persistence":"permanent"},{"className":"Sources.JavaScriptBreakpointsSidebarPane","type":"view","id":"sources.jsBreakpoints","persistence":"permanent","title":"Breakpoints"},{"className":"Sources.JavaScriptBreakpointsSidebarPane","contextTypes":["SDK.DebuggerPausedDetails"],"type":"@UI.ContextFlavorListener"},{"className":"Sources.CallStackSidebarPane","contextTypes":["SDK.DebuggerPausedDetails"],"type":"@UI.ContextFlavorListener"},{"className":"Sources.ScopeChainSidebarPane","contextTypes":["SDK.DebuggerModel.CallFrame"],"type":"@UI.ContextFlavorListener"},{"category":"Debugger","title":"Previous call frame","className":"Sources.CallStackSidebarPane.ActionDelegate","contextTypes":["SDK.DebuggerPausedDetails"],"actionId":"debugger.previous-call-frame","bindings":[{"shortcut":"Ctrl+,"}],"type":"action"},{"category":"Debugger","title":"Next call frame","className":"Sources.CallStackSidebarPane.ActionDelegate","contextTypes":["SDK.DebuggerPausedDetails"],"actionId":"debugger.next-call-frame","bindings":[{"shortcut":"Ctrl+."}],"type":"action"},{"category":"DevTools","title":"Search","className":"Sources.SearchSourcesView.ActionDelegate","actionId":"sources.search","bindings":[{"platform":"mac","shortcut":"Meta+Alt+F"},{"platform":"windows,linux","shortcut":"Ctrl+Shift+F"}],"type":"action"},{"type":"context-menu-item","location":"mainMenu/default","actionId":"sources.search"}],"name":"sources","scripts":["sources_module.js"]},{"extensions":[{"category":"Network","title":"Preserve log","defaultValue":false,"tags":"preserve, clear, reset","settingName":"network_log.preserve-log","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Do not preserve log on page reload / navigation"},{"value":false,"title":"Preserve log on page reload / navigation"}]}],"dependencies":["sdk"],"modules":["browser_sdk.js","LogManager.js"],"name":"browser_sdk","scripts":[]},{"dependencies":["common","platform"],"modules":["host.js","InspectorFrontendHostAPI.js","InspectorFrontendHost.js","Platform.js","ResourceLoader.js","UserMetrics.js"],"name":"host","scripts":[]},{"skip_compilation":["diff_match_patch.js"],"dependencies":["common"],"name":"diff","scripts":["diff_module.js"]},{"dependencies":["sdk","platform","services","workspace"],"modules":["bindings.js","LiveLocation.js","ResourceMapping.js","CompilerScriptMapping.js","ResourceScriptMapping.js","SASSSourceMapping.js","StylesSourceMapping.js","CSSWorkspaceBinding.js","DebuggerWorkspaceBinding.js","BreakpointManager.js","ContentProviderBasedProject.js","DefaultScriptMapping.js","FileUtils.js","BlackboxManager.js","NetworkProject.js","PresentationConsoleMessageHelper.js","ResourceUtils.js","TempFile.js"],"name":"bindings","scripts":[]},{"dependencies":["bindings","quick_open","persistence"],"extensions":[{"className":"Snippets.SnippetsQuickOpen","prefix":"!","type":"@QuickOpen.FilteredListWidget.Provider","title":"Run snippet"}],"name":"snippets","scripts":["snippets_module.js"]},{"dependencies":[],"name":"heap_snapshot_model","scripts":["heap_snapshot_model_module.js"]},{"dependencies":["components","data_grid","object_ui","sdk","product_registry","formatter"],"extensions":[{"title":"Console","id":"console","className":"Console.ConsolePanel","location":"panel","type":"view","order":20},{"title":"Console","id":"console-view","className":"Console.ConsolePanel.WrapperView","location":"drawer-view","type":"view","order":0,"persistence":"permanent"},{"className":"Console.ConsolePanel.ConsoleRevealer","contextTypes":["Common.Console"],"type":"@Common.Revealer"},{"className":"Console.ConsoleView.ActionDelegate","bindings":[{"shortcut":"Ctrl+`"}],"type":"action","actionId":"console.show"},{"category":"Console","iconClass":"largeicon-clear","title":"Clear console","className":"Console.ConsoleView.ActionDelegate","contextTypes":["Console.ConsoleView"],"actionId":"console.clear","bindings":[{"platform":"windows,linux","shortcut":"Ctrl+L"},{"platform":"mac","shortcut":"Ctrl+L Meta+K"}],"type":"action"},{"category":"Console","className":"Console.ConsoleView.ActionDelegate","type":"action","actionId":"console.clear.history","title":"Clear console history"},{"category":"Console","iconClass":"largeicon-visibility","title":"Create live expression","className":"Console.ConsoleView.ActionDelegate","actionId":"console.create-pin","type":"action"},{"category":"Console","title":"Hide network messages","defaultValue":false,"settingName":"hideNetworkMessages","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Hide network messages"},{"value":false,"title":"Show network messages"}]},{"category":"Console","title":"Selected context only","storageType":"session","defaultValue":false,"settingName":"selectedContextFilterEnabled","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Only show messages from the current context (top, iframe, worker, extension)"},{"value":false,"title":"Show messages from all contexts"}]},{"category":"Console","title":"Log XMLHttpRequests","defaultValue":false,"settingName":"monitoringXHREnabled","settingType":"boolean","type":"setting"},{"category":"Console","title":"Show timestamps","defaultValue":false,"settingName":"consoleTimestampsEnabled","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Show timestamps"},{"value":false,"title":"Hide timestamps"}]},{"category":"Console","title":"Autocomplete from history","defaultValue":true,"settingName":"consoleHistoryAutocomplete","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Autocomplete from history"},{"value":false,"title":"Do not autocomplete from history"}]},{"category":"Console","title":"Group similar","defaultValue":true,"settingName":"consoleGroupSimilar","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Group similar messages in console"},{"value":false,"title":"Do not group similar messages in console"}]},{"category":"Console","title":"Eager evaluation","defaultValue":true,"settingName":"consoleEagerEval","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Eagerly evaluate console prompt text"},{"value":false,"title":"Do not eagerly evaluate console prompt text"}]},{"category":"Console","title":"Evaluate triggers user activation","defaultValue":true,"settingName":"consoleUserActivationEval","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Treat evaluation as user activation"},{"value":false,"title":"Do not treat evaluation as user activation"}]}],"name":"console","scripts":["console_module.js"]},{"dependencies":["platform","ui","host","components","data_grid","source_frame"],"extensions":[{"title":"Protocol monitor","id":"protocol-monitor","className":"ProtocolMonitor.ProtocolMonitor","experiment":"protocolMonitor","location":"drawer-view","type":"view","order":100,"persistence":"closeable"}],"name":"protocol_monitor","scripts":["protocol_monitor_module.js"]},{"dependencies":["workspace","diff","persistence"],"name":"workspace_diff","scripts":["workspace_diff_module.js"]},{"dependencies":["ui","sdk","bindings","source_frame","text_editor"],"extensions":[{"className":"PerfUI.LiveHeapProfile","experiment":"liveHeapProfile","type":"late-initialization","setting":"memoryLiveHeapProfile"},{"className":"PerfUI.LineLevelProfile.LineDecorator","decoratorType":"performance","type":"@SourceFrame.LineDecorator"},{"className":"PerfUI.LineLevelProfile.LineDecorator","decoratorType":"memory","type":"@SourceFrame.LineDecorator"},{"category":"Performance","title":"Flamechart mouse wheel action:","defaultValue":"zoom","settingName":"flamechartMouseWheelAction","settingType":"enum","type":"setting","options":[{"text":"Scroll","value":"scroll","title":"Scroll"},{"text":"Zoom","value":"zoom","title":"Zoom"}]},{"category":"Memory","title":"Live memory allocation annotations","defaultValue":false,"experiment":"liveHeapProfile","settingName":"memoryLiveHeapProfile","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Show live memory allocation annotations"},{"value":false,"title":"Hide live memory allocation annotations"}]},{"iconClass":"largeicon-trash-bin","className":"PerfUI.GCActionDelegate","type":"action","actionId":"components.collect-garbage","title":"Collect garbage"}],"name":"perf_ui","scripts":["perf_ui_module.js"]},{"dependencies":["common","sdk","ui"],"extensions":[{"category":"Appearance","title":"Show third party URL badges","defaultValue":false,"settingName":"product_registry.badges-visible","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Show third party badges"},{"value":false,"title":"Do not show third party badges"}]}],"name":"product_registry"},{"dependencies":[],"modules":["utilities.js"],"name":"platform","scripts":[]},{"dependencies":["text_editor","ui","platform","persistence","formatter","object_ui","workspace_diff"],"extensions":[{"category":"Sources","title":"Default indentation:","defaultValue":"    ","settingName":"textEditorIndent","settingType":"enum","type":"setting","options":[{"text":"2 spaces","value":"  ","title":"Set indentation to 2 spaces"},{"text":"4 spaces","value":"    ","title":"Set indentation to 4 spaces"},{"text":"8 spaces","value":"        ","title":"Set indentation to 8 spaces"},{"text":"Tab character","value":"\t","title":"Set indentation to tab character"}]}],"name":"source_frame","scripts":["source_frame_module.js"]},{"dependencies":["extensions","host","platform","sdk","persistence"],"extensions":[{"className":"Main.SimpleAppProvider","type":"@Common.AppProvider","order":10},{"className":"Components.Linkifier.ContentProviderContextMenuProvider","contextTypes":["Workspace.UISourceCode","SDK.Resource","SDK.NetworkRequest"],"type":"@UI.ContextMenu.Provider"},{"className":"UI.XLink.ContextMenuProvider","contextTypes":["Node"],"type":"@UI.ContextMenu.Provider"},{"className":"Components.Linkifier.LinkContextMenuProvider","contextTypes":["Node"],"type":"@UI.ContextMenu.Provider"},{"category":"Drawer","title":"Focus debuggee","className":"InspectorMain.FocusDebuggeeActionDelegate","actionId":"inspector_main.focus-debuggee","type":"action","order":100},{"category":"Drawer","title":"Toggle drawer","className":"UI.InspectorView.ActionDelegate","actionId":"main.toggle-drawer","bindings":[{"shortcut":"Esc"}],"type":"action","order":101},{"className":"UI.InspectorView.ActionDelegate","bindings":[{"platform":"windows,linux","shortcut":"Ctrl+]"},{"platform":"mac","shortcut":"Meta+]"}],"type":"action","actionId":"main.next-tab"},{"className":"UI.InspectorView.ActionDelegate","bindings":[{"platform":"windows,linux","shortcut":"Ctrl+["},{"platform":"mac","shortcut":"Meta+["}],"type":"action","actionId":"main.previous-tab"},{"className":"Main.ReloadActionDelegate","bindings":[{"shortcut":"Alt+R"}],"type":"action","actionId":"main.debug-reload"},{"category":"DevTools","title":"Restore last dock position","className":"Components.DockController.ToggleDockActionDelegate","actionId":"main.toggle-dock","bindings":[{"platform":"windows,linux","shortcut":"Ctrl+Shift+D"},{"platform":"mac","shortcut":"Meta+Shift+D"}],"type":"action"},{"className":"Main.Main.ZoomActionDelegate","bindings":[{"platform":"windows,linux","shortcut":"Ctrl+Plus Ctrl+Shift+Plus Ctrl+NumpadPlus Ctrl+Shift+NumpadPlus"},{"platform":"mac","shortcut":"Meta+Plus Meta+Shift+Plus Meta+NumpadPlus Meta+Shift+NumpadPlus"}],"type":"action","actionId":"main.zoom-in"},{"className":"Main.Main.ZoomActionDelegate","bindings":[{"platform":"windows,linux","shortcut":"Ctrl+Minus Ctrl+Shift+Minus Ctrl+NumpadMinus Ctrl+Shift+NumpadMinus"},{"platform":"mac","shortcut":"Meta+Minus Meta+Shift+Minus Meta+NumpadMinus Meta+Shift+NumpadMinus"}],"type":"action","actionId":"main.zoom-out"},{"className":"Main.Main.ZoomActionDelegate","bindings":[{"platform":"windows,linux","shortcut":"Ctrl+0 Ctrl+Numpad0"},{"platform":"mac","shortcut":"Meta+0 Meta+Numpad0"}],"type":"action","actionId":"main.zoom-reset"},{"className":"Main.Main.SearchActionDelegate","bindings":[{"platform":"windows,linux","shortcut":"Ctrl+F"},{"platform":"mac","shortcut":"Meta+F F3"}],"type":"action","actionId":"main.search-in-panel.find"},{"className":"Main.Main.SearchActionDelegate","bindings":[{"shortcut":"Esc"}],"type":"action","actionId":"main.search-in-panel.cancel","order":10},{"className":"Main.Main.SearchActionDelegate","bindings":[{"platform":"mac","shortcut":"Meta+G"},{"platform":"windows,linux","shortcut":"Ctrl+G"},{"platform":"windows,linux","shortcut":"F3"}],"type":"action","actionId":"main.search-in-panel.find-next"},{"className":"Main.Main.SearchActionDelegate","bindings":[{"platform":"mac","shortcut":"Meta+Shift+G"},{"platform":"windows,linux","shortcut":"Ctrl+Shift+G"},{"platform":"windows,linux","shortcut":"Shift+F3"}],"type":"action","actionId":"main.search-in-panel.find-previous"},{"separator":true,"type":"@UI.ToolbarItem.Provider","location":"main-toolbar-left","order":100},{"separator":true,"type":"@UI.ToolbarItem.Provider","order":98,"location":"main-toolbar-right"},{"className":"Main.Main.MainMenuItem","type":"@UI.ToolbarItem.Provider","order":99,"location":"main-toolbar-right"},{"className":"Components.DockController.CloseButtonProvider","type":"@UI.ToolbarItem.Provider","order":100,"location":"main-toolbar-right"},{"category":"Appearance","title":"Theme:","defaultValue":"systemPreferred","tags":"dark, light","settingName":"uiTheme","settingType":"enum","type":"setting","options":[{"text":"System preference","value":"systemPreferred","title":"Switch to system preferred color theme"},{"text":"Light","value":"default","title":"Switch to light theme"},{"text":"Dark","value":"dark","title":"Switch to dark theme"}]},{"category":"Appearance","title":"Panel layout:","defaultValue":"auto","settingName":"sidebarPosition","settingType":"enum","type":"setting","options":[{"text":"horizontal","value":"bottom","title":"Use horizontal panel layout"},{"text":"vertical","value":"right","title":"Use vertical panel layout"},{"text":"auto","value":"auto","title":"Use automatic panel layout"}]},{"category":"Appearance","title":"Color format:","defaultValue":"original","settingName":"colorFormat","settingType":"enum","type":"setting","options":[{"text":"As authored","value":"original","title":"Set color format as authored"},{"raw":true,"text":"HEX: #dac0de","value":"hex","title":"Set color format to HEX"},{"raw":true,"text":"RGB: rgb(128, 255, 255)","value":"rgb","title":"Set color format to RGB"},{"raw":true,"text":"HSL: hsl(300, 80%, 90%)","value":"hsl","title":"Set color format to HSL"}]},{"category":"Appearance","title-mac":"Enable \u2318 + 1-9 shortcut to switch panels","title":"Enable Ctrl + 1-9 shortcut to switch panels","defaultValue":false,"settingName":"shortcutPanelSwitch","settingType":"boolean","type":"setting"},{"category":"Extensions","className":"Components.Linkifier.LinkHandlerSettingUI","type":"@UI.SettingUI"},{"category":"DevTools","defaultValue":"right","settingName":"currentDockState","settingType":"enum","type":"setting","options":[{"text":"Right","value":"right","title":"Dock to right"},{"text":"Bottom","value":"bottom","title":"Dock to bottom"},{"text":"Undocked","value":"undocked","title":"Undock into separate window"}]},{"category":"Drawer","className":"UI.InspectorView","type":"@UI.ViewLocationResolver","name":"drawer-view"},{"category":"Drawer sidebar","className":"UI.InspectorView","type":"@UI.ViewLocationResolver","name":"drawer-sidebar"},{"category":"Panel","className":"UI.InspectorView","type":"@UI.ViewLocationResolver","name":"panel"}],"name":"main"},{"dependencies":["bindings","workspace","components","sdk"],"extensions":[{"title":"Workspace","id":"workspace","className":"Persistence.WorkspaceSettingsTab","location":"settings-view","type":"view","order":1},{"category":"Persistence","title":"Enable Local Overrides","defaultValue":false,"tags":"interception, override, network, rewrite, request","settingName":"persistenceNetworkOverridesEnabled","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Enable override network requests"},{"value":false,"title":"Disable override network requests"}]},{"className":"Persistence.PersistenceActions.ContextMenuProvider","contextTypes":["Workspace.UISourceCode","SDK.Resource","SDK.NetworkRequest"],"type":"@UI.ContextMenu.Provider"}],"name":"persistence","modules":["persistence.js","PlatformFileSystem.js","IsolatedFileSystem.js","IsolatedFileSystemManager.js","FileSystemWorkspaceBinding.js","Automapping.js","NetworkPersistenceManager.js","PersistenceImpl.js","PersistenceActions.js","PersistenceUtils.js","EditFileSystemView.js","WorkspaceSettingsTab.js"]},{"dependencies":["ui"],"name":"inline_editor","scripts":["inline_editor_module.js"]},{"dependencies":["common","ui","sdk"],"extensions":[{"className":"ConsoleCounters.WarningErrorCounter","type":"@UI.ToolbarItem.Provider","order":1,"location":"main-toolbar-right"}],"name":"console_counters","modules":["console_counters.js","WarningErrorCounter.js"]},{"dependencies":["common","host","platform"],"modules":["workspace.js","FileManager.js","UISourceCode.js","WorkspaceImpl.js"],"name":"workspace","scripts":[]},{"dependencies":["ui","diff"],"extensions":[{"className":"QuickOpen.CommandMenuProvider","prefix":">","type":"@QuickOpen.FilteredListWidget.Provider","title":"Run command"},{"className":"QuickOpen.HelpQuickOpen","prefix":"?","type":"@QuickOpen.FilteredListWidget.Provider"},{"className":"QuickOpen.CommandMenu.ShowActionDelegate","bindings":[{"platform":"windows,linux","shortcut":"Ctrl+Shift+P"},{"platform":"mac","shortcut":"Meta+Shift+P"}],"type":"action","actionId":"commandMenu.show","title":"Run command"},{"type":"context-menu-item","location":"mainMenu/default","actionId":"commandMenu.show"},{"title":"Open file","className":"QuickOpen.QuickOpen.ShowActionDelegate","actionId":"quickOpen.show","bindings":[{"platform":"mac","shortcut":"Meta+P Meta+O"},{"platform":"windows,linux","shortcut":"Ctrl+P Ctrl+O"}],"type":"action","order":100},{"type":"context-menu-item","location":"mainMenu/default","actionId":"quickOpen.show"}],"name":"quick_open","scripts":["quick_open_module.js"]},{"dependencies":["components"],"name":"search","scripts":["search_module.js"]},{"dependencies":["ui"],"name":"data_grid","scripts":["data_grid_module.js"]},{"dependencies":["components","browser_sdk","common"],"modules":["extensions.js","ExtensionAPI.js","ExtensionTraceProvider.js","ExtensionServer.js","ExtensionPanel.js","ExtensionView.js"],"name":"extensions","scripts":[]},{"dependencies":["sdk","ui","source_frame","sources","data_grid"],"extensions":[{"title":"Coverage","order":100,"className":"Coverage.CoverageView","location":"drawer-view","type":"view","id":"coverage","persistence":"closeable"},{"className":"Coverage.CoverageView.LineDecorator","decoratorType":"coverage","type":"@SourceFrame.LineDecorator"},{"iconClass":"largeicon-start-recording","toggledIconClass":"largeicon-stop-recording","className":"Coverage.CoverageView.ActionDelegate","toggleWithRedColor":true,"actionId":"coverage.toggle-recording","toggleable":true,"category":"Performance","type":"action","options":[{"value":true,"title":"Instrument coverage"},{"value":false,"title":"Stop instrumenting coverage and show results"}]},{"iconClass":"largeicon-refresh","category":"Performance","title":"Start instrumenting coverage and reload page","className":"Coverage.CoverageView.ActionDelegate","actionId":"coverage.start-with-reload","type":"action"}],"name":"coverage","scripts":["coverage_module.js"]},{"dependencies":["common","host"],"modules":["services.js","ServiceManager.js"],"name":"services","scripts":[]},{"dependencies":["ui","common","components","sdk","object_ui"],"name":"event_listeners","scripts":["event_listeners_module.js"]},{"dependencies":["platform"],"modules":["DOMExtension.js"],"name":"dom_extension","scripts":[]},{"dependencies":["common","host","platform","protocol"],"extensions":[{"defaultValue":"","type":"setting","settingName":"skipStackFramesPattern","settingType":"regex"},{"defaultValue":false,"type":"setting","settingName":"skipContentScripts","settingType":"boolean"},{"category":"Console","title":"Preserve log upon navigation","defaultValue":false,"settingName":"preserveConsoleLog","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Preserve log upon navigation"},{"value":false,"title":"Do not preserve log upon navigation"}]},{"category":"Debugger","defaultValue":false,"settingName":"pauseOnExceptionEnabled","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Pause on exceptions"},{"value":false,"title":"Do not pause on exceptions"}]},{"defaultValue":false,"type":"setting","settingName":"pauseOnCaughtException","settingType":"boolean"},{"category":"Debugger","title":"Disable JavaScript","storageType":"session","defaultValue":false,"options":[{"value":true,"title":"Disable JavaScript"},{"value":false,"title":"Enable JavaScript"}],"settingName":"javaScriptDisabled","settingType":"boolean","type":"setting","order":1},{"category":"Debugger","title":"Disable async stack traces","defaultValue":false,"options":[{"value":true,"title":"Do not capture async stack traces"},{"value":false,"title":"Capture async stack traces"}],"settingName":"disableAsyncStackTraces","settingType":"boolean","type":"setting","order":2},{"category":"Debugger","storageType":"session","defaultValue":true,"settingName":"breakpointsActive","settingType":"boolean","type":"setting"},{"category":"Elements","title":"Show rulers","defaultValue":false,"settingName":"showMetricsRulers","settingType":"boolean","type":"setting"},{"category":"Rendering","storageType":"session","defaultValue":false,"settingName":"showPaintRects","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Show paint flashing rectangles"},{"value":false,"title":"Hide paint flashing rectangles"}]},{"category":"Rendering","storageType":"session","defaultValue":false,"settingName":"showLayoutShiftRegions","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Show layout shift regions"},{"value":false,"title":"Hide layout shift regions"}]},{"category":"Rendering","storageType":"session","defaultValue":false,"settingName":"showAdHighlights","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Highlight ad frames"},{"value":false,"title":"Do not highlight ad frames"}]},{"category":"Rendering","storageType":"session","defaultValue":false,"settingName":"showDebugBorders","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Show layer borders"},{"value":false,"title":"Hide layer borders"}]},{"category":"Rendering","storageType":"session","defaultValue":false,"settingName":"showFPSCounter","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Show frames per second (FPS) meter"},{"value":false,"title":"Hide frames per second (FPS) meter"}]},{"category":"Rendering","storageType":"session","defaultValue":false,"settingName":"showScrollBottleneckRects","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Show scroll performance bottlenecks"},{"value":false,"title":"Hide scroll performance bottlenecks"}]},{"category":"Rendering","storageType":"session","defaultValue":false,"settingName":"showHitTestBorders","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Show hit-test borders"},{"value":false,"title":"Hide hit-test borders"}]},{"category":"Rendering","tags":"query","storageType":"session","defaultValue":"","title":"Emulate CSS media type","settingName":"emulatedCSSMedia","settingType":"enum","type":"setting","options":[{"text":"No emulation","value":"","title":"Do not emulate CSS media type"},{"text":"print","value":"print","title":"Emulate CSS print media type"},{"text":"screen","value":"screen","title":"Emulate CSS screen media type"}]},{"category":"Rendering","tags":"query","storageType":"session","defaultValue":"","title":"Emulate CSS media feature prefers-color-scheme","settingName":"emulatedCSSMediaFeaturePrefersColorScheme","settingType":"enum","type":"setting","options":[{"text":"No emulation","value":"","title":"Do not emulate CSS prefers-color-scheme"},{"text":"prefers-color-scheme: light","value":"light","title":"Emulate CSS prefers-color-scheme: light"},{"text":"prefers-color-scheme: dark","value":"dark","title":"Emulate CSS prefers-color-scheme: dark"}]},{"category":"Rendering","tags":"query","storageType":"session","defaultValue":"","title":"Emulate CSS media feature prefers-reduced-motion","settingName":"emulatedCSSMediaFeaturePrefersReducedMotion","settingType":"enum","type":"setting","options":[{"text":"No emulation","value":"","title":"Do not emulate CSS prefers-reduced-motion"},{"text":"prefers-reduced-motion: reduce","value":"reduce","title":"Emulate CSS prefers-reduced-motion: reduce"}]},{"category":"Console","title":"Enable custom formatters","defaultValue":false,"settingName":"customFormatters","settingType":"boolean","type":"setting"},{"category":"Network","title":"Enable request blocking","storageType":"session","defaultValue":false,"settingName":"requestBlockingEnabled","settingType":"boolean","type":"setting","options":[{"value":true,"title":"Enable request blocking"},{"value":false,"title":"Disable request blocking"}]},{"category":"Network","title":"Disable cache (while DevTools is open)","defaultValue":false,"options":[{"value":true,"title":"Disable cache (while DevTools is open)"},{"value":false,"title":"Enable cache"}],"userActionCondition":"hasOtherClients","settingName":"cacheDisabled","settingType":"boolean","type":"setting","order":0}],"name":"sdk","scripts":[],"skip_compilation":["../SupportedCSSProperties.js"],"modules":["sdk.js","SDKModel.js","Target.js","TargetManager.js","Connections.js","CompilerSourceMappingContentProvider.js","CookieModel.js","CookieParser.js","ProfileTreeModel.js","ServerTiming.js","CPUProfileDataModel.js","CPUProfilerModel.js","CSSMatchedStyles.js","CSSMedia.js","CSSMetadata.js","CSSModel.js","CSSProperty.js","CSSRule.js","CSSStyleDeclaration.js","CSSStyleSheetHeader.js","ChildTargetManager.js","DOMDebuggerModel.js","DOMModel.js","DebuggerModel.js","EmulationModel.js","HARLog.js","LayerTreeBase.js","LogModel.js","ServiceWorkerManager.js","TracingManager.js","TracingModel.js","OverlayModel.js","RuntimeModel.js","IsolateManager.js","ScreenCaptureModel.js","Script.js","ServiceWorkerCacheModel.js","RemoteObject.js","Resource.js","ResourceTreeModel.js","SecurityOriginManager.js","SourceMap.js","SourceMapManager.js","NetworkManager.js","NetworkLog.js","NetworkRequest.js","PaintProfiler.js","HeapProfilerModel.js","PerformanceMetricsModel.js","../SupportedCSSProperties.js","FilmStripModel.js","ConsoleModel.js"]},{"dependencies":["common"],"name":"formatter","scripts":["formatter_module.js"]},{"dependencies":["components"],"extensions":[{"category":"Settings","title":"Settings","className":"Settings.SettingsScreen.ActionDelegate","actionId":"settings.show","bindings":[{"shortcut":"F1 Shift+?"}],"type":"action"},{"category":"Settings","className":"Settings.SettingsScreen.ActionDelegate","type":"action","actionId":"settings.documentation","title":"Documentation"},{"category":"Settings","className":"Settings.SettingsScreen.ActionDelegate","type":"action","actionId":"settings.shortcuts","title":"Shortcuts"},{"className":"Settings.SettingsScreen.Revealer","contextTypes":["Common.Setting"],"type":"@Common.Revealer"},{"type":"context-menu-item","location":"mainMenu/footer","actionId":"settings.shortcuts"},{"type":"context-menu-item","location":"mainMenuHelp/default","actionId":"settings.documentation"},{"type":"context-menu-item","location":"mainMenu/footer","actionId":"settings.show"},{"title":"Preferences","id":"preferences","className":"Settings.GenericSettingsTab","location":"settings-view","type":"view","order":0},{"title":"Experiments","id":"experiments","className":"Settings.ExperimentsSettingsTab","experiment":"*","location":"settings-view","type":"view","order":3},{"title":"Blackboxing","id":"blackbox","className":"Settings.FrameworkBlackboxSettingsTab","location":"settings-view","type":"view","order":4},{"category":"Settings","className":"Settings.SettingsScreen","type":"@UI.ViewLocationResolver","name":"settings-view"}],"name":"settings","scripts":["settings_module.js"]},{"dependencies":["ui","sdk"],"name":"color_picker","scripts":["color_picker_module.js"]},{"dependencies":["components","perf_ui","data_grid","heap_snapshot_model","object_ui"],"extensions":[{"title":"Memory","id":"heap_profiler","className":"Profiler.HeapProfilerPanel","location":"panel","type":"view","order":60},{"title":"Live Heap Profile","order":100,"className":"Profiler.LiveHeapProfileView","experiment":"liveHeapProfile","location":"drawer-view","type":"view","id":"live_heap_profile","persistence":"closeable"},{"className":"Profiler.HeapProfilerPanel","contextTypes":["SDK.RemoteObject"],"type":"@UI.ContextMenu.Provider"},{"category":"Performance","title":"High resolution CPU profiling","defaultValue":true,"settingName":"highResolutionCpuProfiling","settingType":"boolean","type":"setting"},{"category":"Performance","title":"Show native functions in JS Profile","defaultValue":true,"settingName":"showNativeFunctionsInJSProfile","settingType":"boolean","type":"setting"},{"iconClass":"largeicon-start-recording","toggledIconClass":"largeicon-stop-recording","className":"Profiler.LiveHeapProfileView.ActionDelegate","toggleWithRedColor":true,"actionId":"live-heap-profile.toggle-recording","toggleable":true,"category":"Performance","type":"action","options":[{"value":true,"title":"Start recording heap allocations"},{"value":false,"title":"Stop recording heap allocations"}]},{"iconClass":"largeicon-refresh","category":"Performance","title":"Start recording heap allocations and reload the page","className":"Profiler.LiveHeapProfileView.ActionDelegate","actionId":"live-heap-profile.start-with-reload","type":"action"},{"iconClass":"largeicon-start-recording","toggledIconClass":"largeicon-stop-recording","className":"Profiler.HeapProfilerPanel","toggleWithRedColor":true,"actionId":"profiler.heap-toggle-recording","toggleable":true,"contextTypes":["Profiler.HeapProfilerPanel"],"bindings":[{"platform":"windows,linux","shortcut":"Ctrl+E"},{"platform":"mac","shortcut":"Meta+E"}],"type":"action"},{"iconClass":"largeicon-start-recording","toggledIconClass":"largeicon-stop-recording","className":"Profiler.JSProfilerPanel","toggleWithRedColor":true,"actionId":"profiler.js-toggle-recording","toggleable":true,"contextTypes":["Profiler.JSProfilerPanel"],"bindings":[{"platform":"windows,linux","shortcut":"Ctrl+E"},{"platform":"mac","shortcut":"Meta+E"}],"type":"action"}],"name":"profiler","scripts":["profiler_module.js"]},{"dependencies":["platform","dom_extension","common","host"],"modules":["Action.js","ActionDelegate.js","ARIAUtils.js","ContextFlavorListener.js","ui.js","XElement.js","Widget.js","View.js","ViewManager.js","Treeoutline.js","InspectorView.js","ActionRegistry.js","ShortcutRegistry.js","Context.js","ContextMenu.js","GlassPane.js","Dialog.js","SyntaxHighlighter.js","DropTarget.js","EmptyWidget.js","FilterBar.js","FilterSuggestionBuilder.js","ForwardedInputEventHandler.js","Fragment.js","HistoryInput.js","Icon.js","Infobar.js","InplaceEditor.js","TextEditor.js","KeyboardShortcut.js","ListControl.js","ListModel.js","ListWidget.js","Panel.js","PopoverHelper.js","ProgressIndicator.js","ResizerWidget.js","RemoteDebuggingTerminatedScreen.js","ReportView.js","RootView.js","SearchableView.js","SegmentedButton.js","SettingsUI.js","SoftContextMenu.js","SoftDropDown.js","SplitWidget.js","TargetCrashedScreen.js","TextPrompt.js","ThrottledWidget.js","Toolbar.js","Tooltip.js","SuggestBox.js","TabbedPane.js","UIUtils.js","ZoomManager.js","ShortcutsScreen.js","Geometry.js","XLink.js","XWidget.js"],"name":"ui"},{"dependencies":["text_utils","platform"],"modules":["common.js","EventTarget.js","Object.js","Worker.js","TextDictionary.js","Color.js","Console.js","ContentProvider.js","ParsedURL.js","Progress.js","UIString.js","ResourceType.js","Settings.js","StaticContentProvider.js","SegmentedRange.js","Throttler.js","Trie.js","Revealer.js","App.js","AppProvider.js","JavaScriptMetaData.js","Linkifier.js","QueryParamHandler.js","Revealer.js","Runnable.js","StringOutputStream.js","CharacterIdMap.js"],"name":"common","scripts":[]},{"dependencies":["bindings","platform","ui"],"modules":["components.js","JSPresentationUtils.js","DockController.js","ImagePreview.js","Linkifier.js","Reload.js","TargetDetachedDialog.js"],"name":"components"},{"dependencies":["ui","sdk","components","formatter"],"extensions":[{"className":"ObjectUI.ObjectPropertiesSection.Renderer","contextTypes":["SDK.RemoteObject"],"type":"@UI.Renderer"}],"name":"object_ui","scripts":["object_ui_module.js"]},{"skip_compilation":["NativeFunctions.js"],"dependencies":["common"],"extensions":[{"className":"JavaScriptMetadata.JavaScriptMetadata","type":"@Common.JavaScriptMetadata"}],"name":"javascript_metadata","scripts":["javascript_metadata_module.js"]},{"dependencies":["workspace_diff","text_editor","workspace","diff","bindings","persistence","snippets","ui"],"extensions":[{"title":"Changes","className":"Changes.ChangesView","location":"drawer-view","type":"view","id":"changes.changes","persistence":"closeable"},{"className":"Changes.ChangesView.DiffUILocationRevealer","contextTypes":["WorkspaceDiff.DiffUILocation"],"destination":"Changes drawer","type":"@Common.Revealer"}],"name":"changes","scripts":["changes_module.js"]},{"dependencies":["platform"],"name":"text_utils"}]);Root.applicationDescriptor={"has_html":false,"modules":[{"name":"text_editor"},{"type":"autostart","name":"protocol"},{"name":"cm"},{"name":"data_grid"},{"name":"perf_ui"},{"name":"sources"},{"type":"autostart","name":"browser_sdk"},{"name":"diff"},{"type":"autostart","name":"bindings"},{"name":"snippets"},{"name":"heap_snapshot_model"},{"type":"autostart","name":"dom_extension"},{"name":"console"},{"name":"protocol_monitor"},{"name":"workspace_diff"},{"type":"remote","name":"cm_modes"},{"name":"event_listeners"},{"type":"autostart","name":"platform"},{"type":"autostart","name":"ui"},{"type":"autostart","name":"main"},{"type":"autostart","name":"persistence"},{"name":"inline_editor"},{"type":"autostart","name":"console_counters"},{"type":"autostart","name":"components"},{"name":"quick_open"},{"name":"color_picker"},{"name":"coverage"},{"name":"source_frame"},{"type":"autostart","name":"services"},{"type":"autostart","name":"product_registry"},{"type":"autostart","name":"sdk"},{"name":"search"},{"name":"formatter"},{"name":"settings"},{"type":"autostart","name":"host"},{"name":"profiler"},{"type":"autostart","name":"extensions"},{"type":"autostart","name":"common"},{"type":"autostart","name":"workspace"},{"name":"object_ui"},{"name":"javascript_metadata"},{"name":"changes"},{"type":"autostart","name":"text_utils"}]}
self['Platform']=self['Platform']||{};self['DomExtension']=self['DomExtension']||{};self['TextUtils']=self['TextUtils']||{};TextUtils.Text=class{constructor(value){this._value=value;}
lineEndings(){if(!this._lineEndings){this._lineEndings=this._value.computeLineEndings();}
return this._lineEndings;}
value(){return this._value;}
lineCount(){const lineEndings=this.lineEndings();return lineEndings.length;}
offsetFromPosition(lineNumber,columnNumber){return(lineNumber?this.lineEndings()[lineNumber-1]+1:0)+columnNumber;}
positionFromOffset(offset){const lineEndings=this.lineEndings();const lineNumber=lineEndings.lowerBound(offset);return{lineNumber:lineNumber,columnNumber:offset-(lineNumber&&(lineEndings[lineNumber-1]+1))};}
lineAt(lineNumber){const lineEndings=this.lineEndings();const lineStart=lineNumber>0?lineEndings[lineNumber-1]+1:0;const lineEnd=lineEndings[lineNumber];let lineContent=this._value.substring(lineStart,lineEnd);if(lineContent.length>0&&lineContent.charAt(lineContent.length-1)==='\r'){lineContent=lineContent.substring(0,lineContent.length-1);}
return lineContent;}
toSourceRange(range){const start=this.offsetFromPosition(range.startLine,range.startColumn);const end=this.offsetFromPosition(range.endLine,range.endColumn);return new TextUtils.SourceRange(start,end-start);}
toTextRange(sourceRange){const cursor=new TextUtils.TextCursor(this.lineEndings());const result=TextUtils.TextRange.createFromLocation(0,0);cursor.resetTo(sourceRange.offset);result.startLine=cursor.lineNumber();result.startColumn=cursor.columnNumber();cursor.advance(sourceRange.offset+sourceRange.length);result.endLine=cursor.lineNumber();result.endColumn=cursor.columnNumber();return result;}
replaceRange(range,replacement){const sourceRange=this.toSourceRange(range);return this._value.substring(0,sourceRange.offset)+replacement+
this._value.substring(sourceRange.offset+sourceRange.length);}
extract(range){const sourceRange=this.toSourceRange(range);return this._value.substr(sourceRange.offset,sourceRange.length);}};TextUtils.Text.Position;TextUtils.TextCursor=class{constructor(lineEndings){this._lineEndings=lineEndings;this._offset=0;this._lineNumber=0;this._columnNumber=0;}
advance(offset){this._offset=offset;while(this._lineNumber<this._lineEndings.length&&this._lineEndings[this._lineNumber]<this._offset){++this._lineNumber;}
this._columnNumber=this._lineNumber?this._offset-this._lineEndings[this._lineNumber-1]-1:this._offset;}
offset(){return this._offset;}
resetTo(offset){this._offset=offset;this._lineNumber=this._lineEndings.lowerBound(offset);this._columnNumber=this._lineNumber?this._offset-this._lineEndings[this._lineNumber-1]-1:this._offset;}
lineNumber(){return this._lineNumber;}
columnNumber(){return this._columnNumber;}};;TextUtils.TextUtils={isStopChar:function(char){return(char>' '&&char<'0')||(char>'9'&&char<'A')||(char>'Z'&&char<'_')||(char>'_'&&char<'a')||(char>'z'&&char<='~');},isWordChar:function(char){return!TextUtils.TextUtils.isStopChar(char)&&!TextUtils.TextUtils.isSpaceChar(char);},isSpaceChar:function(char){return TextUtils.TextUtils._SpaceCharRegex.test(char);},isWord:function(word){for(let i=0;i<word.length;++i){if(!TextUtils.TextUtils.isWordChar(word.charAt(i))){return false;}}
return true;},isOpeningBraceChar:function(char){return char==='('||char==='{';},isClosingBraceChar:function(char){return char===')'||char==='}';},isBraceChar:function(char){return TextUtils.TextUtils.isOpeningBraceChar(char)||TextUtils.TextUtils.isClosingBraceChar(char);},textToWords:function(text,isWordChar,wordCallback){let startWord=-1;for(let i=0;i<text.length;++i){if(!isWordChar(text.charAt(i))){if(startWord!==-1){wordCallback(text.substring(startWord,i));}
startWord=-1;}else if(startWord===-1){startWord=i;}}
if(startWord!==-1){wordCallback(text.substring(startWord));}},lineIndent:function(line){let indentation=0;while(indentation<line.length&&TextUtils.TextUtils.isSpaceChar(line.charAt(indentation))){++indentation;}
return line.substr(0,indentation);},isUpperCase:function(text){return text===text.toUpperCase();},isLowerCase:function(text){return text===text.toLowerCase();},splitStringByRegexes(text,regexes){const matches=[];const globalRegexes=[];for(let i=0;i<regexes.length;i++){const regex=regexes[i];if(!regex.global){globalRegexes.push(new RegExp(regex.source,regex.flags?regex.flags+'g':'g'));}else{globalRegexes.push(regex);}}
doSplit(text,0,0);return matches;function doSplit(text,regexIndex,startIndex){if(regexIndex>=globalRegexes.length){matches.push({value:text,position:startIndex,regexIndex:-1,captureGroups:[]});return;}
const regex=globalRegexes[regexIndex];let currentIndex=0;let result;regex.lastIndex=0;while((result=regex.exec(text))!==null){const stringBeforeMatch=text.substring(currentIndex,result.index);if(stringBeforeMatch){doSplit(stringBeforeMatch,regexIndex+1,startIndex+currentIndex);}
const match=result[0];matches.push({value:match,position:startIndex+result.index,regexIndex:regexIndex,captureGroups:result.slice(1)});currentIndex=result.index+match.length;}
const stringAfterMatches=text.substring(currentIndex);if(stringAfterMatches){doSplit(stringAfterMatches,regexIndex+1,startIndex+currentIndex);}}}};TextUtils.FilterParser=class{constructor(keys){this._keys=keys;}
static cloneFilter(filter){return{key:filter.key,text:filter.text,regex:filter.regex,negative:filter.negative};}
parse(query){const splitResult=TextUtils.TextUtils.splitStringByRegexes(query,[TextUtils.TextUtils._keyValueFilterRegex,TextUtils.TextUtils._regexFilterRegex,TextUtils.TextUtils._textFilterRegex]);const filters=[];for(let i=0;i<splitResult.length;i++){const regexIndex=splitResult[i].regexIndex;if(regexIndex===-1){continue;}
const result=splitResult[i].captureGroups;if(regexIndex===0){if(this._keys.indexOf((result[1]))!==-1){filters.push({key:result[1],text:result[2],negative:!!result[0]});}else{filters.push({text:result[1]+':'+result[2],negative:!!result[0]});}}else if(regexIndex===1){try{filters.push({regex:new RegExp(result[1],'i'),negative:!!result[0]});}catch(e){filters.push({text:'/'+result[1]+'/',negative:!!result[0]});}}else if(regexIndex===2){filters.push({text:result[1],negative:!!result[0]});}}
return filters;}};TextUtils.FilterParser.ParsedFilter;TextUtils.TextUtils._keyValueFilterRegex=/(?:^|\s)(\-)?([\w\-]+):([^\s]+)/;TextUtils.TextUtils._regexFilterRegex=/(?:^|\s)(\-)?\/([^\s]+)\//;TextUtils.TextUtils._textFilterRegex=/(?:^|\s)(\-)?([^\s]+)/;TextUtils.TextUtils._SpaceCharRegex=/\s/;TextUtils.TextUtils.Indent={TwoSpaces:'  ',FourSpaces:'    ',EightSpaces:'        ',TabCharacter:'\t'};TextUtils.TextUtils.BalancedJSONTokenizer=class{constructor(callback,findMultiple){this._callback=callback;this._index=0;this._balance=0;this._buffer='';this._findMultiple=findMultiple||false;this._closingDoubleQuoteRegex=/[^\\](?:\\\\)*"/g;}
write(chunk){this._buffer+=chunk;const lastIndex=this._buffer.length;const buffer=this._buffer;let index;for(index=this._index;index<lastIndex;++index){const character=buffer[index];if(character==='"'){this._closingDoubleQuoteRegex.lastIndex=index;if(!this._closingDoubleQuoteRegex.test(buffer)){break;}
index=this._closingDoubleQuoteRegex.lastIndex-1;}else if(character==='{'){++this._balance;}else if(character==='}'){--this._balance;if(this._balance<0){this._reportBalanced();return false;}
if(!this._balance){this._lastBalancedIndex=index+1;if(!this._findMultiple){break;}}}else if(character===']'&&!this._balance){this._reportBalanced();return false;}}
this._index=index;this._reportBalanced();return true;}
_reportBalanced(){if(!this._lastBalancedIndex){return;}
this._callback(this._buffer.slice(0,this._lastBalancedIndex));this._buffer=this._buffer.slice(this._lastBalancedIndex);this._index-=this._lastBalancedIndex;this._lastBalancedIndex=0;}
remainder(){return this._buffer;}};TextUtils.TokenizerFactory=function(){};TextUtils.TokenizerFactory.prototype={createTokenizer(mimeType){}};TextUtils.isMinified=function(text){const kMaxNonMinifiedLength=500;let linesToCheck=10;let lastPosition=0;do{let eolIndex=text.indexOf('\n',lastPosition);if(eolIndex<0){eolIndex=text.length;}
if(eolIndex-lastPosition>kMaxNonMinifiedLength&&text.substr(lastPosition,3)!=='//#'){return true;}
lastPosition=eolIndex+1;}while(--linesToCheck>=0&&lastPosition<text.length);linesToCheck=10;lastPosition=text.length;do{let eolIndex=text.lastIndexOf('\n',lastPosition);if(eolIndex<0){eolIndex=0;}
if(lastPosition-eolIndex>kMaxNonMinifiedLength&&text.substr(lastPosition,3)!=='//#'){return true;}
lastPosition=eolIndex-1;}while(--linesToCheck>=0&&lastPosition>0);return false;};;TextUtils.TextRange=class{constructor(startLine,startColumn,endLine,endColumn){this.startLine=startLine;this.startColumn=startColumn;this.endLine=endLine;this.endColumn=endColumn;}
static createFromLocation(line,column){return new TextUtils.TextRange(line,column,line,column);}
static fromObject(serializedTextRange){return new TextUtils.TextRange(serializedTextRange.startLine,serializedTextRange.startColumn,serializedTextRange.endLine,serializedTextRange.endColumn);}
static comparator(range1,range2){return range1.compareTo(range2);}
static fromEdit(oldRange,newText){let endLine=oldRange.startLine;let endColumn=oldRange.startColumn+newText.length;const lineEndings=newText.computeLineEndings();if(lineEndings.length>1){endLine=oldRange.startLine+lineEndings.length-1;const len=lineEndings.length;endColumn=lineEndings[len-1]-lineEndings[len-2]-1;}
return new TextUtils.TextRange(oldRange.startLine,oldRange.startColumn,endLine,endColumn);}
isEmpty(){return this.startLine===this.endLine&&this.startColumn===this.endColumn;}
immediatelyPrecedes(range){if(!range){return false;}
return this.endLine===range.startLine&&this.endColumn===range.startColumn;}
immediatelyFollows(range){if(!range){return false;}
return range.immediatelyPrecedes(this);}
follows(range){return(range.endLine===this.startLine&&range.endColumn<=this.startColumn)||range.endLine<this.startLine;}
get linesCount(){return this.endLine-this.startLine;}
collapseToEnd(){return new TextUtils.TextRange(this.endLine,this.endColumn,this.endLine,this.endColumn);}
collapseToStart(){return new TextUtils.TextRange(this.startLine,this.startColumn,this.startLine,this.startColumn);}
normalize(){if(this.startLine>this.endLine||(this.startLine===this.endLine&&this.startColumn>this.endColumn)){return new TextUtils.TextRange(this.endLine,this.endColumn,this.startLine,this.startColumn);}else{return this.clone();}}
clone(){return new TextUtils.TextRange(this.startLine,this.startColumn,this.endLine,this.endColumn);}
serializeToObject(){const serializedTextRange={};serializedTextRange.startLine=this.startLine;serializedTextRange.startColumn=this.startColumn;serializedTextRange.endLine=this.endLine;serializedTextRange.endColumn=this.endColumn;return serializedTextRange;}
compareTo(other){if(this.startLine>other.startLine){return 1;}
if(this.startLine<other.startLine){return-1;}
if(this.startColumn>other.startColumn){return 1;}
if(this.startColumn<other.startColumn){return-1;}
return 0;}
compareToPosition(lineNumber,columnNumber){if(lineNumber<this.startLine||(lineNumber===this.startLine&&columnNumber<this.startColumn)){return-1;}
if(lineNumber>this.endLine||(lineNumber===this.endLine&&columnNumber>this.endColumn)){return 1;}
return 0;}
equal(other){return this.startLine===other.startLine&&this.endLine===other.endLine&&this.startColumn===other.startColumn&&this.endColumn===other.endColumn;}
relativeTo(line,column){const relative=this.clone();if(this.startLine===line){relative.startColumn-=column;}
if(this.endLine===line){relative.endColumn-=column;}
relative.startLine-=line;relative.endLine-=line;return relative;}
relativeFrom(line,column){const relative=this.clone();if(this.startLine===0){relative.startColumn+=column;}
if(this.endLine===0){relative.endColumn+=column;}
relative.startLine+=line;relative.endLine+=line;return relative;}
rebaseAfterTextEdit(originalRange,editedRange){console.assert(originalRange.startLine===editedRange.startLine);console.assert(originalRange.startColumn===editedRange.startColumn);const rebase=this.clone();if(!this.follows(originalRange)){return rebase;}
const lineDelta=editedRange.endLine-originalRange.endLine;const columnDelta=editedRange.endColumn-originalRange.endColumn;rebase.startLine+=lineDelta;rebase.endLine+=lineDelta;if(rebase.startLine===editedRange.endLine){rebase.startColumn+=columnDelta;}
if(rebase.endLine===editedRange.endLine){rebase.endColumn+=columnDelta;}
return rebase;}
toString(){return JSON.stringify(this);}
containsLocation(lineNumber,columnNumber){if(this.startLine===this.endLine){return this.startLine===lineNumber&&this.startColumn<=columnNumber&&columnNumber<=this.endColumn;}
if(this.startLine===lineNumber){return this.startColumn<=columnNumber;}
if(this.endLine===lineNumber){return columnNumber<=this.endColumn;}
return this.startLine<lineNumber&&lineNumber<this.endLine;}};TextUtils.SourceRange=class{constructor(offset,length){this.offset=offset;this.length=length;}};TextUtils.SourceEdit=class{constructor(sourceURL,oldRange,newText){this.sourceURL=sourceURL;this.oldRange=oldRange;this.newText=newText;}
static comparator(edit1,edit2){return TextUtils.TextRange.comparator(edit1.oldRange,edit2.oldRange);}
newRange(){return TextUtils.TextRange.fromEdit(this.oldRange,this.newText);}};;self['Common']=self['Common']||{};self['Host']=self['Host']||{};self['UI']=self['UI']||{};self['Protocol']=self['Protocol']||{};self['SDK']=self['SDK']||{};self['Services']=self['Services']||{};self['Workspace']=self['Workspace']||{};self['Bindings']=self['Bindings']||{};self['Components']=self['Components']||{};self['Persistence']=self['Persistence']||{};self['BrowserSDK']=self['BrowserSDK']||{};self['Extensions']=self['Extensions']||{};self['ProductRegistry']=self['ProductRegistry']||{};ProductRegistry.BadgePool=class{constructor(forceShow){this._showTitles=false;this._badgeElements=new Map();if(!forceShow){this._setting=Common.settings.moduleSetting('product_registry.badges-visible');this._setting.addChangeListener(this._settingUpdated.bind(this));if(this._setting.get()){Host.userMetrics.actionTaken(Host.UserMetrics.Action.ShowedThirdPartyBadges);}}}
setShowTitles(value){this._showTitles=value;}
badgeForFrame(frame){return this._badgeForFrameOrUrl(this._resolveUrl.bind(this,frame));}
badgeForURL(parsedUrl){return this._badgeForFrameOrUrl(()=>Promise.resolve(parsedUrl));}
reset(){this._badgeElements.clear();}
_badgeForFrameOrUrl(urlResolver){const element=createElementWithClass('span','hidden');const root=UI.createShadowRootWithCoreStyles(element,'product_registry/badge.css');const badgeElement=root.createChild('span');badgeElement.classList.toggle('hide-badge-title',!this._showTitles);badgeElement.addEventListener('mousedown',event=>event.consume());badgeElement.addEventListener('click',event=>{this._showPopup(badgeElement);event.consume();},false);this._badgeElements.set(badgeElement,urlResolver);this._renderBadge(badgeElement);return element;}
async _resolveUrl(frame){const registry=await ProductRegistry.instance();let parsedUrl=new Common.ParsedURL(frame.url);const entry=registry.entryForUrl(parsedUrl);if(!entry){frame.findCreationCallFrame(callFrame=>{if(!callFrame.url){return false;}
parsedUrl=new Common.ParsedURL(callFrame.url);return!!registry.entryForUrl(parsedUrl);});}
return parsedUrl;}
async _renderBadge(badgeElement){if(badgeElement.children.length||!this._isVisible(badgeElement)){this._updateBadgeElementVisibility(badgeElement);return;}
const parsedUrl=await this._badgeElements.get(badgeElement)();const registry=await ProductRegistry.instance();const entryName=parsedUrl&&registry.nameForUrl(parsedUrl);if(!entryName){return;}
const tokens=entryName.replace(/[a-z]*/g,'').split(' ');let label;if(tokens.length>1){label=tokens[0][0]+tokens[1][0];}else{label=entryName;}
const iconElement=badgeElement.createChild('span','product-registry-badge monospace');iconElement.setAttribute('data-initial',label.substring(0,2).toUpperCase());iconElement.title=entryName;iconElement.style.backgroundColor=ProductRegistry.BadgePool.colorForEntryName(entryName);badgeElement.createChild('span','product-registry-badge-title').textContent=entryName;this._updateBadgeElementVisibility(badgeElement);}
_settingUpdated(){for(const badgeElement of this._badgeElements.keys()){this._renderBadge(badgeElement);}}
_isVisible(badgeElement){return!this._setting||this._setting.get();}
_updateBadgeElementVisibility(badgeElement){badgeElement.parentNodeOrShadowHost().parentNodeOrShadowHost().classList.toggle('hidden',!this._isVisible(badgeElement));}
async _showPopup(badgeElement){if(!this._badgeElements.has(badgeElement)){return;}
const registry=await ProductRegistry.instance();const parsedUrl=await this._badgeElements.get(badgeElement)();const entryName=registry.nameForUrl(parsedUrl);const element=createElement('div');const root=UI.createShadowRootWithCoreStyles(element,'product_registry/popup.css');const popupElement=root.createChild('div','product-registry-popup');const domainElement=popupElement.createChild('div','product-registry-domain');domainElement.textContent=parsedUrl.domain();const entryNameElement=popupElement.createChild('div','product-registry-name');entryNameElement.textContent=entryName;const reportLink='https://docs.google.com/forms/d/e/1FAIpQLSchz2FdcQ-rRllzl8BbhWaTRRY-12BpPjW6Hr9e1-BpCA083w/viewform'+'?entry_1425918171='+encodeURIComponent((parsedUrl.domain()+parsedUrl.path).substr(0,100));popupElement.appendChild(UI.XLink.create(reportLink,'Report mismatch','product-registry-link'));const dialog=new UI.Dialog();dialog.setContentAnchorBox(badgeElement.boxInWindow());dialog.contentElement.appendChild(element);dialog.setSizeBehavior(UI.GlassPane.SizeBehavior.MeasureContent);dialog.setAnchorBehavior(UI.GlassPane.AnchorBehavior.PreferTop);dialog.addCloseButton();dialog.show((badgeElement.ownerDocument));}
static colorForEntryName(entryName){if(!ProductRegistry.BadgePool._colorGenerator){ProductRegistry.BadgePool._colorGenerator=new Common.Color.Generator({min:30,max:330},{min:50,max:80,count:3},80);}
return ProductRegistry.BadgePool._colorGenerator.colorForID(entryName);}};;ProductRegistry.instance=function(){const extension=self.runtime.extension(ProductRegistry.Registry);if(extension){return extension.instance();}
return Promise.resolve((self.singleton(ProductRegistry.RegistryStub)));};ProductRegistry.Registry=class{nameForUrl(parsedUrl){}
entryForUrl(parsedUrl){}
typeForUrl(parsedUrl){}};ProductRegistry.RegistryStub=class{nameForUrl(parsedUrl){return null;}
entryForUrl(parsedUrl){return null;}
typeForUrl(parsedUrl){return null;}};ProductRegistry.Registry.ProductEntry;;self['Main']=self['Main']||{};Main.SimpleApp=class{presentUI(document){const rootView=new UI.RootView();UI.inspectorView.show(rootView.element);rootView.attachToDocument(document);rootView.focus();}};Main.SimpleAppProvider=class{createApp(){return new Main.SimpleApp();}};;Main.ExecutionContextSelector=class{constructor(targetManager,context){context.addFlavorChangeListener(SDK.ExecutionContext,this._executionContextChanged,this);context.addFlavorChangeListener(SDK.Target,this._targetChanged,this);targetManager.addModelListener(SDK.RuntimeModel,SDK.RuntimeModel.Events.ExecutionContextCreated,this._onExecutionContextCreated,this);targetManager.addModelListener(SDK.RuntimeModel,SDK.RuntimeModel.Events.ExecutionContextDestroyed,this._onExecutionContextDestroyed,this);targetManager.addModelListener(SDK.RuntimeModel,SDK.RuntimeModel.Events.ExecutionContextOrderChanged,this._onExecutionContextOrderChanged,this);this._targetManager=targetManager;this._context=context;targetManager.observeModels(SDK.RuntimeModel,this);}
modelAdded(runtimeModel){setImmediate(deferred.bind(this));function deferred(){if(!this._context.flavor(SDK.Target)){this._context.setFlavor(SDK.Target,runtimeModel.target());}}}
modelRemoved(runtimeModel){const currentExecutionContext=this._context.flavor(SDK.ExecutionContext);if(currentExecutionContext&&currentExecutionContext.runtimeModel===runtimeModel){this._currentExecutionContextGone();}
const models=this._targetManager.models(SDK.RuntimeModel);if(this._context.flavor(SDK.Target)===runtimeModel.target()&&models.length){this._context.setFlavor(SDK.Target,models[0].target());}}
_executionContextChanged(event){const newContext=(event.data);if(newContext){this._context.setFlavor(SDK.Target,newContext.target());if(!this._ignoreContextChanged){this._lastSelectedContextId=this._contextPersistentId(newContext);}}}
_contextPersistentId(executionContext){return executionContext.isDefault?executionContext.target().name()+':'+executionContext.frameId:'';}
_targetChanged(event){const newTarget=(event.data);const currentContext=this._context.flavor(SDK.ExecutionContext);if(!newTarget||(currentContext&&currentContext.target()===newTarget)){return;}
const runtimeModel=newTarget.model(SDK.RuntimeModel);const executionContexts=runtimeModel?runtimeModel.executionContexts():[];if(!executionContexts.length){return;}
let newContext=null;for(let i=0;i<executionContexts.length&&!newContext;++i){if(this._shouldSwitchToContext(executionContexts[i])){newContext=executionContexts[i];}}
for(let i=0;i<executionContexts.length&&!newContext;++i){if(this._isDefaultContext(executionContexts[i])){newContext=executionContexts[i];}}
this._ignoreContextChanged=true;this._context.setFlavor(SDK.ExecutionContext,newContext||executionContexts[0]);this._ignoreContextChanged=false;}
_shouldSwitchToContext(executionContext){if(this._lastSelectedContextId&&this._lastSelectedContextId===this._contextPersistentId(executionContext)){return true;}
if(!this._lastSelectedContextId&&this._isDefaultContext(executionContext)){return true;}
return false;}
_isDefaultContext(executionContext){if(!executionContext.isDefault||!executionContext.frameId){return false;}
if(executionContext.target().parentTarget()){return false;}
const resourceTreeModel=executionContext.target().model(SDK.ResourceTreeModel);const frame=resourceTreeModel&&resourceTreeModel.frameForId(executionContext.frameId);if(frame&&frame.isTopFrame()){return true;}
return false;}
_onExecutionContextCreated(event){this._switchContextIfNecessary((event.data));}
_onExecutionContextDestroyed(event){const executionContext=(event.data);if(this._context.flavor(SDK.ExecutionContext)===executionContext){this._currentExecutionContextGone();}}
_onExecutionContextOrderChanged(event){const runtimeModel=(event.data);const executionContexts=runtimeModel.executionContexts();for(let i=0;i<executionContexts.length;i++){if(this._switchContextIfNecessary(executionContexts[i])){break;}}}
_switchContextIfNecessary(executionContext){if(!this._context.flavor(SDK.ExecutionContext)||this._shouldSwitchToContext(executionContext)){this._ignoreContextChanged=true;this._context.setFlavor(SDK.ExecutionContext,executionContext);this._ignoreContextChanged=false;return true;}
return false;}
_currentExecutionContextGone(){const runtimeModels=this._targetManager.models(SDK.RuntimeModel);let newContext=null;for(let i=0;i<runtimeModels.length&&!newContext;++i){const executionContexts=runtimeModels[i].executionContexts();for(const executionContext of executionContexts){if(this._isDefaultContext(executionContext)){newContext=executionContext;break;}}}
if(!newContext){for(let i=0;i<runtimeModels.length&&!newContext;++i){const executionContexts=runtimeModels[i].executionContexts();if(executionContexts.length){newContext=executionContexts[0];break;}}}
this._ignoreContextChanged=true;this._context.setFlavor(SDK.ExecutionContext,newContext);this._ignoreContextChanged=false;}};;Main.Main=class{constructor(){Main.Main._instanceForTest=this;runOnWindowLoad(this._loaded.bind(this));}
static time(label){if(Host.isUnderTest()){return;}
console.time(label);}
static timeEnd(label){if(Host.isUnderTest()){return;}
console.timeEnd(label);}
async _loaded(){console.timeStamp('Main._loaded');await Root.Runtime.appStarted();Root.Runtime.setPlatform(Host.platform());Root.Runtime.setL10nCallback(ls);Host.InspectorFrontendHost.getPreferences(this._gotPreferences.bind(this));}
_gotPreferences(prefs){console.timeStamp('Main._gotPreferences');if(Host.isUnderTest(prefs)){self.runtime.useTestBase();}
this._createSettings(prefs);this._createAppUI();}
_createSettings(prefs){this._initializeExperiments();let storagePrefix='';if(Host.isCustomDevtoolsFrontend()){storagePrefix='__custom__';}else if(!Root.Runtime.queryParam('can_dock')&&!!Root.Runtime.queryParam('debugFrontend')&&!Host.isUnderTest()){storagePrefix='__bundled__';}
let localStorage;if(!Host.isUnderTest()&&window.localStorage){localStorage=new Common.SettingsStorage(window.localStorage,undefined,undefined,()=>window.localStorage.clear(),storagePrefix);}else{localStorage=new Common.SettingsStorage({},undefined,undefined,undefined,storagePrefix);}
const globalStorage=new Common.SettingsStorage(prefs,Host.InspectorFrontendHost.setPreference,Host.InspectorFrontendHost.removePreference,Host.InspectorFrontendHost.clearPreferences,storagePrefix);Common.settings=new Common.Settings(globalStorage,localStorage);if(!Host.isUnderTest()){new Common.VersionController().updateVersion();}}
_initializeExperiments(){Root.Runtime.experiments.register('applyCustomStylesheet','Allow custom UI themes');Root.Runtime.experiments.register('captureNodeCreationStacks','Capture node creation stacks');Root.Runtime.experiments.register('sourcesPrettyPrint','Automatically pretty print in the Sources Panel');Root.Runtime.experiments.register('backgroundServices','Background web platform feature events',true);Root.Runtime.experiments.register('backgroundServicesNotifications','Background services section for Notifications');Root.Runtime.experiments.register('backgroundServicesPaymentHandler','Background services section for Payment Handler');Root.Runtime.experiments.register('backgroundServicesPushMessaging','Background services section for Push Messaging');Root.Runtime.experiments.register('backgroundServicesPeriodicBackgroundSync','Background services section for Periodic Background Sync');Root.Runtime.experiments.register('blackboxJSFramesOnTimeline','Blackbox JavaScript frames on Timeline',true);Root.Runtime.experiments.register('cssOverview','CSS Overview');Root.Runtime.experiments.register('emptySourceMapAutoStepping','Empty sourcemap auto-stepping');Root.Runtime.experiments.register('inputEventsOnTimelineOverview','Input events on Timeline overview',true);Root.Runtime.experiments.register('liveHeapProfile','Live heap profile',true);Root.Runtime.experiments.register('mediaInspector','Media Element Inspection');Root.Runtime.experiments.register('nativeHeapProfiler','Native memory sampling heap profiler',true);Root.Runtime.experiments.register('protocolMonitor','Protocol Monitor');Root.Runtime.experiments.register('recordCoverageWithPerformanceTracing','Record coverage while performance tracing');Root.Runtime.experiments.register('samplingHeapProfilerTimeline','Sampling heap profiler timeline',true);Root.Runtime.experiments.register('sourceDiff','Source diff');Root.Runtime.experiments.register('splitInDrawer','Split in drawer',true);Root.Runtime.experiments.register('spotlight','Spotlight',true);Root.Runtime.experiments.register('timelineEventInitiators','Timeline: event initiators');Root.Runtime.experiments.register('timelineFlowEvents','Timeline: flow events',true);Root.Runtime.experiments.register('timelineInvalidationTracking','Timeline: invalidation tracking',true);Root.Runtime.experiments.register('timelineShowAllEvents','Timeline: show all events',true);Root.Runtime.experiments.register('timelineV8RuntimeCallStats','Timeline: V8 Runtime Call Stats on Timeline',true);Root.Runtime.experiments.register('timelineWebGL','Timeline: WebGL-based flamechart');Root.Runtime.experiments.cleanUpStaleExperiments();const enabledExperiments=Root.Runtime.queryParam('enabledExperiments');if(enabledExperiments){Root.Runtime.experiments.setServerEnabledExperiments(enabledExperiments.split(';'));}
Root.Runtime.experiments.setDefaultExperiments(['backgroundServices','backgroundServicesNotifications','backgroundServicesPushMessaging','backgroundServicesPaymentHandler',]);if(Host.isUnderTest()&&Root.Runtime.queryParam('test').includes('live-line-level-heap-profile.js')){Root.Runtime.experiments.enableForTest('liveHeapProfile');}}
async _createAppUI(){Main.Main.time('Main._createAppUI');UI.viewManager=new UI.ViewManager();Persistence.isolatedFileSystemManager=new Persistence.IsolatedFileSystemManager();const themeSetting=Common.settings.createSetting('uiTheme','systemPreferred');UI.initializeUIUtils(document,themeSetting);themeSetting.addChangeListener(Components.reload.bind(Components));UI.installComponentRootStyles((document.body));this._addMainEventListeners(document);const canDock=!!Root.Runtime.queryParam('can_dock');UI.zoomManager=new UI.ZoomManager(window,Host.InspectorFrontendHost);UI.inspectorView=UI.InspectorView.instance();UI.ContextMenu.initialize();UI.ContextMenu.installHandler(document);UI.Tooltip.installHandler(document);Components.dockController=new Components.DockController(canDock);SDK.consoleModel=new SDK.ConsoleModel();SDK.multitargetNetworkManager=new SDK.MultitargetNetworkManager();SDK.domDebuggerManager=new SDK.DOMDebuggerManager();SDK.targetManager.addEventListener(SDK.TargetManager.Events.SuspendStateChanged,this._onSuspendStateChanged.bind(this));UI.shortcutsScreen=new UI.ShortcutsScreen();UI.shortcutsScreen.section(Common.UIString('Elements Panel'));UI.shortcutsScreen.section(Common.UIString('Styles Pane'));UI.shortcutsScreen.section(Common.UIString('Debugger'));UI.shortcutsScreen.section(Common.UIString('Console'));Workspace.fileManager=new Workspace.FileManager();Workspace.workspace=new Workspace.Workspace();Bindings.networkProjectManager=new Bindings.NetworkProjectManager();Bindings.resourceMapping=new Bindings.ResourceMapping(SDK.targetManager,Workspace.workspace);new Bindings.PresentationConsoleMessageManager();Bindings.cssWorkspaceBinding=new Bindings.CSSWorkspaceBinding(SDK.targetManager,Workspace.workspace);Bindings.debuggerWorkspaceBinding=new Bindings.DebuggerWorkspaceBinding(SDK.targetManager,Workspace.workspace);Bindings.breakpointManager=new Bindings.BreakpointManager(Workspace.workspace,SDK.targetManager,Bindings.debuggerWorkspaceBinding);Extensions.extensionServer=new Extensions.ExtensionServer();new Persistence.FileSystemWorkspaceBinding(Persistence.isolatedFileSystemManager,Workspace.workspace);Persistence.persistence=new Persistence.Persistence(Workspace.workspace,Bindings.breakpointManager);Persistence.networkPersistenceManager=new Persistence.NetworkPersistenceManager(Workspace.workspace);new Main.ExecutionContextSelector(SDK.targetManager,UI.context);Bindings.blackboxManager=new Bindings.BlackboxManager(Bindings.debuggerWorkspaceBinding);new Main.Main.PauseListener();UI.actionRegistry=new UI.ActionRegistry();UI.shortcutRegistry=new UI.ShortcutRegistry(UI.actionRegistry,document);UI.ShortcutsScreen.registerShortcuts();this._registerForwardedShortcuts();this._registerMessageSinkListener();Main.Main.timeEnd('Main._createAppUI');this._showAppUI(await self.runtime.extension(Common.AppProvider).instance());}
_showAppUI(appProvider){Main.Main.time('Main._showAppUI');const app=(appProvider).createApp();Components.dockController.initialize();app.presentUI(document);const toggleSearchNodeAction=UI.actionRegistry.action('elements.toggle-element-search');if(toggleSearchNodeAction){Host.InspectorFrontendHost.events.addEventListener(Host.InspectorFrontendHostAPI.Events.EnterInspectElementMode,toggleSearchNodeAction.execute.bind(toggleSearchNodeAction),this);}
Host.InspectorFrontendHost.events.addEventListener(Host.InspectorFrontendHostAPI.Events.RevealSourceLine,this._revealSourceLine,this);UI.inspectorView.createToolbars();Host.InspectorFrontendHost.loadCompleted();const extensions=self.runtime.extensions(Common.QueryParamHandler);for(const extension of extensions){const value=Root.Runtime.queryParam(extension.descriptor()['name']);if(value!==null){extension.instance().then(handleQueryParam.bind(null,value));}}
function handleQueryParam(value,handler){handler.handleQueryParam(value);}
setTimeout(this._initializeTarget.bind(this),0);Main.Main.timeEnd('Main._showAppUI');}
async _initializeTarget(){Main.Main.time('Main._initializeTarget');const instances=await Promise.all(self.runtime.extensions('early-initialization').map(extension=>extension.instance()));for(const instance of instances){await(instance).run();}
Host.InspectorFrontendHost.readyForTest();setTimeout(this._lateInitialization.bind(this),100);Main.Main.timeEnd('Main._initializeTarget');}
_lateInitialization(){Main.Main.time('Main._lateInitialization');this._registerShortcuts();Extensions.extensionServer.initializeExtensions();const extensions=self.runtime.extensions('late-initialization');const promises=[];for(const extension of extensions){const setting=extension.descriptor()['setting'];if(!setting||Common.settings.moduleSetting(setting).get()){promises.push(extension.instance().then(instance=>((instance)).run()));continue;}
async function changeListener(event){if(!event.data){return;}
Common.settings.moduleSetting(setting).removeChangeListener(changeListener);((await extension.instance())).run();}
Common.settings.moduleSetting(setting).addChangeListener(changeListener);}
this._lateInitDonePromise=Promise.all(promises);Main.Main.timeEnd('Main._lateInitialization');}
lateInitDonePromiseForTest(){return this._lateInitDonePromise;}
_registerForwardedShortcuts(){const forwardedActions=['main.toggle-dock','debugger.toggle-breakpoints-active','debugger.toggle-pause','commandMenu.show','console.show'];const actionKeys=UI.shortcutRegistry.keysForActions(forwardedActions).map(UI.KeyboardShortcut.keyCodeAndModifiersFromKey);Host.InspectorFrontendHost.setWhitelistedShortcuts(JSON.stringify(actionKeys));}
_registerMessageSinkListener(){Common.console.addEventListener(Common.Console.Events.MessageAdded,messageAdded);function messageAdded(event){const message=(event.data);if(message.show){Common.console.show();}}}
_revealSourceLine(event){const url=(event.data['url']);const lineNumber=(event.data['lineNumber']);const columnNumber=(event.data['columnNumber']);const uiSourceCode=Workspace.workspace.uiSourceCodeForURL(url);if(uiSourceCode){Common.Revealer.reveal(uiSourceCode.uiLocation(lineNumber,columnNumber));return;}
function listener(event){const uiSourceCode=(event.data);if(uiSourceCode.url()===url){Common.Revealer.reveal(uiSourceCode.uiLocation(lineNumber,columnNumber));Workspace.workspace.removeEventListener(Workspace.Workspace.Events.UISourceCodeAdded,listener);}}
Workspace.workspace.addEventListener(Workspace.Workspace.Events.UISourceCodeAdded,listener);}
_registerShortcuts(){const shortcut=UI.KeyboardShortcut;const section=UI.shortcutsScreen.section(Common.UIString('All Panels'));let keys=[shortcut.makeDescriptor('[',shortcut.Modifiers.CtrlOrMeta),shortcut.makeDescriptor(']',shortcut.Modifiers.CtrlOrMeta)];section.addRelatedKeys(keys,Common.UIString('Go to the panel to the left/right'));const toggleConsoleLabel=Common.UIString('Show console');section.addKey(shortcut.makeDescriptor(shortcut.Keys.Tilde,shortcut.Modifiers.Ctrl),toggleConsoleLabel);section.addKey(shortcut.makeDescriptor(shortcut.Keys.Esc),Common.UIString('Toggle drawer'));if(Components.dockController.canDock()){section.addKey(shortcut.makeDescriptor('M',shortcut.Modifiers.CtrlOrMeta|shortcut.Modifiers.Shift),Common.UIString('Toggle device mode'));section.addKey(shortcut.makeDescriptor('D',shortcut.Modifiers.CtrlOrMeta|shortcut.Modifiers.Shift),Common.UIString('Toggle dock side'));}
section.addKey(shortcut.makeDescriptor('f',shortcut.Modifiers.CtrlOrMeta),Common.UIString('Search'));const advancedSearchShortcutModifier=Host.isMac()?UI.KeyboardShortcut.Modifiers.Meta|UI.KeyboardShortcut.Modifiers.Alt:UI.KeyboardShortcut.Modifiers.Ctrl|UI.KeyboardShortcut.Modifiers.Shift;const advancedSearchShortcut=shortcut.makeDescriptor('f',advancedSearchShortcutModifier);section.addKey(advancedSearchShortcut,Common.UIString('Search across all sources'));const inspectElementModeShortcuts=UI.shortcutRegistry.shortcutDescriptorsForAction('elements.toggle-element-search');if(inspectElementModeShortcuts.length){section.addKey(inspectElementModeShortcuts[0],Common.UIString('Select node to inspect'));}
const openResourceShortcut=UI.KeyboardShortcut.makeDescriptor('p',UI.KeyboardShortcut.Modifiers.CtrlOrMeta);section.addKey(openResourceShortcut,Common.UIString('Go to source'));if(Host.isMac()){keys=[shortcut.makeDescriptor('g',shortcut.Modifiers.Meta),shortcut.makeDescriptor('g',shortcut.Modifiers.Meta|shortcut.Modifiers.Shift)];section.addRelatedKeys(keys,Common.UIString('Find next/previous'));}}
_postDocumentKeyDown(event){if(!event.handled){UI.shortcutRegistry.handleShortcut(event);}}
_redispatchClipboardEvent(event){const eventCopy=new CustomEvent('clipboard-'+event.type,{bubbles:true});eventCopy['original']=event;const document=event.target&&event.target.ownerDocument;const target=document?document.deepActiveElement():null;if(target){target.dispatchEvent(eventCopy);}
if(eventCopy.handled){event.preventDefault();}}
_contextMenuEventFired(event){if(event.handled||event.target.classList.contains('popup-glasspane')){event.preventDefault();}}
_addMainEventListeners(document){document.addEventListener('keydown',this._postDocumentKeyDown.bind(this),false);document.addEventListener('beforecopy',this._redispatchClipboardEvent.bind(this),true);document.addEventListener('copy',this._redispatchClipboardEvent.bind(this),false);document.addEventListener('cut',this._redispatchClipboardEvent.bind(this),false);document.addEventListener('paste',this._redispatchClipboardEvent.bind(this),false);document.addEventListener('contextmenu',this._contextMenuEventFired.bind(this),true);}
_onSuspendStateChanged(){const suspended=SDK.targetManager.allTargetsSuspended();UI.inspectorView.onSuspendStateChanged(suspended);}};Main.Main.ZoomActionDelegate=class{handleAction(context,actionId){if(Host.InspectorFrontendHost.isHostedMode()){return false;}
switch(actionId){case'main.zoom-in':Host.InspectorFrontendHost.zoomIn();return true;case'main.zoom-out':Host.InspectorFrontendHost.zoomOut();return true;case'main.zoom-reset':Host.InspectorFrontendHost.resetZoom();return true;}
return false;}};Main.Main.SearchActionDelegate=class{handleAction(context,actionId){const searchableView=UI.SearchableView.fromElement(document.deepActiveElement())||UI.inspectorView.currentPanelDeprecated().searchableView();if(!searchableView){return false;}
switch(actionId){case'main.search-in-panel.find':return searchableView.handleFindShortcut();case'main.search-in-panel.cancel':return searchableView.handleCancelSearchShortcut();case'main.search-in-panel.find-next':return searchableView.handleFindNextShortcut();case'main.search-in-panel.find-previous':return searchableView.handleFindPreviousShortcut();}
return false;}};Main.Main.MainMenuItem=class{constructor(){this._item=new UI.ToolbarMenuButton(this._handleContextMenu.bind(this),true);this._item.setTitle(Common.UIString('Customize and control DevTools'));}
item(){return this._item;}
_handleContextMenu(contextMenu){if(Components.dockController.canDock()){const dockItemElement=createElementWithClass('div','flex-centered flex-auto');dockItemElement.tabIndex=-1;const titleElement=dockItemElement.createChild('span','flex-auto');titleElement.textContent=Common.UIString('Dock side');const toggleDockSideShorcuts=UI.shortcutRegistry.shortcutDescriptorsForAction('main.toggle-dock');titleElement.title=Common.UIString('Placement of DevTools relative to the page. (%s to restore last position)',toggleDockSideShorcuts[0].name);dockItemElement.appendChild(titleElement);const dockItemToolbar=new UI.Toolbar('',dockItemElement);if(Host.isMac()&&!UI.themeSupport.hasTheme()){dockItemToolbar.makeBlueOnHover();}
const undock=new UI.ToolbarToggle(Common.UIString('Undock into separate window'),'largeicon-undock');const bottom=new UI.ToolbarToggle(Common.UIString('Dock to bottom'),'largeicon-dock-to-bottom');const right=new UI.ToolbarToggle(Common.UIString('Dock to right'),'largeicon-dock-to-right');const left=new UI.ToolbarToggle(Common.UIString('Dock to left'),'largeicon-dock-to-left');undock.addEventListener(UI.ToolbarButton.Events.MouseDown,event=>event.data.consume());bottom.addEventListener(UI.ToolbarButton.Events.MouseDown,event=>event.data.consume());right.addEventListener(UI.ToolbarButton.Events.MouseDown,event=>event.data.consume());left.addEventListener(UI.ToolbarButton.Events.MouseDown,event=>event.data.consume());undock.addEventListener(UI.ToolbarButton.Events.Click,setDockSide.bind(null,Components.DockController.State.Undocked));bottom.addEventListener(UI.ToolbarButton.Events.Click,setDockSide.bind(null,Components.DockController.State.DockedToBottom));right.addEventListener(UI.ToolbarButton.Events.Click,setDockSide.bind(null,Components.DockController.State.DockedToRight));left.addEventListener(UI.ToolbarButton.Events.Click,setDockSide.bind(null,Components.DockController.State.DockedToLeft));undock.setToggled(Components.dockController.dockSide()===Components.DockController.State.Undocked);bottom.setToggled(Components.dockController.dockSide()===Components.DockController.State.DockedToBottom);right.setToggled(Components.dockController.dockSide()===Components.DockController.State.DockedToRight);left.setToggled(Components.dockController.dockSide()===Components.DockController.State.DockedToLeft);dockItemToolbar.appendToolbarItem(undock);dockItemToolbar.appendToolbarItem(left);dockItemToolbar.appendToolbarItem(bottom);dockItemToolbar.appendToolbarItem(right);dockItemElement.addEventListener('keydown',event=>{let dir=0;if(event.key==='ArrowLeft'){dir=-1;}else if(event.key==='ArrowRight'){dir=1;}else{return;}
const buttons=[undock,left,bottom,right];let index=buttons.findIndex(button=>button.element.hasFocus());index=Number.constrain(index+dir,0,buttons.length-1);buttons[index].element.focus();event.consume(true);});contextMenu.headerSection().appendCustomItem(dockItemElement);}
const button=this._item.element;function setDockSide(side){const hadKeyboardFocus=document.deepActiveElement().hasAttribute('data-keyboard-focus');Components.dockController.once(Components.DockController.Events.AfterDockSideChanged).then(()=>{button.focus();if(hadKeyboardFocus){UI.markAsFocusedByKeyboard(button);}});Components.dockController.setDockSide(side);contextMenu.discard();}
if(Components.dockController.dockSide()===Components.DockController.State.Undocked&&SDK.targetManager.mainTarget()&&SDK.targetManager.mainTarget().type()===SDK.Target.Type.Frame){contextMenu.defaultSection().appendAction('inspector_main.focus-debuggee',Common.UIString('Focus debuggee'));}
contextMenu.defaultSection().appendAction('main.toggle-drawer',UI.inspectorView.drawerVisible()?Common.UIString('Hide console drawer'):Common.UIString('Show console drawer'));contextMenu.appendItemsAtLocation('mainMenu');const moreTools=contextMenu.defaultSection().appendSubMenuItem(Common.UIString('More tools'));const extensions=self.runtime.extensions('view',undefined,true);for(const extension of extensions){const descriptor=extension.descriptor();if(descriptor['persistence']!=='closeable'){continue;}
if(descriptor['location']!=='drawer-view'&&descriptor['location']!=='panel'){continue;}
moreTools.defaultSection().appendItem(extension.title(),UI.viewManager.showView.bind(UI.viewManager,descriptor['id']));}
const helpSubMenu=contextMenu.footerSection().appendSubMenuItem(Common.UIString('Help'));helpSubMenu.appendItemsAtLocation('mainMenuHelp');}};Main.Main.PauseListener=class{constructor(){SDK.targetManager.addModelListener(SDK.DebuggerModel,SDK.DebuggerModel.Events.DebuggerPaused,this._debuggerPaused,this);}
_debuggerPaused(event){SDK.targetManager.removeModelListener(SDK.DebuggerModel,SDK.DebuggerModel.Events.DebuggerPaused,this._debuggerPaused,this);const debuggerModel=(event.data);const debuggerPausedDetails=debuggerModel.debuggerPausedDetails();UI.context.setFlavor(SDK.Target,debuggerModel.target());Common.Revealer.reveal(debuggerPausedDetails);}};Main.sendOverProtocol=function(method,params){return new Promise((resolve,reject)=>{Protocol.test.sendRawMessage(method,params,(err,...results)=>{if(err){return reject(err);}
return resolve(results);});});};Main.ReloadActionDelegate=class{handleAction(context,actionId){switch(actionId){case'main.debug-reload':Components.reload();return true;}
return false;}};new Main.Main();;self['ConsoleCounters']=self['ConsoleCounters']||{};;Root.Runtime.cachedResources["ui/checkboxTextLabel.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n    padding: 0;\n    margin: 0;\n    display: inline-flex;\n    flex-shrink: 0;\n    align-items: center !important;\n}\n\ninput {\n    height: 12px;\n    width: 12px;\n    flex-shrink: 0;\n}\n\ninput:focus {\n    outline: auto 5px -webkit-focus-ring-color;\n}\n\ninput.dt-checkbox-themed {\n    -webkit-appearance: none;\n    margin: auto 5px auto 2px;\n    border: 1px solid rgb(45, 45, 45);\n    border-radius: 3px;\n    background-color: rgb(102, 102, 102);\n}\n\ninput.dt-checkbox-themed:after {\n    content: '';\n    line-height: 10px;\n    position: absolute;\n    cursor: pointer;\n    width: 12px;\n    height: 12px;\n    background: none;\n}\n\ninput.dt-checkbox-themed:checked:after {\n    background-color: #333;\n}\n\ninput.dt-checkbox-themed:after {\n    -webkit-mask-image: url(Images/checkboxCheckmark.svg);\n    -webkit-mask-size: 11px 11px;\n    -webkit-mask-position: 0 0;\n}\n\n:host-context(.-theme-with-dark-background) input:not(.dt-checkbox-themed) {\n    filter: invert(80%);\n}\n\n.dt-checkbox-text {\n    margin-left: 3px;\n    overflow: hidden;\n    text-overflow: ellipsis;\n}\n\n.dt-checkbox-subtitle {\n    color: gray;\n}\n\n/*# sourceURL=ui/checkboxTextLabel.css */";Root.Runtime.cachedResources["ui/closeButton.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.close-button {\n    width: 14px;\n    height: 14px;\n    cursor: default;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n\n.hover-icon, .active-icon {\n    display: none;\n}\n\n.close-button:hover .default-icon, .close-button:active .default-icon {\n    display: none;\n}\n\n.close-button:hover .hover-icon {\n    display: block;\n}\n\n.close-button[data-keyboard-focus=\"true\"]:focus .default-icon, .close-button:active .default-icon {\n    display: none;\n}\n\n.close-button[data-keyboard-focus=\"true\"]:focus .hover-icon {\n    display: block;\n}\n\n.close-button:active .hover-icon {\n    display: none !important;\n}\n\n.close-button:active .active-icon {\n    display: block;\n}\n\n/*# sourceURL=ui/closeButton.css */";Root.Runtime.cachedResources["ui/confirmDialog.css"]="/*\n * Copyright (c) 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.widget {\n    padding: 20px;\n}\n\n.message, .button {\n    font-size: larger;\n    white-space: pre;\n    margin: 5px;\n}\n\n.button {\n    text-align: center;\n    margin-top: 10px;\n}\n\n.button button {\n    min-width: 80px;\n}\n\n.reason {\n    color: #8b0000;\n}\n\n/*# sourceURL=ui/confirmDialog.css */";Root.Runtime.cachedResources["ui/dialog.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.widget {\n    box-shadow: var(--drop-shadow);\n    background: white;\n    justify-content: flex-start;\n    align-items: stretch;\n    display: flex;\n}\n\n.dialog-close-button {\n    position: absolute;\n    right: 9px;\n    top: 9px;\n    z-index: 1;\n}\n/*# sourceURL=ui/dialog.css */";Root.Runtime.cachedResources["ui/dropTarget.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n    position: absolute;\n    top: 0;\n    bottom: 0;\n    left: 0;\n    right: 0;\n    display: flex;\n    background-color: rgba(255,255,255,0.8);\n    z-index: 1000;\n}\n\n.drop-target-message {\n    flex: auto;\n    font-size: 30px;\n    color: #999;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    margin: 20px;\n    border: 4px dashed #ddd;\n    pointer-events: none;\n}\n\n/*# sourceURL=ui/dropTarget.css */";Root.Runtime.cachedResources["ui/emptyWidget.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n .empty-bold-text {\n    display: block;\n    font-size: 1.5em;\n    margin: .83em 0 .83em;\n    font-weight: bold;\n }\n\n.empty-view {\n    color: hsla(0, 0%, 43%, 1);\n    padding: 30px;\n    display: flex;\n    align-items: center;\n    flex-direction: column;\n    min-width: 70px;\n}\n\n.empty-view-scroller {\n    justify-content: center;\n    overflow: auto;\n}\n\n.empty-view p {\n    white-space: initial;\n    line-height: 18px;\n    max-width: 300px;\n    flex-shrink: 0;\n}\n\n/*# sourceURL=ui/emptyWidget.css */";Root.Runtime.cachedResources["ui/filter.css"]="/*\n * Copyright (C) 2013 Google Inc. All rights reserved.\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions are\n * met:\n *\n *     * Redistributions of source code must retain the above copyright\n * notice, this list of conditions and the following disclaimer.\n *     * Redistributions in binary form must reproduce the above\n * copyright notice, this list of conditions and the following disclaimer\n * in the documentation and/or other materials provided with the\n * distribution.\n *     * Neither the name of Google Inc. nor the names of its\n * contributors may be used to endorse or promote products derived from\n * this software without specific prior written permission.\n *\n * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n * \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n\n.filter-bar {\n    background-color: var(--toolbar-bg-color);\n    flex: none;\n    flex-wrap: wrap;\n    align-items: center;\n    border-bottom: var(--divider-border);\n}\n\n.filter-text-filter {\n    display: inline-flex;\n    margin-left: 1px;\n    margin-right: 2px;\n    min-width: 40px;\n    max-width: 200px;\n    height: 24px;\n    align-items: center;\n}\n\n.filter-bitset-filter {\n    padding: 2px;\n    display: inline-flex;\n    overflow: hidden;\n    height: 24px;\n    position: relative;\n    margin: 0;\n}\n\n.filter-bitset-filter span {\n    display: inline-block;\n    flex: none;\n    margin: auto 2px;\n    padding: 3px;\n    background: transparent;\n    text-shadow: rgba(255, 255, 255, 0.5) 0 1px 0;\n    border-radius: 6px;\n    overflow: hidden;\n}\n\n.filter-bitset-filter span[data-keyboard-focus=\"true\"] {\n    outline: -webkit-focus-ring-color auto 5px;\n}\n\n.filter-bitset-filter-divider {\n    background-color: #ccc;\n    height: 16px;\n    width: 1px;\n    margin: auto 2px;\n    display: inline-block;\n}\n\n.filter-bitset-filter span.selected,\n.filter-bitset-filter span:hover,\n.filter-bitset-filter span:active {\n    color: white;\n    text-shadow: rgba(0, 0, 0, 0.4) 0 1px 0;\n}\n\n.filter-bitset-filter span:hover {\n    background: rgba(0, 0, 0, 0.2);\n}\n\n.filter-bitset-filter span.selected {\n    background: rgba(0, 0, 0, 0.3);\n}\n\n.filter-bitset-filter span:active {\n    background: rgba(0, 0, 0, 0.5);\n}\n\n.filter-checkbox-filter {\n    padding-left: 4px;\n    padding-right: 2px;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    overflow: hidden;\n    display: inline-flex;\n    vertical-align: middle;\n    height: 24px;\n    position: relative;\n}\n\n.filter-checkbox-filter > [is=dt-checkbox] {\n    display: flex;\n    margin: auto 0;\n}\n\n.filter-input-field {\n    margin: 0 3px;\n    padding-left: 3px;\n    width: 163px;\n    height: 18px;\n    line-height: 20px;\n    display: inline-block;\n    background: #FFF;\n    overflow: hidden;\n    white-space: nowrap;\n    cursor: auto;\n}\n\n.filter-input-field:hover {\n    box-shadow: var(--focus-ring-inactive-shadow);\n}\n\n.filter-input-field:focus,\n.filter-input-field:not(:empty) {\n    box-shadow: var(--focus-ring-active-shadow);\n}\n\n/*# sourceURL=ui/filter.css */";Root.Runtime.cachedResources["ui/glassPane.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n    position: absolute !important;\n    top: 0;\n    bottom: 0;\n    left: 0;\n    right: 0;\n    overflow: hidden;\n    contain: strict;\n    background-color: transparent;\n}\n\n:host-context(.dimmed-pane) {\n    background-color: rgba(255, 255, 255, 0.5);\n}\n\n:host-context(.no-pointer-events) {\n    pointer-events: none;\n}\n\n.widget {\n    display: flex;\n    background-color: transparent;\n    pointer-events: auto;\n    flex: none;\n}\n\n.no-pointer-events {\n    pointer-events: none;\n}\n\n.arrow-top {\n    margin-top: -19px;\n    margin-left: -9px;\n}\n\n.arrow-bottom {\n    margin-left: -9px;\n}\n\n.arrow-left {\n    margin-left: -19px;\n    margin-top: -9px;\n}\n\n.arrow-right {\n    margin-top: -9px;\n}\n\n.arrow-none {\n    display: none;\n}\n\n:host-context(.-theme-with-dark-background) .arrow {\n    -webkit-filter: invert(80%);\n}\n\n/*# sourceURL=ui/glassPane.css */";Root.Runtime.cachedResources["ui/infobar.css"]="/*\n * Copyright 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.infobar {\n    color: rgb(34, 34, 34);\n    display: flex;\n    flex: auto;\n    border-bottom: 1px solid rgb(171, 171, 171);\n    flex-direction: column;\n    align-items: stretch;\n    position: relative;\n}\n\n.infobar-warning {\n    background-color: rgb(253, 242, 192);\n}\n\n.infobar-info {\n    background-color: rgb(255, 255, 255);\n}\n\n.infobar-main-row {\n    display: flex;\n    flex-direction: row;\n    flex: auto;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n    justify-content: space-between;\n    margin-right: 20px;\n    min-height: 25px;\n    align-items: center;\n    padding-left: 4px;\n}\n\n.infobar-main-row > * {\n    flex: none;\n    padding: 0 3px;\n}\n\n.infobar-main-title {\n    flex: auto;\n    overflow: hidden;\n    text-overflow: ellipsis;\n}\n\n.infobar-details-rows {\n    padding: 5px 5px 0 5px;\n}\n\n.infobar-details-row {\n    display: flex;\n    flex-direction: column;\n    line-height: 18px;\n    padding-bottom: 6px;\n}\n\n.close-button {\n    position: absolute;\n    top: 5px;\n    right: 6px;\n}\n\n.infobar-toggle {\n    color: hsl(214, 92%, 50%);\n    cursor: pointer;\n    margin-top: 5px;\n    margin-bottom: 5px;\n}\n\n.infobar-toggle:hover {\n    color: hsl(214, 92%, 30%);\n}\n\n.info-icon {\n    -webkit-mask-image: url(Images/ic_info_black_18dp.svg);\n    background-color: hsl(214, 92%, 50%);\n}\n\n.warning-icon {\n    -webkit-mask-image: url(Images/ic_warning_black_18dp.svg);\n    background-color: hsl(44, 92%, 50%);\n}\n\n.icon {\n    -webkit-mask-size: 18px 18px;\n    width: 18px;\n    height: 19px;\n}\n\n/*# sourceURL=ui/infobar.css */";Root.Runtime.cachedResources["ui/inlineButton.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n  display: inline-block;\n  border: 1px solid #ddd;\n  position: relative;\n  top: 7px;\n  margin: 2px;\n  background-color: var(--toolbar-bg-color);\n}\n\n:host > * {\n  position: relative;\n  left: -2px;\n  width: 28px;\n  height: 26px;\n}\n/*# sourceURL=ui/inlineButton.css */";Root.Runtime.cachedResources["ui/inspectorCommon.css"]="/*\n * Copyright 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n* {\n    /* This is required for correct sizing of flex items because we rely\n     * on an old version of the flexbox spec.\n     * Longer-term we should remove this, see crbug.com/473625 */\n    min-width: 0;\n    min-height: 0;\n}\n\n:host-context(.platform-mac) .monospace,\n:host-context(.platform-mac) .source-code,\n.platform-mac .monospace,\n.platform-mac .source-code {\n    font-size: 11px !important;\n    font-family: Menlo, monospace;\n}\n\n:host-context(.platform-windows) .monospace,\n:host-context(.platform-windows) .source-code,\n.platform-windows .monospace,\n.platform-windows .source-code {\n    font-size: 12px !important;\n    font-family: Consolas, Lucida Console, Courier New, monospace;\n}\n\n:host-context(.platform-linux) .monospace,\n:host-context(.platform-linux) .source-code,\n.platform-linux .monospace,\n.platform-linux .source-code {\n    font-size: 11px !important;\n    font-family: dejavu sans mono, monospace;\n}\n\n.source-code {\n    font-family: monospace;\n    font-size: 11px !important;\n    white-space: pre-wrap;\n}\n\n* {\n    box-sizing: border-box;\n}\n\n:focus {\n    outline-width: 0;\n}\n\ninput[type=radio]:focus {\n    outline: auto 5px -webkit-focus-ring-color;\n}\n\nimg {\n    -webkit-user-drag: none;\n}\n\niframe,\na img {\n    border: none;\n}\n\n.fill {\n    position: absolute;\n    top: 0;\n    left: 0;\n    right: 0;\n    bottom: 0;\n}\n\niframe.fill {\n    width: 100%;\n    height: 100%;\n}\n\n.widget {\n    position: relative;\n    flex: auto;\n    contain: style;\n}\n\n.hbox {\n    display: flex;\n    flex-direction: row !important;\n    position: relative;\n}\n\n.vbox {\n    display: flex;\n    flex-direction: column !important;\n    position: relative;\n}\n\n.view-container > .toolbar {\n    border-bottom: 1px solid #eee;\n}\n\n.flex-auto {\n    flex: auto;\n}\n\n.flex-none {\n    flex: none;\n}\n\n.flex-centered {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n\n.overflow-auto {\n    overflow: auto;\n}\n\niframe.widget {\n    position: absolute;\n    width: 100%;\n    height: 100%;\n    left: 0;\n    right: 0;\n    top: 0;\n    bottom: 0;\n}\n\n.hidden {\n    display: none !important;\n}\n\n.monospace {\n    font-size: 10px !important;\n    font-family: monospace;\n}\n\n.highlighted-search-result {\n    border-radius: 1px;\n    background-color: rgba(255, 255, 0, 0.8);\n    outline: 1px solid rgba(255, 255, 0, 0.8);\n}\n\n.-theme-with-dark-background .highlighted-search-result,\n:host-context(.-theme-with-dark-background) .highlighted-search-result {\n    background-color: hsl(133, 100%, 30%);\n    color: #333;\n}\n\n.link {\n    cursor: pointer;\n    text-decoration: underline;\n    color: rgb(17, 85, 204);\n}\n\nbutton,\ninput,\nselect {\n    /* Form elements do not automatically inherit font style from ancestors. */\n    font-family: inherit;\n    font-size: inherit;\n}\n\ninput {\n    background-color: white;\n    color: inherit;\n}\n\ninput::placeholder {\n    color: rgba(0, 0, 0, 0.54);\n}\n\n:host-context(.-theme-with-dark-background) input[type=\"checkbox\"]:not(.-theme-preserve) {\n    -webkit-filter: invert(80%);\n}\n\n.harmony-input:not([type]),\n.harmony-input[type=number],\n.harmony-input[type=text] {\n    padding: 3px 6px;\n    height: 24px;\n    border: none;\n}\n\n.harmony-input:not([type]):not(.error-input):not(:invalid):hover,\n.harmony-input[type=number]:not(.error-input):not(:invalid):hover,\n.harmony-input[type=text]:not(.error-input):not(:invalid):hover {\n    box-shadow: var(--focus-ring-inactive-shadow);\n}\n\n.harmony-input:not([type]):not(.error-input):not(:invalid):focus,\n.harmony-input[type=number]:not(.error-input):not(:invalid):focus,\n.harmony-input[type=text]:not(.error-input):not(:invalid):focus {\n    box-shadow: var(--focus-ring-active-shadow);\n}\n\n.highlighted-search-result.current-search-result {\n    border-radius: 1px;\n    padding: 1px;\n    margin: -1px;\n    background-color: rgba(255, 127, 0, 0.8);\n}\n\n.dimmed {\n    opacity: 0.6;\n}\n\n.editing {\n    box-shadow: var(--drop-shadow);\n    background-color: white;\n    text-overflow: clip !important;\n    padding-left: 2px;\n    margin-left: -2px;\n    padding-right: 2px;\n    margin-right: -2px;\n    margin-bottom: -1px;\n    padding-bottom: 1px;\n    opacity: 1.0 !important;\n}\n\n.editing,\n.editing * {\n    color: #222 !important;\n    text-decoration: none !important;\n}\n\n.harmony-input:not([type]).error-input,\n.harmony-input[type=number].error-input,\n.harmony-input[type=text].error-input,\n.harmony-input:not([type]):invalid,\n.harmony-input[type=number]:invalid,\n.harmony-input[type=text]:invalid {\n    box-shadow: 0 0 0 1px #ff1a00;\n}\n\n.chrome-select {\n    -webkit-appearance: none;\n    -webkit-user-select: none;\n    border: 1px solid rgba(0, 0, 0, 0.2);\n    border-radius: 2px;\n    color: #333;\n    font: inherit;\n    margin: 0;\n    outline: none;\n    padding-right: 20px;\n    padding-left: 6px;\n    background-image: -webkit-image-set(url(Images/chromeSelect.png) 1x, url(Images/chromeSelect_2x.png) 2x);\n    background-color: hsl(0, 0%, 98%);\n    background-position: right center;\n    background-repeat: no-repeat;\n    min-height: 24px;\n    min-width: 80px;\n    background-size: 15px;\n}\n\n.chrome-select:enabled:active,\n.chrome-select:enabled:focus,\n.chrome-select:enabled:hover {\n    background-color: hsl(0, 0%, 96%);\n    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);\n}\n\n.chrome-select:enabled:active {\n    background-color: #f2f2f2;\n}\n\n.chrome-select:enabled:focus {\n    border-color: transparent;\n    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1), 0 0 0 2px rgba(66, 133, 244, 0.4);\n}\n\n.chrome-select:disabled {\n    opacity: 0.38;\n}\n\n.chrome-select-label {\n  margin: 0px 22px;\n  flex: none;\n}\n\n.chrome-select-label p {\n  margin-top: 0;\n  color: gray;\n}\n\n.chrome-select optgroup,\n.chrome-select option {\n    background-color: #EEEEEE;\n    color: #222;\n}\n\n:not(.platform-mac).-theme-with-dark-background ::-webkit-scrollbar,\n:host-context(:not(.platform-mac).-theme-with-dark-background) ::-webkit-scrollbar {\n    width: 14px;\n    height: 14px;\n}\n\n:not(.platform-mac).-theme-with-dark-background ::-webkit-scrollbar-track,\n:host-context(:not(.platform-mac).-theme-with-dark-background) ::-webkit-scrollbar-track {\n    -webkit-box-shadow: inset 0 0 1px rgba(255,255,255,0.3);\n}\n\n:not(.platform-mac).-theme-with-dark-background ::-webkit-scrollbar-thumb,\n:host-context(:not(.platform-mac).-theme-with-dark-background) ::-webkit-scrollbar-thumb {\n    border-radius: 2px;\n    background-color: #333;\n    -webkit-box-shadow: inset 0 0 1px rgba(255,255,255,0.5);\n}\n\n:not(.platform-mac).-theme-with-dark-background ::-webkit-scrollbar-corner,\n:host-context(:not(.platform-mac).-theme-with-dark-background) ::-webkit-scrollbar-corner {\n    background-color: #242424;\n}\n\n.gray-info-message {\n    text-align: center;\n    font-style: italic;\n    padding: 6px;\n    color: #888;\n    white-space: nowrap;\n}\n\nspan[is=dt-icon-label] {\n    flex: none;\n}\n\n.full-widget-dimmed-banner a {\n    color: inherit;\n}\n\n.full-widget-dimmed-banner {\n    color: #777;\n    background-color: white;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    text-align: center;\n    padding: 20px;\n    position: absolute;\n    top: 0;\n    right: 0;\n    bottom: 0;\n    left: 0;\n    font-size: 13px;\n    overflow: auto;\n    z-index: 500;\n}\n\n[is=ui-icon] {\n    display: inline-block;\n    flex-shrink: 0;\n}\n\n.-theme-with-dark-background [is=ui-icon].icon-invert,\n:host-context(.-theme-with-dark-background) [is=ui-icon].icon-invert {\n    filter: invert(80%) hue-rotate(180deg);\n}\n\n[is=ui-icon].icon-mask {\n    background-color: rgb(110, 110, 110);\n    -webkit-mask-position: var(--spritesheet-position);\n}\n\n[is=ui-icon]:not(.icon-mask) {\n    background-position: var(--spritesheet-position);\n}\n\n.spritesheet-smallicons:not(.icon-mask) {\n    background-image: url(Images/smallIcons.svg);\n}\n\n.spritesheet-smallicons.icon-mask {\n    -webkit-mask-image: url(Images/smallIcons.svg);\n}\n\n.spritesheet-largeicons:not(.icon-mask) {\n    background-image: url(Images/largeIcons.svg);\n}\n\n.spritesheet-largeicons.icon-mask {\n    -webkit-mask-image: url(Images/largeIcons.svg);\n}\n\n.spritesheet-mediumicons:not(.icon-mask) {\n    background-image: url(Images/mediumIcons.svg);\n}\n\n.spritesheet-mediumicons.icon-mask {\n    -webkit-mask-image: url(Images/mediumIcons.svg);\n}\n\n.spritesheet-arrowicons {\n    background-image: url(Images/popoverArrows.png);\n}\n\n:host-context(.force-white-icons) [is=ui-icon].spritesheet-smallicons, .force-white-icons [is=ui-icon].spritesheet-smallicons, [is=ui-icon].force-white-icons.spritesheet-smallicons, -theme-preserve {\n    -webkit-mask-image: url(Images/smallIcons.svg);\n    -webkit-mask-position: var(--spritesheet-position);\n    background: #fafafa !important;\n}\n\n:host-context(.force-white-icons) [is=ui-icon].spritesheet-largeicons, .force-white-icons [is=ui-icon].spritesheet-largeicons, [is=ui-icon].force-white-icons.spritesheet-largeicons, -theme-preserve {\n    -webkit-mask-image: url(Images/largeIcons.svg);\n    -webkit-mask-position: var(--spritesheet-position);\n    background: #fafafa !important;\n}\n\n:host-context(.force-white-icons) [is=ui-icon].spritesheet-mediumicon, .force-white-icons [is=ui-icon].spritesheet-mediumicons, [is=ui-icon].force-white-icons.spritesheet-mediumicons, -theme-preserve {\n    -webkit-mask-image: url(Images/mediumIcons.svg);\n    -webkit-mask-position: var(--spritesheet-position);\n    background: #fafafa !important;\n}\n\n.expandable-inline-button {\n    background-color: #dedede;\n    color: #333;\n    cursor: pointer;\n    border-radius: 3px;\n}\n\n.undisplayable-text,\n.expandable-inline-button {\n    padding: 2px 4px;\n    margin: 0 2px;\n    font-size: 12px;\n    font-family: sans-serif;\n    white-space: nowrap;\n    display: inline-block;\n}\n\n.undisplayable-text::after,\n.expandable-inline-button::after {\n    content: attr(data-text);\n}\n\n.undisplayable-text {\n    color: rgb(128, 128, 128);\n    font-style: italic;\n}\n\n.expandable-inline-button:hover {\n    background-color: #d5d5d5;\n}\n\n.expandable-inline-button[data-keyboard-focus=\"true\"] {\n    background-color: #bbbbbb;\n}\n\n::selection {\n    background-color: #bbdefb;\n}\n\n.-theme-with-dark-background *::selection,\n:host-context(.-theme-with-dark-background) *::selection {\n    background-color: #9e9e9e;\n}\n\nbutton.link {\n    border: none;\n    background: none;\n    padding: 3px;\n}\n\nbutton.link[data-keyboard-focus=\"true\"]:focus {\n    background-color: rgba(0, 0, 0, 0.08);\n    border-radius: 2px;\n}\n\n/* See ARIAUtils.js */\n[data-aria-utils-animation-hack] {\n    animation: ANIMATION-HACK 0s;\n}\n@keyframes ANIMATION-HACK {\n}\n\n/*# sourceURL=ui/inspectorCommon.css */";Root.Runtime.cachedResources["ui/inspectorStyle.css"]="/*\n * Copyright (C) 2006, 2007, 2008 Apple Inc.  All rights reserved.\n * Copyright (C) 2009 Anthony Ricaud <rik@webkit.org>\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions\n * are met:\n *\n * 1.  Redistributions of source code must retain the above copyright\n *     notice, this list of conditions and the following disclaimer.\n * 2.  Redistributions in binary form must reproduce the above copyright\n *     notice, this list of conditions and the following disclaimer in the\n *     documentation and/or other materials provided with the distribution.\n * 3.  Neither the name of Apple Computer, Inc. (\"Apple\") nor the names of\n *     its contributors may be used to endorse or promote products derived\n *     from this software without specific prior written permission.\n *\n * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS \"AS IS\" AND ANY\n * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY\n * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\n * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\n * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF\n * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n\n:root {\n    height: 100%;\n    overflow: hidden;\n}\n\n:root {\n    --accent-color: #1a73e8;\n    --accent-fg-color: #1a73e8;\n    --accent-color-hover: #3b86e8;\n    --active-control-bg-color: #5a5a5a;\n    --focus-bg-color: hsl(214, 40%, 92%);\n    --toolbar-bg-color: #f3f3f3;\n    --toolbar-hover-bg-color: #eaeaea;\n    --selection-fg-color: white;\n    --selection-inactive-fg-color: #5a5a5a;\n    --selection-inactive-bg-color: #dadada;\n    --tab-selected-fg-color: #333;\n    --tab-selected-bg-color: var(--toolbar-bg-color);\n    --drop-shadow: 0 0 0 1px rgba(0, 0, 0, 0.05),\n                   0 2px 4px rgba(0, 0, 0, 0.2),\n                   0 2px 6px rgba(0, 0, 0, 0.1);\n    --divider-color: #d0d0d0;\n    --focus-ring-inactive-shadow: 0 0 0 1px #e0e0e0;\n    --item-selection-bg-color: #cfe8fc;\n    --item-selection-inactive-bg-color: #e0e0e0;\n}\n\n.-theme-with-dark-background {\n    --accent-color: #0e639c;\n    --accent-fg-color: #cccccc;\n    --accent-color-hover: rgb(17, 119, 187);\n    --active-control-bg-color: #cdcdcd;\n    --focus-bg-color: hsl(214, 19%, 27%);\n    --toolbar-bg-color: #333333;\n    --toolbar-hover-bg-color: #202020;\n    --selection-fg-color: #cdcdcd;\n    --selection-inactive-fg-color: #cdcdcd;\n    --selection-inactive-bg-color: hsl(0, 0%, 28%);\n    --tab-selected-fg-color: #eaeaea;\n    --tab-selected-bg-color: black;\n    --drop-shadow: 0 0 0 1px rgba(255, 255, 255, 0.2),\n                   0 2px 4px 2px rgba(0, 0, 0, 0.2),\n                   0 2px 6px 2px rgba(0, 0, 0, 0.1);\n    --divider-color: #525252;\n    --focus-ring-inactive-shadow: 0 0 0 1px #5a5a5a;\n    --item-selection-bg-color: hsl(207, 88%, 22%);\n    --item-selection-inactive-bg-color: #454545;\n}\n\n:root {\n    --focus-ring-active-shadow: 0 0 0 1px var(--accent-color);\n    --selection-bg-color: var(--accent-color);\n    --divider-border: 1px solid var(--divider-color);\n    --item-hover-color: rgba(56, 121, 217, 0.1);\n}\n\nbody {\n    height: 100%;\n    width: 100%;\n    position: relative;\n    overflow: hidden;\n    margin: 0;\n    cursor: default;\n    font-family: '.SFNSDisplay-Regular', 'Helvetica Neue', 'Lucida Grande', sans-serif;\n    font-size: 12px;\n    tab-size: 4;\n    -webkit-user-select: none;\n    color: #222;\n    background: white;\n}\n\n.platform-linux {\n    color: rgb(48, 57, 66);\n    font-family: Roboto, Ubuntu, Arial, sans-serif;\n}\n\n.platform-mac {\n    color: rgb(48, 57, 66);\n    font-family: '.SFNSDisplay-Regular', 'Helvetica Neue', 'Lucida Grande', sans-serif;\n}\n\n.platform-windows {\n    font-family: 'Segoe UI', Tahoma, sans-serif;\n}\n\n.panel {\n    display: flex;\n    overflow: hidden;\n    position: absolute;\n    top: 0;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    z-index: 0;\n    background-color: white;\n}\n\n.panel-sidebar {\n    overflow-x: hidden;\n    background-color: var(--toolbar-bg-color);\n}\n\niframe.extension {\n    flex: auto;\n    width: 100%;\n    height: 100%;\n}\n\niframe.panel.extension {\n    display: block;\n    height: 100%;\n}\n\n/*# sourceURL=ui/inspectorStyle.css */";Root.Runtime.cachedResources["ui/inspectorSyntaxHighlight.css"]="/*\n * Copyright (C) 2009 Apple Inc.  All rights reserved.\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions\n * are met:\n *\n * 1.  Redistributions of source code must retain the above copyright\n *     notice, this list of conditions and the following disclaimer.\n * 2.  Redistributions in binary form must reproduce the above copyright\n *     notice, this list of conditions and the following disclaimer in the\n *     documentation and/or other materials provided with the distribution.\n * 3.  Neither the name of Apple Computer, Inc. (\"Apple\") nor the names of\n *     its contributors may be used to endorse or promote products derived\n *     from this software without specific prior written permission.\n *\n * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS \"AS IS\" AND ANY\n * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY\n * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\n * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\n * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF\n * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n.cm-js-keyword {color: hsl(310, 86%, 36%);}\n.cm-js-number {color: hsl(248, 100%, 41%);}\n.cm-js-comment {color: hsl(120, 100%, 23%); font-style: italic;}\n.cm-js-string {color: hsl(1, 80%, 43%);}\n.cm-js-string-2 {color: hsl(1, 99%, 39%);}\n.cm-js-atom {color: hsl(310, 86%, 36%);}\n.cm-js-def {color: hsl(240, 73%, 38%);}\n.cm-js-operator {color: hsl(27, 100%, 30%);}\n.cm-js-meta {color: hsl(27, 100%, 30%);}\n.cm-js-variable-2 {color: hsl(240, 73%, 38%);}\n\n.cm-css-keyword { color: rgb(7, 144, 154);}\n.cm-css-number {color: rgb(50, 0, 255);}\n.cm-css-comment {color: rgb(0, 116, 0);}\n.cm-css-def {color: rgb(200, 0, 0);}\n.cm-css-meta {color: rgb(200, 0, 0);}\n.cm-css-atom {color: rgb(7, 144, 154);}\n.cm-css-string {color: rgb(7, 144, 154);}\n.cm-css-string-2 {color: rgb(7, 144, 154);}\n.cm-css-link {color: rgb(7, 144, 154);}\n.cm-css-variable {color: rgb(200, 0, 0);}\n.cm-css-variable-2 {color: rgb(0, 0, 128);}\n.cm-css-property, .webkit-css-property {color: rgb(200, 0, 0);}\n\n.cm-xml-meta {color: rgb(192, 192, 192);}\n.cm-xml-comment {color: rgb(35, 110, 37);}\n.cm-xml-string {color: rgb(26, 26, 166);}\n.cm-xml-tag {color: var(--dom-tag-name-color);}\n.cm-xml-attribute {color: rgb(153, 69, 0);}\n.cm-xml-link {color: #00e;}\n\n:root {\n    --dom-tag-name-color: rgb(136, 18, 128);\n    --dom-attribute-name-color: rgb(153, 69, 0);\n}\n\n.webkit-html-comment {\n    /* Keep this in sync with view-source.css (.webkit-html-comment) */\n    color: rgb(35, 110, 37);\n}\n\n.webkit-html-tag {\n    color: rgb(168, 148, 166);\n}\n\n.webkit-html-tag-name, .webkit-html-close-tag-name {\n    /* Keep this in sync with view-source.css (.webkit-html-tag) */\n    color: var(--dom-tag-name-color);\n}\n\n.webkit-html-pseudo-element {\n    /* This one is non-standard. */\n    color: brown;\n}\n\n.webkit-html-js-node,\n.webkit-html-css-node {\n    white-space: pre-wrap;\n}\n\n.webkit-html-text-node {\n    unicode-bidi: -webkit-isolate;\n}\n\n.webkit-html-entity-value {\n    /* This one is non-standard. */\n    background-color: rgba(0, 0, 0, 0.15);\n    unicode-bidi: -webkit-isolate;\n}\n\n.webkit-html-doctype {\n    /* Keep this in sync with view-source.css (.webkit-html-doctype) */\n    color: rgb(192, 192, 192);\n}\n\n.webkit-html-attribute-name {\n    /* Keep this in sync with view-source.css (.webkit-html-attribute-name) */\n    color: var(--dom-attribute-name-color);\n    unicode-bidi: -webkit-isolate;\n}\n\n.webkit-html-attribute-value {\n    /* Keep this in sync with view-source.css (.webkit-html-attribute-value) */\n    color: rgb(26, 26, 166);\n    unicode-bidi: -webkit-isolate;\n}\n\n.devtools-link {\n    color: rgb(17, 85, 204);\n    text-decoration: underline;\n}\n\n.devtools-link [is=ui-icon] {\n    vertical-align: middle;\n}\n\n.devtools-link[data-keyboard-focus=\"true\"]:focus {\n    outline-width: unset;\n}\n\n.devtools-link:not(.devtools-link-prevent-click) {\n    cursor: pointer;\n}\n\n.-theme-with-dark-background .devtools-link,\n:host-context(.-theme-with-dark-background) .devtools-link {\n    color: hsl(0, 0%, 67%);\n}\n\n/* Default CodeMirror Theme */\n.cm-negative {color: #d44;}\n.cm-positive {color: #292;}\n.cm-header, .cm-strong {font-weight: bold;}\n.cm-em {font-style: italic;}\n.cm-link {text-decoration: underline;}\n.cm-strikethrough {text-decoration: line-through;}\n\n.cm-invalidchar {color: #f00;}\n\n.cm-header {color: blue;}\n.cm-quote {color: #090;}\n\n.cm-keyword {color: #708;}\n.cm-atom {color: #219;}\n.cm-number {color: #164;}\n.cm-def {color: #00f;}\n.cm-variable-2 {color: #05a;}\n.cm-variable-3, .cm-type {color: #085;}\n.cm-comment {color: #a50;}\n.cm-string {color: #a11;}\n.cm-string-2 {color: #f50;}\n.cm-meta {color: #555;}\n.cm-qualifier {color: #555;}\n.cm-builtin {color: #30a;}\n.cm-bracket {color: #997;}\n.cm-tag {color: #170;}\n.cm-attribute {color: #00c;}\n.cm-hr {color: #999;}\n.cm-link {color: #00c;}\n\n.cm-error {color: #f00;}\n\n/*# sourceURL=ui/inspectorSyntaxHighlight.css */";Root.Runtime.cachedResources["ui/inspectorSyntaxHighlightDark.css"]="/*\n * Copyright 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.cm-js-atom{color:rgb(161, 247, 181);}\n.cm-js-attribute{color:rgb(97, 148, 198);}\n.cm-js-builtin{color:rgb(159, 180, 214);}\n.cm-js-comment{color:rgb(116, 116, 116);}\n.cm-js-def{color:var(--dom-tag-name-color);}\n.cm-js-keyword{color:rgb(154, 127, 213);}\n.cm-js-link{color:rgb(159, 180, 214);}\n.cm-js-meta{color:rgb(221, 251, 85);}\n.cm-js-number{color:rgb(161, 247, 181);}\n.cm-js-operator{color:rgb(210, 192, 87);}\n.cm-js-property{color:rgb(210, 192, 87);}\n.cm-js-string{color:rgb(242, 139, 84);}\n.cm-js-string-2{color:rgb(242, 139, 84);}\n.cm-js-tag{color:var(--dom-tag-name-color);}\n.cm-js-variable{color:rgb(217, 217, 217);}\n.cm-js-variable-2{color:rgb(217, 217, 217);}\n.cm-atom{color:rgb(161, 247, 181);}\n.cm-comment{color:rgb(116, 116, 116);}\n.cm-variable{color:rgb(217, 217, 217);}\n.cm-string{color:rgb(242, 139, 84);}\n.cm-keyword{color:rgb(154, 127, 213);}\n.cm-number{color:rgb(161, 247, 181);}\n.cm-operator{color:rgb(210, 192, 87);}\n.cm-css-atom{color:rgb(217, 217, 217);}\n.cm-css-builtin{color:rgb(255, 163, 79);}\n.cm-css-def{color:rgb(255, 163, 79);}\n.cm-css-comment{color:rgb(116, 116, 116);}\n.cm-css-meta{color:rgb(132, 240, 255);}\n.cm-css-number{color:rgb(217, 217, 217);}\n.cm-css-operator{color:rgb(217, 217, 217);}\n.cm-css-property{color:rgb(132, 240, 255);}\n.cm-css-qualifier{color:rgb(255, 163, 79);}\n.cm-css-string{color:rgb(231, 194, 111);}\n.cm-css-string-2{color:rgb(217, 217, 217);}\n.cm-css-tag{color:rgb(255, 163, 79);}\n.cm-css-variable{color:rgb(255, 163, 79);}\n.cm-css-variable-2{color:rgb(255, 163, 79);}\n.cm-xml-comment{color:rgb(137, 137, 137);}\n.cm-xml-error{color:rgb(198, 95, 95);}\n.cm-xml-string{color:rgb(242, 151, 102);}\n.cm-xml-tag{color:var(--dom-tag-name-color);}\n.cm-xml-attribute{color:var(--dom-attribute-name-color);}\n.cm-xml-link{color:rgb(231, 194, 111);}\n\n.webkit-html-attribute-name{color:var(--dom-attribute-name-color);}\n.webkit-html-attribute-value{color:rgb(242, 151, 102);}\n.webkit-html-comment{color:rgb(137, 137, 137);}\n.devtools-link{color:rgb(231, 194, 111);}\n.webkit-html-tag{color:var(--dom-tag-name-color);}\n.webkit-html-tag-name{color:var(--dom-tag-name-color);}\n.webkit-html-close-tag-name{color:var(--dom-tag-name-color);}\n.webkit-html-text-node{color:rgb(207, 208, 208);}\n.webkit-html-css-node{color:rgb(207, 208, 208);}\n.webkit-html-js-node{color:rgb(207, 208, 208);}\n.webkit-html-pseudo-element{color:rgb(93, 175, 215);}\n.webkit-css-property{color: rgb(53, 212, 199);}\n\n.cm-def{color:var(--dom-tag-name-color);}\n.cm-header{color:var(--dom-tag-name-color);}\n.cm-variable-2{color:rgb(217, 217, 217);}\n\n.cm-variable-2 {color: #05a;}\n.cm-variable-3, .cm-type {color: rgb(93, 176, 215);}\n.cm-string {color: rgb(242, 139, 84);}\n.cm-meta {color: #555;}\n.cm-meta {color:rgb(221, 251, 85);}\n.cm-qualifier{color:rgb(255, 163, 79);}\n.cm-builtin{color:rgb(159, 180, 214);}\n.cm-bracket {color: #997;}\n.cm-tag{color:var(--dom-tag-name-color);}\n.cm-attribute{color:rgb(97, 148, 198);}\n.cm-hr {color: #999;}\n.cm-link{color:rgb(159, 180, 214);}\n\n:root {\n    --dom-tag-name-color: rgb(93, 176, 215);\n    --dom-attribute-name-color: rgb(155, 187, 220);\n}\n\n/*# sourceURL=ui/inspectorSyntaxHighlightDark.css */";Root.Runtime.cachedResources["ui/inspectorViewTabbedPane.css"]="/*\n * Copyright 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.tabbed-pane-header-tab,\n.tabbed-pane-header-tab.selected {\n    height: 26px;\n    margin: 0;\n    border: none;\n    border-left: 2px solid transparent;\n    border-right: 2px solid transparent;\n}\n\n.tabbed-pane-header-tab.selected {\n    border-width: 0 2px 0 2px;\n}\n\n.tabbed-pane-header-contents {\n    margin-left: 0;\n}\n\n.tabbed-pane-left-toolbar {\n    margin-right: 0 !important;\n}\n\n/*# sourceURL=ui/inspectorViewTabbedPane.css */";Root.Runtime.cachedResources["ui/listWidget.css"]="/*\n * Copyright 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.list {\n    flex: auto 0 1;\n    overflow-y: auto;\n    border: 1px solid rgb(231, 231, 231);\n    flex-direction: column;\n}\n\n.list-separator {\n    background: rgb(231, 231, 231);\n    height: 1px;\n}\n\n.list-item {\n    flex: none;\n    min-height: 30px;\n    display: flex;\n    align-items: center;\n    position: relative;\n    overflow: hidden;\n}\n\n.list-item:hover {\n    background: hsl(0, 0%, 96%);\n}\n\n.list-widget-input-validation-error {\n    color: #db1600;\n    margin: 0 5px;\n}\n\n.controls-container {\n    display: flex;\n    flex-direction: row;\n    justify-content: flex-end;\n    align-items: stretch;\n    pointer-events: none;\n}\n\n.controls-gradient {\n    flex: 0 1 50px;\n}\n\n.list-item:hover .controls-gradient {\n    background-image: linear-gradient(90deg, transparent, hsl(0, 0%, 96%));\n}\n\n.controls-buttons {\n    flex: none;\n    display: flex;\n    flex-direction: row;\n    align-items: center;\n    pointer-events: auto;\n    visibility: hidden;\n}\n\n.list-item:hover .controls-buttons {\n    background-color: hsl(0, 0%, 96%);\n    visibility: visible;\n}\n\n.editor-container {\n    display: flex;\n    flex-direction: column;\n    align-items: stretch;\n    flex: none;\n    background: hsl(0, 0%, 96%);\n    overflow: hidden;\n}\n\n.editor-content {\n    flex: auto;\n    display: flex;\n    flex-direction: column;\n    align-items: stretch;\n}\n\n.editor-buttons {\n    flex: none;\n    display: flex;\n    flex-direction: row;\n    align-items: center;\n    justify-content: flex-start;\n    padding: 5px;\n}\n\n.editor-buttons > button {\n    flex: none;\n    margin-right: 10px;\n}\n\n.editor-content input {\n    margin-right: 10px;\n}\n\n.editor-content input.error-input {\n    background-color: white;\n}\n\n/*# sourceURL=ui/listWidget.css */";Root.Runtime.cachedResources["ui/popover.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.widget {\n    display: flex;\n    background: white;\n    box-shadow: var(--drop-shadow);\n    border-radius: 2px;\n    overflow: auto;\n    -webkit-user-select: text;\n    line-height: 11px;\n}\n\n.widget.has-padding {\n    padding: 6px;\n}\n\n/*# sourceURL=ui/popover.css */";Root.Runtime.cachedResources["ui/progressIndicator.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.progress-indicator-shadow-stop-button {\n    background-color: rgb(216, 0, 0) !important;\n    border: 0;\n    width: 10px;\n    height: 12px;\n    border-radius: 2px;\n}\n\n.progress-indicator-shadow-container {\n    display: flex;\n    flex: 1 0 auto;\n    align-items: center;\n}\n\n.progress-indicator-shadow-container .title {\n    text-overflow: ellipsis;\n    overflow: hidden;\n    max-width: 150px;\n    margin-right: 2px;\n    color: #777;\n}\n\n.progress-indicator-shadow-container progress {\n    flex: auto;\n    margin: 0 2px;\n    width: 100px\n}\n\n/*# sourceURL=ui/progressIndicator.css */";Root.Runtime.cachedResources["ui/radioButton.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n::slotted(input.dt-radio-button) {\n    height: 17px;\n    width: 17px;\n    min-width: 17px;\n    border: 1px solid rgb(165, 165, 165);\n    background-image: linear-gradient(to bottom, rgb(252, 252, 252), rgb(223, 223, 223));\n    border-radius: 8px;\n    -webkit-appearance: none;\n    vertical-align: middle;\n    margin: 0 5px 5px 0;\n}\n\n::slotted(input.dt-radio-button:active:not(:disabled)) {\n    background-image: linear-gradient(to bottom, rgb(194, 194, 194), rgb(239, 239, 239));\n}\n\n::slotted(input.dt-radio-button:checked) {\n    background: url(Images/radioDot.png) center no-repeat,\n                linear-gradient(to bottom, rgb(252, 252, 252), rgb(223, 223, 223));\n}\n\n::slotted(input.dt-radio-button:checked:active) {\n    background: url(Images/radioDot.png) center no-repeat,\n                linear-gradient(to bottom, rgb(194, 194, 194), rgb(239, 239, 239));\n}\n\n/*# sourceURL=ui/radioButton.css */";Root.Runtime.cachedResources["ui/remoteDebuggingTerminatedScreen.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.widget {\n    padding: 20px;\n}\n\n.message, .button {\n    font-size: larger;\n    white-space: pre;\n    margin: 5px;\n}\n\n.button {\n    text-align: center;\n    margin-top: 10px;\n}\n\n.reason {\n    color: #8b0000;\n}\n\n/*# sourceURL=ui/remoteDebuggingTerminatedScreen.css */";Root.Runtime.cachedResources["ui/reportView.css"]="/*\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n    background-color: #f9f9f9;\n}\n\n.report-content-box {\n    background-color: white;\n    white-space: nowrap;\n    overflow: auto;\n}\n\n.report-content-box.no-scroll {\n    overflow: visible;\n}\n\n.report-header {\n    border-bottom: 1px solid rgb(230, 230, 230);\n    padding: 12px 24px;\n}\n\n.report-header .toolbar {\n    margin-bottom: -8px;\n}\n\n.report-header .toolbar {\n    margin-top: 5px;\n    margin-left: -8px;\n}\n\n.report-title {\n    font-size: 15px;\n}\n\n.report-url, .report-subtitle {\n    font-size: 12px;\n    margin-top: 10px;\n}\n\n.report-section {\n    display: flex;\n    padding: 12px;\n    border-bottom: 1px solid rgb(230, 230, 230);\n    flex-direction: column;\n}\n\n.report-section-header {\n    margin-left: 18px;\n    display: flex;\n    flex-direction: row;\n    align-items: center;\n}\n\n.report-section-title {\n    flex: auto;\n    text-overflow: ellipsis;\n    overflow: hidden;\n    font-weight: bold;\n    color: #555;\n}\n\n.report-field {\n    margin-top: 8px;\n    display: flex;\n    line-height: 28px;\n}\n\n.report-row {\n    margin: 10px 0 2px 18px;\n}\n\n.report-field-name {\n    color: #888;\n    flex: 0 0 128px;\n    text-align: right;\n    padding: 0 6px;\n    white-space: pre;\n}\n\n.report-field-value {\n    flex: auto;\n    padding: 0 6px;\n    white-space: pre;\n}\n\n.report-field-value-subtitle {\n    color: #888;\n    line-height: 14px;\n}\n\n.report-row-selectable {\n    user-select: text;\n}\n\n/*# sourceURL=ui/reportView.css */";Root.Runtime.cachedResources["ui/rootView.css"]="/*\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.root-view {\n    background-color: white;\n    overflow: hidden;\n    position: absolute !important;\n    left: 0;\n    top: 0;\n    right: 0;\n    bottom: 0;\n}\n\n/*# sourceURL=ui/rootView.css */";Root.Runtime.cachedResources["ui/searchableView.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.search-bar {\n    flex: 0 0 31px;\n    background-color: #eee;\n    border-top: 1px solid #ccc;\n    display: flex;\n    overflow: hidden;\n    z-index: 0;\n}\n\n.search-bar.replaceable {\n    flex: 0 0 57px;\n}\n\n.search-replace {\n    -webkit-appearance: none;\n    border: 0;\n    padding: 0 3px;\n    margin: 0;\n    flex: 1;\n}\n\n.search-replace:focus {\n    outline: none;\n}\n\n.toolbar-search {\n    display: flex;\n    width: 100%;\n}\n\n.toolbar-search > div {\n    margin: 2px 2px;\n    flex-shrink: 0;\n}\n\n.toolbar-search-inputs {\n    flex-grow: 1;\n    min-width: 150px;\n}\n\n.toolbar-search-navigation-controls {\n    align-self: stretch;\n}\n\n.toolbar-search-navigation {\n    display: inline-block;\n    width: 20px;\n    height: 20px;\n    background-repeat: no-repeat;\n    background-position: 4px 7px;\n    border-left: 1px solid rgb(170, 170, 170);\n    opacity: 0.3;\n}\n\n.toolbar-search-navigation.enabled {\n    opacity: 1.0;\n}\n\n.toolbar-search button.search-action-button {\n    font-weight: 400;\n    height: 22px;\n    width: 87px;\n}\n\n.toolbar-search-control {\n    display: -webkit-flex;\n    position: relative;\n    background-color: white;\n}\n\n.toolbar-search-buttons {\n    display: flex;\n    flex-direction: column;\n}\n\n.toolbar-replace-control,\n#search-input-field {\n    margin-top: 1px;\n    line-height: 17px;\n}\n\n.toolbar-search-control, .toolbar-replace-control {\n    border: 1px solid rgb(163, 163, 163);\n    height: 22px;\n    border-radius: 2px;\n    width: 100%;\n    margin-top: 2px;\n    margin-bottom: 2px;\n}\n\n.toolbar-search-navigation.enabled:active {\n    background-position: 4px 7px, 0 0;\n}\n\n.toolbar-search-navigation.toolbar-search-navigation-prev {\n    background-image: url(Images/searchPrev.png);\n    border-left: 1px solid rgb(163, 163, 163);\n}\n\n:host-context(.-theme-with-dark-background) .toolbar-search-navigation {\n    -webkit-filter: invert(90%);\n}\n\n.toolbar-search-navigation.toolbar-search-navigation-prev.enabled:active {\n    background-image: url(Images/searchPrev.png), #f2f2f2;\n}\n\n.toolbar-search-navigation.toolbar-search-navigation-next {\n    background-image: url(Images/searchNext.png);\n    border-left: 1px solid rgb(230, 230, 230);\n}\n\n.toolbar-search-navigation.toolbar-search-navigation-next.enabled:active {\n    background-image: url(Images/searchNext.png), #f2f2f2;\n}\n\n.search-results-matches {\n    display: inline-block;\n    text-align: right;\n    padding: 0 4px;\n    color: rgb(165, 165, 165);\n    align-self: center;\n}\n\n.first-row-buttons {\n    display: flex;\n    justify-content: space-between;\n}\n\n.toolbar-search > .replace-toggle-toolbar {\n    margin: 2px -2px 0 0;\n}\n\n.toolbar-search-options {\n    margin: 0 auto;\n}\n\n/*# sourceURL=ui/searchableView.css */";Root.Runtime.cachedResources["ui/slider.css"]="/*\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.dt-range-input {\n    -webkit-appearance: none;\n    margin: 0;\n    padding: 0;\n    height: 10px;\n    width: 88px;\n    outline: none;\n    background: none;\n}\n\n.dt-range-input::-webkit-slider-thumb, -theme-preserve {\n    -webkit-appearance: none;\n    margin: 0;\n    padding: 0;\n    border: 0;\n    width: 12px;\n    height: 12px;\n    margin-top: -5px;\n    border-radius: 50%;\n    background-color: #4285F4;\n}\n\n.dt-range-input::-webkit-slider-runnable-track {\n    -webkit-appearance: none;\n    margin: 0;\n    padding: 0;\n    width: 100%;\n    height: 2px;\n    background-color: rgba(0, 0, 0, 0.26);\n}\n\n.dt-range-input:focus::-webkit-slider-thumb, -theme-preserve {\n    box-shadow: 0 0 0 2px rgba(66, 133, 244, 0.4);\n}\n\n.dt-range-input:disabled::-webkit-slider-thumb {\n    background-color: #bdbdbd;\n}\n\n/*# sourceURL=ui/slider.css */";Root.Runtime.cachedResources["ui/smallBubble.css"]="/*\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\ndiv {\n    display: inline-block;\n    height: 14px;\n    vertical-align: middle;\n    white-space: nowrap;\n    padding: 1px 4px;\n    text-align: left;\n    font-size: 11px;\n    line-height: normal;\n    font-weight: bold;\n    text-shadow: none;\n    color: white;\n    margin-top: -1px;\n    border-radius: 7px;\n}\n\ndiv.verbose {\n    background-color: rgb(0, 0, 255);\n}\n\ndiv.info {\n    background-color: rgb(128, 151, 189);\n}\n\ndiv.warning {\n    background-color: rgb(232, 164, 0);\n}\n\ndiv.error {\n    background-color: rgb(216, 35, 35);\n}\n\n/*# sourceURL=ui/smallBubble.css */";Root.Runtime.cachedResources["ui/segmentedButton.css"]="/*\n * Copyright 2018 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.segmented-button {\n  align-items: center;\n  align-content: center;\n  display: flex;\n}\n\n.segmented-button-segment {\n  background-color: white;\n  border: var(--divider-border);\n  border-right-style: none;\n  color: #5a5a5a;\n  flex: 1 1 0;\n  font-weight: 700;\n  margin-left: -1px;\n  padding: 4px 16px;\n}\n\n.segmented-button-segment:hover {\n  background-color: #F4F4F4;\n  color: #333;\n}\n\n.segmented-button-segment:first-child {\n  border-bottom-left-radius: 4px;\n  border-top-left-radius: 4px;\n}\n\n.segmented-button-segment:last-child {\n  border-bottom-right-radius: 4px;\n  border-right-style: solid;\n  border-top-right-radius: 4px;\n}\n\n.segmented-button-segment.segmented-button-segment-selected {\n  background-color: hsl(218, 81%, 59%);\n  border-color: transparent;\n  color: #FAFAFA;\n}\n\n.segmented-button-segment.segmented-button-segment-selected:hover {\n  background-color: hsl(218, 81%, 62%);\n  color: #FFF;\n}\n\n/* Remove a border between the selected button and its siblin */\n.segmented-button-segment-selected + .segmented-button-segment {\n  border-left-color: transparent;\n}\n\n/*# sourceURL=ui/segmentedButton.css */";Root.Runtime.cachedResources["ui/softContextMenu.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.soft-context-menu {\n    overflow-y: auto;\n    min-width: 160px !important;\n    /* NOTE: Keep padding in sync with padding adjustment in SoftContextMenu.js */\n    padding: 4px 0 4px 0;\n    border: 1px solid #b9b9b9;\n    background-color: #FFF;\n    box-shadow: var(--drop-shadow);\n    --context-menu-hover-bg: #ebebeb;\n    --context-menu-hover-color: #222;\n    --context-menu-seperator-color: var(--divider-color);\n}\n\n:host:host-context(.platform-mac):host-context(html:not(.-theme-with-dark-background)) .soft-context-menu {\n    border: 1px solid rgba(196, 196, 196, 0.9);\n    border-top: 1px solid rgba(196, 196, 196, 0.5);\n    border-radius: 4px;\n    background-color: rgb(240, 240, 240);\n    box-shadow: 0 5px 10px rgba(0, 0, 0, 0.25);\n    --context-menu-hover-color: #FFF;\n    --context-menu-seperator-color: rgb(222, 222, 222);\n}\n\n:host-context(.-theme-with-dark-background) .soft-context-menu {\n    --context-menu-hover-bg: var(--selection-bg-color);\n    --context-menu-hover-color: var(--selection-fg-color);\n    border: none;\n}\n\n.soft-context-menu-item {\n    display: flex;\n    width: 100%;\n    line-height: 14px;\n    font-size: 12px;\n    border-top: 1px solid transparent;\n    border-bottom: 1px solid transparent;\n    padding: 2px 7px 2px 8px;\n    margin: 0 13px 0 0;\n    white-space: nowrap;\n}\n\n.soft-context-menu-disabled {\n    color: #999;\n    pointer-events: none;\n}\n\n.soft-context-menu-separator {\n    height: 10px;\n    margin: 0 1px;\n}\n\n.soft-context-menu-separator > .separator-line {\n    margin: 0;\n    height: 5px;\n    border-bottom: 1px solid var(--context-menu-seperator-color);\n    pointer-events: none;\n}\n\n.soft-context-menu-item-mouse-over {\n    border-top: 1px solid var(--context-menu-hover-bg);\n    border-bottom: 1px solid var(--context-menu-hover-bg);\n    background-color: var(--context-menu-hover-bg);\n    color: var(--context-menu-hover-color);\n}\n\n:host:host-context(.platform-mac):host-context(html:not(.-theme-with-dark-background)) .soft-context-menu-item-mouse-over {\n    border-top: 1px solid transparent;\n    border-bottom: 1px solid transparent;\n    background-image: linear-gradient(to right, hsl(214, 81%, 60%), hsl(214, 100%, 56%));\n}\n\n:host:host-context(.platform-mac):host-context(html:not(.-theme-with-dark-background)) .separator-line {\n    border-width: 2px;\n}\n\n.soft-context-menu-item-submenu-arrow {\n    pointer-events: none;\n    font-size: 11px;\n    text-align: right;\n    align-self: center;\n    margin-left: auto;\n}\n\n.soft-context-menu-item-mouse-over .soft-context-menu-item-checkmark {\n    color: var(--selection-fg-color);\n}\n\n.soft-context-menu-custom-item {\n    display: inline-flex;\n    justify-content: center;\n    align-items: center;\n    flex: auto;\n}\n\n.soft-context-menu-shortcut {\n    color: gray;\n    pointer-events: none;\n    flex: 1 1 auto;\n    text-align: right;\n    padding-left: 10px;\n}\n\n.soft-context-menu-item-mouse-over .soft-context-menu-shortcut {\n    color: inherit;\n}\n\n.checkmark {\n    opacity: 0.7;\n    pointer-events: none;\n    margin: auto 5px auto 0px;\n}\n\n:host-context(.-theme-with-dark-background) .checkmark {\n    filter: invert(80%);\n}\n\n.soft-context-menu-item-mouse-over .checkmark {\n    opacity: 1;\n    filter: none;\n}\n\n/*# sourceURL=ui/softContextMenu.css */";Root.Runtime.cachedResources["ui/softDropDown.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.item.disabled {\n    opacity: 0.5;\n}\n\n.item-list {\n    background-color: white;\n    box-shadow: var(--drop-shadow);\n    overflow-x: hidden;\n    overflow-y: auto;\n    width: 100%;\n}\n\n.item.highlighted {\n    color: var(--selection-fg-color);\n    background-color: var(--selection-bg-color);\n}\n\n.list-container {\n    width: 100%;\n}\n\n/*# sourceURL=ui/softDropDown.css */";Root.Runtime.cachedResources["ui/softDropDownButton.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\nbutton.soft-dropdown {\n    height: 26px;\n    text-align: left;\n    position: relative;\n    border: none;\n    background: none;\n}\n\nbutton.soft-dropdown[disabled] {\n    opacity: .5;\n}\n\nbutton.soft-dropdown > .title {\n    padding-right: 5px;\n    width: 120px;\n    overflow: hidden;\n    text-overflow: ellipsis;\n}\n\nbutton.soft-dropdown[data-keyboard-focus=\"true\"]:focus::before {\n    content: \"\";\n    position: absolute;\n    top: 2px;\n    left: 2px;\n    right: 2px;\n    bottom: 2px;\n    border-radius: 2px;\n    background: rgba(0, 0, 0, 0.08);\n}\n\n/*# sourceURL=ui/softDropDownButton.css */";Root.Runtime.cachedResources["ui/splitWidget.css"]="/*\n * Copyright (C) 2011 Google Inc. All rights reserved.\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions are\n * met:\n *\n * 1. Redistributions of source code must retain the above copyright\n * notice, this list of conditions and the following disclaimer.\n *\n * 2. Redistributions in binary form must reproduce the above\n * copyright notice, this list of conditions and the following disclaimer\n * in the documentation and/or other materials provided with the\n * distribution.\n *\n * THIS SOFTWARE IS PROVIDED BY GOOGLE INC. AND ITS CONTRIBUTORS\n * \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GOOGLE INC.\n * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n\n:host {\n    overflow: hidden;\n}\n\n.shadow-split-widget {\n    display: flex;\n    overflow: hidden;\n}\n\n.shadow-split-widget-contents {\n    display: flex;\n    position: relative;\n    flex-direction: column;\n    contain: layout size style;\n}\n\n.shadow-split-widget-sidebar {\n    flex: none;\n}\n\n.shadow-split-widget-main, .shadow-split-widget-sidebar.maximized {\n    flex: auto;\n}\n\n.shadow-split-widget.hbox > .shadow-split-widget-resizer {\n    position: absolute;\n    top: 0;\n    bottom: 0;\n    width: 6px;\n    z-index: 500;\n}\n\n.shadow-split-widget.vbox > .shadow-split-widget-resizer {\n    position: absolute;\n    left: 0;\n    right: 0;\n    height: 6px;\n    z-index: 500;\n}\n\n.shadow-split-widget.vbox > .shadow-split-widget-sidebar.no-default-splitter {\n    border: 0 !important;\n}\n\n.shadow-split-widget.vbox > .shadow-split-widget-sidebar:not(.maximized) {\n    border: 0;\n    border-top: 1px solid var(--divider-color);\n}\n\n.shadow-split-widget.vbox > .shadow-split-widget-sidebar:first-child:not(.maximized) {\n    border: 0;\n    border-bottom: 1px solid var(--divider-color);\n}\n\n.shadow-split-widget.hbox > .shadow-split-widget-sidebar:not(.maximized) {\n    border: 0;\n    border-left: 1px solid var(--divider-color);\n}\n\n.shadow-split-widget.hbox > .shadow-split-widget-sidebar:first-child:not(.maximized) {\n    border: 0;\n    border-right: 1px solid var(--divider-color);\n}\n\n:host-context(.disable-resizer-for-elements-hack) .shadow-split-widget-resizer {\n    pointer-events: none;\n}\n\n/*# sourceURL=ui/splitWidget.css */";Root.Runtime.cachedResources["ui/toolbar.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n    flex: none;\n    padding: 0 2px;\n}\n\n.toolbar-shadow {\n    position: relative;\n    white-space: nowrap;\n    height: 26px;\n    overflow: hidden;\n    z-index: 12;\n    display: flex;\n    flex: none;\n    align-items: center;\n}\n\n.toolbar-shadow.wrappable {\n    flex-wrap: wrap;\n    overflow: visible;\n}\n\n.toolbar-shadow.toolbar-grow-vertical {\n    height: initial;\n}\n\n.toolbar-shadow.vertical {\n    flex-direction: column;\n    height: auto;\n    align-items: flex-start;\n}\n\n.toolbar-item {\n    position: relative;\n    display: flex;\n    background-color: transparent;\n    flex: none;\n    align-items: center;\n    justify-content: center;\n    padding: 0;\n    height: 26px;\n    border: none;\n    white-space: pre;\n}\n\n.toolbar-item,\n.toolbar-item .devtools-link {\n    color: #5a5a5a;\n}\n\nselect.toolbar-item:disabled {\n    opacity: 0.5;\n}\n\n.toolbar-dropdown-arrow {\n    background-color: #6D6D6D;\n    pointer-events: none;\n    flex: none;\n}\n\nselect.toolbar-item:disabled + .toolbar-dropdown-arrow {\n    opacity: 0.5;\n}\n\n/* Toolbar item */\n\n.toolbar-button {\n    white-space: nowrap;\n    overflow: hidden;\n    min-width: 28px;\n    background: transparent;\n    border-radius: 0;\n}\n\n.toolbar-text {\n    margin: 0 5px;\n    flex: none;\n    color: #5a5a5a;\n}\n\n.toolbar-text:empty {\n    margin: 0;\n}\n\n.toolbar-has-dropdown {\n    justify-content: space-between;\n    padding: 0 3px 0 5px;\n}\n\n.toolbar-has-dropdown .toolbar-text {\n    margin: 0 4px 0 0;\n    text-overflow: ellipsis;\n    flex: auto;\n    overflow: hidden;\n    text-align: right;\n}\n\n.toolbar-button.dark-text .toolbar-dropdown-arrow {\n    background-color: #333;\n}\n\n.toolbar-has-glyph .toolbar-text {\n    margin-left: -4px;\n}\n\n.toolbar-button:not(.toolbar-has-glyph):not(.toolbar-has-dropdown):not(.largeicon-menu) {\n    font-weight: bold;\n}\n\n.toolbar-render-as-links * {\n    font-weight: initial;\n    color: rgb(17, 85, 204);\n    text-decoration: underline;\n    cursor: pointer;\n}\n\n.toolbar-toggled-gray:not(.toolbar-render-as-links) .toolbar-button:not(.toolbar-has-glyph):not(.toolbar-has-dropdown):not(.largeicon-menu):hover {\n    background-color: var(--toolbar-bg-color);\n}\n\n.toolbar-glyph {\n    background-color: #5a5a5a;\n    flex: none;\n}\n\n/* Button */\n\n.toolbar-button:disabled {\n    opacity: 0.5;\n}\n\n.toolbar-button.dark-text .toolbar-text{\n    color: #333 !important;\n}\n\n:not(.toolbar-render-as-links) .toolbar-button:enabled:hover:not(:active) .toolbar-glyph {\n    background-color: #333;\n}\n\n:not(.toolbar-render-as-links) .toolbar-button:enabled:hover:not(:active) .toolbar-text {\n    color: #333;\n}\n\n.toolbar-button.toolbar-state-on .toolbar-glyph,\n.toolbar-blue-on-hover .toolbar-button:not(.toolbar-state-on):enabled:hover:not(:active) {\n    background-color: var(--accent-color);\n}\n\n.toolbar-button.toolbar-state-on .toolbar-text {\n    color: var(--accent-color);\n}\n\n.toolbar-blue-on-hover .toolbar-button:not(.toolbar-state-on):enabled:hover .toolbar-glyph {\n    background-color: white;\n}\n\n.toolbar-blue-on-hover .toolbar-button:not(.toolbar-state-on):enabled:hover .toolbar-text {\n    color: white;\n}\n\n.toolbar-button.toolbar-state-on:enabled:hover:not(:active) .toolbar-glyph,\n.toolbar-blue-on-hover .toolbar-button:not(.toolbar-state-on):enabled:active:hover {\n    background-color: var(--accent-color);\n}\n\n.toolbar-button.toolbar-state-on:enabled:hover:not(:active) .toolbar-text {\n    color: var(--accent-color);\n}\n\n.toolbar-toggled-gray .toolbar-button.toolbar-state-on {\n    background-color: var(--toolbar-bg-color) !important;\n}\n\n.toolbar-button.toolbar-state-on.toolbar-toggle-with-red-color .toolbar-glyph,\n.toolbar-button.toolbar-state-off.toolbar-default-with-red-color .toolbar-glyph {\n    background-color: rgb(216, 0, 0) !important;\n}\n\n:host-context(.-theme-with-dark-background) .toolbar-button.toolbar-state-on.toolbar-toggle-with-red-color .toolbar-glyph,\n:host-context(.-theme-with-dark-background) .toolbar-button.toolbar-state-off.toolbar-default-with-red-color .toolbar-glyph {\n    background-color: hsl(0, 100%, 65%) !important;\n}\n\n\n/* Checkbox */\n\n.toolbar-item.checkbox {\n    padding: 0 5px 0 2px;\n}\n\n.toolbar-item.checkbox:hover {\n    color: #333;\n}\n\n/* Select */\n\n.toolbar-select-container {\n    display: inline-flex;\n    flex-shrink: 0;\n    margin-right: 6px;\n}\n\nselect.toolbar-item {\n    min-width: 38px;\n    -webkit-appearance: none;\n    border: 0;\n    border-radius: 0;\n    padding: 0 13px 0 5px;\n    margin-right: -10px;\n    position: relative;\n    height: 22px;\n    margin-top: 2px;\n    margin-bottom: 2px;\n}\n\nselect.toolbar-item[data-keyboard-focus=\"true\"]:focus {\n    background: rgba(0, 0, 0, 0.08);\n    border-radius: 2px;\n}\n\nselect.toolbar-item[data-keyboard-focus=\"true\"]:focus > * {\n    background: white;\n}\n\n/* Input */\n\n.toolbar-input {\n    width: 120px;\n    height: 19px;\n    padding: 4px 3px 3px 3px;\n    margin: 1px 3px;\n    background-color: white;\n    border: 1px solid transparent ;\n    min-width: 35px;\n}\n\n.toolbar-input:hover {\n    box-shadow: var(--focus-ring-inactive-shadow);\n}\n\n.toolbar-input.focused,\n.toolbar-input:not(.toolbar-input-empty) {\n    box-shadow: var(--focus-ring-active-shadow);\n}\n\n.toolbar-input > input {\n    border: none;\n    flex-grow: 1;\n}\n\n.toolbar-input-clear-button {\n    opacity: 0.7;\n    flex-basis: 13px;\n    flex-shrink: 0;\n    height: 16px;\n}\n\n.toolbar-input-clear-button:hover {\n    opacity: .99;\n}\n\n.toolbar-input-empty .toolbar-input-clear-button {\n    display: none;\n}\n\n.toolbar-prompt-proxy {\n    flex: 1;\n}\n\n.toolbar-input-prompt {\n    flex: 1;\n    overflow: hidden;\n    white-space: nowrap;\n    cursor: auto;\n}\n\n/* Separator */\n\n.toolbar-divider {\n    background-color: #ccc;\n    width: 1px;\n    margin: 5px 4px;\n    height: 16px;\n}\n\n.toolbar-spacer {\n    flex: auto;\n}\n\n/* Long click */\n\n.long-click-glyph {\n    position: absolute;\n    background-color: #5a5a5a;\n    top: 0;\n    left:  0;\n}\n\n.toolbar-button.emulate-active {\n    background-color: rgb(163, 163, 163);\n}\n\n.toolbar-button[data-keyboard-focus=\"true\"]:focus::after {\n    position: absolute;\n    top: 2px;\n    bottom: 2px;\n    left: 2px;\n    right: 2px;\n    background-color: rgba(0, 0, 0, 0.08);\n    border-radius: 2px;\n    content: \"\";\n}\n\n.toolbar-shadow.floating {\n    flex-direction: column;\n    height: auto;\n    background-color: white;\n    border: 1px solid #ccc;\n    margin-top: -1px;\n    width: 28px;\n    left: -2px;\n}\n\ninput[is=history-input] {\n    border: none;\n    line-height: 16px;\n    padding: 1px;\n}\n\ninput[is=history-input]:hover {\n    box-shadow: var(--focus-ring-inactive-shadow);\n}\n\ninput[is=history-input]:focus,\ninput[is=history-input]:not(:placeholder-shown) {\n    box-shadow: var(--focus-ring-active-shadow);\n}\n\n.toolbar-item.warning {\n    background: hsl(0, 100%, 95%);\n}\n\n/*# sourceURL=ui/toolbar.css */";Root.Runtime.cachedResources["ui/suggestBox.css"]="/*\n * Copyright (C) 2011 Google Inc. All rights reserved.\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions are\n * met:\n *\n *     * Redistributions of source code must retain the above copyright\n * notice, this list of conditions and the following disclaimer.\n *     * Redistributions in binary form must reproduce the above\n * copyright notice, this list of conditions and the following disclaimer\n * in the documentation and/or other materials provided with the\n * distribution.\n *     * Neither the name of Google Inc. nor the names of its\n * contributors may be used to endorse or promote products derived from\n * this software without specific prior written permission.\n *\n * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n * \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n\n:host {\n    display: flex;\n    flex: auto;\n}\n\n.suggest-box {\n    flex: auto;\n    background-color: #FFFFFF;\n    pointer-events: auto;\n    margin-left: -3px;\n    box-shadow: var(--drop-shadow);\n    overflow-x: hidden;\n}\n\n.suggest-box-content-item {\n    padding: 1px 0 1px 1px;\n    margin: 0;\n    border: 1px solid transparent;\n    white-space: nowrap;\n    display: flex;\n}\n\n.suggest-box-content-item.secondary {\n    background-color: #f9f9f9;\n}\n\n.suggestion-title {\n    overflow: hidden;\n    text-overflow: ellipsis;\n}\n\n.suggestion-title span {\n    white-space: pre;\n}\n\n.suggestion-subtitle {\n    flex: auto;\n    text-align: right;\n    color: #999;\n    margin-right: 3px;\n    overflow: hidden;\n    text-overflow: ellipsis;\n}\n\n.suggestion-icon {\n    user-select: none;\n    align-self: center;\n    flex-shrink: 0;\n}\n\n.suggest-box-content-item .query {\n    font-weight: bold;\n}\n\n.suggest-box-content-item .spacer {\n    display: inline-block;\n    width: 20px;\n}\n\n.suggest-box-content-item.selected {\n    background-color: var(--selection-bg-color);\n}\n\n.suggest-box-content-item.selected > span {\n    color: var(--selection-fg-color);\n}\n\n.suggest-box-content-item:hover:not(.selected) {\n    background-color: var(--item-hover-color);\n}\n\n/*# sourceURL=ui/suggestBox.css */";Root.Runtime.cachedResources["ui/tabbedPane.css"]="/*\n * Copyright (C) 2006, 2007, 2008 Apple Inc.  All rights reserved.\n * Copyright (C) 2009 Anthony Ricaud <rik@webkit.org>\n * Copyright (C) 2011 Google Inc. All rights reserved.\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions are\n * met:\n *\n * 1. Redistributions of source code must retain the above copyright\n * notice, this list of conditions and the following disclaimer.\n *\n * 2. Redistributions in binary form must reproduce the above\n * copyright notice, this list of conditions and the following disclaimer\n * in the documentation and/or other materials provided with the\n * distribution.\n *\n * THIS SOFTWARE IS PROVIDED BY GOOGLE INC. AND ITS CONTRIBUTORS\n * \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GOOGLE INC.\n * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n\n.tabbed-pane {\n    flex: auto;\n    overflow: hidden;\n}\n\n.tabbed-pane-content {\n    position: relative;\n    overflow: auto;\n    flex: auto;\n    display: flex;\n    flex-direction: column;\n}\n\n.tabbed-pane-content.has-no-tabs {\n    background-color: lightgray;\n}\n\n.tabbed-pane-placeholder {\n    font-size: 14px;\n    text-align: center;\n    width: fit-content;\n    margin: 20px auto 0px;\n    text-shadow: rgba(255, 255, 255, 0.75) 0 1px 0;\n    line-height: 28px;\n    overflow: hidden;\n}\n\n.tabbed-pane-placeholder-row {\n    display: flex;\n    white-space: nowrap;\n}\n\n.tabbed-pane-placeholder-row[data-keyboard-focus=\"true\"]:focus {\n  outline-width: unset;\n}\n\n.tabbed-pane-placeholder-key {\n    flex: 1;\n    text-align: right;\n    padding-right: 14px;\n    overflow: hidden;\n    text-overflow: ellipsis;\n}\n\n.tabbed-pane-no-shortcut {\n  flex: 1;\n  text-align: center;\n}\n\n.tabbed-pane-placeholder-value {\n    flex: 1;\n    text-align: left;\n    padding-left: 14px;\n}\n\n.tabbed-pane-header {\n    display: flex;\n    flex: 0 0 27px;\n    border-bottom: 1px solid #ccc;\n    overflow: visible;\n    width: 100%;\n    background-color: var(--toolbar-bg-color);\n}\n\n.tabbed-pane-header-contents {\n    flex: auto;\n    pointer-events: none;\n    margin-left: 0;\n    position: relative;\n}\n\n.tabbed-pane-header-contents > * {\n    pointer-events: initial;\n}\n\n.tabbed-pane-header-tab-icon {\n    min-width: 14px;\n    display: flex;\n    align-items: center;\n    margin-right: 2px;\n}\n\n.tabbed-pane-header-tab {\n    float: left;\n    padding: 2px 0.8em;\n    height: 26px;\n    line-height: 15px;\n    white-space: nowrap;\n    cursor: default;\n    display: flex;\n    align-items: center;\n    color: #5a5a5a;\n}\n\n.tabbed-pane-header-tab.closeable {\n    padding-right: 4px;\n}\n\n.tabbed-pane-header-tab:hover,\n.tabbed-pane-shadow .tabbed-pane-header-tab[data-keyboard-focus=\"true\"]:focus {\n    color: #333;\n    background-color: var(--toolbar-hover-bg-color);\n}\n\n.tabbed-pane-header-tab-title {\n    text-overflow: ellipsis;\n    overflow: hidden;\n}\n\n.tabbed-pane-header-tab.measuring {\n    visibility: hidden;\n}\n\n.tabbed-pane-header-tab.selected {\n    border-bottom: none;\n}\n\n.tabbed-pane-header-tab.selected {\n    background-color: var(--tab-selected-bg-color);\n    color: var(--tab-selected-fg-color);\n}\n\n.tabbed-pane-header-tab.dragging {\n    position: relative;\n    box-shadow: 0 1px 4px 0 rgba(0, 0, 0, 0.37);\n    background-color: #e5e5e5;\n}\n\n.tabbed-pane-header-tab .tabbed-pane-close-button {\n    margin: 0 -3px 0 4px;\n    visibility: hidden;\n}\n\n.tabbed-pane-header-tab:hover .tabbed-pane-close-button,\n.tabbed-pane-header-tab.selected .tabbed-pane-close-button {\n    visibility: visible;\n}\n\n.tabbed-pane-header-tabs-drop-down-container {\n    float: left;\n    opacity: 0.8;\n    cursor: pointer;\n    display: flex;\n    align-items: center;\n    height: 100%;\n}\n\n.tabbed-pane-header-tabs-drop-down-container > .chevron-icon {\n    background-color: hsla(0,0%,20%,1);\n    display: block;\n}\n\n.tabbed-pane-header-tabs-drop-down-container:hover,\n.tabbed-pane-header-tabs-drop-down-container[data-keyboard-focus=\"true\"]:focus {\n    background-color: rgba(0, 0, 0, 0.08);\n}\n\n.tabbed-pane-header-tabs-drop-down-container.measuring {\n    visibility: hidden;\n}\n\n.tabbed-pane-header-tabs-drop-down-container:active {\n    opacity: 0.8;\n}\n\n/* Web page style */\n\n.tabbed-pane-shadow.vertical-tab-layout {\n    flex-direction: row !important;\n}\n\n.tabbed-pane-shadow.vertical-tab-layout .tabbed-pane-header {\n    background-color: transparent;\n    border: none transparent !important;\n    width: auto;\n    flex: 0 0 auto;\n    flex-direction: column;\n    padding-top: 10px;\n    overflow: hidden;\n}\n\n.tabbed-pane-shadow.vertical-tab-layout .tabbed-pane-content {\n    padding: 10px 10px 10px 0;\n    overflow-x: hidden;\n}\n\n.tabbed-pane-shadow.vertical-tab-layout .tabbed-pane-header-contents {\n    margin: 0;\n    flex: none;\n}\n\n.tabbed-pane-shadow.vertical-tab-layout .tabbed-pane-header-tabs {\n    display: flex;\n    flex-direction: column;\n    width: 120px;\n}\n\n.tabbed-pane-shadow.vertical-tab-layout .tabbed-pane-header-tab {\n    background-color: transparent;\n    border: none transparent;\n    font-weight: normal;\n    text-shadow: none;\n    color: #777;\n    height: 26px;\n    padding-left: 10px;\n    border-left: 6px solid transparent;\n    margin: 0;\n    display: flex;\n    align-items: center;\n}\n\n.tabbed-pane-shadow.vertical-tab-layout .tabbed-pane-header-tab:not(.selected) {\n    cursor: pointer !important;\n}\n\n.tabbed-pane-shadow.vertical-tab-layout .tabbed-pane-header-tab.selected {\n    color: inherit;\n    border: none transparent;\n    border-left: 6px solid #666;\n}\n\n.tabbed-pane-tab-slider {\n    height: 2px;\n    position: absolute;\n    bottom: -1px;\n    background-color: var(--accent-color);\n    left: 0;\n    z-index: 50;\n    transform-origin: 0 100%;\n    transition: transform 150ms cubic-bezier(0, 0, 0.2, 1);\n    visibility: hidden;\n}\n\n:host-context(.-theme-with-dark-background) .tabbed-pane-tab-slider {\n    display: none;\n}\n\n@media (-webkit-min-device-pixel-ratio: 1.1) {\n    .tabbed-pane-tab-slider {\n        border-top: none;\n    }\n}\n\n.tabbed-pane-tab-slider.enabled {\n    visibility: visible;\n}\n\n.tabbed-pane-header-tab.disabled {\n    opacity: 0.5;\n    pointer-events: none;\n}\n\n.tabbed-pane-left-toolbar {\n    margin-right: -4px;\n    flex: none;\n}\n\n.tabbed-pane-right-toolbar {\n    margin-left: -4px;\n    flex: none;\n}\n\n/*# sourceURL=ui/tabbedPane.css */";Root.Runtime.cachedResources["ui/targetCrashedScreen.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.widget {\n    padding: 25px;\n}\n\n.message {\n    font-size: larger;\n    white-space: pre;\n    margin: 5px;\n}\n\n/*# sourceURL=ui/targetCrashedScreen.css */";Root.Runtime.cachedResources["ui/textButton.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.text-button {\n    margin: 2px;\n    height: 24px;\n    font-size: 12px;\n    border: 1px solid rgba(0, 0, 0, 0.2);\n    border-radius: 4px;\n    padding: 0px 12px;\n    font-weight: 500;\n    color: var(--accent-fg-color);\n    background-color: #fff;\n    flex: none;\n    white-space: nowrap;\n}\n\n.text-button:not(:disabled):focus,\n.text-button:not(:disabled):hover,\n.text-button:not(:disabled):active {\n    background-color: var(--toolbar-bg-color);\n    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);\n    cursor: pointer;\n}\n\n.text-button:not(:disabled):active {\n    background-color: #f2f2f2;\n}\n\n.text-button:not(:disabled):focus {\n    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1), 0 0 0 2px rgba(66, 133, 244, 0.4);\n}\n\n.text-button:disabled {\n    opacity: 0.38;\n}\n\n.text-button.primary-button, -theme-preserve {\n    background-color: var(--accent-color);\n    border: none;\n    color: #fff;\n}\n\n.text-button.link-style {\n  background: none;\n  border: none;\n  padding: 0!important;\n  font: inherit;\n  cursor: pointer;\n  height: 18px;\n}\n\n.text-button.primary-button:not(:disabled):focus,\n.text-button.primary-button:not(:disabled):hover,\n.text-button.primary-button:not(:disabled):active, -theme-preserve {\n    background-color: var(--accent-color-hover);\n}\n\n.-theme-with-dark-background .text-button:not(.primary-button):not(:disabled):focus,\n.-theme-with-dark-background .text-button:not(.primary-button):not(:disabled):hover,\n.-theme-with-dark-background .text-button:not(.primary-button):not(:disabled):active {\n    background-color: #313131;\n    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);\n}\n\n.-theme-with-dark-background .text-button:not(.primary-button):not(:disabled):focus {\n    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1), 0 0 0 2px rgba(94, 151, 246, 0.6);\n}\n\n.-theme-with-dark-background .text-button:not(.primary-button):not(:disabled):active {\n    background-color: #3e3e3e;\n}\n\n/*# sourceURL=ui/textButton.css */";Root.Runtime.cachedResources["ui/textPrompt.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n .text-prompt-root {\n    display: flex;\n    align-items: center;\n}\n\n.text-prompt-editing {\n    box-shadow: var(--drop-shadow);\n    background-color: white;\n    text-overflow: clip !important;\n    padding-left: 2px;\n    margin-left: -2px;\n    padding-right: 2px;\n    margin-right: -2px;\n    margin-bottom: -1px;\n    padding-bottom: 1px;\n    opacity: 1.0 !important;\n}\n\n.text-prompt-editing > .text-prompt {\n    color: #222 !important;\n    text-decoration: none !important;\n    white-space: pre;\n}\n\n.text-prompt > .auto-complete-text {\n    color: rgb(128, 128, 128) !important;\n}\n\n.text-prompt[data-placeholder]:empty::before {\n    content: attr(data-placeholder);\n    color: rgb(128, 128, 128);\n}\n\n.text-prompt:not([data-placeholder]):empty::after {\n    content: '\\00A0';\n    width: 0;\n    display: block;\n}\n\n.text-prompt {\n    cursor: text;\n    overflow-x: visible;\n}\n\n.text-prompt::-webkit-scrollbar {\n    display: none;\n}\n\n.text-prompt.disabled {\n    opacity: 0.5;\n    cursor: default;\n}\n\n.text-prompt-editing br {\n    display: none;\n}\n\n.text-prompt-root:not(:focus-within) ::selection {\n    background: transparent;\n}\n\n/*# sourceURL=ui/textPrompt.css */";Root.Runtime.cachedResources["ui/tooltip.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.tooltip {\n    background: hsl(0, 0%, 95%);\n    border-radius: 2px;\n    color: hsl(0, 0%, 20%);\n    padding: 5px 8px;\n    line-height: 14px;\n    display: flex;\n    align-items: center;\n    -webkit-filter: drop-shadow(0 1px 2px hsla(0, 0%, 0%, 0.3));\n    border: 1px solid hsla(0, 0%, 0%, 0.1);\n    background-clip: padding-box;\n    box-sizing: border-box;\n    position: absolute;\n    visibility: hidden;\n    transition: visibility 0s 100ms, opacity 150ms cubic-bezier(0, 0, .2, 1);\n    z-index: 20001;\n    top: 0;\n    left: 0;\n    opacity: 0;\n    text-overflow: ellipsis;\n    overflow: hidden;\n    pointer-events: none;\n}\n\n.tooltip-breakword {\n    word-break: break-word;\n}\n\n.tooltip.shown {\n    visibility: visible;\n    transition-delay: 600ms;\n    opacity: 1;\n}\n\n.tooltip.shown.instant {\n    transition-delay: 0s;\n}\n\n.tooltip-shortcut {\n    color: hsl(0, 0%, 45%);\n    display: inline-block;\n    margin-left: 8px;\n    flex: 0 0 auto;\n}\n\n/*# sourceURL=ui/tooltip.css */";Root.Runtime.cachedResources["ui/treeoutline.css"]="/*\n * Copyright 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n    flex: 1 1 auto;\n    padding: 2px 0 0 0;\n}\n\n.tree-outline-disclosure:not(.tree-outline-disclosure-hide-overflow) {\n    min-width: 100%;\n    display: inline-block;\n}\n\n.tree-outline {\n    padding: 0 0 4px 4px;\n    margin: 0;\n    z-index: 0;\n    position: relative;\n}\n\n.tree-outline:not(.hide-selection-when-blurred) li.hovered:not(.selected) .selection {\n    display: block;\n    left: 3px;\n    right: 3px;\n    background-color: var(--item-hover-color);\n    border-radius: 5px;\n}\n\n.tree-outline li .selection {\n    display: none;\n    z-index: -1;\n    margin-left: -10000px;\n}\n\n.tree-outline:not(.hide-selection-when-blurred) li.selected {\n    color: var(--selection-inactive-fg-color);\n}\n\n.tree-outline:not(.hide-selection-when-blurred) li.selected .selection {\n    display: block;\n    background-color: var(--selection-inactive-bg-color);\n}\n\n.tree-outline:not(.hide-selection-when-blurred) li.in-clipboard .highlight {\n    outline: 1px dotted darkgrey;\n}\n\n.tree-outline:not(.hide-selection-when-blurred) li.elements-drag-over .selection {\n    display: block;\n    margin-top: -2px;\n    border-top: 2px solid;\n    border-top-color: var(--selection-bg-color);\n}\n\nol.tree-outline:not(.hide-selection-when-blurred) li.selected:focus .selection {\n    background-color: var(--selection-bg-color);\n}\n\nol.tree-outline:not(.hide-selection-when-blurred) li.parent.selected:focus::before {\n    background-color: var(--selection-fg-color);\n}\n\nol.tree-outline,\n.tree-outline ol {\n    list-style-type: none;\n}\n\n.tree-outline ol {\n    padding-left: 12px;\n}\n\n.tree-outline li {\n    text-overflow: ellipsis;\n    white-space: nowrap;\n    position: relative;\n    display: flex;\n    align-items: center;\n    min-height: 16px;\n}\n\nol.tree-outline:not(.hide-selection-when-blurred) li.selected:focus {\n    color: var(--selection-fg-color);\n}\n\nol.tree-outline:not(.hide-selection-when-blurred) li.selected:focus * {\n    color: inherit;\n}\n\n.tree-outline li .icons-container {\n    align-self: center;\n    display: flex;\n    align-items: center;\n}\n\n.tree-outline li .leading-icons {\n    margin-right: 4px;\n}\n\n.tree-outline li .trailing-icons {\n    margin-left: 4px;\n}\n\n.tree-outline li::before {\n    -webkit-user-select: none;\n    -webkit-mask-image: url(Images/treeoutlineTriangles.svg);\n    -webkit-mask-size: 32px 24px;\n    content: \"\\00a0\\00a0\";\n    text-shadow: none;\n    margin-right: -2px;\n    height: 12px;\n    width: 13px;\n}\n\n.tree-outline li:not(.parent)::before {\n    background-color: transparent;\n}\n\n.tree-outline li::before {\n    -webkit-mask-position: 0 0;\n    background-color: #727272;\n}\n\n.tree-outline li.parent.expanded::before {\n    -webkit-mask-position: -16px 0;\n}\n\n.tree-outline ol.children {\n    display: none;\n}\n\n.tree-outline ol.children.expanded {\n    display: block;\n}\n\n.tree-outline.tree-outline-dense li {\n    margin-top: 1px;\n    min-height: 12px;\n}\n\n.tree-outline.tree-outline-dense li.parent {\n    margin-top: 0;\n}\n\n.tree-outline.tree-outline-dense li.parent::before {\n    top: 0;\n}\n\n.tree-outline.tree-outline-dense ol {\n    padding-left: 10px;\n}\n\n.tree-outline.hide-selection-when-blurred .selected:focus[data-keyboard-focus=\"true\"] {\n    background: var(--focus-bg-color);\n    border-radius: 2px;\n}\n\n.tree-outline-disclosure:not(.tree-outline-disclosure-hide-overflow) .tree-outline.hide-selection-when-blurred .selected:focus[data-keyboard-focus=\"true\"] {\n    width: fit-content;\n    padding-right: 3px;\n}\n\n/*# sourceURL=ui/treeoutline.css */";Root.Runtime.cachedResources["ui/viewContainers.css"]="/*\n * Copyright (C) 2006, 2007, 2008 Apple Inc.  All rights reserved.\n * Copyright (C) 2009 Anthony Ricaud <rik@webkit.org>\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions\n * are met:\n *\n * 1.  Redistributions of source code must retain the above copyright\n *     notice, this list of conditions and the following disclaimer.\n * 2.  Redistributions in binary form must reproduce the above copyright\n *     notice, this list of conditions and the following disclaimer in the\n *     documentation and/or other materials provided with the distribution.\n * 3.  Neither the name of Apple Computer, Inc. (\"Apple\") nor the names of\n *     its contributors may be used to endorse or promote products derived\n *     from this software without specific prior written permission.\n *\n * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS \"AS IS\" AND ANY\n * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY\n * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\n * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\n * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF\n * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n\n.expandable-view-title {\n    display: flex;\n    align-items: center;\n    background-color: var(--toolbar-bg-color);\n    height: 22px;\n    padding: 0 5px;\n    border-top: var(--divider-border);\n    white-space: nowrap;\n    overflow: hidden;\n    position: relative;\n    border-bottom: 1px solid transparent;\n}\n\n.expandable-view-title.expanded,\n.expandable-view-title:last-child {\n    border-bottom: 1px solid #ddd;\n}\n\n.expandable-view-title .toolbar {\n    margin-top: -3px;\n}\n\n.expandable-view-title:not(.expanded) .toolbar {\n    display: none;\n}\n\n.title-expand-icon {\n    margin-right: 2px;\n    margin-bottom: -2px;\n}\n\n.expandable-view-title[data-keyboard-focus=\"true\"]:focus {\n    background-color: #e0e0e0;\n}\n\n.expandable-view-title > .toolbar {\n    position: absolute;\n    right: 0;\n    top: 0;\n}\n\n\n/*# sourceURL=ui/viewContainers.css */";Root.Runtime.cachedResources["components/imagePreview.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.image-preview-container {\n    background: transparent;\n    text-align: center;\n    border-spacing: 0;\n}\n\n.image-preview-container img {\n    margin: 2px auto;\n    max-width: 100px;\n    max-height: 100px;\n    background-image: url(Images/checker.png);\n    -webkit-user-select: text;\n    -webkit-user-drag: auto;\n}\n\n.image-container {\n    padding: 0;\n}\n\n/*# sourceURL=components/imagePreview.css */";Root.Runtime.cachedResources["components/jsUtils.css"]="/*\n * Copyright 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n  display: inline;\n}\n\n.stack-preview-async-description {\n    padding: 3px 0 1px;\n    font-style: italic;\n}\n\n.stack-preview-container .webkit-html-blackbox-link {\n    opacity: 0.6;\n}\n\n.stack-preview-container > tr {\n    height: 16px;\n    line-height: 16px;\n}\n\n.stack-preview-container td {\n    white-space: nowrap;\n    overflow: hidden;\n    text-overflow: ellipsis;\n}\n\n.stack-preview-container .function-name {\n    max-width: 80em;\n}\n\n.stack-preview-container:not(.show-blackboxed) > tr.blackboxed {\n    display: none;\n}\n\n.stack-preview-container.show-blackboxed > tr.show-blackboxed-link {\n    display: none;\n}\n\n.stack-preview-container > tr.show-blackboxed-link {\n    font-style: italic;\n}\n\n/*# sourceURL=components/jsUtils.css */";Root.Runtime.cachedResources["persistence/editFileSystemView.css"]="/*\n * Copyright 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.file-system-header {\n    display: flex;\n    flex-direction: row;\n    align-items: center;\n    flex: auto;\n    margin: 10px 0;\n}\n\n.file-system-header-text {\n    flex: 1 0 auto;\n}\n\n.add-button {\n    margin-left: 10px;\n    align-self: flex-start;\n}\n\n.file-system-list {\n    flex: auto;\n}\n\n.file-system-list-empty {\n    flex: auto;\n    height: 30px;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    text-align: center;\n}\n\n.file-system-list-item {\n    padding: 3px 5px 3px 5px;\n    height: 30px;\n    display: flex;\n    align-items: center;\n    flex: auto 1 1;\n}\n\n.list-item .file-system-value {\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    -webkit-user-select: none;\n    overflow: hidden;\n}\n\n.file-system-value {\n    flex: 1 1 0px;\n}\n\n.file-system-edit-row {\n    flex: none;\n    display: flex;\n    flex-direction: row;\n    margin: 6px 5px;\n    align-items: center;\n}\n\n.file-system-edit-row input {\n    width: 100%;\n    text-align: inherit;\n}\n\n/*# sourceURL=persistence/editFileSystemView.css */";Root.Runtime.cachedResources["persistence/workspaceSettingsTab.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\nheader {\n    padding: 0 0 6px;\n    border-bottom: 1px solid #EEEEEE;\n}\n\nheader > h1 {\n    font-size: 18px;\n    font-weight: normal;\n    margin: 0;\n    padding-bottom: 3px;\n}\n\n.settings-content {\n    overflow-y: auto;\n    overflow-x: hidden;\n    margin: 8px 8px 8px 0;\n    padding: 0 4px;\n    flex: auto;\n}\n\n.settings-container {\n    width: 100%;\n    -webkit-column-width: 288px;\n}\n\n\n.settings-tab.settings-container {\n    -webkit-column-width: 308px;\n}\n\n.settings-tab label {\n    padding-right: 4px;\n    display: inline-flex;\n}\n\n.settings-container-wrapper {\n    position: absolute;\n    top: 31px;\n    left: 0px;\n    right: 0;\n    bottom: 0;\n    overflow: auto;\n    padding-top: 9px;\n}\n\n.settings-tab.settings-content {\n    margin: 0;\n    padding: 0;\n}\n\n.settings-tab p {\n    margin: 12px 0;\n}\n\np.folder-exclude-pattern {\n    display: flex;\n    align-items: center;\n}\n\np.folder-exclude-pattern > input {\n    flex: auto;\n}\n\n.settings-tab .file-system-container {\n    border-top: 1px solid #aaa;\n    padding: 19px 0 10px;\n    margin: 20px 0;\n}\n\n.settings-tab .file-system-header {\n    display: flex;\n    flex-direction: row;\n    align-items: center;\n}\n\n.settings-tab .file-system-name {\n    font-weight: bold;\n    flex: none;\n    margin-right: 10px;\n    font-size: 15px;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    max-width: 70%;\n}\n\n.settings-tab .file-system-path {\n    white-space: nowrap;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    flex: auto;\n}\n\n.settings-info-message {\n    background-color: #eee;\n    padding: 10px;\n    margin: 20px 0;\n}\n\n.settings-tab.settings-content.settings-container {\n    -webkit-column-width: initial;\n    overflow: hidden;\n    padding-right: 10px;\n}\n\n/*# sourceURL=persistence/workspaceSettingsTab.css */";Root.Runtime.cachedResources["product_registry/badge.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.product-registry-badge {\n  background-color: rgba(0, 0, 0, 0.2);\n  border-radius: 2px;\n  padding: 1px 2px;\n  white-space: pre;\n  cursor: pointer;\n}\n\n.product-registry-badge::before {\n  content: attr(data-initial);\n  color: #222;\n}\n\n.hide-badge-title .product-registry-badge-title {\n  display: none;\n}\n\n:host-context(.-theme-with-dark-background) .product-registry-badge::before {\n  color: #000;\n}\n\n.product-registry-badge-title {\n  padding-left: 4px;\n}\n\n/*# sourceURL=product_registry/badge.css */";Root.Runtime.cachedResources["product_registry/popup.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.product-registry-popup {\n    background-color: white;\n    padding: 15px 45px 15px 15px;\n    border-radius: 4px;\n    white-space: nowrap;\n    box-shadow: 0px 1px 2px 0px gray;\n}\n\n.product-registry-domain {\n    font-weight: bold;\n}\n\n.product-registry-name {\n    padding: 10px 0;\n}\n\n.product-registry-link {\n    display: block;\n}\n\ndiv[is=dt-close-button] {\n  position: absolute;\n  top: 5px;\n  right: 5px;\n}\n\n/*# sourceURL=product_registry/popup.css */";Root.Runtime.cachedResources["console_counters/errorWarningCounter.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n    cursor: pointer;\n    padding: 0 2px;\n    min-width: 26px;\n}\n\n:host:hover {\n    color: #333;\n}\n\n.counter-item {\n    margin-left: 6px;\n}\n\n.counter-item.counter-item-first {\n    margin-left: 0;\n}\n\n/*# sourceURL=console_counters/errorWarningCounter.css */";