/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.Timer;

public class MemoryMonitor {
    private Timer timer;
    private JLabel label = new JLabel();
    private long totalMemory = 0L;
    private long freeMemory = 0L;
    private long usedMemory = 0L;
    private MouseAdapter gcMouseEvent = new MouseAdapter(){

        @Override
        @SuppressWarnings(value={"DM_GC"}, justification="Used as a debugging tool")
        public void mousePressed(MouseEvent e) {
            System.gc();
        }
    };

    public MemoryMonitor() {
        this.timer = new Timer(1000, new MemoryUsageListener());
        this.label.addMouseListener(this.gcMouseEvent);
    }

    public void start() {
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
    }

    public JLabel getLabel() {
        return this.label;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public String toString() {
        return "MemoryMonitor Status: Total:" + this.totalMemory + "; Used:" + this.usedMemory + "; Free:" + this.freeMemory;
    }

    private class MemoryUsageListener
    implements ActionListener {
        private MemoryUsageListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            long megabyte = 0x100000L;
            MemoryMonitor.this.totalMemory = Runtime.getRuntime().totalMemory() / megabyte;
            MemoryMonitor.this.freeMemory = Runtime.getRuntime().freeMemory() / megabyte;
            MemoryMonitor.this.usedMemory = MemoryMonitor.this.totalMemory - MemoryMonitor.this.freeMemory;
            MemoryMonitor.this.label.setText(MemoryMonitor.this.usedMemory + "M/" + MemoryMonitor.this.totalMemory + "M");
        }
    }
}

