/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.codelinks;

import com.almworks.tracklink.util.Utils;
import com.almworks.util.Log;
import com.almworks.util.PatternInversion;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.search.IndexPattern;
import com.intellij.util.xmlb.annotations.Property;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class CodeLinkType
extends IndexPattern {
    @Property
    private String myReplacePattern;
    private transient boolean myInverseDone;
    private transient Pattern myInversePattern;
    private transient String myInverseReplacement;

    public CodeLinkType() {
        this("", "");
    }

    public CodeLinkType(@NotNull String searchPattern, @NotNull String replacePattern) {
        if (searchPattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/codelinks/CodeLinkType.<init> must not be null");
        }
        if (replacePattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/almworks/tracklink/codelinks/CodeLinkType.<init> must not be null");
        }
        super(searchPattern, true);
        this.myInverseDone = false;
        this.myInversePattern = null;
        this.myInverseReplacement = null;
        this.setReplacePattern(replacePattern);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getReplacePattern() {
        String string = this.myReplacePattern;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/codelinks/CodeLinkType.getReplacePattern must not return null");
        }
        return string;
    }

    public void setReplacePattern(String replacePattern) {
        assert (replacePattern != null);
        this.myReplacePattern = replacePattern;
        this.myInverseDone = false;
    }

    public void setPatternString(String patternString) {
        super.setPatternString(patternString);
        this.myInverseDone = false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CodeLinkType)) {
            return false;
        }
        CodeLinkType type = (CodeLinkType)((Object)obj);
        return Utils.equals(type.getPatternString(), this.getPatternString()) && Utils.equals(type.getReplacePattern(), this.getReplacePattern());
    }

    public int hashCode() {
        int result = 29 * super.hashCode() + Comparing.hashcode((Object)this.getPatternString());
        result = 29 * result + Comparing.hashcode((Object)this.myReplacePattern);
        return result;
    }

    public String toString() {
        return "CodeLinkType{pattern=[" + this.getPatternString() + "], url=[" + this.myReplacePattern + "]}";
    }

    public synchronized String getVisualID(String url) {
        if (!this.myInverseDone) {
            try {
                this.myInversePattern = null;
                this.myInverseReplacement = null;
                PatternInversion inversion = new PatternInversion(this.getPatternString(), this.getReplacePattern());
                inversion.invert();
                try {
                    this.myInversePattern = Pattern.compile(inversion.getInvertedPattern());
                    this.myInverseReplacement = inversion.getInvertedReplacement();
                }
                catch (Exception e) {
                    Log.warn("bad result of pattern inversion (" + inversion.getInvertedPattern() + ")");
                }
            }
            catch (PatternInversion.InversionImpossibleException e) {
                // empty catch block
            }
        }
        if (this.myInversePattern == null || this.myInverseReplacement == null) {
            return null;
        }
        Matcher matcher = this.myInversePattern.matcher(url);
        if (matcher.matches()) {
            return matcher.replaceAll(this.myInverseReplacement);
        }
        return null;
    }
}

