(declare (block) (standard-bindings) (extended-bindings))
(begin
  (declare (not safe))
  (define std/actor/rpc/proto/cipher#::digest-type
    std/crypto/digest#digest::sha256)
  (define std/actor/rpc/proto/cipher#::digest-size
    (std/crypto/digest#digest-size std/actor/rpc/proto/cipher#::digest-type))
  (define std/actor/rpc/proto/cipher#::cipher-type
    std/crypto/cipher#cipher::aes-128-cbc)
  (define std/actor/rpc/proto/cipher#::cipher-key-length
    (std/crypto/cipher#cipher-key-length
     std/actor/rpc/proto/cipher#::cipher-type))
  (define std/actor/rpc/proto/cipher#::cipher-iv-length
    (std/crypto/cipher#cipher-iv-length
     std/actor/rpc/proto/cipher#::cipher-type))
  (define std/actor/rpc/proto/cipher#::cipher-block-size
    (std/crypto/cipher#cipher-block-size
     std/actor/rpc/proto/cipher#::cipher-type))
  (define std/actor/rpc/proto/cipher#::DH::new std/crypto/dh#DH-get-1024-160)
  (define std/actor/rpc/proto/cipher#rpc-cipher-proto-key-exchange
    (lambda (_ibuf203881_ _obuf203882_)
      (let* ((_dh203884_ (std/actor/rpc/proto/cipher#::DH::new))
             (_g203908_ (std/crypto/dh#DH-generate-key _dh203884_))
             (_pubk203887_ (std/crypto/libcrypto#DH_pub_key _dh203884_))
             (_bytes203889_ (std/crypto/bn#BN->bytes _pubk203887_)))
        (std/net/bio/output#bio-write-u8
         std/actor/rpc/proto/message#rpc-proto-key-exchange
         _obuf203882_)
        (std/net/bio/output#bio-write-u32
         (u8vector-length _bytes203889_)
         _obuf203882_)
        (std/net/bio/output#bio-write-bytes _bytes203889_ _obuf203882_)
        (std/net/bio/output#bio-force-output _obuf203882_)
        (let ((_e203892_ (std/net/bio/input#bio-read-u8 _ibuf203881_)))
          (if (eq? _e203892_
                   std/actor/rpc/proto/message#rpc-proto-key-exchange)
              (let* ((_sz203894_ (std/net/bio/input#bio-read-u32 _ibuf203881_))
                     (_g203909_
                      (if (fx> _sz203894_ '1024)
                          (std/actor/proto#raise-rpc-io-error
                           'rpc-proto-key-exchange
                           '"inordinately sized key"
                           _sz203894_)
                          '#!void))
                     (_bytes203897_ (make-u8vector _sz203894_))
                     (_g203910_
                      (std/net/bio/input#bio-read-bytes
                       _bytes203897_
                       _ibuf203881_))
                     (_peerk203900_
                      (std/crypto/bn#bytes->BN__0 _bytes203897_)))
                (std/crypto/dh#DH-compute-key _dh203884_ _peerk203900_))
              (if (eof-object? _e203892_)
                  (std/actor/proto#raise-rpc-io-error
                   'rpc-proto-key-exchange
                   '"connection closed")
                  (std/actor/proto#raise-rpc-io-error
                   'rpc-proto-key-exchange
                   '"key exchange error"
                   _e203892_)))))))
  (define std/actor/rpc/proto/cipher#rpc-cipher-proto-read-e
    (lambda (_secret203867_)
      (let ((_key203869_
             (subu8vector
              _secret203867_
              '0
              std/actor/rpc/proto/cipher#::cipher-key-length))
            (_hmac203870_
             (make-u8vector std/actor/rpc/proto/cipher#::digest-size))
            (_iv203871_
             (make-u8vector std/actor/rpc/proto/cipher#::cipher-iv-length))
            (_ctext203872_ (box (make-u8vector '4096))))
        (lambda (_g203873203876_ _g203874203878_)
          (std/actor/rpc/proto/cipher#rpc-cipher-proto-read
           _g203873203876_
           _g203874203878_
           _secret203867_
           _key203869_
           _hmac203870_
           _iv203871_
           _ctext203872_)))))
  (define std/actor/rpc/proto/cipher#rpc-cipher-proto-read
    (lambda (_ibuf203828_
             _bytes203829_
             _secret203830_
             _key203831_
             _hmac203832_
             _iv203833_
             _ctext203834_)
      (let ((_e203836_ (std/net/bio/input#bio-read-u8 _ibuf203828_)))
        (if (eq? _e203836_ std/actor/rpc/proto/message#rpc-proto-message)
            (let* ((_digest203838_
                    (let ((__obj203902
                           (make-object std/crypto/digest#digest::t '2)))
                      (std/crypto/digest#digest:::init!
                       __obj203902
                       std/actor/rpc/proto/cipher#::digest-type)
                      __obj203902))
                   (_cipher203840_
                    (let ((__obj203903
                           (make-object std/crypto/cipher#cipher::t '2)))
                      (std/crypto/cipher#cipher:::init!
                       __obj203903
                       std/actor/rpc/proto/cipher#::cipher-type)
                      __obj203903))
                   (_g203911_
                    (std/net/bio/input#bio-read-bytes
                     _hmac203832_
                     _ibuf203828_))
                   (_g203912_
                    (std/net/bio/input#bio-read-bytes _iv203833_ _ibuf203828_))
                   (_size203844_ (std/net/bio/input#bio-read-u32 _ibuf203828_))
                   (_g203913_
                    (if (fx<= _size203844_
                              std/actor/rpc/proto/message#rpc-proto-message-max-length)
                        '#!void
                        (std/actor/proto#raise-rpc-io-error
                         'rpc-proto-read
                         '"message too large"
                         _size203844_)))
                   (_ctext203851_
                    (let ((_buf203847_ (unbox _ctext203834_)))
                      (if (fx< (u8vector-length _buf203847_) _size203844_)
                          (let ((_buf203849_ (make-u8vector _size203844_)))
                            (set-box! _ctext203834_ _buf203849_)
                            _buf203849_)
                          _buf203847_)))
                   (_rd203853_
                    (std/net/bio/input#bio-read-subu8vector-unbuffered
                     _ctext203851_
                     '0
                     _size203844_
                     _ibuf203828_))
                   (_g203914_
                    (if (fx< _rd203853_ _size203844_)
                        (std/actor/proto#raise-rpc-io-error
                         'rpc-proto-read
                         '"incomplete message"
                         _rd203853_
                         _size203844_)
                        '#!void))
                   (_g203915_
                    (std/crypto/digest#digest-update!__0
                     _digest203838_
                     _secret203830_))
                   (_g203916_
                    (std/crypto/digest#digest-update!__0
                     _digest203838_
                     _iv203833_))
                   (_g203917_
                    (std/crypto/digest#digest-update!__%
                     _digest203838_
                     _ctext203851_
                     '0
                     _size203844_))
                   (_hmac*203859_
                    (std/crypto/digest#digest-final!__0 _digest203838_))
                   (_g203918_
                    (if (equal? _hmac203832_ _hmac*203859_)
                        '#!void
                        (std/actor/proto#raise-rpc-io-error
                         'rpc-proto-read
                         '"HMAC failure")))
                   (_bytes203862_
                    (if (fx< (u8vector-length _bytes203829_) _size203844_)
                        (make-u8vector _size203844_)
                        _bytes203829_))
                   (_len203864_
                    (std/crypto/cipher#decrypt-u8vector!
                     _cipher203840_
                     _key203831_
                     _iv203833_
                     _ctext203851_
                     '0
                     _size203844_
                     _bytes203862_)))
              (values _bytes203862_ _len203864_))
            (if (eq? _e203836_
                     std/actor/rpc/proto/message#rpc-proto-keep-alive)
                '#!void
                (if (eof-object? _e203836_)
                    _e203836_
                    (std/actor/proto#raise-rpc-io-error
                     'rpc-proto-read
                     '"bad message"
                     _e203836_)))))))
  (define std/actor/rpc/proto/cipher#rpc-cipher-proto-write-e
    (lambda (_secret203815_)
      (let ((_key203817_
             (subu8vector
              _secret203815_
              '0
              std/actor/rpc/proto/cipher#::cipher-key-length))
            (_iv203818_
             (make-u8vector std/actor/rpc/proto/cipher#::cipher-iv-length))
            (_ctext203819_ (box (make-u8vector '4096))))
        (lambda (_g203820203823_ _g203821203825_)
          (std/actor/rpc/proto/cipher#rpc-cipher-proto-write
           _g203820203823_
           _g203821203825_
           _secret203815_
           _key203817_
           _iv203818_
           _ctext203819_)))))
  (define std/actor/rpc/proto/cipher#rpc-cipher-proto-write
    (lambda (_obuf203750_
             _obj203751_
             _secret203752_
             _key203753_
             _iv203754_
             _ctext203755_)
      (if (eq? _obj203751_ '#!void)
          (begin
            (std/net/bio/output#bio-write-u8
             std/actor/rpc/proto/message#rpc-proto-keep-alive
             _obuf203750_)
            (std/net/bio/output#bio-force-output _obuf203750_))
          (if (u8vector? _obj203751_)
              (begin
                (std/net/bio/output#bio-write-u8
                 std/actor/rpc/proto/message#rpc-proto-message
                 _obuf203750_)
                (let* ((_digest203757_
                        (let ((__obj203904
                               (make-object std/crypto/digest#digest::t '2)))
                          (std/crypto/digest#digest:::init!
                           __obj203904
                           std/actor/rpc/proto/cipher#::digest-type)
                          __obj203904))
                       (_cipher203759_
                        (let ((__obj203905
                               (make-object std/crypto/cipher#cipher::t '2)))
                          (std/crypto/cipher#cipher:::init!
                           __obj203905
                           std/actor/rpc/proto/cipher#::cipher-type)
                          __obj203905))
                       (_g203919_ (std/crypto/etc#random-bytes!__0 _iv203754_))
                       (_plen203762_ (u8vector-length _obj203751_))
                       (_maxlen203764_
                        (fx+ _plen203762_
                             std/actor/rpc/proto/cipher#::cipher-block-size))
                       (_ctext203770_
                        (let ((_buf203766_ (unbox _ctext203755_)))
                          (if (fx< (u8vector-length _buf203766_)
                                   _maxlen203764_)
                              (let ((_buf203768_
                                     (make-u8vector _maxlen203764_)))
                                (set-box! _ctext203755_ _buf203768_)
                                _buf203768_)
                              _buf203766_)))
                       (_clen203772_
                        (std/crypto/cipher#encrypt-u8vector!
                         _cipher203759_
                         _key203753_
                         _iv203754_
                         _obj203751_
                         '0
                         _plen203762_
                         _ctext203770_))
                       (_g203920_
                        (std/crypto/digest#digest-update!__0
                         _digest203757_
                         _secret203752_))
                       (_g203921_
                        (std/crypto/digest#digest-update!__0
                         _digest203757_
                         _iv203754_))
                       (_g203922_
                        (std/crypto/digest#digest-update!__%
                         _digest203757_
                         _ctext203770_
                         '0
                         _clen203772_))
                       (_hmac203777_
                        (std/crypto/digest#digest-final!__0 _digest203757_)))
                  (std/net/bio/output#bio-write-bytes
                   _hmac203777_
                   _obuf203750_)
                  (std/net/bio/output#bio-write-bytes _iv203754_ _obuf203750_)
                  (std/net/bio/output#bio-write-u32 _clen203772_ _obuf203750_)
                  (std/net/bio/output#bio-write-subu8vector
                   _ctext203770_
                   '0
                   _clen203772_
                   _obuf203750_)
                  (std/net/bio/output#bio-force-output _obuf203750_)))
              (if (##structure-instance-of?
                   _obj203751_
                   'std/net/bio/buffer#chunked-output-buffer::t)
                  (begin
                    (std/net/bio/output#bio-write-u8
                     std/actor/rpc/proto/message#rpc-proto-message
                     _obuf203750_)
                    (let* ((_digest203780_
                            (let ((__obj203906
                                   (make-object
                                    std/crypto/digest#digest::t
                                    '2)))
                              (std/crypto/digest#digest:::init!
                               __obj203906
                               std/actor/rpc/proto/cipher#::digest-type)
                              __obj203906))
                           (_cipher203782_
                            (let ((__obj203907
                                   (make-object
                                    std/crypto/cipher#cipher::t
                                    '2)))
                              (std/crypto/cipher#cipher:::init!
                               __obj203907
                               std/actor/rpc/proto/cipher#::cipher-type)
                              __obj203907))
                           (_g203923_
                            (std/crypto/etc#random-bytes!__0 _iv203754_))
                           (_plen203785_
                            (std/net/bio/buffer#chunked-output-length
                             _obj203751_))
                           (_chunks203787_
                            (std/net/bio/buffer#chunked-output-chunks
                             _obj203751_))
                           (_maxlen203789_
                            (fx+ _plen203785_
                                 std/actor/rpc/proto/cipher#::cipher-block-size))
                           (_ctext203795_
                            (let ((_buf203791_ (unbox _ctext203755_)))
                              (if (fx< (u8vector-length _buf203791_)
                                       _maxlen203789_)
                                  (let ((_buf203793_
                                         (make-u8vector _maxlen203789_)))
                                    (set-box! _ctext203755_ _buf203793_)
                                    _buf203793_)
                                  _buf203791_)))
                           (_g203924_
                            (std/crypto/cipher#encrypt-init!
                             _cipher203782_
                             _key203753_
                             _iv203754_))
                           (_clen203803_
                            (foldl1 (lambda (_chunk203798_ _r203799_)
                                      (let ((_count203801_
                                             (std/crypto/cipher#encrypt-update!
                                              _cipher203782_
                                              _ctext203795_
                                              _r203799_
                                              _chunk203798_
                                              '0
                                              (u8vector-length
                                               _chunk203798_))))
                                        (fx+ _r203799_ _count203801_)))
                                    '0
                                    _chunks203787_))
                           (_flen203805_
                            (std/crypto/cipher#encrypt-final!__%
                             _cipher203782_
                             _ctext203795_
                             _clen203803_))
                           (_clen203807_ (fx+ _clen203803_ _flen203805_))
                           (_g203925_
                            (std/crypto/digest#digest-update!__0
                             _digest203780_
                             _secret203752_))
                           (_g203926_
                            (std/crypto/digest#digest-update!__0
                             _digest203780_
                             _iv203754_))
                           (_g203927_
                            (std/crypto/digest#digest-update!__%
                             _digest203780_
                             _ctext203795_
                             '0
                             _clen203807_))
                           (_hmac203812_
                            (std/crypto/digest#digest-final!__0
                             _digest203780_)))
                      (std/net/bio/output#bio-write-bytes
                       _hmac203812_
                       _obuf203750_)
                      (std/net/bio/output#bio-write-bytes
                       _iv203754_
                       _obuf203750_)
                      (std/net/bio/output#bio-write-u32
                       _clen203807_
                       _obuf203750_)
                      (std/net/bio/output#bio-write-subu8vector
                       _ctext203795_
                       '0
                       _clen203807_
                       _obuf203750_)
                      (std/net/bio/output#bio-force-output _obuf203750_)))
                  (std/actor/proto#raise-rpc-io-error
                   'rpc-proto-write
                   '"unexpected object"
                   _obj203751_))))))
  (define std/actor/rpc/proto/cipher#rpc-cipher-proto-accept
    (lambda (_ibuf203742_ _obuf203743_)
      (std/actor/rpc/proto/null#rpc-proto-accept-e
       _ibuf203742_
       _obuf203743_
       std/actor/rpc/proto/message#rpc-proto-cipher
       (lambda (_ibuf203745_ _obuf203746_)
         (let ((_secret203748_
                (std/actor/rpc/proto/cipher#rpc-cipher-proto-key-exchange
                 _ibuf203745_
                 _obuf203746_)))
           (values (std/actor/rpc/proto/cipher#rpc-cipher-proto-read-e
                    _secret203748_)
                   (std/actor/rpc/proto/cipher#rpc-cipher-proto-write-e
                    _secret203748_)))))))
  (define std/actor/rpc/proto/cipher#rpc-cipher-proto-connect
    (lambda (_ibuf203734_ _obuf203735_)
      (std/actor/rpc/proto/null#rpc-proto-connect-e
       _ibuf203734_
       _obuf203735_
       std/actor/rpc/proto/message#rpc-proto-cipher
       (lambda (_ibuf203737_ _obuf203738_)
         (let ((_secret203740_
                (std/actor/rpc/proto/cipher#rpc-cipher-proto-key-exchange
                 _ibuf203737_
                 _obuf203738_)))
           (values (std/actor/rpc/proto/cipher#rpc-cipher-proto-read-e
                    _secret203740_)
                   (std/actor/rpc/proto/cipher#rpc-cipher-proto-write-e
                    _secret203740_)))))))
  (define std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto-accept
    (lambda (_ibuf203725_ _obuf203726_ _cookie203727_)
      (std/actor/rpc/proto/null#rpc-proto-accept-e
       _ibuf203725_
       _obuf203726_
       std/actor/rpc/proto/message#rpc-proto-cookie-cipher
       (lambda (_ibuf203729_ _obuf203730_)
         (std/actor/rpc/proto/cookie#rpc-cookie-proto-challenge
          _ibuf203729_
          _obuf203730_
          _cookie203727_)
         (let ((_secret203732_
                (std/actor/rpc/proto/cipher#rpc-cipher-proto-key-exchange
                 _ibuf203729_
                 _obuf203730_)))
           (values (std/actor/rpc/proto/cipher#rpc-cipher-proto-read-e
                    _secret203732_)
                   (std/actor/rpc/proto/cipher#rpc-cipher-proto-write-e
                    _secret203732_)))))))
  (define std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto-connect
    (lambda (_ibuf203714_ _obuf203715_ _cookie203716_)
      (std/actor/rpc/proto/null#rpc-proto-connect-e
       _ibuf203714_
       _obuf203715_
       std/actor/rpc/proto/message#rpc-proto-cookie-cipher
       (lambda (_ibuf203718_ _obuf203719_)
         (let ((_e203721_ (std/net/bio/input#bio-read-u8 _ibuf203718_)))
           (if (eq? _e203721_ std/actor/rpc/proto/message#rpc-proto-challenge)
               (begin
                 (std/actor/rpc/proto/cookie#rpc-cookie-proto-challenge-respond
                  _ibuf203718_
                  _obuf203719_
                  _cookie203716_)
                 (let ((_secret203723_
                        (std/actor/rpc/proto/cipher#rpc-cipher-proto-key-exchange
                         _ibuf203718_
                         _obuf203719_)))
                   (values (std/actor/rpc/proto/cipher#rpc-cipher-proto-read-e
                            _secret203723_)
                           (std/actor/rpc/proto/cipher#rpc-cipher-proto-write-e
                            _secret203723_))))
               (if (eof-object? _e203721_)
                   (std/actor/proto#raise-rpc-io-error
                    'rpc-proto-connect
                    '"connect closed")
                   (std/actor/proto#raise-rpc-io-error
                    'rpc-proto-connect
                    '"bad hello"
                    _e203721_))))))))
  (define std/actor/rpc/proto/cipher#rpc-cipher-proto
    (lambda ()
      (##structure
       std/actor/rpc/base#!rpc-protocol::t
       std/actor/rpc/proto/cipher#rpc-cipher-proto-accept
       std/actor/rpc/proto/cipher#rpc-cipher-proto-connect)))
  (define std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto__%
    (lambda (_cookie-file203687_)
      (let ((_cookie203689_ (call-with-input-file _cookie-file203687_ read)))
        (if (u8vector? _cookie203689_)
            (##structure
             std/actor/rpc/base#!rpc-protocol::t
             (lambda (_g203690203693_ _g203691203695_)
               (std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto-connect
                _g203690203693_
                _g203691203695_
                _cookie203689_))
             (lambda (_g203697203700_ _g203698203702_)
               (std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto-accept
                _g203697203700_
                _g203698203702_
                _cookie203689_)))
            (error '"Invalid cookie; expected u8vector"
                   _cookie-file203687_
                   _cookie203689_)))))
  (define std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto__0
    (lambda ()
      (let ((_cookie-file203709_ '"~/.gerbil/cookie"))
        (std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto__%
         _cookie-file203709_))))
  (define std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto
    (lambda _g203929_
      (let ((_g203928_ (length _g203929_)))
        (cond ((##fx= _g203928_ 0)
               (apply std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto__0
                      _g203929_))
              ((##fx= _g203928_ 1)
               (apply std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto__%
                      _g203929_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/actor/rpc/proto/cipher#rpc-cookie-cipher-proto
                _g203929_)))))))
