(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/net/socks#open-socks-client
    (lambda (_proxy115241_ _server115242_ _open115243_ _connect115244_)
      (let ((_sock115246_
             (open-tcp-client
              (std/net/address#inet-address->string
               (std/net/address#inet-address _proxy115241_)))))
        (with-exception-catcher
         (lambda (_e115248_)
           (with-exception-catcher void (lambda () (close-port _sock115246_)))
           (raise _e115248_))
         (lambda ()
           (_open115243_ _sock115246_)
           (_connect115244_ _sock115246_ _server115242_)
           _sock115246_)))))
  (define std/net/socks#open-socks4-client
    (lambda (_proxy115238_ _server115239_)
      (std/net/socks#open-socks-client
       _proxy115238_
       _server115239_
       void
       std/net/socks#socks4-connect)))
  (define std/net/socks#open-socks5-client
    (lambda (_proxy115235_ _server115236_)
      (std/net/socks#open-socks-client
       _proxy115235_
       _server115236_
       std/net/socks#socks5-open
       std/net/socks#socks5-connect)))
  (define std/net/socks#socks5-open
    (lambda (_sock115227_)
      (std/net/socks#send-msg _sock115227_ '#u8(5 1 0))
      (let ((_in115229_ (##make-u8vector '2 '0)))
        (std/net/socks#recv-msg _sock115227_ _in115229_)
        (let ((_proto115231_ (##u8vector-ref _in115229_ '0)))
          (if (eq? _proto115231_ '5)
              '#!void
              (std/error#raise-io-error
               'socks5-open
               '"SOCKS5 handshake error; protocol version mismatch"
               _proto115231_)))
        (let ((_rep115233_ (##u8vector-ref _in115229_ '1)))
          (if (eq? _rep115233_ '0)
              '#!void
              (std/error#raise-io-error
               'socks5-open
               '"SOCKS5 handshake error; negotiation failed"
               _rep115233_))))))
  (define std/net/socks#socks5-connect
    (lambda (_sock115224_ _address115225_)
      (std/net/socks#socks-connect
       std/net/socks#socks5-send-request
       std/net/socks#socks5-recv-reply
       _sock115224_
       _address115225_)))
  (define std/net/socks#socks5-bind__%
    (lambda (_sock115211_ _address115212_)
      (std/net/socks#socks-bind
       std/net/socks#socks5-send-request
       std/net/socks#socks5-recv-reply
       _sock115211_
       _address115212_)))
  (define std/net/socks#socks5-bind__0
    (lambda (_sock115217_)
      (let ((_address115219_ '#f))
        (std/net/socks#socks5-bind__% _sock115217_ _address115219_))))
  (define std/net/socks#socks5-bind
    (lambda _g115252_
      (let ((_g115251_ (length _g115252_)))
        (cond ((##fx= _g115251_ 1)
               (apply std/net/socks#socks5-bind__0 _g115252_))
              ((##fx= _g115251_ 2)
               (apply std/net/socks#socks5-bind__% _g115252_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socks#socks5-bind
                _g115252_))))))
  (define std/net/socks#socks5-accept
    (lambda (_sock115208_) (std/net/socks#socks5-recv-reply _sock115208_)))
  (define std/net/socks#socks4-connect__%
    (lambda (_sock115192_ _address115193_ _userid115194_)
      (std/net/socks#socks-connect
       std/net/socks#socks4-send-request
       std/net/socks#socks4-recv-reply
       _sock115192_
       _address115193_
       _userid115194_)))
  (define std/net/socks#socks4-connect__0
    (lambda (_sock115199_ _address115200_)
      (let ((_userid115202_ '#f))
        (std/net/socks#socks4-connect__%
         _sock115199_
         _address115200_
         _userid115202_))))
  (define std/net/socks#socks4-connect
    (lambda _g115254_
      (let ((_g115253_ (length _g115254_)))
        (cond ((##fx= _g115253_ 2)
               (apply std/net/socks#socks4-connect__0 _g115254_))
              ((##fx= _g115253_ 3)
               (apply std/net/socks#socks4-connect__% _g115254_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socks#socks4-connect
                _g115254_))))))
  (define std/net/socks#socks4-bind__%
    (lambda (_sock115169_ _address115170_ _userid115171_)
      (std/net/socks#socks-bind
       std/net/socks#socks4-send-request
       std/net/socks#socks4-recv-reply
       _sock115169_
       _address115170_
       _userid115171_)))
  (define std/net/socks#socks4-bind__0
    (lambda (_sock115176_)
      (let* ((_address115178_ '#f) (_userid115180_ '#f))
        (std/net/socks#socks4-bind__%
         _sock115176_
         _address115178_
         _userid115180_))))
  (define std/net/socks#socks4-bind__1
    (lambda (_sock115182_ _address115183_)
      (let ((_userid115185_ '#f))
        (std/net/socks#socks4-bind__%
         _sock115182_
         _address115183_
         _userid115185_))))
  (define std/net/socks#socks4-bind
    (lambda _g115256_
      (let ((_g115255_ (length _g115256_)))
        (cond ((##fx= _g115255_ 1)
               (apply std/net/socks#socks4-bind__0 _g115256_))
              ((##fx= _g115255_ 2)
               (apply std/net/socks#socks4-bind__1 _g115256_))
              ((##fx= _g115255_ 3)
               (apply std/net/socks#socks4-bind__% _g115256_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socks#socks4-bind
                _g115256_))))))
  (define std/net/socks#socks4-accept
    (lambda (_sock115166_) (std/net/socks#socks4-recv-reply _sock115166_)))
  (define std/net/socks#socks-connect
    (lambda (_send115157_
             _recv115158_
             _sock115159_
             _address115160_
             .
             _args115161_)
      (let ((_g115257_ (std/net/socks#parse-address _address115160_)))
        (begin
          (let ((_g115258_
                 (if (##values? _g115257_) (##vector-length _g115257_) 1)))
            (if (not (##fx= _g115258_ 2))
                (error "Context expects 2 values" _g115258_)))
          (let ((_host115163_ (##vector-ref _g115257_ 0))
                (_port115164_ (##vector-ref _g115257_ 1)))
            (apply _send115157_
                   _sock115159_
                   '1
                   _host115163_
                   _port115164_
                   _args115161_))))
      (_recv115158_ _sock115159_)))
  (define std/net/socks#socks-bind
    (lambda (_send115148_
             _recv115149_
             _sock115150_
             _address115151_
             .
             _args115152_)
      (let ((_g115259_
             (if _address115151_
                 (std/net/socks#parse-address _address115151_)
                 (values '#u8(0 0 0 0) '0))))
        (begin
          (let ((_g115260_
                 (if (##values? _g115259_) (##vector-length _g115259_) 1)))
            (if (not (##fx= _g115260_ 2))
                (error "Context expects 2 values" _g115260_)))
          (let ((_host115154_ (##vector-ref _g115259_ 0))
                (_port115155_ (##vector-ref _g115259_ 1)))
            (begin
              (apply _send115148_
                     _sock115150_
                     '2
                     _host115154_
                     _port115155_
                     _args115152_)
              (_recv115149_ _sock115150_)))))))
  (define std/net/socks#parse-address
    (lambda (_addr115118_)
      (let* ((_g115119115126_ (std/net/address#inet-address _addr115118_))
             (_E115121115130_
              (lambda () (error '"No clause matching" _g115119115126_)))
             (_K115122115136_
              (lambda (_port115133_ _host115134_)
                (values _host115134_ _port115133_))))
        (if (##pair? _g115119115126_)
            (let ((_hd115123115139_ (##car _g115119115126_))
                  (_tl115124115141_ (##cdr _g115119115126_)))
              (let* ((_host115144_ _hd115123115139_)
                     (_port115146_ _tl115124115141_))
                (_K115122115136_ _port115146_ _host115144_)))
            (_E115121115130_)))))
  (define std/net/socks#socks5-send-request
    (lambda (_sock115092_ _cmd115093_ _host115094_ _port115095_)
      (let* ((_porthi115097_
              (##fxand (##fxarithmetic-shift _port115095_ '-8) '255))
             (_portlo115099_ (##fxand _port115095_ '255))
             (_out115115_
              (if (string? _host115094_)
                  (let* ((_fqdn115101_
                          (std/text/utf8#string->utf8__0 _host115094_))
                         (_fqdnlen115103_ (##u8vector-length _fqdn115101_))
                         (_g115261_
                          (if (##fx> _fqdnlen115103_ '255)
                              (error '"Domain name too long"
                                     _host115094_
                                     _fqdnlen115103_)
                              '#!void))
                         (_len115106_ (##fx+ '7 _fqdnlen115103_))
                         (_out115108_ (##make-u8vector _len115106_ '0)))
                    (##u8vector-set! _out115108_ '3 '3)
                    (##u8vector-set! _out115108_ '4 _fqdnlen115103_)
                    (##subu8vector-move!
                     _fqdn115101_
                     '0
                     _fqdnlen115103_
                     _out115108_
                     '5)
                    (##u8vector-set!
                     _out115108_
                     (##fx+ _fqdnlen115103_ '5)
                     _porthi115097_)
                    (##u8vector-set!
                     _out115108_
                     (##fx+ _fqdnlen115103_ '6)
                     _portlo115099_))
                  (if (and (##u8vector? _host115094_)
                           (##fx= (##u8vector-length _host115094_) '4))
                      (let ((_out115111_ (##make-u8vector '10 '0)))
                        (##u8vector-set! _out115111_ '3 '1)
                        (##subu8vector-move! _host115094_ '0 '4 _out115111_ '4)
                        (##u8vector-set! _out115111_ '8 _porthi115097_)
                        (##u8vector-set! _out115111_ '9 _portlo115099_))
                      (if (and (##u8vector? _host115094_)
                               (##fx= (##u8vector-length _host115094_) '16))
                          (let ((_out115113_ (##make-u8vector '22 '0)))
                            (##u8vector-set! _out115113_ '3 '4)
                            (##subu8vector-move!
                             _host115094_
                             '0
                             '4
                             _out115113_
                             '16)
                            (##u8vector-set! _out115113_ '20 _porthi115097_)
                            (##u8vector-set! _out115113_ '21 _portlo115099_))
                          (error '"Unexpected host address" _host115094_))))))
        (##u8vector-set! _out115115_ '0 '5)
        (##u8vector-set! _out115115_ '1 _cmd115093_)
        (std/net/socks#send-msg _sock115092_ _out115115_))))
  (define std/net/socks#socks5-recv-reply
    (lambda (_sock115062_)
      (letrec ((_recv-port115064_
                (lambda ()
                  (let* ((_porthi115087_ (##read-u8 _sock115062_))
                         (_portlo115089_ (##read-u8 _sock115062_)))
                    (##fxior (##fxarithmetic-shift _porthi115087_ '8)
                             _portlo115089_))))
               (_recv-address115065_
                (lambda (_atype115074_ _rep115075_)
                  (let ((_$e115077_ _atype115074_))
                    (if (eq? '1 _$e115077_)
                        (let ((_addr115080_ (##make-u8vector '4 '0)))
                          (std/net/socks#recv-msg _sock115062_ _addr115080_)
                          (cons _addr115080_ (_recv-port115064_)))
                        (if (eq? '3 _$e115077_)
                            (let ((_buf115082_
                                   (##make-u8vector
                                    (##read-u8 _sock115062_)
                                    '0)))
                              (std/net/socks#recv-msg _sock115062_ _buf115082_)
                              (cons (std/text/utf8#utf8->string__0 _buf115082_)
                                    (_recv-port115064_)))
                            (if (eq? '4 _$e115077_)
                                (let ((_addr115084_ (##make-u8vector '16 '0)))
                                  (std/net/socks#recv-msg
                                   _sock115062_
                                   _addr115084_)
                                  (cons _addr115084_ (_recv-port115064_)))
                                (std/error#raise-io-error
                                 'socks5-recv-reply
                                 '"Unexpected SOCKS5 address type"
                                 _atype115074_
                                 _rep115075_))))))))
        (let ((_hdr115067_ (##make-u8vector '4 '0)))
          (std/net/socks#recv-msg _sock115062_ _hdr115067_)
          (let ((_proto115069_ (##u8vector-ref _hdr115067_ '0))
                (_rep115070_ (##u8vector-ref _hdr115067_ '1)))
            (if (eq? _proto115069_ '5)
                '#!void
                (std/error#raise-io-error
                 'socks5-recv-reply
                 '"Unexpected SOCKS5 reply; protocol mismatch"
                 _proto115069_))
            (let ((_addr115072_
                   (_recv-address115065_
                    (##u8vector-ref _hdr115067_ '3)
                    _rep115070_)))
              (if (eq? _rep115070_ '0)
                  _addr115072_
                  (std/error#raise-io-error
                   'socks5-recv-reply
                   '"SOCKS5 error response"
                   _rep115070_))))))))
  (define std/net/socks#socks4-send-request
    (lambda (_sock115031_ _cmd115032_ _host115033_ _port115034_ _userid115035_)
      (let* ((_porthi115037_
              (##fxand (##fxarithmetic-shift _port115034_ '-8) '255))
             (_portlo115039_ (##fxand _port115034_ '255))
             (_userid115041_
              (if _userid115035_
                  (std/text/utf8#string->utf8__0 _userid115035_)
                  '#f))
             (_userlen115043_
              (if _userid115041_ (##u8vector-length _userid115041_) '0))
             (_out115059_
              (if (string? _host115033_)
                  (let* ((_fqdn115045_
                          (std/text/utf8#string->utf8__0 _host115033_))
                         (_fqdnlen115047_ (##u8vector-length _fqdn115045_))
                         (_len115049_
                          (##fx+ '8 _userlen115043_ '1 _fqdnlen115047_ '1))
                         (_out115051_ (##make-u8vector _len115049_ '0)))
                    (##u8vector-set! _out115051_ '7 '1)
                    (##subu8vector-move!
                     _fqdn115045_
                     '0
                     _fqdnlen115047_
                     _out115051_
                     (##fx+ _userlen115043_ '9)))
                  (if (and (##u8vector? _host115033_)
                           (##fx= (##u8vector-length _host115033_) '4))
                      (let* ((_len115054_ (##fx+ _userlen115043_ '9))
                             (_out115056_ (##make-u8vector _len115054_ '0)))
                        (##subu8vector-move!
                         _host115033_
                         '0
                         '4
                         _out115056_
                         '4))
                      (error '"Unexpected host address" _host115033_)))))
        (##u8vector-set! _out115059_ '0 '4)
        (##u8vector-set! _out115059_ '1 _cmd115032_)
        (##u8vector-set! _out115059_ '2 _porthi115037_)
        (##u8vector-set! _out115059_ '3 _portlo115039_)
        (if _userid115041_
            (##subu8vector-move!
             _userid115041_
             '0
             _userlen115043_
             _out115059_
             '8)
            '#!void)
        (std/net/socks#send-msg _sock115031_ _out115059_))))
  (define std/net/socks#socks4-recv-reply
    (lambda (_sock115023_)
      (let ((_buf115025_ (##make-u8vector '8 '0)))
        (std/net/socks#recv-msg _sock115023_ _buf115025_)
        (let ((_vn115027_ (##u8vector-ref _buf115025_ '0)))
          (if (eq? _vn115027_ '0)
              '#!void
              (std/error#raise-io-error
               'socks4-recv-reply
               '"Unexpected SOCKS4 reply; version mismatch"
               _vn115027_)))
        (let ((_rep115029_ (##u8vector-ref _buf115025_ '1)))
          (if (eq? _rep115029_ '90)
              '#!void
              (std/error#raise-io-error
               'socks4-recv-reply
               '"SOCKS4 request rejected"
               _rep115029_)))
        (cons (##subu8vector _buf115025_ '4 '8)
              (##fxior (##fxarithmetic-shift
                        (##u8vector-ref _buf115025_ '2)
                        '8)
                       (##u8vector-ref _buf115025_ '3))))))
  (define std/net/socks#send-msg
    (lambda (_sock115018_ _buf115019_)
      (let ((_wr115021_
             (gerbil/gambit/ports#write-u8vector__% _buf115019_ _sock115018_)))
        (if (eq? _wr115021_ (##u8vector-length _buf115019_))
            '#!void
            (std/error#raise-io-error
             'socks-send-message
             '"Failed to send message; incomplete write"
             _sock115018_
             _wr115021_))
        (force-output _sock115018_))))
  (define std/net/socks#recv-msg
    (lambda (_sock115013_ _buf115014_)
      (let ((_rd115016_
             (gerbil/gambit/ports#read-u8vector__% _buf115014_ _sock115013_)))
        (if (eq? _rd115016_ (##u8vector-length _buf115014_))
            '#!void
            (std/error#raise-io-error
             'socks-recv-message
             '"Failed to receive message; incomplete read"
             _sock115013_
             _rd115016_))))))
