/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.client;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.OptionDialog;
import docking.widgets.PasswordChangeDialog;
import docking.widgets.PasswordDialog;
import docking.widgets.PopupKeyStorePasswordProvider;
import ghidra.framework.client.ClientAuthenticator;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.remote.AnonymousCallback;
import ghidra.framework.remote.SSHSignatureCallback;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.awt.Component;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.swing.JFrame;

public class DefaultClientAuthenticator
extends PopupKeyStorePasswordProvider
implements ClientAuthenticator {
    private Authenticator authenticator = new Authenticator(){

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            String prompt;
            Msg.debug((Object)this, (Object)("PasswordAuthentication requested for " + this.getRequestingURL()));
            NameCallback nameCb = null;
            if (!"NO_NAME".equals(this.getRequestingScheme())) {
                nameCb = new NameCallback("Name: ", ClientUtil.getUserName());
            }
            if ((prompt = this.getRequestingPrompt()) == null) {
                prompt = "Password:";
            }
            PasswordCallback passCb = new PasswordCallback(prompt, false);
            ServerPasswordPrompt pp = new ServerPasswordPrompt("Connection Authentication", "Server", this.getRequestingHost(), nameCb, passCb, null, null, null);
            SystemUtilities.runSwingNow((Runnable)pp);
            if (pp.okWasPressed()) {
                return new PasswordAuthentication(nameCb != null ? nameCb.getName() : null, passCb.getPassword());
            }
            return null;
        }
    };

    @Override
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public boolean isSSHKeyAvailable() {
        return false;
    }

    @Override
    public boolean processSSHSignatureCallbacks(String serverName, NameCallback nameCb, SSHSignatureCallback sshCb) {
        return false;
    }

    @Override
    public boolean processPasswordCallbacks(String title, String serverType, String serverName, NameCallback nameCb, PasswordCallback passCb, ChoiceCallback choiceCb, AnonymousCallback anonymousCb, String loginError) {
        ServerPasswordPrompt pp = new ServerPasswordPrompt(title, serverType, serverName, nameCb, passCb, choiceCb, anonymousCb, loginError);
        SystemUtilities.runSwingNow((Runnable)pp);
        return pp.okWasPressed();
    }

    @Override
    public boolean promptForReconnect(Component parent, String message) {
        boolean[] retVal = new boolean[]{false};
        Runnable r = () -> {
            Object msg = message;
            if (msg != null) {
                msg = (String)msg + "\n";
            }
            msg = (String)msg + "Do you want to reconnect to the server now?";
            retVal[0] = OptionDialog.showYesNoDialog((Component)parent, (String)"Lost Connection to Server", (String)message) == 1;
        };
        SystemUtilities.runSwingNow((Runnable)r);
        return retVal[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] getNewPassword(Component parent, String serverInfo, String username) {
        PasswordChangeDialog dlg = new PasswordChangeDialog("Change Password", "Repository Server", serverInfo, username);
        Runnable r = () -> DockingWindowManager.showDialog((Component)parent, (DialogComponentProvider)dlg);
        try {
            SystemUtilities.runSwingNow((Runnable)r);
            char[] cArray = dlg.getPassword();
            return cArray;
        }
        finally {
            dlg.dispose();
        }
    }

    private class ServerPasswordPrompt
    implements Runnable {
        private static final String NAME_PREFERENCE = "PasswordPrompt.Name";
        private static final String CHOICE_PREFERENCE = "PasswordPrompt.Choice";
        private String title;
        private String serverType;
        private String serverName;
        private NameCallback nameCb;
        private PasswordCallback passCb;
        private ChoiceCallback choiceCb;
        private AnonymousCallback anonymousCb;
        private String errorMsg;
        private boolean okPressed = false;

        ServerPasswordPrompt(String title, String serverType, String serverName, NameCallback nameCb, PasswordCallback passCb, ChoiceCallback choiceCb, AnonymousCallback anonymousCb, String errorMsg) {
            this.title = title;
            this.serverType = serverType;
            this.serverName = serverName;
            this.nameCb = nameCb;
            this.passCb = passCb;
            this.choiceCb = choiceCb;
            this.anonymousCb = anonymousCb;
            this.errorMsg = errorMsg;
        }

        private String getDefaultUserName() {
            if (this.nameCb == null) {
                return ClientUtil.getUserName();
            }
            return Preferences.getProperty((String)NAME_PREFERENCE, (String)ClientUtil.getUserName(), (boolean)true);
        }

        private int getDefaultChoice() {
            try {
                String choiceStr = Preferences.getProperty((String)CHOICE_PREFERENCE);
                if (choiceStr != null) {
                    return Integer.parseInt(choiceStr);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return 0;
        }

        @Override
        public void run() {
            DockingWindowManager winMgr;
            String choicePrompt = null;
            String[] choices = null;
            if (this.choiceCb != null) {
                choicePrompt = this.choiceCb.getPrompt();
                choices = this.choiceCb.getChoices();
            }
            PasswordDialog pwdDialog = new PasswordDialog(this.title, this.serverType, this.serverName, this.passCb.getPrompt(), this.nameCb != null ? this.nameCb.getPrompt() : null, this.getDefaultUserName(), choicePrompt, choices, this.getDefaultChoice(), this.anonymousCb != null);
            if (this.errorMsg != null) {
                pwdDialog.setErrorText(this.errorMsg);
            }
            JFrame rootFrame = (winMgr = DockingWindowManager.getActiveInstance()) != null ? winMgr.getRootFrame() : null;
            DockingWindowManager.showDialog((Component)rootFrame, (DialogComponentProvider)pwdDialog);
            if (pwdDialog.okWasPressed()) {
                if (this.anonymousCb != null && pwdDialog.anonymousAccessRequested()) {
                    this.anonymousCb.setAnonymousAccessRequested(true);
                } else {
                    this.passCb.setPassword(pwdDialog.getPassword());
                    if (this.nameCb != null) {
                        String username = pwdDialog.getUserID();
                        this.nameCb.setName(username);
                        Preferences.setProperty((String)NAME_PREFERENCE, (String)username);
                    }
                    if (this.choiceCb != null) {
                        int choice = pwdDialog.getChoice();
                        this.choiceCb.setSelectedIndex(choice);
                        Preferences.setProperty((String)CHOICE_PREFERENCE, (String)Integer.toString(choice));
                    }
                }
                this.okPressed = true;
            }
            pwdDialog.dispose();
        }

        boolean okWasPressed() {
            return this.okPressed;
        }
    }
}

