/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.namespace;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.NamespaceException;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;

public class NamespaceMapping
implements NamespaceResolver {
    private final Properties prefixToURI = new Properties();
    private final Properties URIToPrefix = new Properties();
    private final NamespaceResolver base;

    public NamespaceMapping() {
        this.base = null;
    }

    public NamespaceMapping(NamespaceResolver base) {
        this.base = base;
    }

    public String getPrefix(String uri) throws NamespaceException {
        if (this.URIToPrefix.containsKey(uri)) {
            return this.URIToPrefix.getProperty(uri);
        }
        if (this.base == null) {
            throw new NamespaceException("No prefix for URI '" + uri + "' declared.");
        }
        return this.base.getPrefix(uri);
    }

    public String getURI(String prefix) throws NamespaceException {
        if (this.prefixToURI.containsKey(prefix)) {
            return this.prefixToURI.getProperty(prefix);
        }
        if (this.base == null) {
            throw new NamespaceException("No URI for prefix '" + prefix + "' declared.");
        }
        return this.base.getURI(prefix);
    }

    public boolean hasPrefix(String prefix) {
        return this.prefixToURI.containsKey(prefix);
    }

    public void setMapping(String prefix, String uri) throws NamespaceException {
        if (prefix == null) {
            throw new NamespaceException("Prefix must not be null");
        }
        if (uri == null) {
            throw new NamespaceException("URI must not be null");
        }
        if (this.URIToPrefix.containsKey(uri)) {
            this.prefixToURI.remove(this.URIToPrefix.remove(uri));
        }
        if (this.prefixToURI.containsKey(prefix)) {
            this.URIToPrefix.remove(this.prefixToURI.remove(prefix));
        }
        this.prefixToURI.put(prefix, uri);
        this.URIToPrefix.put(uri, prefix);
    }

    public Map getPrefixToURIMapping() {
        return new HashMap<Object, Object>(this.prefixToURI);
    }

    public Map getURIToPrefixMapping() {
        return new HashMap<Object, Object>(this.URIToPrefix);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NamespaceMapping) {
            NamespaceMapping other = (NamespaceMapping)obj;
            return ((Object)this.getPrefixToURIMapping()).equals(other.getPrefixToURIMapping()) && ((Object)this.getURIToPrefixMapping()).equals(other.getURIToPrefixMapping());
        }
        return false;
    }

    public String toString() {
        String s = "";
        Set<Map.Entry<Object, Object>> mapping = this.prefixToURI.entrySet();
        Iterator<Map.Entry<Object, Object>> i = mapping.iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            String prefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            s = s + "'" + prefix + "' == '" + uri + "'\n";
        }
        return s;
    }
}

