/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import generic.timer.GhidraTimer;
import generic.timer.GhidraTimerFactory;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;

class DomainObjectChangeSupport {
    private WeakSet<DomainObjectListener> listeners;
    private DomainObject src;
    private List<DomainObjectChangeRecord> changesQueue;
    private GhidraTimer timer;
    private Lock domainObjectLock;
    private Lock writeLock = new Lock("DOCS Change Records Queue Lock");
    private volatile boolean isDisposed;

    DomainObjectChangeSupport(DomainObject src, int timeInterval, int bufsize, Lock lock) {
        this.src = src;
        this.domainObjectLock = lock;
        this.changesQueue = new ArrayList<DomainObjectChangeRecord>(bufsize);
        this.listeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();
        this.timer = GhidraTimerFactory.getGhidraTimer((int)timeInterval, (int)timeInterval, () -> this.sendEventNow());
        this.timer.setInitialDelay(25);
        this.timer.setDelay(500);
        this.timer.setRepeats(true);
    }

    void addListener(DomainObjectListener listener) {
        DomainObjectChangedEvent pendingEvent = this.convertEventQueueRecordsToEvent();
        List<DomainObjectListener> previousListeners = this.atomicAddListener(listener);
        SystemUtilities.runIfSwingOrPostSwingLater(() -> this.notifyEvent(previousListeners, pendingEvent));
    }

    void removeListener(DomainObjectListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void sendEventNow() {
        DomainObjectChangedEvent ev = this.convertEventQueueRecordsToEvent();
        this.notifyEvent((Iterable<DomainObjectListener>)this.listeners, ev);
    }

    private DomainObjectChangedEvent convertEventQueueRecordsToEvent() {
        DomainObjectChangedEvent event = this.lockQueue(() -> {
            if (this.changesQueue.isEmpty()) {
                this.timer.stop();
                return null;
            }
            DomainObjectChangedEvent e = new DomainObjectChangedEvent(this.src, this.changesQueue);
            this.changesQueue = new ArrayList<DomainObjectChangeRecord>();
            return e;
        });
        return event;
    }

    private void notifyEvent(Iterable<DomainObjectListener> listenersToNotify, DomainObjectChangedEvent ev) {
        if (ev == null) {
            return;
        }
        if (this.isDisposed) {
            return;
        }
        for (DomainObjectListener dol : listenersToNotify) {
            try {
                dol.domainObjectChanged(ev);
            }
            catch (Exception exc) {
                Msg.showError((Object)this, null, (String)"Error", (Object)"Error in Domain Object listener", (Throwable)exc);
            }
        }
    }

    void flush() {
        Thread lockOwner = this.domainObjectLock.getOwner();
        if (this.domainObjectLock != null && lockOwner == Thread.currentThread()) {
            throw new IllegalStateException("Cannot call flush() with locks!");
        }
        SystemUtilities.runSwingNow(() -> this.sendEventNow());
    }

    void fireEvent(DomainObjectChangeRecord docr) {
        if (this.isDisposed) {
            return;
        }
        this.lockQueue(() -> {
            this.changesQueue.add(docr);
            this.timer.start();
        });
    }

    void fatalErrorOccurred(Throwable t) {
        ArrayList listenersCopy = new ArrayList(this.listeners.values());
        this.dispose();
        Runnable errorTask = () -> {
            List<DomainObjectChangeRecord> records = Arrays.asList(new DomainObjectChangeRecord(8, null, t));
            DomainObjectChangedEvent ev = new DomainObjectChangedEvent(this.src, records);
            for (DomainObjectListener l : listenersCopy) {
                try {
                    l.domainObjectChanged(ev);
                }
                catch (Throwable throwable) {}
            }
        };
        SystemUtilities.runSwingLater((Runnable)errorTask);
    }

    void dispose() {
        this.lockQueue(() -> {
            this.isDisposed = true;
            this.timer.stop();
            this.changesQueue.clear();
        });
        this.listeners.clear();
    }

    private List<DomainObjectListener> atomicAddListener(DomainObjectListener l) {
        ArrayList<DomainObjectListener> previousLisetners = new ArrayList<DomainObjectListener>();
        for (DomainObjectListener listener : this.listeners) {
            previousLisetners.add(listener);
        }
        this.listeners.add((Object)l);
        return previousLisetners;
    }

    private void lockQueue(Runnable r) {
        try {
            this.writeLock.acquire();
            r.run();
        }
        finally {
            this.writeLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T lockQueue(Callable<T> c) {
        try {
            T t;
            this.writeLock.acquire();
            try {
                T result;
                t = result = c.call();
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)"Exception while updating change records", (Throwable)e);
                T t2 = null;
                this.writeLock.release();
                return t2;
            }
            return t;
        }
        finally {
            this.writeLock.release();
        }
    }
}

