/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.address;

import ghidra.feature.vt.api.correlator.address.StraightLineCorrelation;
import ghidra.feature.vt.api.impl.VTProgramCorrelatorInfo;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationManager;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.util.AddressCorrelation;
import ghidra.program.util.AddressCorrelator;
import java.util.List;

public class ExactMatchAddressCorrelator
implements AddressCorrelator {
    private static final String CORRELATOR_NAME = "ExactMatchAddressCorrelator";
    private ToolOptions options = new ToolOptions("ExactMatchAddressCorrelator");
    private VTController controller;

    public ExactMatchAddressCorrelator(VTController controller) {
        this.controller = controller;
    }

    public synchronized AddressCorrelation correlate(Function sourceFunction, Function destinationFunction) {
        VTSession session = this.controller.getSession();
        VTAssociationManager associationManager = session.getAssociationManager();
        VTAssociation association = associationManager.getAssociation(sourceFunction.getEntryPoint(), destinationFunction.getEntryPoint());
        List<VTMatch> matches = session.getMatches(association);
        for (VTMatch match : matches) {
            VTMatchSet matchSet = match.getMatchSet();
            VTProgramCorrelatorInfo info = matchSet.getProgramCorrelatorInfo();
            String correlatorName = info.getName();
            if (!correlatorName.equals("Exact Function Bytes Match") && !correlatorName.equals("Exact Function Instructions Match") && !correlatorName.equals("Exact Function Mnemonics Match")) continue;
            return new StraightLineCorrelation(sourceFunction, destinationFunction);
        }
        return null;
    }

    public AddressCorrelation correlate(Data sourceData, Data destinationData) {
        return null;
    }

    public ToolOptions getOptions() {
        return this.options;
    }

    public void setOptions(ToolOptions options) {
        this.options = options.copy();
    }

    public Options getDefaultOptions() {
        return new ToolOptions(CORRELATOR_NAME);
    }
}

