/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.android.bootimg.BootImage;
import ghidra.file.formats.android.bootimg.BootImageUtil;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class BootImageAnalyzer
extends FileFormatAnalyzer
implements AnalysisWorker {
    private MessageLog log;

    public String getName() {
        return "Android Boot or Recovery Image Annotation";
    }

    public boolean getDefaultEnablement(Program program) {
        return false;
    }

    public String getDescription() {
        return "Annotates Android Boot and Recovery Image files.";
    }

    public boolean canAnalyze(Program program) {
        try {
            return BootImageUtil.isBootImage(program);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isPrototype() {
        return true;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        this.log = log;
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager((Program)program);
        return manager.scheduleWorker((AnalysisWorker)this, null, false, monitor);
    }

    public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor monitor) throws Exception, CancelledException {
        Address end;
        Address start;
        Address address = program.getMinAddress();
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), address);
        BinaryReader reader = new BinaryReader((ByteProvider)provider, true);
        BootImage header = new BootImage(reader);
        if (!header.getMagic().equals("ANDROID!")) {
            return false;
        }
        DataType headerDataType = header.toDataType();
        Data headerData = this.createData(program, address, headerDataType);
        if (headerData == null) {
            this.log.appendMsg("Unable to create header data.");
        }
        this.createFragment(program, headerDataType.getName(), this.toAddr(program, 0L), this.toAddr(program, header.getPageSize()));
        if (header.getKernelSize() > 0) {
            start = this.toAddr(program, header.getKernelOffset());
            end = this.toAddr(program, header.getKernelOffset() + header.getKernelSize());
            this.createFragment(program, "kernel", start, end);
        }
        if (header.getRamDiskSize() > 0) {
            start = this.toAddr(program, header.getRamDiskOffset());
            end = this.toAddr(program, header.getRamDiskOffset() + header.getRamDiskSize());
            this.createFragment(program, "ramdisk", start, end);
        }
        if (header.getSecondStageSize() > 0) {
            start = this.toAddr(program, header.getSecondStageOffset());
            end = this.toAddr(program, header.getSecondStageOffset() + header.getSecondStageSize());
            this.createFragment(program, "second stage", start, end);
        }
        this.changeDataSettings(program, monitor);
        this.removeEmptyFragments(program);
        return true;
    }

    public String getWorkerName() {
        return "BootImageAnalyzer";
    }
}

