/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.classfinder;

import ghidra.util.classfinder.ClassPackage;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class ClassDir {
    private String dirPath;
    private File dir;
    private List<ClassPackage> children = new ArrayList<ClassPackage>();

    ClassDir(String dirPath, TaskMonitor monitor) throws CancelledException {
        this.dirPath = dirPath;
        this.dir = new File(dirPath);
        this.children.add(new ClassPackage(this.dir, "", monitor));
    }

    void rescan(TaskMonitor monitor) throws CancelledException {
        Iterator<ClassPackage> classPackageIterator = this.children.iterator();
        while (classPackageIterator.hasNext()) {
            ClassPackage pkg = classPackageIterator.next();
            try {
                pkg.rescan(monitor);
            }
            catch (FileNotFoundException e) {
                classPackageIterator.remove();
            }
        }
    }

    void getClasses(Set<Class<?>> set, TaskMonitor monitor) throws CancelledException {
        Iterator<ClassPackage> classPackageIterator = this.children.iterator();
        while (classPackageIterator.hasNext()) {
            monitor.checkCanceled();
            ClassPackage pkg = classPackageIterator.next();
            pkg.getClasses(set, monitor);
        }
    }

    String getDirPath() {
        return this.dirPath;
    }

    public String toString() {
        return this.dirPath;
    }
}

