/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import java.io.Serializable;
import java.util.ArrayList;

public class ShortIndexManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private short nextIndex = 0;
    private ArrayList<Short> freeList = new ArrayList();

    public short allocate() {
        if (this.freeList.size() == 0) {
            if (this.nextIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            short temp = this.nextIndex;
            this.nextIndex = (short)(this.nextIndex + 1);
            return temp;
        }
        Short s = this.freeList.remove(this.freeList.size() - 1);
        return s;
    }

    public void deallocate(short index) {
        if (index < 0 || index >= this.nextIndex) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.nextIndex - 1) {
            this.nextIndex = (short)(this.nextIndex - 1);
        } else {
            this.freeList.add(new Short(index));
        }
        if (this.nextIndex == this.freeList.size()) {
            this.clear();
        }
    }

    public void clear() {
        this.nextIndex = 0;
        this.freeList.clear();
    }
}

