/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.assembler;

import docking.action.DockingAction;
import docking.action.DockingActionIf;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.assembler.AssembleDockingAction;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Patching", shortDescription="Assembler", description="This plugin provides funcationality for assembly patching. The assembler supports most processor languages also supported by the disassembler. Depending on the particular processor, your mileage may vary. We are in the process of testing and improving support for all our processors. You can access the assembler by pressing Ctrl-Shift-G, and then modifying the instruction in place. As you type, a content assist will guide you and provide assembled bytes when you have a complete instruction.")
public class AssemblerPlugin
extends ProgramPlugin {
    public static final String ASSEMBLER_NAME = "Assembler";
    private DockingAction assembleAction;

    public AssemblerPlugin(PluginTool tool) {
        super(tool, false, false, false);
        this.createActions();
    }

    private void createActions() {
        this.assembleAction = new AssembleDockingAction(this.tool, "Assemble", this.getName());
        this.assembleAction.setEnabled(true);
        this.tool.addAction((DockingActionIf)this.assembleAction);
    }

    protected void dispose() {
        this.assembleAction.dispose();
    }
}

