/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.checksums;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.checksums.ChecksumAlgorithm;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import java.util.Comparator;
import java.util.List;

public class ChecksumTableModel
extends GDynamicColumnTableModel<ChecksumAlgorithm, List<ChecksumAlgorithm>> {
    public static final int NAME_COL = 0;
    public static final int VALUE_COL = 1;
    private List<ChecksumAlgorithm> checksumList;
    private boolean isHex;

    public ChecksumTableModel(ServiceProvider serviceProvider, List<ChecksumAlgorithm> checksumAlgorithms) {
        super(serviceProvider);
        this.checksumList = checksumAlgorithms;
    }

    public String getName() {
        return "Checksum";
    }

    public List<ChecksumAlgorithm> getModelData() {
        return this.checksumList;
    }

    public void formatOptions(boolean asHex) {
        this.isHex = asHex;
    }

    public ChecksumAlgorithm getChecksumFor(String checksumName) {
        for (ChecksumAlgorithm res : this.checksumList) {
            if (!res.getName().equals(checksumName)) continue;
            return res;
        }
        return null;
    }

    protected TableColumnDescriptor<ChecksumAlgorithm> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new ChecksumNameColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ChecksumValueColumn());
        return descriptor;
    }

    public List<ChecksumAlgorithm> getDataSource() {
        return this.checksumList;
    }

    private class CaseInsensitiveComparator
    implements Comparator<String> {
        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            if (o1 == null && o2 != null) {
                return 1;
            }
            return o1.compareToIgnoreCase(o2);
        }
    }

    private class ChecksumValueColumn
    extends AbstractDynamicTableColumn<ChecksumAlgorithm, String, Object> {
        private ChecksumValueColumn() {
        }

        public String getColumnName() {
            return "Value";
        }

        public String getValue(ChecksumAlgorithm rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            if (rowObject.supportsDecimal()) {
                return ChecksumAlgorithm.format(rowObject.getChecksum(), ChecksumTableModel.this.isHex);
            }
            return ChecksumAlgorithm.format(rowObject.getChecksum(), true);
        }

        public int getColumnPreferredWidth() {
            return 280;
        }
    }

    private class ChecksumNameColumn
    extends AbstractDynamicTableColumn<ChecksumAlgorithm, String, Object> {
        Comparator<String> comparator;

        private ChecksumNameColumn() {
            this.comparator = new CaseInsensitiveComparator();
        }

        public String getColumnName() {
            return "Name";
        }

        public String getValue(ChecksumAlgorithm rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getName();
        }

        public int getColumnPreferredWidth() {
            return 280;
        }

        public Comparator<String> getComparator() {
            return this.comparator;
        }
    }
}

