/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.app.util.datatype.DataTypeSelectionDialog;
import ghidra.framework.options.DummyKeyBindingsOptionsAction;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.program.util.VariableTypeFieldLocation;
import ghidra.util.HelpLocation;
import ghidra.util.data.DataTypeParser;
import javax.swing.KeyStroke;

public class ChooseDataTypeAction
extends DockingAction
implements OptionsChangeListener {
    private static final KeyStroke KEY_BINDING = KeyStroke.getKeyStroke(84, 0);
    private static final String ACTION_NAME = "Choose Data Type";
    private FunctionPlugin plugin;

    public ChooseDataTypeAction(FunctionPlugin plugin) {
        super(ACTION_NAME, plugin.getName(), false);
        this.plugin = plugin;
        PluginTool tool = plugin.getTool();
        DummyKeyBindingsOptionsAction action = new DummyKeyBindingsOptionsAction(ACTION_NAME, KEY_BINDING);
        tool.addAction((DockingActionIf)action);
        ToolOptions options = tool.getOptions("Key Bindings");
        KeyStroke keyStroke = options.getKeyStroke(action.getFullName(), KEY_BINDING);
        this.setPopupMenu(plugin.getDataActionMenuName(null), true);
        if (!KEY_BINDING.equals(keyStroke)) {
            this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        } else {
            this.setKeyBindingData(new KeyBindingData(keyStroke));
        }
        options.addOptionsChangeListener((OptionsChangeListener)this);
        this.setHelpLocation(new HelpLocation("DataTypeEditors", "DataTypeSelectionDialog"));
    }

    public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
        KeyStroke keyStroke = (KeyStroke)newValue;
        if (name.startsWith(ACTION_NAME)) {
            this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
    }

    public void actionPerformed(ActionContext actionContext) {
        ListingActionContext context = (ListingActionContext)actionContext.getContextObject();
        this.createDataType(context);
    }

    public boolean isEnabledForContext(ActionContext actionContext) {
        if (!(actionContext.getContextObject() instanceof ListingActionContext)) {
            return false;
        }
        ListingActionContext context = (ListingActionContext)actionContext.getContextObject();
        if (context.hasSelection()) {
            return false;
        }
        ProgramLocation location = context.getLocation();
        if (this.plugin.isValidDataLocation(location)) {
            this.setPopupMenu(this.plugin.getDataActionMenuName(location), true);
            return true;
        }
        if (location instanceof VariableLocation) {
            this.setPopupMenu(this.plugin.getDataActionMenuName(location), false);
            return true;
        }
        return false;
    }

    private void createDataType(ListingActionContext context) {
        int maxSize = this.getSelectedVariableStorageSize(context);
        DataType dataType = this.getUserSelectedDataType(context, maxSize);
        if (dataType != null) {
            this.plugin.createData(dataType, context, false, true);
        }
    }

    private int getSelectedVariableStorageSize(ListingActionContext context) {
        ProgramLocation loc = context.getLocation();
        if (loc instanceof VariableTypeFieldLocation) {
            Variable var = ((VariableTypeFieldLocation)loc).getVariable();
            Function func = var.getFunction();
            if (var instanceof Parameter && !func.hasCustomVariableStorage()) {
                return -1;
            }
            VariableStorage storage = var.getVariableStorage();
            if (storage.isValid()) {
                return storage.size();
            }
        }
        return -1;
    }

    private DataType getUserSelectedDataType(ListingActionContext context, int maxStorageSize) {
        PluginTool tool = this.plugin.getTool();
        DataTypeManager dataTypeManager = context.getProgram().getDataTypeManager();
        DataTypeSelectionDialog selectionDialog = this.showSelectionDialog(context, maxStorageSize, tool, dataTypeManager);
        return selectionDialog.getUserChosenDataType();
    }

    private DataTypeSelectionDialog showSelectionDialog(ListingActionContext context, int maxStorageSize, PluginTool tool, DataTypeManager dataTypeManager) {
        DataTypeSelectionDialog selectionDialog = new DataTypeSelectionDialog(tool, dataTypeManager, maxStorageSize, DataTypeParser.AllowedDataTypes.FIXED_LENGTH);
        DataType currentDataType = this.plugin.getCurrentDataType(context);
        selectionDialog.setInitialDataType(currentDataType);
        tool.showDialog((DialogComponentProvider)selectionDialog);
        return selectionDialog;
    }

    private void setPopupMenu(String name, boolean isSignatureAction) {
        this.setPopupMenuData(new MenuData(new String[]{"Set Data Type", "Choose Data Type..."}, null, "Array"));
    }
}

