/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.stackeditor;

import docking.ComponentProvider;
import ghidra.app.plugin.core.compositeeditor.ApplyAction;
import ghidra.app.plugin.core.compositeeditor.ArrayAction;
import ghidra.app.plugin.core.compositeeditor.ClearAction;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorAction;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorModel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.DeleteAction;
import ghidra.app.plugin.core.compositeeditor.EditComponentAction;
import ghidra.app.plugin.core.compositeeditor.EditFieldAction;
import ghidra.app.plugin.core.compositeeditor.HexNumbersAction;
import ghidra.app.plugin.core.compositeeditor.PointerAction;
import ghidra.app.plugin.core.compositeeditor.ShowComponentPathAction;
import ghidra.app.plugin.core.stackeditor.StackEditorModel;
import ghidra.app.plugin.core.stackeditor.StackEditorPanel;
import ghidra.app.plugin.core.stackeditor.StackFrameDataType;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataTypeManagerDomainObject;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;

public class StackEditorProvider
extends CompositeEditorProvider
implements DomainObjectListener {
    private Program program;
    private Function function;
    private StackEditorModel stackModel;

    public StackEditorProvider(Plugin plugin, Function function) {
        super(plugin);
        this.program = function.getProgram();
        this.function = function;
        this.program.addListener((DomainObjectListener)this);
        this.editorModel = new StackEditorModel(this);
        this.stackModel = (StackEditorModel)this.editorModel;
        this.stackModel.load(function);
        this.initializeActions();
        this.editorPanel = new StackEditorPanel(this.program, this.stackModel, this);
        this.setTitle(this.getName() + " - " + StackEditorProvider.getProviderSubTitle(function));
        plugin.getTool().addComponentProvider((ComponentProvider)this, true);
        this.addActionsToTool();
        this.editorPanel.getTable().requestFocus();
    }

    @Override
    public void dispose() {
        this.program.removeListener((DomainObjectListener)this);
        super.dispose();
    }

    static String getProviderSubTitle(Function function) {
        Program pgm = function.getProgram();
        return function.getName() + " (" + pgm.getDomainFile().getName() + ")";
    }

    @Override
    protected Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getName() {
        return "Stack Editor";
    }

    @Override
    public String getHelpName() {
        return "Stack_Editor";
    }

    @Override
    public String getHelpTopic() {
        return "StackEditor";
    }

    @Override
    protected CompositeEditorAction[] createActions() {
        return new CompositeEditorAction[]{new ApplyAction(this), new ClearAction(this), new DeleteAction(this), new PointerAction(this), new ArrayAction(this), new ShowComponentPathAction(this), new EditComponentAction(this), new EditFieldAction(this), new HexNumbersAction(this)};
    }

    String getStackName() {
        return this.stackModel.getEditorStack().getDisplayName();
    }

    Function getFunction() {
        StackFrameDataType editorStack = this.stackModel.getEditorStack();
        if (editorStack == null) {
            return null;
        }
        return editorStack.getFunction();
    }

    @Override
    public boolean isEditing(DataTypePath functionPath) {
        return this.getDtPath().equals((Object)functionPath);
    }

    protected Program getProgram() {
        return this.program;
    }

    @Override
    protected CompositeEditorModel getModel() {
        return this.stackModel;
    }

    @Override
    protected CompositeEditorAction[] getActions() {
        return this.actionMgr.getAllActions();
    }

    @Override
    public void domainObjectRestored(DataTypeManagerDomainObject domainObject) {
        this.refreshName();
        this.editorPanel.domainObjectRestored(domainObject);
    }

    private void refreshName() {
        String newName;
        StackFrameDataType origDt = (StackFrameDataType)this.stackModel.getOriginalComposite();
        StackFrameDataType viewDt = this.stackModel.getViewComposite();
        String oldName = origDt.getName();
        if (oldName.equals(newName = this.function.getName())) {
            return;
        }
        this.setTitle("Stack Editor: " + newName);
        try {
            origDt.setName(newName);
            if (viewDt.getName().equals(oldName)) {
                viewDt.setName(newName);
            }
        }
        catch (InvalidNameException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        CategoryPath oldCategoryPath = origDt.getCategoryPath();
        DataTypePath oldDtPath = new DataTypePath(oldCategoryPath, oldName);
        DataTypePath newDtPath = new DataTypePath(oldCategoryPath, newName);
        this.stackModel.dataTypeRenamed(this.stackModel.getOriginalDataTypeManager(), oldDtPath, newDtPath);
    }

    public void domainObjectChanged(DomainObjectChangedEvent event) {
        if (!this.isVisible()) {
            return;
        }
        int recordCount = event.numRecords();
        block7: for (int i = 0; i < recordCount; ++i) {
            DomainObjectChangeRecord rec = event.getChangeRecord(i);
            int eventType = rec.getEventType();
            switch (eventType) {
                case 4: {
                    Object source = event.getSource();
                    if (source instanceof Program) {
                        Program restoredProgram = (Program)source;
                        this.domainObjectRestored((DataTypeManagerDomainObject)restoredProgram);
                    }
                    return;
                }
                case 151: {
                    Function func = (Function)((ProgramChangeRecord)rec).getObject();
                    if (func == this.function) {
                        this.dispose();
                        this.tool.setStatusInfo("Stack Editor was closed for " + this.getName());
                    }
                    return;
                }
                case 46: 
                case 52: {
                    Symbol sym = (Symbol)((ProgramChangeRecord)rec).getObject();
                    SymbolType symType = sym.getSymbolType();
                    if (symType == SymbolType.CODE) {
                        if (!sym.isPrimary() || !sym.getAddress().equals((Object)this.function.getEntryPoint())) continue block7;
                        this.refreshName();
                        continue block7;
                    }
                    if (!this.inCurrentFunction(rec)) continue block7;
                    this.reloadFunction();
                    continue block7;
                }
                case 40: 
                case 41: 
                case 53: 
                case 152: {
                    if (!this.inCurrentFunction(rec)) continue block7;
                    this.reloadFunction();
                    continue block7;
                }
                case 45: {
                    Symbol sym = (Symbol)((ProgramChangeRecord)rec).getObject();
                    SymbolType symType = sym.getSymbolType();
                    if (symType != SymbolType.CODE || !sym.getAddress().equals((Object)this.function.getEntryPoint())) continue block7;
                    this.refreshName();
                }
            }
        }
    }

    private void reloadFunction() {
        if (!this.stackModel.hasChanges()) {
            this.stackModel.load(this.function);
        } else {
            this.stackModel.stackChangedExcternally(true);
            this.editorPanel.setStatus("Stack may have been changed externally--data may be stale.");
        }
    }

    private boolean inCurrentFunction(DomainObjectChangeRecord record) {
        Address changedEntry;
        if (!(record instanceof ProgramChangeRecord)) {
            return false;
        }
        if (this.function == null) {
            return false;
        }
        ProgramChangeRecord programChangeRecord = (ProgramChangeRecord)record;
        Object affectedValue = programChangeRecord.getObject();
        if (affectedValue instanceof Symbol) {
            Address address = ((Symbol)affectedValue).getAddress();
            if (address.isVariableAddress()) {
                Symbol s = (Symbol)affectedValue;
                return s.getParentNamespace() == this.function;
            }
        } else if (affectedValue instanceof Function && (changedEntry = ((Function)affectedValue).getEntryPoint()).equals((Object)this.function.getEntryPoint())) {
            return true;
        }
        return false;
    }
}

