/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.util.data.DataTypeParser;

class DtParser {
    private DataTypeManager dtManager;
    private DataTypeParser parser;

    DtParser(DataTypeManager dtManager) {
        this.dtManager = dtManager;
        this.parser = new DataTypeParser(dtManager, dtManager, null, DataTypeParser.AllowedDataTypes.DYNAMIC);
    }

    DataType parseDataType(String dtName, CategoryPath category, int size) {
        DataType dt;
        try {
            dt = this.parser.parse(dtName, category);
        }
        catch (InvalidDataTypeException e) {
            return null;
        }
        if (size > 0 && size != dt.getLength()) {
            dt = this.adjustPointerDataTypes(size, dt);
        }
        return dt;
    }

    private DataType adjustPointerDataTypes(int size, DataType dt) {
        if (dt instanceof Pointer) {
            Pointer p = (Pointer)dt;
            dt = new PointerDataType(p.getDataType(), size, this.dtManager);
        } else if (dt instanceof Array && ((Array)dt).getDataType() instanceof Pointer) {
            Array array = (Array)dt;
            DataType pointerDt = ((Pointer)array.getDataType()).getDataType();
            int pointerSize = size / array.getNumElements();
            PointerDataType pointer = new PointerDataType(pointerDt, pointerSize, this.dtManager);
            dt = new ArrayDataType((DataType)pointer, array.getNumElements(), pointerSize, this.dtManager);
        }
        return dt;
    }
}

