/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.PcodeEmit;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.VarnodeData;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.UniqueAddressFactory;
import ghidra.program.model.lang.InstructionContext;
import ghidra.program.model.lang.PackedBytes;
import ghidra.program.model.pcode.PcodeOverride;
import java.util.ArrayList;

public class PcodeEmitPacked
extends PcodeEmit {
    public static final int unimpl_tag = 32;
    public static final int inst_tag = 33;
    public static final int op_tag = 34;
    public static final int void_tag = 35;
    public static final int spaceid_tag = 36;
    public static final int addrsz_tag = 37;
    public static final int end_tag = 96;
    private PackedBytes buf;
    private ArrayList<LabelRef> labelref = null;

    public PcodeEmitPacked() {
        this.buf = new PackedBytes(64);
    }

    public PcodeEmitPacked(ParserWalker walk, InstructionContext ictx, int fallOffset, PcodeOverride override, UniqueAddressFactory uniqueFactory) {
        super(walk, ictx, fallOffset, override, uniqueFactory);
        this.buf = new PackedBytes(512);
    }

    public PackedBytes getPackedBytes() {
        return this.buf;
    }

    @Override
    public void resolveRelatives() {
        if (this.labelref == null) {
            return;
        }
        for (int i = 0; i < this.labelref.size(); ++i) {
            LabelRef ref = this.labelref.get(i);
            if (ref.labelIndex >= this.labeldef.size() || this.labeldef.get(ref.labelIndex) == null) {
                throw new SleighException("Reference to non-existant sleigh label");
            }
            long res = (long)((Integer)this.labeldef.get(ref.labelIndex)).intValue() - (long)ref.opIndex;
            if (ref.labelSize < 8) {
                long mask = -1L;
                res &= (mask >>>= (8 - ref.labelSize) * 8);
            }
            this.insertOffset(ref.streampos + 5, res);
        }
    }

    @Override
    void addLabelRef() {
        if (this.labelref == null) {
            this.labelref = new ArrayList();
        }
        int labelIndex = (int)this.incache[0].offset;
        int labelSize = this.incache[0].size;
        this.incache[0].offset = -1L;
        this.labelref.add(new LabelRef(this.numOps, labelIndex, labelSize, this.buf.size()));
    }

    @Override
    void dump(Address instrAddr, int opcode, VarnodeData[] in, int isize, VarnodeData out) {
        this.checkOverrides(opcode, in);
        this.checkOverlays(opcode, in, isize, out);
        this.buf.write(34);
        this.buf.write(opcode + 32);
        if (out == null) {
            this.buf.write(35);
        } else {
            this.dumpVarnodeData(out);
        }
        int i = 0;
        if (opcode == 2 || opcode == 3) {
            this.dumpSpaceId(in[0]);
            i = 1;
        }
        while (i < isize) {
            this.dumpVarnodeData(in[i]);
            ++i;
        }
        this.buf.write(96);
    }

    private void dumpSpaceId(VarnodeData v) {
        this.buf.write(36);
        int spcindex = (int)v.offset >> 7;
        this.buf.write(spcindex + 32);
    }

    private void dumpVarnodeData(VarnodeData v) {
        this.buf.write(37);
        int spcindex = v.space.getUnique();
        this.buf.write(spcindex + 32);
        this.dumpOffset(v.offset);
        this.buf.write(v.size + 32);
    }

    public void write(int val) {
        this.buf.write(val);
    }

    public void dumpOffset(long val) {
        while (val != 0L) {
            int chunk = (int)(val & 0x3FL);
            val >>>= 6;
            this.buf.write(chunk + 32);
        }
        this.buf.write(96);
    }

    private void insertOffset(int streampos, long val) {
        while (val != 0L) {
            if (this.buf.getByte(streampos) == 96) {
                throw new SleighException("Could not properly insert relative jump offset");
            }
            int chunk = (int)(val & 0x3FL);
            val >>>= 6;
            this.buf.insertByte(streampos, chunk + 32);
            ++streampos;
        }
        for (int i = 0; i < 11; ++i) {
            if (this.buf.getByte(streampos) == 96) {
                return;
            }
            this.buf.insertByte(streampos, 32);
            ++streampos;
        }
        throw new SleighException("Could not find terminator while inserting relative jump offset");
    }

    public class LabelRef {
        public int opIndex;
        public int labelIndex;
        public int labelSize;
        public int streampos;

        public LabelRef(int op, int lab, int size, int stream) {
            this.opIndex = op;
            this.labelIndex = lab;
            this.labelSize = size;
            this.streampos = stream;
        }
    }
}

