/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.ConvertedRecordIterator;
import db.DBHandle;
import db.DBLongIterator;
import db.Field;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.map.AddressIndexKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.EquateRefDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class EquateRefDBAdapterV0
extends EquateRefDBAdapter {
    private Table refTable;
    private AddressMap addrMap;
    static final int V0_EQUATE_ID_COL = 0;
    static final int V0_ADDR_COL = 1;
    static final int V0_OP_INDEX_COL = 2;

    EquateRefDBAdapterV0(DBHandle handle, AddressMap addrMap) throws VersionException {
        this.addrMap = addrMap;
        this.refTable = handle.getTable("Equate References");
        if (this.refTable == null) {
            throw new VersionException("Missing Table: Equate References");
        }
        if (this.refTable.getSchema().getVersion() != 0) {
            throw new VersionException(false);
        }
    }

    @Override
    Record getRecord(long key) throws IOException {
        return EquateRefDBAdapterV0.convertV0Record(this.refTable.getRecord(key));
    }

    @Override
    Record createReference(long addr, short opIndex, long dynamicHash, long equateID) {
        throw new UnsupportedOperationException();
    }

    @Override
    long[] getRecordKeysForAddr(long addr) throws IOException {
        return this.refTable.findRecords((Field)new LongField(addr), 1);
    }

    @Override
    void updateRecord(Record record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    long[] getRecordKeysForEquateID(long equateID) throws IOException {
        return this.refTable.findRecords((Field)new LongField(equateID), 0);
    }

    @Override
    DBLongIterator getIteratorForAddresses() throws IOException {
        return new AddressIndexKeyIterator(this.refTable, 1, this.addrMap, true);
    }

    @Override
    DBLongIterator getIteratorForAddresses(Address start, Address end) throws IOException {
        return new AddressIndexKeyIterator(this.refTable, 1, this.addrMap, start, end, true);
    }

    @Override
    DBLongIterator getIteratorForAddresses(Address start) throws IOException {
        return new AddressIndexKeyIterator(this.refTable, 1, this.addrMap, start, true);
    }

    @Override
    DBLongIterator getIteratorForAddresses(AddressSetView set) throws IOException {
        return new AddressIndexKeyIterator(this.refTable, 1, this.addrMap, set, true);
    }

    @Override
    void removeRecord(long key) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return new MyRecordConversionIterator(this.refTable.iterator());
    }

    @Override
    void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    int getRecordCount() {
        return this.refTable.getRecordCount();
    }

    private static Record convertV0Record(Record record) {
        if (record == null) {
            return null;
        }
        Record newRec = REFS_SCHEMA.createRecord(record.getKey());
        newRec.setLongValue(0, record.getLongValue(0));
        newRec.setLongValue(1, record.getLongValue(1));
        newRec.setShortValue(2, record.getShortValue(2));
        newRec.setLongValue(3, 0L);
        return newRec;
    }

    private static class MyRecordConversionIterator
    extends ConvertedRecordIterator {
        MyRecordConversionIterator(RecordIterator originalIterator) {
            super(originalIterator, false);
        }

        protected Record convertRecord(Record record) {
            return EquateRefDBAdapterV0.convertV0Record(record);
        }
    }
}

