/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.mem;

import ghidra.framework.store.LockException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.LiveMemoryHandler;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockException;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.InputStream;

public interface Memory
extends AddressSetView {
    public static final int GBYTE_SHIFT_FACTOR = 30;
    public static final long GBYTE = 0x40000000L;
    public static final int MAX_BINARY_SIZE_GB = 16;
    public static final long MAX_BINARY_SIZE = 0x400000000L;
    public static final int MAX_INITIALIZED_BLOCK_SIZE_GB = 1;
    public static final long MAX_INITIALIZED_BLOCK_SIZE = 0x40000000L;
    public static final int MAX_UNINITIALIZED_BLOCK_SIZE_GB = 12;
    public static final long MAX_UNINITIALIZED_BLOCK_SIZE = 0x300000000L;

    public Program getProgram();

    public AddressSetView getLoadedAndInitializedAddressSet();

    public AddressSetView getAllInitializedAddressSet();

    @Deprecated
    public AddressSetView getInitializedAddressSet();

    public AddressSetView getExecuteSet();

    public boolean isBigEndian();

    public void setLiveMemoryHandler(LiveMemoryHandler var1);

    public LiveMemoryHandler getLiveMemoryHandler();

    public MemoryBlock createInitializedBlock(String var1, Address var2, InputStream var3, long var4, TaskMonitor var6, boolean var7) throws LockException, MemoryConflictException, AddressOverflowException, CancelledException, DuplicateNameException;

    public MemoryBlock createInitializedBlock(String var1, Address var2, long var3, byte var5, TaskMonitor var6, boolean var7) throws LockException, DuplicateNameException, MemoryConflictException, AddressOverflowException, CancelledException;

    public MemoryBlock createUninitializedBlock(String var1, Address var2, long var3, boolean var5) throws LockException, DuplicateNameException, MemoryConflictException, AddressOverflowException;

    public MemoryBlock createBitMappedBlock(String var1, Address var2, Address var3, long var4) throws LockException, MemoryConflictException, AddressOverflowException;

    public MemoryBlock createByteMappedBlock(String var1, Address var2, Address var3, long var4) throws LockException, MemoryConflictException, AddressOverflowException;

    public MemoryBlock createBlock(MemoryBlock var1, String var2, Address var3, long var4) throws LockException, MemoryConflictException, AddressOverflowException;

    public void removeBlock(MemoryBlock var1, TaskMonitor var2) throws LockException;

    public long getSize();

    public MemoryBlock getBlock(Address var1);

    public MemoryBlock getBlock(String var1);

    public MemoryBlock[] getBlocks();

    public void moveBlock(MemoryBlock var1, Address var2, TaskMonitor var3) throws LockException, MemoryBlockException, MemoryConflictException, AddressOverflowException, NotFoundException;

    public void split(MemoryBlock var1, Address var2) throws MemoryBlockException, LockException, NotFoundException;

    public MemoryBlock join(MemoryBlock var1, MemoryBlock var2) throws LockException, MemoryBlockException, NotFoundException;

    public MemoryBlock convertToInitialized(MemoryBlock var1, byte var2) throws LockException, MemoryBlockException, NotFoundException;

    public MemoryBlock convertToUninitialized(MemoryBlock var1) throws MemoryBlockException, NotFoundException, LockException;

    public Address findBytes(Address var1, byte[] var2, byte[] var3, boolean var4, TaskMonitor var5);

    public Address findBytes(Address var1, Address var2, byte[] var3, byte[] var4, boolean var5, TaskMonitor var6);

    public byte getByte(Address var1) throws MemoryAccessException;

    public int getBytes(Address var1, byte[] var2) throws MemoryAccessException;

    public int getBytes(Address var1, byte[] var2, int var3, int var4) throws MemoryAccessException;

    public short getShort(Address var1) throws MemoryAccessException;

    public short getShort(Address var1, boolean var2) throws MemoryAccessException;

    public int getShorts(Address var1, short[] var2) throws MemoryAccessException;

    public int getShorts(Address var1, short[] var2, int var3, int var4) throws MemoryAccessException;

    public int getShorts(Address var1, short[] var2, int var3, int var4, boolean var5) throws MemoryAccessException;

    public int getInt(Address var1) throws MemoryAccessException;

    public int getInt(Address var1, boolean var2) throws MemoryAccessException;

    public int getInts(Address var1, int[] var2) throws MemoryAccessException;

    public int getInts(Address var1, int[] var2, int var3, int var4) throws MemoryAccessException;

    public int getInts(Address var1, int[] var2, int var3, int var4, boolean var5) throws MemoryAccessException;

    public long getLong(Address var1) throws MemoryAccessException;

    public long getLong(Address var1, boolean var2) throws MemoryAccessException;

    public int getLongs(Address var1, long[] var2) throws MemoryAccessException;

    public int getLongs(Address var1, long[] var2, int var3, int var4) throws MemoryAccessException;

    public int getLongs(Address var1, long[] var2, int var3, int var4, boolean var5) throws MemoryAccessException;

    public void setByte(Address var1, byte var2) throws MemoryAccessException;

    public void setBytes(Address var1, byte[] var2) throws MemoryAccessException;

    public void setBytes(Address var1, byte[] var2, int var3, int var4) throws MemoryAccessException;

    public void setShort(Address var1, short var2) throws MemoryAccessException;

    public void setShort(Address var1, short var2, boolean var3) throws MemoryAccessException;

    public void setInt(Address var1, int var2) throws MemoryAccessException;

    public void setInt(Address var1, int var2, boolean var3) throws MemoryAccessException;

    public void setLong(Address var1, long var2) throws MemoryAccessException;

    public void setLong(Address var1, long var2, boolean var4) throws MemoryAccessException;
}

