/*
 * Decompiled with CFR 0.152.
 */
package docking;

import ghidra.util.datastruct.FixedSizeStack;
import javax.swing.undo.UndoableEdit;

public class UndoRedoKeeper {
    private static final int MAX_UNDO_REDO_SIZE = 50;
    private FixedSizeStack<UndoableEdit> undoStack = new FixedSizeStack(50);
    private FixedSizeStack<UndoableEdit> redoStack = new FixedSizeStack(50);

    void addUndo(UndoableEdit edit) {
        this.undoStack.push((Object)edit);
        this.redoStack.clear();
    }

    void undo() {
        if (this.undoStack.isEmpty()) {
            return;
        }
        UndoableEdit item = (UndoableEdit)this.undoStack.pop();
        this.redoStack.push((Object)item);
        item.undo();
    }

    void redo() {
        if (this.redoStack.isEmpty()) {
            return;
        }
        UndoableEdit item = (UndoableEdit)this.redoStack.pop();
        this.undoStack.push((Object)item);
        item.redo();
    }

    public void clear() {
        this.undoStack.clear();
        this.redoStack.clear();
    }
}

