/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint.dialog;

import docking.widgets.table.RowObjectFilterModel;
import docking.widgets.table.columnfilter.ColumnBasedTableFilter;
import docking.widgets.table.columnfilter.ColumnConstraintSet;
import docking.widgets.table.columnfilter.LogicOperation;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnData;
import docking.widgets.table.constraint.dialog.ColumnFilterData;
import docking.widgets.table.constraint.dialog.DialogFilterCondition;
import docking.widgets.table.constraint.dialog.DialogFilterRow;
import docking.widgets.table.constrainteditor.ColumnConstraintEditor;
import java.util.ArrayList;
import java.util.List;

public class DialogFilterConditionSet<T> {
    private final DialogFilterRow filterRow;
    private final ColumnFilterData<T> columnFilterData;
    private final List<DialogFilterCondition<T>> conditionSet = new ArrayList<DialogFilterCondition<T>>();

    DialogFilterConditionSet(DialogFilterRow filterRow, ColumnFilterData<T> columnFilterData) {
        this.filterRow = filterRow;
        this.columnFilterData = columnFilterData;
        this.conditionSet.add(new DialogFilterCondition(this));
    }

    DialogFilterConditionSet(DialogFilterRow filterRow, ColumnConstraintSet<?, T> columnFilter) {
        this.filterRow = filterRow;
        this.columnFilterData = this.getColumnFilterData(columnFilter.getColumnModelIndex());
        ArrayList<ColumnConstraint<T>> constraints = new ArrayList<ColumnConstraint<T>>(columnFilter.getConstraints());
        for (ColumnConstraint columnConstraint : constraints) {
            this.conditionSet.add(new DialogFilterCondition(this, columnConstraint));
        }
    }

    DialogFilterCondition<T> addFilterCondition() {
        DialogFilterCondition condition = new DialogFilterCondition(this);
        this.conditionSet.add(condition);
        this.filterRow.conditionSetChanged(this);
        return condition;
    }

    ColumnFilterData<T> getColumnFilterData() {
        return this.columnFilterData;
    }

    boolean hasValidFilterValue() {
        for (DialogFilterCondition<T> condition : this.conditionSet) {
            if (condition.hasValidFilterValue()) continue;
            return false;
        }
        return true;
    }

    void conditionChanged(DialogFilterCondition<T> condition) {
        this.filterRow.conditionSetChanged(this);
    }

    void editorValueChanged(ColumnConstraintEditor<T> editor) {
        this.filterRow.editorValueChanged(editor);
    }

    void addToTableFilter(ColumnBasedTableFilter<?> tableColumnFilter, LogicOperation logicOperation) {
        ArrayList orConditions = new ArrayList();
        for (DialogFilterCondition<T> condition : this.conditionSet) {
            orConditions.add(condition.getConstraint());
        }
        tableColumnFilter.addConstraintSet(logicOperation, this.columnFilterData.getColumnModelIndex(), orConditions);
    }

    List<DialogFilterCondition<T>> getFilterConditions() {
        return this.conditionSet;
    }

    <R> ColumnData<T> getColumnData() {
        final RowObjectFilterModel<?> tableModel = this.filterRow.getTableModel();
        final int columnModelIndex = this.columnFilterData.getColumnModelIndex();
        return new ColumnData<T>(){

            @Override
            public String getColumnName() {
                return tableModel.getColumnName(columnModelIndex);
            }

            @Override
            public int getCount() {
                return tableModel.getUnfilteredRowCount();
            }

            @Override
            public T getColumnValue(int row) {
                Object rowObject = tableModel.getUnfilteredData().get(row);
                return tableModel.getColumnValueForRow(rowObject, columnModelIndex);
            }

            @Override
            public Object getTableDataSource() {
                return DialogFilterConditionSet.this.filterRow.getDataSource();
            }
        };
    }

    void delete(DialogFilterCondition<T> condition) {
        this.conditionSet.remove(condition);
        if (this.conditionSet.isEmpty()) {
            this.filterRow.delete();
        } else {
            this.filterRow.conditionSetChanged(this);
        }
    }

    private ColumnFilterData<T> getColumnFilterData(int columnModelIndex) {
        List<ColumnFilterData<?>> columnDataList = this.filterRow.getAllColumnData();
        for (ColumnFilterData<?> data : columnDataList) {
            if (data.getColumnModelIndex() != columnModelIndex) continue;
            return data;
        }
        return null;
    }

    public String toString() {
        return "{\n\tfilterRow: " + this.filterRow + ",\n\tdata: " + this.columnFilterData + ",\n\tconditions: " + this.conditionSet + "\n}";
    }
}

