/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.constantpool;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.javaclass.format.constantpool.ConstantPoolClassInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolDoubleInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolFieldReferenceInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolFloatInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolIntegerInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolInterfaceMethodReferenceInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolInvokeDynamicInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolLongInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolMethodHandleInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolMethodReferenceInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolMethodTypeInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolNameAndTypeInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolStringInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolUtf8Info;
import java.io.IOException;

public class ConstantPoolFactory {
    public static AbstractConstantPoolInfoJava get(BinaryReader reader) throws IOException {
        switch (reader.peekNextByte()) {
            case 7: {
                return new ConstantPoolClassInfo(reader);
            }
            case 6: {
                return new ConstantPoolDoubleInfo(reader);
            }
            case 9: {
                return new ConstantPoolFieldReferenceInfo(reader);
            }
            case 4: {
                return new ConstantPoolFloatInfo(reader);
            }
            case 3: {
                return new ConstantPoolIntegerInfo(reader);
            }
            case 11: {
                return new ConstantPoolInterfaceMethodReferenceInfo(reader);
            }
            case 18: {
                return new ConstantPoolInvokeDynamicInfo(reader);
            }
            case 5: {
                return new ConstantPoolLongInfo(reader);
            }
            case 15: {
                return new ConstantPoolMethodHandleInfo(reader);
            }
            case 10: {
                return new ConstantPoolMethodReferenceInfo(reader);
            }
            case 16: {
                return new ConstantPoolMethodTypeInfo(reader);
            }
            case 12: {
                return new ConstantPoolNameAndTypeInfo(reader);
            }
            case 8: {
                return new ConstantPoolStringInfo(reader);
            }
            case 1: {
                return new ConstantPoolUtf8Info(reader);
            }
            case 0: {
                return null;
            }
        }
        throw new RuntimeException();
    }
}

