/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.base.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;

/**
 * An action that can be added to a menu in order to separate menu items into groups
 */
public class HorizontalRuleAction extends DockingAction {

	private static int idCount = 0;

	/**
	 * Constructor
	 * 
	 * @param owner the action owner
	 * @param topName the name that will appear above the separator bar
	 * @param bottomName the name that will apppear below the separator bar
	 */
	public HorizontalRuleAction(String owner, String topName, String bottomName) {
		super("HorizontalRuleAction: " + ++idCount, owner, false);
		setEnabled(false);

		// the menu name is both names, one over the other, in a small, light grayish font
		setMenuBarData(new MenuData(new String[] { "<HTML><CENTER><FONT SIZE=2 COLOR=SILVER>" +
			topName + "<BR>" + bottomName + "</FONT></CENTER>" }));

		// the description is meant to be used for the tooltip and is larger
		String padding = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
		setDescription("<HTML><CENTER><B>" + padding + topName + padding + "<B><HR><B>" + padding +
			bottomName + padding + "</B></CENTER>");
	}

	@Override
	public void actionPerformed(ActionContext context) {
		// this does't actually do anything
	}

}
