/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.api;

import co.elastic.logstash.api.PluginConfigSpec;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;

public final class Configuration {
    private final Map<String, Object> rawSettings;

    public Configuration(Map<String, Object> raw) {
        this.rawSettings = raw;
    }

    public <T> T get(PluginConfigSpec<T> configSpec) {
        if (this.rawSettings.containsKey(configSpec.name())) {
            Object o = this.rawSettings.get(configSpec.name());
            if (configSpec.type().isAssignableFrom(o.getClass())) {
                return (T)o;
            }
            throw new IllegalStateException(String.format("Setting value for '%s' of type '%s' incompatible with defined type of '%s'", configSpec.name(), o.getClass(), configSpec.type()));
        }
        return configSpec.defaultValue();
    }

    public Object getRawValue(PluginConfigSpec<?> configSpec) {
        return this.rawSettings.get(configSpec.name());
    }

    public boolean contains(PluginConfigSpec<?> configSpec) {
        return this.rawSettings.containsKey(configSpec.name());
    }

    public Collection<String> allKeys() {
        return this.rawSettings.keySet();
    }

    public static PluginConfigSpec<String> stringSetting(String name) {
        return new PluginConfigSpec<Object>(name, String.class, null, false, false);
    }

    public static PluginConfigSpec<String> stringSetting(String name, String defaultValue) {
        return new PluginConfigSpec<String>(name, String.class, defaultValue, false, false);
    }

    public static PluginConfigSpec<String> requiredStringSetting(String name) {
        return new PluginConfigSpec<Object>(name, String.class, null, false, true);
    }

    public static PluginConfigSpec<Long> numSetting(String name) {
        return new PluginConfigSpec<Object>(name, Long.class, null, false, false);
    }

    public static PluginConfigSpec<Long> numSetting(String name, long defaultValue) {
        return new PluginConfigSpec<Long>(name, Long.class, defaultValue, false, false);
    }

    public static PluginConfigSpec<Path> pathSetting(String name) {
        return new PluginConfigSpec<Object>(name, Path.class, null, false, false);
    }

    public static PluginConfigSpec<Boolean> booleanSetting(String name) {
        return new PluginConfigSpec<Object>(name, Boolean.class, null, false, false);
    }

    public static PluginConfigSpec<Map<String, String>> hashSetting(String name) {
        return new PluginConfigSpec<Object>(name, Map.class, null, false, false);
    }

    public static <T> PluginConfigSpec<Map<String, T>> requiredFlatHashSetting(String name, Class<T> type) {
        return new PluginConfigSpec<Object>(name, Map.class, null, false, true);
    }

    public static PluginConfigSpec<Map<String, Configuration>> requiredNestedHashSetting(String name, Collection<PluginConfigSpec<?>> spec) {
        return new PluginConfigSpec<Object>(name, Map.class, null, false, true, spec);
    }
}

