/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.server.data.mspdi;

import com.projectlibre.core.time.TimephasedType;
import com.projectlibre1.configuration.Settings;
import com.projectlibre1.contrib.util.Log;
import com.projectlibre1.contrib.util.LogFactory;
import com.projectlibre1.exchange.ImportedCalendarService;
import com.projectlibre1.pm.assignment.Assignment;
import com.projectlibre1.pm.calendar.CalendarService;
import com.projectlibre1.pm.snapshot.Snapshottable;
import com.projectlibre1.pm.task.NormalTask;
import com.projectlibre1.pm.task.TaskSnapshot;
import com.projectlibre1.server.data.MPXConverter;
import com.projectlibre1.server.data.mspdi.TimephasedConsumer;
import com.projectlibre1.server.data.mspdi.TimephasedService;
import com.projectlibre1.util.DateTime;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.mspdi.DatatypeConverter;
import net.sf.mpxj.mspdi.MSPDIWriter;
import net.sf.mpxj.mspdi.schema.Project;
import net.sf.mpxj.mspdi.schema.TimephasedDataType;

public class ModifiedMSPDIWriter
extends MSPDIWriter {
    static Log log = LogFactory.getLog(ModifiedMSPDIWriter.class);
    protected com.projectlibre1.pm.task.Project projectlibre1Project;
    protected Map projectlibreTaskMap = new HashMap();
    protected Map projectlibreAssignmentMap = new HashMap();
    protected Map projectlibreSnapshotIdMap = new HashMap();
    protected Map timephasedMap = new HashMap();
    private static Resource UNASSIGNED = null;

    protected Boolean formatOutput() {
        return Boolean.FALSE;
    }

    public void setProjectFile(ProjectFile projectFile) {
        this.m_projectFile = projectFile;
    }

    private Resource unassignedResource() {
        if (UNASSIGNED == null) {
            UNASSIGNED = this.m_projectFile.addResource();
            UNASSIGNED.setUniqueID(-65535);
        }
        return UNASSIGNED;
    }

    protected void writeProjectCalendar(Project project) {
        int n = 1;
        ProjectCalendar projectCalendar = ImportedCalendarService.getInstance().findExportedCalendar(CalendarService.findBaseCalendar(this.m_projectFile.getProjectProperties().getDefaultCalendarName()));
        if (projectCalendar != null) {
            n = projectCalendar.getUniqueID();
        } else {
            log.warn("EXPORT: Could not export project calendar: Project: " + this.m_projectFile.getProjectProperties().getName() + " calendar " + this.m_projectFile.getProjectProperties().getDefaultCalendarName());
        }
        project.setCalendarUID(BigInteger.valueOf(n));
    }

    @Override
    protected void writeResources(Project project) {
        Project.Resources resources = this.m_factory.createProjectResources();
        project.setResources(resources);
        List<Project.Resources.Resource> list = resources.getResource();
        for (Resource resource : this.m_projectFile.getAllResources()) {
            if (resource.getUniqueID() == -65535) continue;
            list.add(this.writeResource(resource));
        }
    }

    @Override
    protected Project.Tasks.Task writeTask(Task task) {
        Number number = task.getFixedCost();
        if (number == null || Double.isNaN(number.doubleValue())) {
            task.setFixedCost(null);
        }
        Project.Tasks.Task task2 = super.writeTask(task);
        if (!task.getNull()) {
            this.writeTaskBaselinesAndTimephased(task2, task);
        }
        return task2;
    }

    @Override
    protected Project.Assignments.Assignment writeAssignment(ResourceAssignment resourceAssignment) {
        Project.Assignments.Assignment assignment = super.writeAssignment(resourceAssignment);
        if (resourceAssignment.getResourceUniqueID() == 0) {
            assignment.setResourceUID(BigInteger.valueOf(-65535L));
        }
        Assignment assignment2 = (Assignment)this.projectlibreAssignmentMap.get(resourceAssignment);
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        gregorianCalendar.setTimeInMillis(assignment2.getStop());
        assignment.setStop(gregorianCalendar);
        GregorianCalendar gregorianCalendar2 = DateTime.calendarInstance();
        gregorianCalendar2.setTimeInMillis(assignment2.getResume());
        assignment.setResume(gregorianCalendar2);
        this.writeAssigmentBaselinesAndTimephased(assignment, resourceAssignment, assignment2.getStart(), assignment2.getFinish());
        return assignment;
    }

    public void setOPPrProject(com.projectlibre1.pm.task.Project project) {
        this.projectlibre1Project = project;
    }

    public void putOPPrTaskMap(Object object, Object object2) {
        this.projectlibreTaskMap.put(object, object2);
    }

    public void putOPPrAssignmentMap(Object object, Object object2) {
        this.projectlibreAssignmentMap.put(object, object2);
    }

    public void putOPPrSnapshotIdMap(Object object, Object object2) {
        this.projectlibreSnapshotIdMap.put(object, object2);
    }

    public void putTimephasedList(Object object, Object object2) {
        if (object == null || object2 == null) {
            return;
        }
        this.timephasedMap.put(object, object2);
    }

    public List getTimephasedList(Object object) {
        return (List)this.timephasedMap.get(object);
    }

    public Resource getResourceByUniqueID(int n) {
        Resource resource = n == -65535 ? this.unassignedResource() : this.m_projectFile.getResourceByUniqueID(n);
        return resource;
    }

    private void writeTaskBaselinesAndTimephased(Project.Tasks.Task task, Task task2) {
        List<Project.Tasks.Task.Baseline> list = task.getBaseline();
        NormalTask normalTask = (NormalTask)this.projectlibreTaskMap.get(task2);
        if (normalTask == null) {
            return;
        }
        for (int i = 0; i < Settings.numBaselines(); ++i) {
            TaskSnapshot taskSnapshot;
            if (i == Snapshottable.CURRENT || (taskSnapshot = (TaskSnapshot)normalTask.getSnapshot(new Integer(i))) == null) continue;
            Project.Tasks.Task.Baseline baseline = this.m_factory.createProjectTasksTaskBaseline();
            baseline.setNumber(BigInteger.valueOf(i));
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(DateTime.fromGmt(normalTask.getBaselineStart(i)));
            baseline.setStart(calendar);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTimeInMillis(DateTime.fromGmt(normalTask.getBaselineFinish(i)));
            baseline.setFinish(calendar2);
            baseline.setWork(DatatypeConverter.printDuration(this, MPXConverter.toMPXDuration((long)normalTask.getBaselineWork(i))));
            list.add(baseline);
        }
    }

    private void writeAssigmentBaselinesAndTimephased(final Project.Assignments.Assignment assignment, ResourceAssignment resourceAssignment, final long l, long l2) {
        int n = (Integer)this.projectlibreSnapshotIdMap.get(resourceAssignment);
        Assignment assignment2 = (Assignment)this.projectlibreAssignmentMap.get(resourceAssignment);
        final List<TimephasedDataType> list = assignment.getTimephasedData();
        final long[] lArray = new long[]{-1L};
        final long[] lArray2 = new long[11];
        final long[] lArray3 = new long[11];
        TimephasedService.getInstance().consumeTimephased(assignment2, new TimephasedConsumer(){

            @Override
            public void consumeTimephased(Object object) {
                TimephasedDataType timephasedDataType = (TimephasedDataType)object;
                if (lArray[0] == -1L) {
                    lArray[0] = timephasedDataType.getStart().getTimeInMillis() < l ? l - timephasedDataType.getStart().getTimeInMillis() : 0L;
                }
                if (lArray[0] > 0L) {
                    timephasedDataType.getStart().setTimeInMillis(timephasedDataType.getStart().getTimeInMillis() + lArray[0]);
                    timephasedDataType.getFinish().setTimeInMillis(timephasedDataType.getFinish().getTimeInMillis() + lArray[0]);
                }
                ((TimephasedDataType)object).setUID(assignment.getUID());
                TimephasedType timephasedType = TimephasedType.getInstance(timephasedDataType.getType().intValue());
                int n = timephasedType.getSnapshotId();
                if (n >= 0 && n < 11) {
                    if (lArray2[n] <= 0L || lArray2[n] < timephasedDataType.getStart().getTimeInMillis()) {
                        lArray2[n] = timephasedDataType.getStart().getTimeInMillis();
                    }
                    if (lArray3[n] <= 0L || lArray3[n] < timephasedDataType.getFinish().getTimeInMillis()) {
                        lArray3[n] = timephasedDataType.getFinish().getTimeInMillis();
                    }
                }
                list.add(timephasedDataType);
            }

            @Override
            public boolean acceptValue(double d) {
                return d != 0.0;
            }
        }, this.m_factory);
        for (int i = 0; i < 11; ++i) {
            if (lArray2[i] <= 0L || lArray3[i] <= 0L) continue;
            Project.Assignments.Assignment.Baseline baseline = this.m_factory.createProjectAssignmentsAssignmentBaseline();
            baseline.setStart(DatatypeConverter.printExtendedAttributeDate(new Date(lArray2[i])));
            baseline.setFinish(DatatypeConverter.printExtendedAttributeDate(new Date(lArray3[i])));
            baseline.setNumber(Integer.toString(i));
            assignment.getBaseline().add(baseline);
        }
    }

    public ProjectFile getProjectFile() {
        return this.m_projectFile;
    }
}

