/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SpecProvider;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.ValidatingJsonMap;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.ConfigEditablePlugin;
import org.apache.solr.security.JWTPrincipal;
import org.apache.solr.security.JWTPrincipalWithUserRoles;
import org.eclipse.jetty.client.api.Request;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.InvalidJwtSignatureException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTAuthPlugin
extends AuthenticationPlugin
implements SpecProvider,
ConfigEditablePlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PARAM_BLOCK_UNKNOWN = "blockUnknown";
    private static final String PARAM_JWK_URL = "jwkUrl";
    private static final String PARAM_JWK = "jwk";
    private static final String PARAM_ISSUER = "iss";
    private static final String PARAM_AUDIENCE = "aud";
    private static final String PARAM_REQUIRE_SUBJECT = "requireSub";
    private static final String PARAM_PRINCIPAL_CLAIM = "principalClaim";
    private static final String PARAM_REQUIRE_EXPIRATIONTIME = "requireExp";
    private static final String PARAM_ALG_WHITELIST = "algWhitelist";
    private static final String PARAM_JWK_CACHE_DURATION = "jwkCacheDur";
    private static final String PARAM_CLAIMS_MATCH = "claimsMatch";
    private static final String PARAM_SCOPE = "scope";
    private static final String PARAM_ADMINUI_SCOPE = "adminUiScope";
    private static final String PARAM_REDIRECT_URIS = "redirectUris";
    private static final String PARAM_CLIENT_ID = "clientId";
    private static final String PARAM_WELL_KNOWN_URL = "wellKnownUrl";
    private static final String PARAM_AUTHORIZATION_ENDPOINT = "authorizationEndpoint";
    private static final String AUTH_REALM = "solr-jwt";
    private static final String CLAIM_SCOPE = "scope";
    private static final long RETRY_INIT_DELAY_SECONDS = 30L;
    private static final Set<String> PROPS = ImmutableSet.of((Object)"blockUnknown", (Object)"jwkUrl", (Object)"jwk", (Object)"iss", (Object)"aud", (Object)"requireSub", (Object[])new String[]{"principalClaim", "requireExp", "algWhitelist", "jwkCacheDur", "claimsMatch", "scope", "clientId", "wellKnownUrl", "authorizationEndpoint", "adminUiScope", "redirectUris"});
    private JwtConsumer jwtConsumer;
    private String iss;
    private String aud;
    private boolean requireSubject;
    private boolean requireExpirationTime;
    private List<String> algWhitelist;
    VerificationKeyResolver verificationKeyResolver;
    private String principalClaim;
    private HashMap<String, Pattern> claimsMatchCompiled;
    private boolean blockUnknown;
    private List<String> requiredScopes = new ArrayList<String>();
    private String clientId;
    private long jwkCacheDuration;
    private WellKnownDiscoveryConfig oidcDiscoveryConfig;
    private String confIdpConfigUrl;
    private Map<String, Object> pluginConfig;
    private Instant lastInitTime = Instant.now();
    private String authorizationEndpoint;
    private String adminUiScope;
    private List<String> redirectUris;
    private HttpsJwks httpsJkws;

    @Override
    public void init(Map<String, Object> pluginConfig) {
        List unknownKeys = pluginConfig.keySet().stream().filter(k -> !PROPS.contains(k)).collect(Collectors.toList());
        unknownKeys.remove("class");
        unknownKeys.remove("");
        if (!unknownKeys.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid JwtAuth configuration parameter " + unknownKeys);
        }
        this.blockUnknown = Boolean.parseBoolean(String.valueOf(pluginConfig.getOrDefault(PARAM_BLOCK_UNKNOWN, false)));
        this.clientId = (String)pluginConfig.get(PARAM_CLIENT_ID);
        this.requireSubject = Boolean.parseBoolean(String.valueOf(pluginConfig.getOrDefault(PARAM_REQUIRE_SUBJECT, "true")));
        this.requireExpirationTime = Boolean.parseBoolean(String.valueOf(pluginConfig.getOrDefault(PARAM_REQUIRE_EXPIRATIONTIME, "true")));
        this.principalClaim = (String)pluginConfig.getOrDefault(PARAM_PRINCIPAL_CLAIM, "sub");
        this.confIdpConfigUrl = (String)pluginConfig.get(PARAM_WELL_KNOWN_URL);
        Object redirectUrisObj = pluginConfig.get(PARAM_REDIRECT_URIS);
        this.redirectUris = Collections.emptyList();
        if (redirectUrisObj != null) {
            if (redirectUrisObj instanceof String) {
                this.redirectUris = Collections.singletonList((String)redirectUrisObj);
            } else if (redirectUrisObj instanceof List) {
                this.redirectUris = (List)redirectUrisObj;
            }
        }
        if (this.confIdpConfigUrl != null) {
            log.debug("Initializing well-known oidc config from {}", (Object)this.confIdpConfigUrl);
            this.oidcDiscoveryConfig = WellKnownDiscoveryConfig.parse(this.confIdpConfigUrl);
            this.iss = this.oidcDiscoveryConfig.getIssuer();
            this.authorizationEndpoint = this.oidcDiscoveryConfig.getAuthorizationEndpoint();
        }
        if (pluginConfig.containsKey(PARAM_ISSUER)) {
            if (this.iss != null) {
                log.debug("Explicitly setting required issuer instead of using issuer from well-known config");
            }
            this.iss = (String)pluginConfig.get(PARAM_ISSUER);
        }
        if (pluginConfig.containsKey(PARAM_AUTHORIZATION_ENDPOINT)) {
            if (this.authorizationEndpoint != null) {
                log.debug("Explicitly setting authorizationEndpoint instead of using issuer from well-known config");
            }
            this.authorizationEndpoint = (String)pluginConfig.get(PARAM_AUTHORIZATION_ENDPOINT);
        }
        if (pluginConfig.containsKey(PARAM_AUDIENCE)) {
            if (this.clientId != null) {
                log.debug("Explicitly setting required audience instead of using configured clientId");
            }
            this.aud = (String)pluginConfig.get(PARAM_AUDIENCE);
        } else {
            this.aud = this.clientId;
        }
        this.algWhitelist = (List)pluginConfig.get(PARAM_ALG_WHITELIST);
        String requiredScopesStr = (String)pluginConfig.get("scope");
        if (!StringUtils.isEmpty((String)requiredScopesStr)) {
            this.requiredScopes = Arrays.asList(requiredScopesStr.split("\\s+"));
        }
        this.adminUiScope = (String)pluginConfig.get(PARAM_ADMINUI_SCOPE);
        if (this.adminUiScope == null && this.requiredScopes.size() > 0) {
            this.adminUiScope = this.requiredScopes.get(0);
            log.warn("No adminUiScope given, using first scope in 'scope' list as required scope for accessing Admin UI");
        }
        if (this.adminUiScope == null) {
            this.adminUiScope = "solr";
            log.warn("Warning: No adminUiScope provided, fallback to 'solr' as required scope. If this is not correct, the Admin UI login may not work");
        }
        Map claimsMatch = (Map)pluginConfig.get(PARAM_CLAIMS_MATCH);
        this.claimsMatchCompiled = new HashMap();
        if (claimsMatch != null) {
            for (Map.Entry entry : claimsMatch.entrySet()) {
                this.claimsMatchCompiled.put((String)entry.getKey(), Pattern.compile((String)entry.getValue()));
            }
        }
        this.initJwk(pluginConfig);
        this.lastInitTime = Instant.now();
    }

    private void initJwk(Map<String, Object> pluginConfig) {
        this.pluginConfig = pluginConfig;
        String confJwkUrl = (String)pluginConfig.get(PARAM_JWK_URL);
        Map confJwk = (Map)pluginConfig.get(PARAM_JWK);
        this.jwkCacheDuration = Long.parseLong((String)pluginConfig.getOrDefault(PARAM_JWK_CACHE_DURATION, "3600"));
        this.jwtConsumer = null;
        int jwkConfigured = this.confIdpConfigUrl != null ? 1 : 0;
        jwkConfigured += confJwkUrl != null ? 1 : 0;
        if ((jwkConfigured += confJwk != null ? 1 : 0) > 1) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "JWTAuthPlugin needs to configure exactly one of wellKnownUrl, jwkUrl and jwk");
        }
        if (jwkConfigured == 0) {
            log.warn("Initialized JWTAuthPlugin without any JWK config. Requests with jwk header will fail.");
        }
        if (this.oidcDiscoveryConfig != null) {
            String jwkUrl = this.oidcDiscoveryConfig.getJwksUrl();
            this.setupJwkUrl(jwkUrl);
        } else if (confJwkUrl != null) {
            this.setupJwkUrl(confJwkUrl);
        } else if (confJwk != null) {
            try {
                JsonWebKeySet jwks = this.parseJwkSet(confJwk);
                this.verificationKeyResolver = new JwksVerificationKeyResolver(jwks.getJsonWebKeys());
                this.httpsJkws = null;
            }
            catch (JoseException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid JWTAuthPlugin configuration, jwk parse error", (Throwable)e);
            }
        }
        this.initConsumer();
        log.debug("JWK configured");
    }

    void setupJwkUrl(String url) {
        try {
            URL jwkUrl = new URL(url);
            if (!"https".equalsIgnoreCase(jwkUrl.getProtocol())) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "jwkUrl must be an HTTPS url");
            }
        }
        catch (MalformedURLException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "jwkUrl must be a valid URL");
        }
        this.httpsJkws = new HttpsJwks(url);
        this.httpsJkws.setDefaultCacheDuration(this.jwkCacheDuration);
        this.httpsJkws.setRefreshReprieveThreshold(5000L);
        this.verificationKeyResolver = new HttpsJwksVerificationKeyResolver(this.httpsJkws);
    }

    JsonWebKeySet parseJwkSet(Map<String, Object> jwkObj) throws JoseException {
        JsonWebKeySet webKeySet = new JsonWebKeySet(new JsonWebKey[0]);
        if (jwkObj.containsKey("keys")) {
            List jwkList = (List)jwkObj.get("keys");
            for (Object jwkO : jwkList) {
                webKeySet.addJsonWebKey(JsonWebKey.Factory.newJwk((Map)((Map)jwkO)));
            }
        } else {
            webKeySet = new JsonWebKeySet(new JsonWebKey[]{JsonWebKey.Factory.newJwk(jwkObj)});
        }
        return webKeySet;
    }

    @Override
    public boolean doAuthenticate(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws Exception {
        JWTAuthenticationResponse authResponse;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String header = request.getHeader("Authorization");
        if (this.jwtConsumer == null) {
            if (header == null && !this.blockUnknown) {
                log.info("JWTAuth not configured, but allowing anonymous access since {}==false", (Object)PARAM_BLOCK_UNKNOWN);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                this.numPassThrough.inc();
                return true;
            }
            if (this.lastInitTime.plusSeconds(30L).isAfter(Instant.now())) {
                log.info("Retrying JWTAuthPlugin initialization (retry delay={}s)", (Object)30L);
                this.init(this.pluginConfig);
            }
            if (this.jwtConsumer == null) {
                log.warn("JWTAuth not configured");
                this.numErrors.mark();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "JWTAuth plugin not correctly configured");
            }
        }
        if (JWTAuthenticationResponse.AuthCode.SIGNATURE_INVALID.equals((Object)(authResponse = this.authenticate(header)).getAuthCode()) && this.httpsJkws != null) {
            log.warn("Signature validation failed. Refreshing JWKs from IdP before trying again: {}", (Object)(authResponse.getJwtException() == null ? "" : authResponse.getJwtException().getMessage()));
            this.httpsJkws.refresh();
            authResponse = this.authenticate(header);
        }
        String exceptionMessage = authResponse.getJwtException() != null ? authResponse.getJwtException().getMessage() : "";
        switch (authResponse.getAuthCode()) {
            case AUTHENTICATED: {
                final Principal principal = authResponse.getPrincipal();
                HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(request){

                    public Principal getUserPrincipal() {
                        return principal;
                    }
                };
                if (!(principal instanceof JWTPrincipal)) {
                    this.numErrors.mark();
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "JWTAuth plugin says AUTHENTICATED but no token extracted");
                }
                if (log.isDebugEnabled()) {
                    log.debug("Authentication SUCCESS");
                }
                filterChain.doFilter((ServletRequest)wrapper, (ServletResponse)response);
                this.numAuthenticated.inc();
                return true;
            }
            case PASS_THROUGH: {
                if (log.isDebugEnabled()) {
                    log.debug("Unknown user, but allow due to {}=false", (Object)PARAM_BLOCK_UNKNOWN);
                }
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                this.numPassThrough.inc();
                return true;
            }
            case AUTZ_HEADER_PROBLEM: 
            case JWT_PARSE_ERROR: {
                log.warn("Authentication failed. {}, {}", (Object)authResponse.getAuthCode(), (Object)authResponse.getAuthCode().getMsg());
                this.authenticationFailure(response, authResponse.getAuthCode().getMsg(), 400, BearerWwwAuthErrorCode.invalid_request);
                this.numErrors.mark();
                return false;
            }
            case CLAIM_MISMATCH: 
            case JWT_EXPIRED: 
            case JWT_VALIDATION_EXCEPTION: 
            case PRINCIPAL_MISSING: {
                log.warn("Authentication failed. {}, {}", (Object)authResponse.getAuthCode(), (Object)exceptionMessage);
                this.authenticationFailure(response, authResponse.getAuthCode().getMsg(), 401, BearerWwwAuthErrorCode.invalid_token);
                this.numWrongCredentials.inc();
                return false;
            }
            case SIGNATURE_INVALID: {
                log.warn("Signature validation failed: {}", (Object)exceptionMessage);
                this.authenticationFailure(response, authResponse.getAuthCode().getMsg(), 401, BearerWwwAuthErrorCode.invalid_token);
                this.numWrongCredentials.inc();
                return false;
            }
            case SCOPE_MISSING: {
                this.authenticationFailure(response, authResponse.getAuthCode().getMsg(), 401, BearerWwwAuthErrorCode.insufficient_scope);
                this.numWrongCredentials.inc();
                return false;
            }
        }
        this.authenticationFailure(response, authResponse.getAuthCode().getMsg(), 401, null);
        this.numMissingCredentials.inc();
        return false;
    }

    protected JWTAuthenticationResponse authenticate(String authorizationHeader) {
        if (authorizationHeader != null) {
            StringTokenizer st = new StringTokenizer(authorizationHeader);
            if (st.hasMoreTokens()) {
                String bearer = st.nextToken();
                if (bearer.equalsIgnoreCase("Bearer") && st.hasMoreTokens()) {
                    try {
                        String jwtCompact = st.nextToken();
                        try {
                            JwtClaims jwtClaims = this.jwtConsumer.processToClaims(jwtCompact);
                            String principal = jwtClaims.getStringClaimValue(this.principalClaim);
                            if (principal == null || principal.isEmpty()) {
                                return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.PRINCIPAL_MISSING, "Cannot identify principal from JWT. Required claim " + this.principalClaim + " missing. Cannot authenticate");
                            }
                            if (this.claimsMatchCompiled != null) {
                                for (Map.Entry<String, Pattern> entry : this.claimsMatchCompiled.entrySet()) {
                                    String claim = entry.getKey();
                                    if (jwtClaims.hasClaim(claim)) {
                                        if (entry.getValue().matcher(jwtClaims.getStringClaimValue(claim)).matches()) continue;
                                        return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.CLAIM_MISMATCH, "Claim " + claim + "=" + jwtClaims.getStringClaimValue(claim) + " does not match required regular expression " + entry.getValue().pattern());
                                    }
                                    return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.CLAIM_MISMATCH, "Claim " + claim + " is required but does not exist in JWT");
                                }
                            }
                            if (!this.requiredScopes.isEmpty() && !jwtClaims.hasClaim("scope")) {
                                return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.CLAIM_MISMATCH, "Claim scope is required but does not exist in JWT");
                            }
                            Set scopes = Collections.emptySet();
                            Object scopesObj = jwtClaims.getClaimValue("scope");
                            if (scopesObj != null) {
                                if (scopesObj instanceof String) {
                                    scopes = new HashSet<String>(Arrays.asList(((String)scopesObj).split("\\s+")));
                                } else if (scopesObj instanceof List) {
                                    scopes = new HashSet(jwtClaims.getStringListClaimValue("scope"));
                                }
                                if (!this.requiredScopes.isEmpty()) {
                                    if (scopes.stream().noneMatch(this.requiredScopes::contains)) {
                                        return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.SCOPE_MISSING, "Claim scope does not contain any of the required scopes: " + this.requiredScopes);
                                    }
                                }
                                HashSet<String> finalScopes = new HashSet<String>(scopes);
                                finalScopes.remove("openid");
                                return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.AUTHENTICATED, new JWTPrincipalWithUserRoles(principal, jwtCompact, jwtClaims.getClaimsMap(), finalScopes));
                            }
                            return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.AUTHENTICATED, new JWTPrincipal(principal, jwtCompact, jwtClaims.getClaimsMap()));
                        }
                        catch (InvalidJwtSignatureException ise) {
                            return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.SIGNATURE_INVALID, (InvalidJwtException)((Object)ise));
                        }
                        catch (InvalidJwtException e) {
                            if (e.hasExpired()) {
                                return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.JWT_EXPIRED, "Authentication failed due to expired JWT token. Expired at " + e.getJwtContext().getJwtClaims().getExpirationTime());
                            }
                            if (e.getCause() != null && e.getCause() instanceof JoseException && e.getCause().getMessage().contains("Invalid JOSE Compact Serialization")) {
                                return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.JWT_PARSE_ERROR, e.getCause().getMessage());
                            }
                            return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.JWT_VALIDATION_EXCEPTION, e);
                        }
                    }
                    catch (MalformedClaimException e) {
                        return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.JWT_PARSE_ERROR, "Malformed claim, error was: " + e.getMessage());
                    }
                }
                return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.AUTZ_HEADER_PROBLEM, "Authorization header is not in correct format");
            }
            return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.AUTZ_HEADER_PROBLEM, "Authorization header is not in correct format");
        }
        if (this.blockUnknown) {
            return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.NO_AUTZ_HEADER, "Missing Authorization header");
        }
        log.debug("No user authenticated, but blockUnknown=false, so letting request through");
        return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.PASS_THROUGH);
    }

    private void initConsumer() {
        JwtConsumerBuilder jwtConsumerBuilder = new JwtConsumerBuilder().setAllowedClockSkewInSeconds(30);
        if (this.iss != null) {
            jwtConsumerBuilder.setExpectedIssuer(this.iss);
        }
        if (this.aud != null) {
            jwtConsumerBuilder.setExpectedAudience(new String[]{this.aud});
        } else {
            jwtConsumerBuilder.setSkipDefaultAudienceValidation();
        }
        if (this.requireSubject) {
            jwtConsumerBuilder.setRequireSubject();
        }
        if (this.requireExpirationTime) {
            jwtConsumerBuilder.setRequireExpirationTime();
        }
        if (this.algWhitelist != null) {
            jwtConsumerBuilder.setJwsAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, this.algWhitelist.toArray(new String[0])));
        }
        jwtConsumerBuilder.setVerificationKeyResolver(this.verificationKeyResolver);
        this.jwtConsumer = jwtConsumerBuilder.build();
    }

    @Override
    public void close() throws IOException {
        this.jwtConsumer = null;
    }

    public ValidatingJsonMap getSpec() {
        return Utils.getSpec((String)"cluster.security.JwtAuth.Commands").getSpec();
    }

    @Override
    public Map<String, Object> edit(Map<String, Object> latestConf, List<CommandOperation> commands) {
        for (CommandOperation command : commands) {
            if (!command.name.equals("set-property")) continue;
            for (Map.Entry e : command.getDataMap().entrySet()) {
                if (PROPS.contains(e.getKey())) {
                    latestConf.put((String)e.getKey(), e.getValue());
                    return latestConf;
                }
                command.addError("Unknown property " + (String)e.getKey());
            }
        }
        if (!CommandOperation.captureErrors(commands).isEmpty()) {
            return null;
        }
        return latestConf;
    }

    private void authenticationFailure(HttpServletResponse response, String message, int httpCode, BearerWwwAuthErrorCode responseError) throws IOException {
        ArrayList<String> wwwAuthParams = new ArrayList<String>();
        wwwAuthParams.add("Bearer realm=\"solr-jwt\"");
        if (responseError != null) {
            wwwAuthParams.add("error=\"" + (Object)((Object)responseError) + "\"");
            wwwAuthParams.add("error_description=\"" + message + "\"");
        }
        response.addHeader("WWW-Authenticate", String.join((CharSequence)", ", wwwAuthParams));
        response.addHeader("X-Solr-AuthData", this.generateAuthDataHeader());
        response.sendError(httpCode, message);
        log.info("JWT Authentication attempt failed: {}", (Object)message);
    }

    protected String generateAuthDataHeader() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(PARAM_AUTHORIZATION_ENDPOINT, this.authorizationEndpoint);
        data.put("client_id", this.clientId);
        data.put("scope", this.adminUiScope);
        data.put("redirect_uris", this.redirectUris);
        String headerJson = Utils.toJSONString(data);
        return Base64.byteArrayToBase64((byte[])headerJson.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    protected boolean interceptInternodeRequest(HttpRequest httpRequest, HttpContext httpContext) {
        HttpClientContext httpClientContext;
        if (httpContext instanceof HttpClientContext && (httpClientContext = (HttpClientContext)httpContext).getUserToken() instanceof JWTPrincipal) {
            JWTPrincipal jwtPrincipal = (JWTPrincipal)httpClientContext.getUserToken();
            httpRequest.setHeader("Authorization", "Bearer " + jwtPrincipal.getToken());
            return true;
        }
        return false;
    }

    @Override
    protected boolean interceptInternodeRequest(Request request) {
        Object userToken = request.getAttributes().get("solr-req-principal");
        if (userToken instanceof JWTPrincipal) {
            JWTPrincipal jwtPrincipal = (JWTPrincipal)userToken;
            request.header("Authorization", "Bearer " + jwtPrincipal.getToken());
            return true;
        }
        return false;
    }

    public static class WellKnownDiscoveryConfig {
        private static Map<String, Object> securityConf;

        WellKnownDiscoveryConfig(Map<String, Object> securityConf) {
            WellKnownDiscoveryConfig.securityConf = securityConf;
        }

        public static WellKnownDiscoveryConfig parse(String urlString) {
            try {
                URL url = new URL(urlString);
                if (!Arrays.asList("https", "file").contains(url.getProtocol())) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Well-known config URL must be HTTPS or file");
                }
                return WellKnownDiscoveryConfig.parse(url.openStream());
            }
            catch (MalformedURLException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Well-known config URL " + urlString + " is malformed", (Throwable)e);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Well-known config could not be read from url " + urlString, (Throwable)e);
            }
        }

        public static WellKnownDiscoveryConfig parse(String json, Charset charset) {
            return WellKnownDiscoveryConfig.parse(new ByteArrayInputStream(json.getBytes(charset)));
        }

        public static WellKnownDiscoveryConfig parse(InputStream configStream) {
            securityConf = (Map)Utils.fromJSON((InputStream)configStream);
            return new WellKnownDiscoveryConfig(securityConf);
        }

        public String getJwksUrl() {
            return (String)securityConf.get("jwks_uri");
        }

        public String getIssuer() {
            return (String)securityConf.get("issuer");
        }

        public String getAuthorizationEndpoint() {
            return (String)securityConf.get("authorization_endpoint");
        }

        public String getUserInfoEndpoint() {
            return (String)securityConf.get("userinfo_endpoint");
        }

        public String getTokenEndpoint() {
            return (String)securityConf.get("token_endpoint");
        }

        public List<String> getScopesSupported() {
            return (List)securityConf.get("scopes_supported");
        }

        public List<String> getResponseTypesSupported() {
            return (List)securityConf.get("response_types_supported");
        }
    }

    static class JWTAuthenticationResponse {
        private final Principal principal;
        private String errorMessage;
        private AuthCode authCode;
        private InvalidJwtException jwtException;

        JWTAuthenticationResponse(AuthCode authCode, InvalidJwtException e) {
            this.authCode = authCode;
            this.jwtException = e;
            this.principal = null;
            this.errorMessage = e.getMessage();
        }

        JWTAuthenticationResponse(AuthCode authCode, String errorMessage) {
            this.authCode = authCode;
            this.errorMessage = errorMessage;
            this.principal = null;
        }

        JWTAuthenticationResponse(AuthCode authCode, Principal principal) {
            this.authCode = authCode;
            this.principal = principal;
        }

        JWTAuthenticationResponse(AuthCode authCode) {
            this.authCode = authCode;
            this.principal = null;
        }

        boolean isAuthenticated() {
            return this.authCode.equals((Object)AuthCode.AUTHENTICATED);
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        String getErrorMessage() {
            return this.errorMessage;
        }

        InvalidJwtException getJwtException() {
            return this.jwtException;
        }

        AuthCode getAuthCode() {
            return this.authCode;
        }

        static enum AuthCode {
            PASS_THROUGH("No user, pass through"),
            AUTHENTICATED("Authenticated"),
            PRINCIPAL_MISSING("No principal in JWT"),
            JWT_PARSE_ERROR("Invalid JWT"),
            AUTZ_HEADER_PROBLEM("Wrong header"),
            NO_AUTZ_HEADER("Require authentication"),
            JWT_EXPIRED("JWT token expired"),
            CLAIM_MISMATCH("Required JWT claim missing"),
            JWT_VALIDATION_EXCEPTION("JWT validation failed"),
            SCOPE_MISSING("Required scope missing in JWT"),
            SIGNATURE_INVALID("Signature invalid");

            private final String msg;

            public String getMsg() {
                return this.msg;
            }

            private AuthCode(String msg) {
                this.msg = msg;
            }
        }
    }

    private static enum BearerWwwAuthErrorCode {
        invalid_request,
        invalid_token,
        insufficient_scope;

    }
}

