/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.cloud.api.collections.AliasCmd;
import org.apache.solr.cloud.api.collections.CategoryRoutedAlias;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.api.collections.RoutedAlias;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintainCategoryRoutedAliasCmd
extends AliasCmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String IF_CATEGORY_COLLECTION_NOT_FOUND = "ifCategoryCollectionNotFound";
    private static NamedSimpleSemaphore DELETE_LOCK = new NamedSimpleSemaphore();
    private final OverseerCollectionMessageHandler ocmh;

    MaintainCategoryRoutedAliasCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    public static void remoteInvoke(CollectionsHandler collHandler, String aliasName, String categoryCollection) throws Exception {
        String operation = CollectionParams.CollectionAction.MAINTAINCATEGORYROUTEDALIAS.toLower();
        HashMap<String, String> msg = new HashMap<String, String>();
        msg.put("operation", operation);
        msg.put("name", aliasName);
        msg.put(IF_CATEGORY_COLLECTION_NOT_FOUND, categoryCollection);
        SolrResponse rsp = collHandler.sendToOCPQueue(new ZkNodeProps(msg));
        if (rsp.getException() != null) {
            throw rsp.getException();
        }
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        String aliasName = message.getStr("name");
        String categoryRequired = message.getStr(IF_CATEGORY_COLLECTION_NOT_FOUND);
        ZkStateReader.AliasesManager aliasesManager = this.ocmh.zkStateReader.aliasesManager;
        Aliases aliases = aliasesManager.getAliases();
        Map aliasMetadata = aliases.getCollectionAliasProperties(aliasName);
        if (aliasMetadata.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Alias " + aliasName + " does not exist or is not a routed alias.");
        }
        CategoryRoutedAlias categoryRoutedAlias = (CategoryRoutedAlias)RoutedAlias.fromProps(aliasName, aliasMetadata);
        if (categoryRoutedAlias == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, this.getClass() + " got alias metadata with an invalid routing type and produced null");
        }
        Map collectionAliasListMap = aliases.getCollectionAliasListMap();
        if (!((List)collectionAliasListMap.get(aliasName)).contains(categoryRequired)) {
            NamedList createResults;
            String initialCollection = categoryRoutedAlias.buildCollectionNameFromValue("NEW_CATEGORY_ROUTED_ALIAS_WAITING_FOR_DATA__TEMP");
            ArrayList colList = new ArrayList((Collection)collectionAliasListMap.get(aliasName));
            if (colList.contains(initialCollection) && colList.size() > 1 && DELETE_LOCK.tryAcquire(aliasName)) {
                this.ocmh.overseer.getCoreContainer().runAsync(() -> {
                    aliasesManager.applyModificationAndExportToZk(curAliases -> {
                        colList.remove(initialCollection);
                        String collectionsToKeepStr = StrUtils.join((Collection)colList, (char)',');
                        return curAliases.cloneWithCollectionAlias(aliasName, collectionsToKeepStr);
                    });
                    CollectionsHandler collHandler = this.ocmh.overseer.getCoreContainer().getCollectionsHandler();
                    SolrParams reqParams = CollectionAdminRequest.deleteCollection((String)initialCollection).getParams();
                    SolrQueryResponse rsp = new SolrQueryResponse();
                    try {
                        collHandler.handleRequestBody(new LocalSolrQueryRequest(null, reqParams), rsp);
                    }
                    catch (Exception e) {
                        log.error("Could not delete initial collection from CRA", (Throwable)e);
                    }
                    results.add("NEW_CATEGORY_ROUTED_ALIAS_WAITING_FOR_DATA__TEMP", (Object)rsp.getValues());
                    DELETE_LOCK.release(aliasName);
                });
            }
            if ((createResults = MaintainCategoryRoutedAliasCmd.createCollectionAndWait(state, aliasName, aliasMetadata, categoryRequired, this.ocmh)) != null) {
                results.add("create", (Object)createResults);
            }
            this.updateAlias(aliasName, aliasesManager, categoryRequired);
        }
    }

    private static class NamedSimpleSemaphore {
        private final HashMap<String, Semaphore> semaphores = new HashMap();

        NamedSimpleSemaphore() {
        }

        boolean tryAcquire(String name) {
            return this.semaphores.computeIfAbsent(name, s -> new Semaphore(1)).tryAcquire();
        }

        public void release(String name) {
            this.semaphores.get(name).release();
        }
    }
}

