/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.solr.common.SolrException;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.security.AuditEvent;
import org.apache.solr.security.AuditLoggerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDestinationAuditLogger
extends AuditLoggerPlugin
implements ResourceLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PARAM_PLUGINS = "plugins";
    private ResourceLoader loader;
    List<AuditLoggerPlugin> plugins = new ArrayList<AuditLoggerPlugin>();
    List<String> pluginNames = new ArrayList<String>();

    @Override
    public void audit(AuditEvent event) {
        log.debug("Passing auditEvent to plugins {}", this.pluginNames);
        this.plugins.parallelStream().forEach(plugin -> {
            if (plugin.shouldLog(event.getEventType())) {
                plugin.doAudit(event);
            }
        });
    }

    @Override
    public void init(Map<String, Object> pluginConfig) {
        pluginConfig.put("async", false);
        super.init(pluginConfig);
        if (!pluginConfig.containsKey(PARAM_PLUGINS)) {
            log.warn("No plugins configured");
        } else {
            List pluginList = (List)pluginConfig.get(PARAM_PLUGINS);
            pluginList.forEach(pluginConf -> this.plugins.add(this.createPlugin((Map<String, Object>)pluginConf)));
            pluginConfig.remove(PARAM_PLUGINS);
            this.pluginNames = this.plugins.stream().map(AuditLoggerPlugin::getName).collect(Collectors.toList());
        }
        if (pluginConfig.size() > 0) {
            log.error("Plugin config was not fully consumed. Remaining parameters are {}", pluginConfig);
        }
        log.info("Initialized {} audit plugins: {}", (Object)this.plugins.size(), this.pluginNames);
    }

    @Override
    public boolean shouldLog(AuditEvent.EventType eventType) {
        return super.shouldLog(eventType) || this.plugins.stream().anyMatch(p -> p.shouldLog(eventType));
    }

    private AuditLoggerPlugin createPlugin(Map<String, Object> auditConf) {
        if (auditConf != null) {
            String klas = (String)auditConf.get("class");
            if (klas == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "class is required for auditlogger plugin");
            }
            log.info("Initializing auditlogger plugin: " + klas);
            AuditLoggerPlugin p = (AuditLoggerPlugin)this.loader.newInstance(klas, AuditLoggerPlugin.class);
            if (p.getClass().equals(this.getClass())) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cannot nest MultiDestinationAuditLogger");
            }
            p.init(auditConf);
            return p;
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Empty config when creating audit plugin");
    }

    public void inform(ResourceLoader loader) {
        this.loader = loader;
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registryName, String tag, String scope) {
        super.initializeMetrics(manager, registryName, tag, scope);
        this.plugins.forEach(p -> p.initializeMetrics(manager, registryName, tag, scope));
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.plugins.forEach(p -> {
            try {
                p.close();
            }
            catch (IOException e) {
                log.error("Exception trying to close {}", (Object)p.getName());
            }
        });
    }
}

