/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;

public final class IntrospectionUtils {
    private static final Log log = LogFactory.getLog(IntrospectionUtils.class);
    @Deprecated
    public static final String PATH_SEPARATOR = File.pathSeparator;
    static Hashtable<Class<?>, Method[]> objectMethods = new Hashtable();
    @Deprecated
    private static final Object[] emptyArray = new Object[0];

    @Deprecated
    public static void execute(Object proxy, String method) throws Exception {
        Class[] params;
        Method executeM = null;
        Class<?> c = proxy.getClass();
        executeM = IntrospectionUtils.findMethod(c, method, params = new Class[0]);
        if (executeM == null) {
            throw new RuntimeException("No execute in " + proxy.getClass());
        }
        executeM.invoke(proxy, (Object[])null);
    }

    @Deprecated
    public static void setAttribute(Object proxy, String n, Object v) throws Exception {
        if (proxy instanceof AttributeHolder) {
            ((AttributeHolder)proxy).setAttribute(n, v);
            return;
        }
        Method executeM = null;
        Class<?> c = proxy.getClass();
        Class[] params = new Class[]{String.class, Object.class};
        executeM = IntrospectionUtils.findMethod(c, "setAttribute", params);
        if (executeM == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No setAttribute in " + proxy.getClass()));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting " + n + "=" + v + "  in " + proxy));
        }
        executeM.invoke(proxy, n, v);
    }

    @Deprecated
    public static Object getAttribute(Object proxy, String n) throws Exception {
        Method executeM = null;
        Class<?> c = proxy.getClass();
        Class[] params = new Class[]{String.class};
        executeM = IntrospectionUtils.findMethod(c, "getAttribute", params);
        if (executeM == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No getAttribute in " + proxy.getClass()));
            }
            return null;
        }
        return executeM.invoke(proxy, n);
    }

    @Deprecated
    public static ClassLoader getURLClassLoader(URL[] urls, ClassLoader parent) {
        try {
            Class<?> urlCL = Class.forName("java.net.URLClassLoader");
            Class[] paramT = new Class[]{urls.getClass(), ClassLoader.class};
            Method m = IntrospectionUtils.findMethod(urlCL, "newInstance", paramT);
            if (m == null) {
                return null;
            }
            ClassLoader cl = (ClassLoader)m.invoke(urlCL, urls, parent);
            return cl;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static String guessInstall(String installSysProp, String homeSysProp, String jarName) {
        return IntrospectionUtils.guessInstall(installSysProp, homeSysProp, jarName, null);
    }

    @Deprecated
    public static String guessInstall(String installSysProp, String homeSysProp, String jarName, String classFile) {
        String install = null;
        String home = null;
        if (installSysProp != null) {
            install = System.getProperty(installSysProp);
        }
        if (homeSysProp != null) {
            home = System.getProperty(homeSysProp);
        }
        if (install != null) {
            if (home == null) {
                System.getProperties().put(homeSysProp, install);
            }
            return install;
        }
        String cpath = System.getProperty("java.class.path");
        String pathSep = File.pathSeparator;
        StringTokenizer st = new StringTokenizer(cpath, pathSep);
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            if (path.endsWith(jarName)) {
                home = path.substring(0, path.length() - jarName.length());
                try {
                    if ("".equals(home)) {
                        home = new File("./").getCanonicalPath();
                    } else if (home.endsWith(File.separator)) {
                        home = home.substring(0, home.length() - 1);
                    }
                    File f = new File(home);
                    String parentDir = f.getParent();
                    if (parentDir == null) {
                        parentDir = home;
                    }
                    File f1 = new File(parentDir);
                    install = f1.getCanonicalPath();
                    if (installSysProp != null) {
                        System.getProperties().put(installSysProp, install);
                    }
                    if (homeSysProp != null) {
                        System.getProperties().put(homeSysProp, install);
                    }
                    return install;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
            }
            String fname = path + (path.endsWith("/") ? "" : "/") + classFile;
            if (!new File(fname).exists()) continue;
            try {
                File f = new File(path);
                String parentDir = f.getParent();
                if (parentDir == null) {
                    parentDir = path;
                }
                File f1 = new File(parentDir);
                install = f1.getCanonicalPath();
                if (installSysProp != null) {
                    System.getProperties().put(installSysProp, install);
                }
                if (home == null && homeSysProp != null) {
                    System.getProperties().put(homeSysProp, install);
                }
                return install;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (home != null) {
            System.getProperties().put(installSysProp, home);
            return home;
        }
        return null;
    }

    @Deprecated
    public static void displayClassPath(String msg, URL[] cp) {
        if (log.isDebugEnabled()) {
            log.debug((Object)msg);
            for (int i = 0; i < cp.length; ++i) {
                log.debug((Object)cp[i].getFile());
            }
        }
    }

    @Deprecated
    public static String classPathAdd(URL[] urls, String cp) {
        if (urls == null) {
            return cp;
        }
        for (int i = 0; i < urls.length; ++i) {
            cp = cp != null ? cp + PATH_SEPARATOR + urls[i].getFile() : urls[i].getFile();
        }
        return cp;
    }

    public static boolean setProperty(Object o, String name, String value) {
        return IntrospectionUtils.setProperty(o, name, value, true);
    }

    public static boolean setProperty(Object o, String name, String value, boolean invokeSetProperty) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("IntrospectionUtils: setProperty(" + o.getClass() + " " + name + "=" + value + ")"));
        }
        String setter = "set" + IntrospectionUtils.capitalize(name);
        try {
            int i;
            Method[] methods = IntrospectionUtils.findMethods(o.getClass());
            Method setPropertyMethodVoid = null;
            Method setPropertyMethodBool = null;
            for (i = 0; i < methods.length; ++i) {
                Class<?>[] paramT = methods[i].getParameterTypes();
                if (!setter.equals(methods[i].getName()) || paramT.length != 1 || !"java.lang.String".equals(paramT[0].getName())) continue;
                methods[i].invoke(o, value);
                return true;
            }
            for (i = 0; i < methods.length; ++i) {
                boolean ok = true;
                if (setter.equals(methods[i].getName()) && methods[i].getParameterTypes().length == 1) {
                    Class<?> paramType = methods[i].getParameterTypes()[0];
                    Object[] params = new Object[1];
                    if ("java.lang.Integer".equals(paramType.getName()) || "int".equals(paramType.getName())) {
                        try {
                            params[0] = Integer.valueOf(value);
                        }
                        catch (NumberFormatException ex) {
                            ok = false;
                        }
                    } else if ("java.lang.Long".equals(paramType.getName()) || "long".equals(paramType.getName())) {
                        try {
                            params[0] = Long.valueOf(value);
                        }
                        catch (NumberFormatException ex) {
                            ok = false;
                        }
                    } else if ("java.lang.Boolean".equals(paramType.getName()) || "boolean".equals(paramType.getName())) {
                        params[0] = Boolean.valueOf(value);
                    } else if ("java.net.InetAddress".equals(paramType.getName())) {
                        try {
                            params[0] = InetAddress.getByName(value);
                        }
                        catch (UnknownHostException exc) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("IntrospectionUtils: Unable to resolve host name:" + value));
                            }
                            ok = false;
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("IntrospectionUtils: Unknown type " + paramType.getName()));
                    }
                    if (ok) {
                        methods[i].invoke(o, params);
                        return true;
                    }
                }
                if (!"setProperty".equals(methods[i].getName())) continue;
                if (methods[i].getReturnType() == Boolean.TYPE) {
                    setPropertyMethodBool = methods[i];
                    continue;
                }
                setPropertyMethodVoid = methods[i];
            }
            if (invokeSetProperty && (setPropertyMethodBool != null || setPropertyMethodVoid != null)) {
                Object[] params = new Object[]{name, value};
                if (setPropertyMethodBool != null) {
                    try {
                        return (Boolean)setPropertyMethodBool.invoke(o, params);
                    }
                    catch (IllegalArgumentException biae) {
                        if (setPropertyMethodVoid != null) {
                            setPropertyMethodVoid.invoke(o, params);
                            return true;
                        }
                        throw biae;
                    }
                }
                setPropertyMethodVoid.invoke(o, params);
                return true;
            }
        }
        catch (IllegalArgumentException ex2) {
            log.warn((Object)("IAE " + o + " " + name + " " + value), (Throwable)ex2);
        }
        catch (SecurityException ex1) {
            log.warn((Object)("IntrospectionUtils: SecurityException for " + o.getClass() + " " + name + "=" + value + ")"), (Throwable)ex1);
        }
        catch (IllegalAccessException iae) {
            log.warn((Object)("IntrospectionUtils: IllegalAccessException for " + o.getClass() + " " + name + "=" + value + ")"), (Throwable)iae);
        }
        catch (InvocationTargetException ie) {
            ExceptionUtils.handleThrowable(ie.getCause());
            log.warn((Object)("IntrospectionUtils: InvocationTargetException for " + o.getClass() + " " + name + "=" + value + ")"), (Throwable)ie);
        }
        return false;
    }

    public static Object getProperty(Object o, String name) {
        String getter = "get" + IntrospectionUtils.capitalize(name);
        String isGetter = "is" + IntrospectionUtils.capitalize(name);
        try {
            Method[] methods = IntrospectionUtils.findMethods(o.getClass());
            Method getPropertyMethod = null;
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] paramT = methods[i].getParameterTypes();
                if (getter.equals(methods[i].getName()) && paramT.length == 0) {
                    return methods[i].invoke(o, (Object[])null);
                }
                if (isGetter.equals(methods[i].getName()) && paramT.length == 0) {
                    return methods[i].invoke(o, (Object[])null);
                }
                if (!"getProperty".equals(methods[i].getName())) continue;
                getPropertyMethod = methods[i];
            }
            if (getPropertyMethod != null) {
                Object[] params = new Object[]{name};
                return getPropertyMethod.invoke(o, params);
            }
        }
        catch (IllegalArgumentException ex2) {
            log.warn((Object)("IAE " + o + " " + name), (Throwable)ex2);
        }
        catch (SecurityException ex1) {
            log.warn((Object)("IntrospectionUtils: SecurityException for " + o.getClass() + " " + name + ")"), (Throwable)ex1);
        }
        catch (IllegalAccessException iae) {
            log.warn((Object)("IntrospectionUtils: IllegalAccessException for " + o.getClass() + " " + name + ")"), (Throwable)iae);
        }
        catch (InvocationTargetException ie) {
            ExceptionUtils.handleThrowable(ie.getCause());
            log.warn((Object)("IntrospectionUtils: InvocationTargetException for " + o.getClass() + " " + name + ")"), (Throwable)ie);
        }
        return null;
    }

    @Deprecated
    public static void setProperty(Object o, String name) {
        block3: {
            String setter = "set" + IntrospectionUtils.capitalize(name);
            try {
                Method[] methods = IntrospectionUtils.findMethods(o.getClass());
                for (int i = 0; i < methods.length; ++i) {
                    Class<?>[] paramT = methods[i].getParameterTypes();
                    if (!setter.equals(methods[i].getName()) || paramT.length != 0) continue;
                    methods[i].invoke(o, new Object[0]);
                    return;
                }
            }
            catch (Exception ex1) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("IntrospectionUtils: Exception for " + o.getClass() + " " + name), (Throwable)ex1);
            }
        }
    }

    public static String replaceProperties(String value, Hashtable<Object, Object> staticProp, PropertySource[] dynamicProp) {
        int pos;
        if (value.indexOf(36) < 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        int prev = 0;
        while ((pos = value.indexOf(36, prev)) >= 0) {
            if (pos > 0) {
                sb.append(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                sb.append('$');
                prev = pos + 1;
                continue;
            }
            if (value.charAt(pos + 1) != '{') {
                sb.append('$');
                prev = pos + 1;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName < 0) {
                sb.append(value.substring(pos));
                prev = value.length();
                continue;
            }
            String n = value.substring(pos + 2, endName);
            String v = null;
            if (staticProp != null) {
                v = (String)staticProp.get(n);
            }
            if (v == null && dynamicProp != null) {
                for (int i = 0; i < dynamicProp.length && (v = dynamicProp[i].getProperty(n)) == null; ++i) {
                }
            }
            if (v == null) {
                v = "${" + n + "}";
            }
            sb.append(v);
            prev = endName + 1;
        }
        if (prev < value.length()) {
            sb.append(value.substring(prev));
        }
        return sb.toString();
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    @Deprecated
    public static String unCapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    @Deprecated
    public static void addToClassPath(Vector<URL> cpV, String dir) {
        try {
            String[] cpComp = IntrospectionUtils.getFilesByExt(dir, ".jar");
            if (cpComp != null) {
                int jarCount = cpComp.length;
                for (int i = 0; i < jarCount; ++i) {
                    URL url = IntrospectionUtils.getURL(dir, cpComp[i]);
                    if (url == null) continue;
                    cpV.addElement(url);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Deprecated
    public static void addToolsJar(Vector<URL> v) {
        try {
            File f = new File(System.getProperty("java.home") + "/../lib/tools.jar");
            if (!f.exists() && (f = new File(System.getProperty("java.home") + "/lib/tools.jar")).exists() && log.isDebugEnabled()) {
                log.debug((Object)("Detected strange java.home value " + System.getProperty("java.home") + ", it should point to jre"));
            }
            URL url = new URL("file", "", f.getAbsolutePath());
            v.addElement(url);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
    }

    @Deprecated
    public static String[] getFilesByExt(String ld, String ext) {
        File dir = new File(ld);
        String[] names = null;
        final String lext = ext;
        if (dir.isDirectory()) {
            names = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File d, String name) {
                    return name.endsWith(lext);
                }
            });
        }
        return names;
    }

    @Deprecated
    public static URL getURL(String base, String file) {
        try {
            File baseF = new File(base);
            File f = new File(baseF, file);
            String path = f.getCanonicalPath();
            if (f.isDirectory()) {
                path = path + "/";
            }
            if (!f.exists()) {
                return null;
            }
            return new URL("file", "", path);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static void addJarsFromClassPath(Vector<URL> jars, String cp) throws IOException, MalformedURLException {
        String sep = File.pathSeparator;
        if (cp != null) {
            StringTokenizer st = new StringTokenizer(cp, sep);
            while (st.hasMoreTokens()) {
                URL url;
                File f = new File(st.nextToken());
                String path = f.getCanonicalPath();
                if (f.isDirectory()) {
                    path = path + "/";
                }
                if (jars.contains(url = new URL("file", "", path))) continue;
                jars.addElement(url);
            }
        }
    }

    @Deprecated
    public static URL[] getClassPath(Vector<URL> v) {
        URL[] urls = new URL[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            urls[i] = v.elementAt(i);
        }
        return urls;
    }

    @Deprecated
    public static URL[] getClassPath(String dir, String cpath, String cpathProp, boolean addTools) throws IOException, MalformedURLException {
        Vector<URL> jarsV = new Vector<URL>();
        if (dir != null) {
            URL url = IntrospectionUtils.getURL(dir, "classes");
            if (url != null) {
                jarsV.addElement(url);
            }
            IntrospectionUtils.addToClassPath(jarsV, dir);
        }
        if (cpath != null) {
            IntrospectionUtils.addJarsFromClassPath(jarsV, cpath);
        }
        if (cpathProp != null) {
            String cpath1 = System.getProperty(cpathProp);
            IntrospectionUtils.addJarsFromClassPath(jarsV, cpath1);
        }
        if (addTools) {
            IntrospectionUtils.addToolsJar(jarsV);
        }
        return IntrospectionUtils.getClassPath(jarsV);
    }

    public static void clear() {
        objectMethods.clear();
    }

    public static Method[] findMethods(Class<?> c) {
        Method[] methods = objectMethods.get(c);
        if (methods != null) {
            return methods;
        }
        methods = c.getMethods();
        objectMethods.put(c, methods);
        return methods;
    }

    public static Method findMethod(Class<?> c, String name, Class<?>[] params) {
        Method[] methods = IntrospectionUtils.findMethods(c);
        if (methods == null) {
            return null;
        }
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            Class<?>[] methodParams = methods[i].getParameterTypes();
            if (methodParams == null && (params == null || params.length == 0)) {
                return methods[i];
            }
            if (params == null && (methodParams == null || methodParams.length == 0)) {
                return methods[i];
            }
            if (params.length != methodParams.length) continue;
            boolean found = true;
            for (int j = 0; j < params.length; ++j) {
                if (params[j] == methodParams[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return methods[i];
        }
        return null;
    }

    @Deprecated
    public static boolean hasHook(Object obj, String methodN) {
        try {
            Method[] myMethods = IntrospectionUtils.findMethods(obj.getClass());
            for (int i = 0; i < myMethods.length; ++i) {
                Class<?> declaring;
                Class<?> parentOfDeclaring;
                if (!methodN.equals(myMethods[i].getName()) || "java.lang.Object".equals((parentOfDeclaring = (declaring = myMethods[i].getDeclaringClass()).getSuperclass()).getName())) continue;
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Deprecated
    public static void callMain(Class<?> c, String[] args) throws Exception {
        Class[] p = new Class[]{args.getClass()};
        Method m = c.getMethod("main", p);
        m.invoke(c, new Object[]{args});
    }

    public static Object callMethod1(Object target, String methodN, Object param1, String typeParam1, ClassLoader cl) throws Exception {
        if (target == null || param1 == null) {
            throw new IllegalArgumentException("IntrospectionUtils: Assert: Illegal params " + target + " " + param1);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("IntrospectionUtils: callMethod1 " + target.getClass().getName() + " " + param1.getClass().getName() + " " + typeParam1));
        }
        Class[] params = new Class[]{typeParam1 == null ? param1.getClass() : cl.loadClass(typeParam1)};
        Method m = IntrospectionUtils.findMethod(target.getClass(), methodN, params);
        if (m == null) {
            throw new NoSuchMethodException(target.getClass().getName() + " " + methodN);
        }
        try {
            return m.invoke(target, param1);
        }
        catch (InvocationTargetException ie) {
            ExceptionUtils.handleThrowable(ie.getCause());
            throw ie;
        }
    }

    @Deprecated
    public static Object callMethod0(Object target, String methodN) throws Exception {
        if (target == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("IntrospectionUtils: Assert: Illegal params " + target));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("IntrospectionUtils: callMethod0 " + target.getClass().getName() + "." + methodN));
        }
        Class[] params = new Class[]{};
        Method m = IntrospectionUtils.findMethod(target.getClass(), methodN, params);
        if (m == null) {
            throw new NoSuchMethodException(target.getClass().getName() + " " + methodN);
        }
        try {
            return m.invoke(target, emptyArray);
        }
        catch (InvocationTargetException ie) {
            ExceptionUtils.handleThrowable(ie.getCause());
            throw ie;
        }
    }

    public static Object callMethodN(Object target, String methodN, Object[] params, Class<?>[] typeParams) throws Exception {
        Method m = null;
        m = IntrospectionUtils.findMethod(target.getClass(), methodN, typeParams);
        if (m == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("IntrospectionUtils: Can't find method " + methodN + " in " + target + " CLASS " + target.getClass()));
            }
            return null;
        }
        try {
            Object o = m.invoke(target, params);
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append(target.getClass().getName()).append('.').append(methodN).append("( ");
                for (int i = 0; i < params.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(params[i]);
                }
                sb.append(")");
                log.debug((Object)("IntrospectionUtils:" + sb.toString()));
            }
            return o;
        }
        catch (InvocationTargetException ie) {
            ExceptionUtils.handleThrowable(ie.getCause());
            throw ie;
        }
    }

    public static Object convert(String object, Class<?> paramType) {
        Object result = null;
        if ("java.lang.String".equals(paramType.getName())) {
            result = object;
        } else if ("java.lang.Integer".equals(paramType.getName()) || "int".equals(paramType.getName())) {
            try {
                result = Integer.valueOf(object);
            }
            catch (NumberFormatException ex) {}
        } else if ("java.lang.Boolean".equals(paramType.getName()) || "boolean".equals(paramType.getName())) {
            result = Boolean.valueOf(object);
        } else if ("java.net.InetAddress".equals(paramType.getName())) {
            try {
                result = InetAddress.getByName(object);
            }
            catch (UnknownHostException exc) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("IntrospectionUtils: Unable to resolve host name:" + object));
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("IntrospectionUtils: Unknown type " + paramType.getName()));
        }
        if (result == null) {
            throw new IllegalArgumentException("Can't convert argument: " + object);
        }
        return result;
    }

    public static boolean isInstance(Class<?> clazz, String type) {
        Class<?>[] ifaces;
        if (type.equals(clazz.getName())) {
            return true;
        }
        for (Class<?> iface : ifaces = clazz.getInterfaces()) {
            if (!IntrospectionUtils.isInstance(iface, type)) continue;
            return true;
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz == null) {
            return false;
        }
        return IntrospectionUtils.isInstance(superClazz, type);
    }

    @Deprecated
    public static interface AttributeHolder {
        public void setAttribute(String var1, Object var2);
    }

    public static interface PropertySource {
        public String getProperty(String var1);
    }
}

