/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import org.traccar.StringProtocolEncoder;
import org.traccar.model.Command;

public class Gps103ProtocolEncoder
extends StringProtocolEncoder
implements StringProtocolEncoder.ValueFormatter {
    @Override
    public String formatValue(String key, Object value) {
        if (key.equals("frequency")) {
            long frequency = ((Number)value).longValue();
            if (frequency / 60L / 60L > 0L) {
                return String.format("%02dh", frequency / 60L / 60L);
            }
            if (frequency / 60L > 0L) {
                return String.format("%02dm", frequency / 60L);
            }
            return String.format("%02ds", frequency);
        }
        return null;
    }

    @Override
    protected Object encodeCommand(Command command) {
        switch (command.getType()) {
            case "custom": {
                return this.formatCommand(command, "**,imei:{%s},{%s}", "uniqueId", "data");
            }
            case "positionStop": {
                return this.formatCommand(command, "**,imei:{%s},A", "uniqueId");
            }
            case "positionSingle": {
                return this.formatCommand(command, "**,imei:{%s},B", "uniqueId");
            }
            case "positionPeriodic": {
                return this.formatCommand(command, "**,imei:{%s},C,{%s}", this, "uniqueId", "frequency");
            }
            case "engineStop": {
                return this.formatCommand(command, "**,imei:{%s},J", "uniqueId");
            }
            case "engineResume": {
                return this.formatCommand(command, "**,imei:{%s},K", "uniqueId");
            }
            case "alarmArm": {
                return this.formatCommand(command, "**,imei:{%s},L", "uniqueId");
            }
            case "alarmDisarm": {
                return this.formatCommand(command, "**,imei:{%s},M", "uniqueId");
            }
            case "requestPhoto": {
                return this.formatCommand(command, "**,imei:{%s},160", "uniqueId");
            }
        }
        return null;
    }
}

