/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.model.Position;

public class PiligrimProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_GPS = 241;
    public static final int MSG_GPS_SENSORS = 242;
    public static final int MSG_EVENTS = 243;

    public PiligrimProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, String message) {
        if (channel != null) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)message, (Charset)StandardCharsets.US_ASCII));
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        String uri = request.uri();
        if (uri.startsWith("/config")) {
            this.sendResponse(channel, "CONFIG: OK");
        } else if (uri.startsWith("/addlog")) {
            this.sendResponse(channel, "ADDLOG: OK");
        } else if (uri.startsWith("/inform")) {
            this.sendResponse(channel, "INFORM: OK");
        } else if (uri.startsWith("/bingps")) {
            this.sendResponse(channel, "BINGPS: OK");
            QueryStringDecoder decoder = new QueryStringDecoder(request.uri());
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, (String)((List)decoder.parameters().get("imei")).get(0));
            if (deviceSession == null) {
                return null;
            }
            LinkedList<Position> positions = new LinkedList<Position>();
            ByteBuf buf = request.content();
            while (buf.readableBytes() > 2) {
                buf.readUnsignedByte();
                short type = buf.readUnsignedByte();
                buf.readUnsignedByte();
                if (type == 241 || type == 242) {
                    Position position = new Position(this.getProtocolName());
                    position.setDeviceId(deviceSession.getDeviceId());
                    DateBuilder dateBuilder = new DateBuilder().setDay(buf.readUnsignedByte()).setMonth(buf.getByte(buf.readerIndex()) & 0xF).setYear(2010 + (buf.readUnsignedByte() >> 4)).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
                    position.setTime(dateBuilder.getDate());
                    double latitude = buf.readUnsignedByte();
                    latitude += (double)buf.readUnsignedByte() / 60.0;
                    latitude += (double)buf.readUnsignedByte() / 6000.0;
                    latitude += (double)buf.readUnsignedByte() / 600000.0;
                    double longitude = buf.readUnsignedByte();
                    longitude += (double)buf.readUnsignedByte() / 60.0;
                    longitude += (double)buf.readUnsignedByte() / 6000.0;
                    longitude += (double)buf.readUnsignedByte() / 600000.0;
                    short flags = buf.readUnsignedByte();
                    if (BitUtil.check(flags, 0)) {
                        latitude = -latitude;
                    }
                    if (BitUtil.check(flags, 1)) {
                        longitude = -longitude;
                    }
                    position.setLatitude(latitude);
                    position.setLongitude(longitude);
                    short satellites = buf.readUnsignedByte();
                    position.set("sat", Integer.valueOf(satellites));
                    position.setValid(satellites >= 3);
                    position.setSpeed(buf.readUnsignedByte());
                    double course = buf.readUnsignedByte() << 1;
                    course += (double)(flags >> 2 & 1);
                    position.setCourse(course += (double)buf.readUnsignedByte() / 100.0);
                    if (type == 242) {
                        double power = buf.readUnsignedByte();
                        position.set("power", (power += (double)(buf.readUnsignedByte() << 8)) * 0.01);
                        double battery = buf.readUnsignedByte();
                        position.set("battery", (battery += (double)(buf.readUnsignedByte() << 8)) * 0.01);
                        buf.skipBytes(6);
                    }
                    positions.add(position);
                    continue;
                }
                if (type != 243) continue;
                buf.skipBytes(13);
            }
            return positions;
        }
        return null;
    }
}

