/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptContext;

public class ScriptVars {
    private static int MAX_KEY_SIZE = 30;
    private static int MAX_VALUE_SIZE = 0x100000;
    private static int MAX_SCRIPT_VARS = 20;
    private static int MAX_GLOBAL_VARS = 50;
    private static Map<String, String> globalVars = new HashMap<String, String>();
    private static Map<String, Map<String, String>> scriptVars = new HashMap<String, Map<String, String>>();

    public static void setGlobalVar(String key, String value) {
        if (key == null || key.length() > MAX_KEY_SIZE) {
            throw new InvalidParameterException("Invalid key - must be non null and have a length less than " + MAX_KEY_SIZE);
        }
        if (value == null) {
            globalVars.remove(key);
        } else {
            if (value.length() > MAX_VALUE_SIZE) {
                throw new InvalidParameterException("Invalid value - must have a length less than " + MAX_VALUE_SIZE);
            }
            if (globalVars.size() > MAX_GLOBAL_VARS) {
                throw new InvalidParameterException("Maximum number of global variables reached: " + MAX_GLOBAL_VARS);
            }
            globalVars.put(key, value);
        }
    }

    public static String getGlobalVar(String key) {
        return globalVars.get(key);
    }

    public static void setScriptVar(ScriptContext context, String key, String value) {
        if (context == null) {
            throw new InvalidParameterException("Invalid context - must be non null");
        }
        if (key == null || key.length() > MAX_KEY_SIZE) {
            throw new InvalidParameterException("Invalid key - must be non null and have a length less than " + MAX_KEY_SIZE);
        }
        String scriptName = (String)context.getAttribute("zap.script.name");
        if (scriptName == null) {
            throw new InvalidParameterException("Failed to find script name");
        }
        Map<String, String> scVars = scriptVars.get(scriptName);
        if (scVars == null) {
            scVars = new HashMap<String, String>();
            scriptVars.put(scriptName, scVars);
        }
        if (value == null) {
            scVars.remove(key);
        } else {
            if (value.length() > MAX_VALUE_SIZE) {
                throw new InvalidParameterException("Invalid value - must have a length less than " + MAX_VALUE_SIZE);
            }
            if (scVars.size() > MAX_SCRIPT_VARS) {
                throw new InvalidParameterException("Maximum number of script variables reached: " + MAX_SCRIPT_VARS);
            }
            scVars.put(key, value);
        }
    }

    public static String getScriptVar(ScriptContext context, String key) {
        if (context == null) {
            throw new InvalidParameterException("Invalid context - must be non null");
        }
        String scriptName = (String)context.getAttribute("zap.script.name");
        if (scriptName == null) {
            throw new InvalidParameterException("Failed to find script name");
        }
        Map<String, String> scVars = scriptVars.get(scriptName);
        if (scVars == null) {
            return null;
        }
        return scVars.get(key);
    }

    static void clear() {
        globalVars.clear();
        scriptVars.clear();
    }
}

